/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.encoder;

import com.dcloud.zxing2.Dimension;
import com.dcloud.zxing2.datamatrix.encoder.ASCIIEncoder;
import com.dcloud.zxing2.datamatrix.encoder.Base256Encoder;
import com.dcloud.zxing2.datamatrix.encoder.C40Encoder;
import com.dcloud.zxing2.datamatrix.encoder.EdifactEncoder;
import com.dcloud.zxing2.datamatrix.encoder.Encoder;
import com.dcloud.zxing2.datamatrix.encoder.EncoderContext;
import com.dcloud.zxing2.datamatrix.encoder.SymbolShapeHint;
import com.dcloud.zxing2.datamatrix.encoder.TextEncoder;
import com.dcloud.zxing2.datamatrix.encoder.X12Encoder;
import java.util.Arrays;

public final class HighLevelEncoder {
    private static final char PAD = '\u0081';
    static final char LATCH_TO_C40 = '\u00e6';
    static final char LATCH_TO_BASE256 = '\u00e7';
    static final char UPPER_SHIFT = '\u00eb';
    private static final char MACRO_05 = '\u00ec';
    private static final char MACRO_06 = '\u00ed';
    static final char LATCH_TO_ANSIX12 = '\u00ee';
    static final char LATCH_TO_TEXT = '\u00ef';
    static final char LATCH_TO_EDIFACT = '\u00f0';
    static final char C40_UNLATCH = '\u00fe';
    static final char X12_UNLATCH = '\u00fe';
    private static final String MACRO_05_HEADER = "[)>\u001e05\u001d";
    private static final String MACRO_06_HEADER = "[)>\u001e06\u001d";
    private static final String MACRO_TRAILER = "\u001e\u0004";
    static final int ASCII_ENCODATION = 0;
    static final int C40_ENCODATION = 1;
    static final int TEXT_ENCODATION = 2;
    static final int X12_ENCODATION = 3;
    static final int EDIFACT_ENCODATION = 4;
    static final int BASE256_ENCODATION = 5;

    private HighLevelEncoder() {
    }

    private static char randomize253State(char c6, int n5) {
        int n6 = c6 + (n5 * 149 % 253 + 1);
        c6 = (char)n6;
        return n6 <= 254 ? (char)c6 : (char)(c6 - 254);
    }

    public static String encodeHighLevel(String string2) {
        return HighLevelEncoder.encodeHighLevel(string2, SymbolShapeHint.FORCE_NONE, null, null);
    }

    public static String encodeHighLevel(String string2, SymbolShapeHint symbolShapeHint, Dimension dimension, Dimension dimension2) {
        StringBuilder stringBuilder;
        EncoderContext encoderContext;
        Base256Encoder base256Encoder;
        EdifactEncoder edifactEncoder;
        X12Encoder x12Encoder;
        TextEncoder textEncoder;
        C40Encoder c40Encoder;
        ASCIIEncoder aSCIIEncoder;
        Object object = aSCIIEncoder;
        aSCIIEncoder = new ASCIIEncoder();
        C40Encoder c40Encoder2 = c40Encoder;
        c40Encoder = new C40Encoder();
        TextEncoder textEncoder2 = textEncoder;
        textEncoder = new TextEncoder();
        X12Encoder x12Encoder2 = x12Encoder;
        x12Encoder = new X12Encoder();
        EdifactEncoder edifactEncoder2 = edifactEncoder;
        edifactEncoder = new EdifactEncoder();
        Base256Encoder base256Encoder2 = base256Encoder;
        base256Encoder = new Base256Encoder();
        Encoder[] encoderArray = new Encoder[6];
        Encoder[] encoderArray2 = encoderArray;
        encoderArray[0] = object;
        encoderArray[1] = c40Encoder2;
        encoderArray[2] = textEncoder2;
        encoderArray[3] = x12Encoder2;
        encoderArray[4] = edifactEncoder2;
        encoderArray[5] = base256Encoder2;
        object = encoderContext;
        encoderContext = new EncoderContext(string2);
        ((EncoderContext)object).setSymbolShape(symbolShapeHint);
        ((EncoderContext)object).setSizeConstraints(dimension, dimension2);
        if (string2.startsWith(MACRO_05_HEADER) && string2.endsWith(MACRO_TRAILER)) {
            ((EncoderContext)object).writeCodeword('\u00ec');
            ((EncoderContext)object).setSkipAtEnd(2);
            ((EncoderContext)object).pos += 7;
        } else if (string2.startsWith(MACRO_06_HEADER) && string2.endsWith(MACRO_TRAILER)) {
            ((EncoderContext)object).writeCodeword('\u00ed');
            ((EncoderContext)object).setSkipAtEnd(2);
            ((EncoderContext)object).pos += 7;
        }
        int n5 = 0;
        while (((EncoderContext)object).hasMoreCharacters()) {
            encoderArray2[n5].encode((EncoderContext)object);
            if (((EncoderContext)object).getNewEncoding() < 0) continue;
            n5 = ((EncoderContext)object).getNewEncoding();
            ((EncoderContext)object).resetEncoderSignal();
        }
        int n6 = ((EncoderContext)object).getCodewordCount();
        ((EncoderContext)object).updateSymbolInfo();
        int n7 = ((EncoderContext)object).getSymbolInfo().getDataCapacity();
        if (n6 < n7 && n5 != 0 && n5 != 5) {
            ((EncoderContext)object).writeCodeword('\u00fe');
        }
        if ((stringBuilder = ((EncoderContext)object).getCodewords()).length() < n7) {
            stringBuilder.append('\u0081');
        }
        while (stringBuilder.length() < n7) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(HighLevelEncoder.randomize253State('\u0081', stringBuilder2.length() + 1));
        }
        return ((EncoderContext)object).getCodewords().toString();
    }

    static int lookAheadTest(CharSequence object, int n5, int n6) {
        block21: {
            float[] fArray;
            if (n5 >= object.length()) {
                return n6;
            }
            if (n6 == 0) {
                float[] fArray2 = new float[6];
                fArray = fArray2;
                fArray2[0] = 0.0f;
                fArray2[1] = 1.0f;
                fArray2[2] = 1.0f;
                fArray2[3] = 1.0f;
                fArray2[4] = 1.0f;
                fArray2[5] = 1.25f;
            } else {
                float[] fArray3 = new float[6];
                float[] fArray4 = fArray3;
                fArray3[0] = 1.0f;
                fArray3[1] = 2.0f;
                fArray3[2] = 2.0f;
                fArray3[3] = 2.0f;
                fArray3[4] = 2.0f;
                fArray3[5] = 2.25f;
                fArray3[n6] = 0.0f;
                fArray = fArray4;
            }
            int n7 = 0;
            while (true) {
                int n8;
                byte by;
                byte by2;
                float f5;
                float f6;
                char c6;
                if ((c6 = n5 + n7) == object.length()) {
                    object = new byte[6];
                    int[] nArray = new int[6];
                    int n9 = HighLevelEncoder.findMinimums(fArray, nArray, Integer.MAX_VALUE, (byte[])object);
                    int n10 = HighLevelEncoder.getMinimumCount((byte[])object);
                    if (nArray[0] == n9) {
                        return 0;
                    }
                    if (n10 == 1 && object[5] > 0) {
                        return 5;
                    }
                    if (n10 == 1 && object[4] > 0) {
                        return 4;
                    }
                    if (n10 == 1 && object[2] > 0) {
                        return 2;
                    }
                    if (n10 == 1 && object[3] > 0) {
                        return 3;
                    }
                    return 1;
                }
                char c7 = object.charAt(c6);
                c6 = c7;
                ++n7;
                if (HighLevelEncoder.isDigit(c7)) {
                    fArray[0] = f6 = (float)((double)fArray[0] + 0.5);
                } else if (HighLevelEncoder.isExtendedASCII(c6)) {
                    fArray[0] = f6 = (float)((int)Math.ceil(fArray[0]));
                    fArray[0] = f6 += 2.0f;
                } else {
                    fArray[0] = f6 = (float)((int)Math.ceil(fArray[0]));
                    fArray[0] = f6 += 1.0f;
                }
                fArray[1] = HighLevelEncoder.isNativeC40(c6) ? (f6 = fArray[1] + 0.6666667f) : (HighLevelEncoder.isExtendedASCII(c6) ? (f6 = fArray[1] + 2.6666667f) : (f6 = fArray[1] + 1.3333334f));
                fArray[2] = HighLevelEncoder.isNativeText(c6) ? (f6 = fArray[2] + 0.6666667f) : (HighLevelEncoder.isExtendedASCII(c6) ? (f6 = fArray[2] + 2.6666667f) : (f6 = fArray[2] + 1.3333334f));
                fArray[3] = HighLevelEncoder.isNativeX12(c6) ? (f6 = fArray[3] + 0.6666667f) : (HighLevelEncoder.isExtendedASCII(c6) ? (f6 = fArray[3] + 4.3333335f) : (f6 = fArray[3] + 3.3333333f));
                fArray[4] = HighLevelEncoder.isNativeEDIFACT(c6) ? (f6 = fArray[4] + 0.75f) : (HighLevelEncoder.isExtendedASCII(c6) ? (f6 = fArray[4] + 4.25f) : (f6 = fArray[4] + 3.25f));
                fArray[5] = HighLevelEncoder.isSpecialB256(c6) ? (f5 = fArray[5] + 4.0f) : (f5 = fArray[5] + 1.0f);
                if (n7 < 4) continue;
                int[] nArray = new int[6];
                byte[] byArray = new byte[6];
                HighLevelEncoder.findMinimums(fArray, nArray, Integer.MAX_VALUE, byArray);
                int n11 = HighLevelEncoder.getMinimumCount(byArray);
                int n12 = nArray[0];
                int n13 = nArray[5];
                if (n12 < n13 && n12 < nArray[1] && n12 < nArray[2] && n12 < nArray[3] && n12 < nArray[4]) {
                    return 0;
                }
                if (n13 < n12 || byArray[1] + (by2 = byArray[2]) + (by = byArray[3]) + (n8 = byArray[4]) == 0) break block21;
                if (n11 == 1 && n8 > 0) {
                    return 4;
                }
                if (n11 == 1 && by2 > 0) {
                    return 2;
                }
                if (n11 == 1 && by > 0) {
                    return 3;
                }
                n8 = nArray[1];
                if (n8 + 1 >= n12 || n8 + 1 >= n13 || n8 + 1 >= nArray[4] || n8 + 1 >= nArray[2]) continue;
                int n14 = nArray[3];
                if (n8 < n14) {
                    return 1;
                }
                if (n8 == n14) break;
            }
            for (n5 = n5 + n7 + 1; n5 < object.length(); ++n5) {
                char c8 = object.charAt(n5);
                if (HighLevelEncoder.isX12TermSep(c8)) {
                    return 3;
                }
                if (!HighLevelEncoder.isNativeX12(c8)) break;
            }
            return 1;
        }
        return 5;
    }

    private static int findMinimums(float[] fArray, int[] nArray, int n5, byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
        for (int i5 = 0; i5 < 6; ++i5) {
            int n6;
            nArray[i5] = n6 = (int)Math.ceil(fArray[i5]);
            if (n5 > n6) {
                Arrays.fill(byArray, (byte)0);
                n5 = n6;
            }
            if (n5 != n6) continue;
            byArray[i5] = (byte)(byArray[i5] + 1);
        }
        return n5;
    }

    private static int getMinimumCount(byte[] byArray) {
        int n5 = 0;
        for (int i5 = 0; i5 < 6; ++i5) {
            n5 += byArray[i5];
        }
        return n5;
    }

    static boolean isDigit(char c6) {
        return c6 >= '0' && c6 <= '9';
    }

    static boolean isExtendedASCII(char c6) {
        return c6 >= '\u0080' && c6 <= '\u00ff';
    }

    private static boolean isNativeC40(char c6) {
        return c6 == ' ' || c6 >= '0' && c6 <= '9' || c6 >= 'A' && c6 <= 'Z';
    }

    private static boolean isNativeText(char c6) {
        return c6 == ' ' || c6 >= '0' && c6 <= '9' || c6 >= 'a' && c6 <= 'z';
    }

    private static boolean isNativeX12(char c6) {
        return HighLevelEncoder.isX12TermSep(c6) || c6 == ' ' || c6 >= '0' && c6 <= '9' || c6 >= 'A' && c6 <= 'Z';
    }

    private static boolean isX12TermSep(char c6) {
        return c6 == '\r' || c6 == '*' || c6 == '>';
    }

    private static boolean isNativeEDIFACT(char c6) {
        return c6 >= ' ' && c6 <= '^';
    }

    private static boolean isSpecialB256(char c6) {
        return false;
    }

    public static int determineConsecutiveDigitCount(CharSequence charSequence, int n5) {
        int n6 = 0;
        int n7 = charSequence.length();
        if (n5 < n7) {
            char c6 = charSequence.charAt(n5);
            while (HighLevelEncoder.isDigit(c6) && n5 < n7) {
                ++n6;
                if (++n5 >= n7) continue;
                c6 = charSequence.charAt(n5);
            }
        }
        return n6;
    }

    static void illegalCharacter(char c6) {
        String string2 = Integer.toHexString(c6);
        int n5 = 4 - string2.length();
        string2 = "0000".substring(0, n5) + string2;
        throw new IllegalArgumentException("Illegal character: " + c6 + " (0x" + string2 + ')');
    }
}

