/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.Code128Reader;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import java.util.ArrayList;
import java.util.Map;

public final class Code128Writer
extends OneDimensionalCodeWriter {
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_STOP = 106;
    private static final char ESCAPE_FNC_1 = '\u00f1';
    private static final char ESCAPE_FNC_2 = '\u00f2';
    private static final char ESCAPE_FNC_3 = '\u00f3';
    private static final char ESCAPE_FNC_4 = '\u00f4';
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_B = 100;

    private static boolean isDigits(CharSequence charSequence, int n5, int n6) {
        n6 = n5 + n6;
        int n7 = charSequence.length();
        while (n5 < n6 && n5 < n7) {
            char c6 = charSequence.charAt(n5);
            if (c6 < '0' || c6 > '9') {
                if (c6 != '\u00f1') {
                    return false;
                }
                ++n6;
            }
            ++n5;
        }
        return n6 <= n7;
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.CODE_128) {
            return super.encode(string2, barcodeFormat, n5, n6, map);
        }
        throw new IllegalArgumentException("Can only encode CODE_128, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String object) {
        int n5 = ((String)object).length();
        if (n5 >= 1 && n5 <= 80) {
            ArrayList<int[]> arrayList;
            int n6;
            for (int i5 = 0; i5 < n5; ++i5) {
                n6 = ((String)object).charAt(i5);
                if (n6 >= 32 && n6 <= 126) continue;
                switch (n6) {
                    default: {
                        throw new IllegalArgumentException("Bad character in input: " + (char)n6);
                    }
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                }
            }
            Object object2 = arrayList;
            arrayList = new ArrayList<int[]>();
            n6 = 0;
            int n7 = 1;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n5) {
                int n10 = n8 == 99 ? 2 : 4;
                if ((n10 = Code128Writer.isDigits((CharSequence)object, n9, n10) ? 99 : 100) == n8) {
                    switch (((String)object).charAt(n9)) {
                        default: {
                            if (n8 == 100) {
                                n10 = ((String)object).charAt(n9) - 32;
                                break;
                            }
                            int n11 = n9++;
                            n10 = Integer.parseInt(((String)object).substring(n11, n11 + 2));
                            break;
                        }
                        case '\u00f4': {
                            n10 = 100;
                            break;
                        }
                        case '\u00f3': {
                            n10 = 96;
                            break;
                        }
                        case '\u00f2': {
                            n10 = 97;
                            break;
                        }
                        case '\u00f1': {
                            n10 = 102;
                        }
                    }
                    ++n9;
                } else {
                    n8 = n8 == 0 ? (n10 == 100 ? 104 : 105) : n10;
                    int n12 = n8;
                    n8 = n10;
                    n10 = n12;
                }
                object2.add(Code128Reader.CODE_PATTERNS[n10]);
                n6 += n10 * n7;
                if (n9 == 0) continue;
                ++n7;
            }
            ArrayList<int[]> arrayList2 = object2;
            n5 = n6 % 103;
            object2.add(Code128Reader.CODE_PATTERNS[n5]);
            arrayList2.add(Code128Reader.CODE_PATTERNS[106]);
            n5 = 0;
            for (int[] nArray : arrayList2) {
                n7 = nArray.length;
                for (n8 = 0; n8 < n7; ++n8) {
                    n5 += nArray[n8];
                }
            }
            boolean[] blArray = new boolean[n5];
            int n13 = 0;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                n13 += OneDimensionalCodeWriter.appendPattern(blArray, n13, (int[])object2.next(), true);
            }
            return blArray;
        }
        throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got " + n5);
    }
}

