/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultMetadataType;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.UPCEANReader;
import java.util.EnumMap;
import java.util.Map;

final class UPCEANExtension5Support {
    private static final int[] CHECK_DIGIT_ENCODINGS = new int[]{24, 20, 18, 17, 12, 6, 3, 10, 9, 5};
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension5Support() {
    }

    private static int extensionChecksum(CharSequence charSequence) {
        int n5 = charSequence.length();
        int n6 = 0;
        for (int i5 = n5 - 2; i5 >= 0; i5 -= 2) {
            n6 += charSequence.charAt(i5) - 48;
        }
        int n7 = n5;
        n5 = n6 * 3;
        for (n6 = (v96556) - 1; n6 >= 0; n6 -= 2) {
            n5 += charSequence.charAt(n6) - 48;
        }
        return n5 * 3 % 10;
    }

    private static int determineCheckDigit(int n5) throws NotFoundException {
        for (int i5 = 0; i5 < 10; ++i5) {
            if (n5 != CHECK_DIGIT_ENCODINGS[i5]) continue;
            return i5;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static Map<ResultMetadataType, Object> parseExtensionString(String string2) {
        if (string2.length() != 5) {
            return null;
        }
        if ((string2 = UPCEANExtension5Support.parseExtension5String(string2)) == null) {
            return null;
        }
        EnumMap<ResultMetadataType, Object> enumMap = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        enumMap.put(ResultMetadataType.SUGGESTED_PRICE, string2);
        return enumMap;
    }

    private static String parseExtension5String(String string2) {
        String string3;
        char c6 = string2.charAt(0);
        if (c6 != '0') {
            if (c6 != '5') {
                if (c6 != '9') {
                    string3 = "";
                } else {
                    if ("90000".equals(string2)) {
                        return null;
                    }
                    if ("99991".equals(string2)) {
                        return "0.00";
                    }
                    if ("99990".equals(string2)) {
                        return "Used";
                    }
                    string3 = "";
                }
            } else {
                string3 = "$";
            }
        } else {
            string3 = "\u00a3";
        }
        int n5 = Integer.parseInt(string2.substring(1));
        string2 = String.valueOf(n5 / 100);
        int n6 = n5 % 100;
        String string4 = n6 < 10 ? "0" + n6 : String.valueOf(n6);
        return string3 + string2 + '.' + string4;
    }

    Result decodeRow(int n5, BitArray object, int[] nArray) throws NotFoundException {
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        Result result;
        Object object2 = this.decodeRowStringBuffer;
        ((StringBuilder)object2).setLength(0);
        int n6 = this.decodeMiddle((BitArray)object, nArray, (StringBuilder)object2);
        object = ((StringBuilder)object2).toString();
        object2 = UPCEANExtension5Support.parseExtensionString((String)object);
        Result result2 = result;
        Object object3 = object;
        object = resultPoint2;
        float f5 = (float)(nArray[0] + nArray[1]) / 2.0f;
        float f6 = n5;
        resultPoint2 = new ResultPoint(f5, f6);
        Object object4 = resultPoint;
        resultPoint = new ResultPoint(n6, f6);
        ResultPoint[] resultPointArray = new ResultPoint[2];
        ResultPoint[] resultPointArray2 = resultPointArray;
        resultPointArray[0] = object;
        resultPointArray[1] = object4;
        object4 = BarcodeFormat.UPC_EAN_EXTENSION;
        result = new Result((String)object3, null, resultPointArray2, (BarcodeFormat)((Object)object4));
        if (object2 != null) {
            result2.putAllMetadata((Map<ResultMetadataType, Object>)object2);
        }
        return result2;
    }

    int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int[] nArray2 = ((UPCEANExtension5Support)object).decodeMiddleCounters;
        Object object = nArray2;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        ((UPCEANExtension5Support)object).decodeMiddleCounters[3] = 0;
        int n5 = bitArray.getSize();
        int n6 = nArray[1];
        int n7 = 0;
        for (int i5 = 0; i5 < 5 && n6 < n5; ++i5) {
            int n8 = UPCEANReader.decodeDigit(bitArray, (int[])object, n6, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(n8 % 10 + 48));
            int n9 = ((Object)object).length;
            for (int i6 = 0; i6 < n9; ++i6) {
                n6 += object[i6];
            }
            if (n8 >= 10) {
                n7 |= 1 << 4 - i5;
            }
            if (i5 == 4) continue;
            BitArray bitArray2 = bitArray;
            n6 = bitArray2.getNextUnset(bitArray2.getNextSet(n6));
        }
        if (stringBuilder.length() == 5) {
            int n10 = UPCEANExtension5Support.determineCheckDigit(n7);
            if (UPCEANExtension5Support.extensionChecksum(stringBuilder.toString()) == n10) {
                return n6;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

