/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ReaderException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultMetadataType;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.ResultPointCallback;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.EANManufacturerOrgSupport;
import com.dcloud.zxing2.oned.OneDReader;
import com.dcloud.zxing2.oned.UPCEANExtensionSupport;
import java.util.Arrays;
import java.util.Map;

public abstract class UPCEANReader
extends OneDReader {
    private static final float MAX_AVG_VARIANCE = 0.48f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.7f;
    static final int[] START_END_PATTERN = new int[]{1, 1, 1};
    static final int[] MIDDLE_PATTERN = new int[]{1, 1, 1, 1, 1};
    static final int[] END_PATTERN = new int[]{1, 1, 1, 1, 1, 1};
    static final int[][] L_PATTERNS;
    static final int[][] L_AND_G_PATTERNS;
    private final StringBuilder decodeRowStringBuffer;
    private final UPCEANExtensionSupport extensionReader;
    private final EANManufacturerOrgSupport eanManSupport;

    protected UPCEANReader() {
        EANManufacturerOrgSupport eANManufacturerOrgSupport;
        UPCEANExtensionSupport uPCEANExtensionSupport;
        StringBuilder stringBuilder;
        Object object = stringBuilder;
        stringBuilder = new StringBuilder(20);
        v1.decodeRowStringBuffer = object;
        object = uPCEANExtensionSupport;
        uPCEANExtensionSupport = new UPCEANExtensionSupport();
        v1.extensionReader = object;
        object = eANManufacturerOrgSupport;
        eANManufacturerOrgSupport = new EANManufacturerOrgSupport();
        v1.eanManSupport = object;
    }

    static int[] findStartGuardPattern(BitArray bitArray) throws NotFoundException {
        boolean bl = false;
        int[] nArray = null;
        int n5 = 0;
        int[] nArray2 = new int[START_END_PATTERN.length];
        while (!bl) {
            nArray = START_END_PATTERN;
            Arrays.fill(nArray2, 0, START_END_PATTERN.length, 0);
            nArray = UPCEANReader.findGuardPattern(bitArray, n5, false, nArray, nArray2);
            n5 = nArray[0];
            int n6 = nArray[1];
            int n7 = n5 - (n6 - n5);
            if (n7 >= 0) {
                bl = bitArray.isRange(n7, n5, false);
            }
            n5 = n6;
        }
        return nArray;
    }

    static boolean checkStandardUPCEANChecksum(CharSequence charSequence) throws FormatException {
        int n5;
        int n6 = charSequence.length();
        if (n6 == 0) {
            return false;
        }
        int n7 = 0;
        for (n5 = n6 - 2; n5 >= 0; n5 -= 2) {
            int n8 = charSequence.charAt(n5) - 48;
            if (n8 >= 0 && n8 <= 9) {
                n7 += n8;
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        int n9 = n6;
        n6 = n7 * 3;
        for (n7 = (v97009) - 1; n7 >= 0; n7 -= 2) {
            n5 = charSequence.charAt(n7) - 48;
            if (n5 >= 0 && n5 <= 9) {
                n6 += n5;
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        return n6 % 10 == 0;
    }

    static int[] findGuardPattern(BitArray object, int n5, boolean bl, int[] nArray) throws NotFoundException {
        BitArray bitArray = object;
        object = new int[nArray.length];
        return UPCEANReader.findGuardPattern(bitArray, n5, bl, nArray, (int[])object);
    }

    private static int[] findGuardPattern(BitArray bitArray, int n5, boolean n6, int[] nArray, int[] nArray2) throws NotFoundException {
        int n7 = nArray.length;
        int n8 = bitArray.getSize();
        n5 = n6 != 0 ? bitArray.getNextUnset(n5) : bitArray.getNextSet(n5);
        int n9 = 0;
        int n10 = n6;
        n6 = n5;
        int n11 = n9;
        n9 = n10;
        while (n5 < n8) {
            if (bitArray.get(n5) ^ n9) {
                nArray2[n11] = nArray2[n11] + 1;
            } else {
                int n12 = n7 - 1;
                if (n11 == n12) {
                    if (OneDReader.patternMatchVariance(nArray2, nArray, 0.7f) < 0.48f) {
                        return new int[]{n6, n5};
                    }
                    int n13 = n12;
                    n6 += nArray2[0] + nArray2[1];
                    n12 = n7 - 2;
                    System.arraycopy(nArray2, 2, nArray2, 0, n12);
                    nArray2[n12] = 0;
                    nArray2[n13] = 0;
                    --n11;
                } else {
                    ++n11;
                }
                nArray2[n11] = 1;
                n9 ^= 1;
            }
            ++n5;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static int decodeDigit(BitArray bitArray, int[] nArray, int n5, int[][] nArray2) throws NotFoundException {
        OneDReader.recordPattern(bitArray, n5, nArray);
        float f5 = 0.48f;
        n5 = -1;
        int n6 = nArray2.length;
        for (int i5 = 0; i5 < n6; ++i5) {
            float f6;
            float f7 = OneDReader.patternMatchVariance(nArray, nArray2[i5], 0.7f);
            if (!(f6 < f5)) continue;
            n5 = i5;
            f5 = f7;
        }
        if (n5 >= 0) {
            return n5;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[4];
        Object object = nArray;
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 1;
        nArrayArray[0] = object;
        int[] nArray2 = new int[4];
        object = nArray2;
        nArray2[0] = 2;
        nArray2[1] = 2;
        nArray2[2] = 2;
        nArray2[3] = 1;
        nArrayArray[1] = object;
        int[] nArray3 = new int[4];
        object = nArray3;
        nArray3[0] = 2;
        nArray3[1] = 1;
        nArray3[2] = 2;
        nArray3[3] = 2;
        nArrayArray[2] = object;
        int[] nArray4 = new int[4];
        object = nArray4;
        nArray4[0] = 1;
        nArray4[1] = 4;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArrayArray[3] = object;
        int[] nArray5 = new int[4];
        object = nArray5;
        nArray5[0] = 1;
        nArray5[1] = 1;
        nArray5[2] = 3;
        nArray5[3] = 2;
        nArrayArray[4] = object;
        int[] nArray6 = new int[4];
        object = nArray6;
        nArray6[0] = 1;
        nArray6[1] = 2;
        nArray6[2] = 3;
        nArray6[3] = 1;
        nArrayArray[5] = object;
        int[] nArray7 = new int[4];
        object = nArray7;
        nArray7[0] = 1;
        nArray7[1] = 1;
        nArray7[2] = 1;
        nArray7[3] = 4;
        nArrayArray[6] = object;
        int[] nArray8 = new int[4];
        object = nArray8;
        nArray8[0] = 1;
        nArray8[1] = 3;
        nArray8[2] = 1;
        nArray8[3] = 2;
        nArrayArray[7] = object;
        int[] nArray9 = new int[4];
        object = nArray9;
        nArray9[0] = 1;
        nArray9[1] = 2;
        nArray9[2] = 1;
        nArray9[3] = 3;
        nArrayArray[8] = object;
        int[] nArray10 = new int[4];
        object = nArray10;
        nArray10[0] = 3;
        nArray10[1] = 1;
        nArray10[2] = 1;
        nArray10[3] = 2;
        nArrayArray[9] = object;
        L_PATTERNS = nArrayArray;
        int[][] nArrayArray2 = new int[20][];
        object = nArrayArray2;
        L_AND_G_PATTERNS = nArrayArray2;
        System.arraycopy(nArrayArray, 0, object, 0, 10);
        for (int i5 = 10; i5 < 20; ++i5) {
            int[] nArray11 = L_PATTERNS[i5 - 10];
            int[] nArray12 = new int[nArray11.length];
            for (int i6 = 0; i6 < nArray11.length; ++i6) {
                nArray12[i6] = nArray11[nArray11.length - i6 - 1];
            }
            UPCEANReader.L_AND_G_PATTERNS[i5] = nArray12;
        }
    }

    @Override
    public Result decodeRow(int n5, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        return this.decodeRow(n5, bitArray, UPCEANReader.findStartGuardPattern(bitArray), map);
    }

    public Result decodeRow(int n5, BitArray object, int[] nArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        int n6;
        int n7;
        ResultPointCallback resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        if (resultPointCallback != null) {
            float f5 = (float)(nArray[0] + nArray[1]) / 2.0f;
            resultPointCallback.foundPossibleResultPoint(new ResultPoint(f5, n5));
        }
        UPCEANReader uPCEANReader = this;
        StringBuilder stringBuilder = uPCEANReader.decodeRowStringBuffer;
        stringBuilder.setLength(0);
        int n8 = uPCEANReader.decodeMiddle((BitArray)object, nArray, stringBuilder);
        if (resultPointCallback != null) {
            ResultPoint resultPoint;
            ResultPoint resultPoint2 = resultPoint;
            float f6 = n8;
            resultPoint = new ResultPoint(f6, n5);
            resultPointCallback.foundPossibleResultPoint(resultPoint2);
        }
        int[] nArray2 = ((UPCEANReader)this).decodeEnd((BitArray)object, n8);
        if (resultPointCallback != null) {
            float f7 = (float)(nArray2[0] + nArray2[1]) / 2.0f;
            resultPointCallback.foundPossibleResultPoint(new ResultPoint(f7, n5));
        }
        if ((n7 = (n6 = nArray2[1]) + (n6 - nArray2[0])) < object.getSize() && object.isRange(n6, n7, false)) {
            String string2 = stringBuilder.toString();
            if (string2.length() >= 8) {
                if (((UPCEANReader)this).checkChecksum(string2)) {
                    Result result;
                    BarcodeFormat barcodeFormat;
                    block14: {
                        Result result2;
                        ResultPoint resultPoint;
                        ResultPoint resultPoint3;
                        Result result3;
                        float f8 = (float)(nArray[1] + nArray[0]) / 2.0f;
                        float f9 = (float)(nArray2[1] + nArray2[0]) / 2.0f;
                        barcodeFormat = ((UPCEANReader)this).getBarcodeFormat();
                        result = result3;
                        ResultPoint resultPoint4 = resultPoint3;
                        float f10 = f8;
                        f8 = n5;
                        resultPoint3 = new ResultPoint(f10, f8);
                        ResultPoint resultPoint5 = resultPoint;
                        resultPoint = new ResultPoint(f9, f8);
                        ResultPoint[] resultPointArray = new ResultPoint[2];
                        ResultPoint[] resultPointArray2 = resultPointArray;
                        resultPointArray[0] = resultPoint4;
                        resultPointArray[1] = resultPoint5;
                        result(string2, null, resultPointArray2, barcodeFormat);
                        int n9 = 0;
                        try {
                            result2 = ((UPCEANReader)this).extensionReader.decodeRow(n5, (BitArray)object, nArray2[1]);
                        }
                        catch (ReaderException readerException) {}
                        object = ResultMetadataType.UPC_EAN_EXTENSION;
                        result3.putMetadata((ResultMetadataType)((Object)object), result2.getText());
                        result3.putAllMetadata(result2.getResultMetadata());
                        result3.addResultPoints(result2.getResultPoints());
                        n9 = result2.getText().length();
                        int[] nArray3 = map == null ? null : (int[])map.get((Object)DecodeHintType.ALLOWED_EAN_EXTENSIONS);
                        if (nArray3 != null) {
                            int n10 = nArray3.length;
                            for (int i5 = 0; i5 < n10; ++i5) {
                                if (n9 != nArray3[i5]) {
                                    continue;
                                }
                                break block14;
                            }
                            throw NotFoundException.getNotFoundInstance();
                        }
                    }
                    if ((barcodeFormat == BarcodeFormat.EAN_13 || barcodeFormat == BarcodeFormat.UPC_A) && (this = ((UPCEANReader)this).eanManSupport.lookupCountryIdentifier(string2)) != null) {
                        result.putMetadata(ResultMetadataType.POSSIBLE_COUNTRY, this);
                    }
                    return result;
                }
                throw ChecksumException.getChecksumInstance();
            }
            throw FormatException.getFormatInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    boolean checkChecksum(String string2) throws FormatException {
        return UPCEANReader.checkStandardUPCEANChecksum(string2);
    }

    int[] decodeEnd(BitArray bitArray, int n5) throws NotFoundException {
        return UPCEANReader.findGuardPattern(bitArray, n5, false, START_END_PATTERN);
    }

    abstract BarcodeFormat getBarcodeFormat();

    protected abstract int decodeMiddle(BitArray var1, int[] var2, StringBuilder var3) throws NotFoundException;
}

