/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.pdf417.decoder.BarcodeMetadata;
import com.dcloud.zxing2.pdf417.decoder.BoundingBox;
import com.dcloud.zxing2.pdf417.decoder.Codeword;
import com.dcloud.zxing2.pdf417.decoder.DetectionResultColumn;
import com.dcloud.zxing2.pdf417.decoder.DetectionResultRowIndicatorColumn;
import java.util.Formatter;

final class DetectionResult {
    private static final int ADJUST_ROW_NUMBER_SKIP = 2;
    private final BarcodeMetadata barcodeMetadata;
    private final DetectionResultColumn[] detectionResultColumns;
    private BoundingBox boundingBox;
    private final int barcodeColumnCount;

    DetectionResult(BarcodeMetadata barcodeMetadata, BoundingBox boundingBox) {
        int n5;
        this.barcodeMetadata = barcodeMetadata;
        this.barcodeColumnCount = n5 = barcodeMetadata.getColumnCount();
        this.boundingBox = boundingBox;
        this.detectionResultColumns = new DetectionResultColumn[n5 + 2];
    }

    private void adjustIndicatorColumnRowNumbers(DetectionResultColumn detectionResultColumn) {
        if (detectionResultColumn != null) {
            ((DetectionResultRowIndicatorColumn)detectionResultColumn).adjustCompleteIndicatorColumnRowNumbers(this.barcodeMetadata);
        }
    }

    private int adjustRowNumbers() {
        int n5 = this.adjustRowNumbersByRow();
        if (n5 == 0) {
            return 0;
        }
        for (int i5 = 1; i5 < this.barcodeColumnCount + 1; ++i5) {
            Codeword[] codewordArray = this.detectionResultColumns[i5].getCodewords();
            for (int i6 = 0; i6 < codewordArray.length; ++i6) {
                Codeword codeword = codewordArray[i6];
                if (codeword == null || codeword.hasValidRowNumber()) continue;
                this.adjustRowNumbers(i5, i6, codewordArray);
            }
        }
        return n5;
    }

    private int adjustRowNumbersByRow() {
        DetectionResult detectionResult = this;
        detectionResult.adjustRowNumbersFromBothRI();
        return detectionResult.adjustRowNumbersFromLRI() + this.adjustRowNumbersFromRRI();
    }

    private void adjustRowNumbersFromBothRI() {
        Object[] objectArray = this.detectionResultColumns;
        Codeword[] codewordArray = this.detectionResultColumns[0];
        if (codewordArray != null && objectArray[this.barcodeColumnCount + 1] != null) {
            objectArray = codewordArray.getCodewords();
            codewordArray = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
            for (int i5 = 0; i5 < objectArray.length; ++i5) {
                Object object = objectArray[i5];
                if (object == null || codewordArray[i5] == null || ((Codeword)object).getRowNumber() != codewordArray[i5].getRowNumber()) continue;
                for (int i6 = 1; i6 <= this.barcodeColumnCount; ++i6) {
                    Codeword codeword = this.detectionResultColumns[i6].getCodewords()[i5];
                    if (codeword == null) continue;
                    Codeword codeword2 = codeword;
                    codeword2.setRowNumber(((Codeword)objectArray[i5]).getRowNumber());
                    if (codeword2.hasValidRowNumber()) continue;
                    this.detectionResultColumns[i6].getCodewords()[i5] = null;
                }
            }
            return;
        }
    }

    private int adjustRowNumbersFromRRI() {
        DetectionResultColumn[] detectionResultColumnArray = this.detectionResultColumns;
        int n5 = this.barcodeColumnCount;
        if (this.detectionResultColumns[n5 + 1] == null) {
            return 0;
        }
        int n6 = 0;
        Codeword[] codewordArray = detectionResultColumnArray[n5 + 1].getCodewords();
        for (int i5 = 0; i5 < codewordArray.length; ++i5) {
            Codeword codeword = codewordArray[i5];
            if (codeword == null) continue;
            int n7 = codeword.getRowNumber();
            int n8 = 0;
            for (int i6 = this.barcodeColumnCount + 1; i6 > 0 && n8 < 2; --i6) {
                Codeword codeword2 = this.detectionResultColumns[i6].getCodewords()[i5];
                if (codeword2 == null) continue;
                n8 = DetectionResult.adjustRowNumberIfValid(n7, n8, codeword2);
                if (codeword2.hasValidRowNumber()) continue;
                ++n6;
            }
        }
        return n6;
    }

    private int adjustRowNumbersFromLRI() {
        DetectionResultColumn detectionResultColumn = this.detectionResultColumns[0];
        if (detectionResultColumn == null) {
            return 0;
        }
        int n5 = 0;
        Codeword[] codewordArray = detectionResultColumn.getCodewords();
        for (int i5 = 0; i5 < codewordArray.length; ++i5) {
            Codeword codeword = codewordArray[i5];
            if (codeword == null) continue;
            int n6 = codeword.getRowNumber();
            int n7 = 0;
            for (int i6 = 1; i6 < this.barcodeColumnCount + 1 && n7 < 2; ++i6) {
                Codeword codeword2 = this.detectionResultColumns[i6].getCodewords()[i5];
                if (codeword2 == null) continue;
                n7 = DetectionResult.adjustRowNumberIfValid(n6, n7, codeword2);
                if (codeword2.hasValidRowNumber()) continue;
                ++n5;
            }
        }
        return n5;
    }

    private static int adjustRowNumberIfValid(int n5, int n6, Codeword codeword) {
        if (codeword == null) {
            return n6;
        }
        if (!codeword.hasValidRowNumber()) {
            if (codeword.isValidRowNumber(n5)) {
                codeword.setRowNumber(n5);
                n6 = 0;
            } else {
                ++n6;
            }
        }
        return n6;
    }

    private void adjustRowNumbers(int n5, int n6, Codeword[] codewordArray) {
        int n7;
        DetectionResult detectionResult = codeword;
        Codeword codeword = codewordArray[n6];
        Codeword[] codewordArray2 = detectionResult.detectionResultColumns[n5 - 1].getCodewords();
        Codeword[] codewordArray3 = detectionResult.detectionResultColumns[n5 + 1];
        codewordArray3 = codewordArray3 != null ? codewordArray3.getCodewords() : codewordArray2;
        int n8 = 14;
        Codeword[] codewordArray4 = new Codeword[14];
        Codeword[] codewordArray5 = codewordArray4;
        codewordArray5[2] = codewordArray2[n6];
        codewordArray4[3] = codewordArray3[n6];
        if (n6 > 0) {
            n7 = n6 - 1;
            codewordArray5[0] = codewordArray[n7];
            codewordArray5[4] = codewordArray2[n7];
            codewordArray5[5] = codewordArray3[n7];
        }
        if (n6 > 1) {
            n7 = n6 - 2;
            codewordArray5[8] = codewordArray[n7];
            codewordArray5[10] = codewordArray2[n7];
            codewordArray5[11] = codewordArray3[n7];
        }
        if (n6 < codewordArray.length - 1) {
            n7 = n6 + 1;
            codewordArray5[1] = codewordArray[n7];
            codewordArray5[6] = codewordArray2[n7];
            codewordArray5[7] = codewordArray3[n7];
        }
        if (n6 < codewordArray.length - 2) {
            int n9 = n6 + 2;
            codewordArray5[9] = codewordArray[n9];
            codewordArray5[12] = codewordArray2[n9];
            codewordArray5[13] = codewordArray3[n9];
        }
        for (int i5 = 0; i5 < n8; ++i5) {
            if (!DetectionResult.adjustRowNumber(codeword, codewordArray5[i5])) continue;
            return;
        }
    }

    private static boolean adjustRowNumber(Codeword codeword, Codeword codeword2) {
        if (codeword2 == null) {
            return false;
        }
        if (codeword2.hasValidRowNumber() && codeword2.getBucket() == codeword.getBucket()) {
            codeword.setRowNumber(codeword2.getRowNumber());
            return true;
        }
        return false;
    }

    DetectionResultColumn[] getDetectionResultColumns() {
        int n5;
        DetectionResult detectionResult = this;
        detectionResult.adjustIndicatorColumnRowNumbers(detectionResult.detectionResultColumns[0]);
        detectionResult.adjustIndicatorColumnRowNumbers(detectionResult.detectionResultColumns[this.barcodeColumnCount + 1]);
        int n6 = 928;
        while ((n5 = this.adjustRowNumbers()) > 0 && n5 < n6) {
            n6 = n5;
        }
        return this.detectionResultColumns;
    }

    int getBarcodeColumnCount() {
        return this.barcodeColumnCount;
    }

    int getBarcodeRowCount() {
        return this.barcodeMetadata.getRowCount();
    }

    int getBarcodeECLevel() {
        return this.barcodeMetadata.getErrorCorrectionLevel();
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    void setDetectionResultColumn(int n5, DetectionResultColumn detectionResultColumn) {
        this.detectionResultColumns[n5] = detectionResultColumn;
    }

    DetectionResultColumn getDetectionResultColumn(int n5) {
        return this.detectionResultColumns[n5];
    }

    public String toString() {
        Formatter formatter;
        Object object = this.detectionResultColumns;
        DetectionResultColumn detectionResultColumn = this.detectionResultColumns[0];
        if (detectionResultColumn == null) {
            detectionResultColumn = object[this.barcodeColumnCount + 1];
        }
        object = formatter;
        formatter = new Formatter();
        for (int i5 = 0; i5 < detectionResultColumn.getCodewords().length; ++i5) {
            Integer n5 = i5;
            Object[] objectArray = new Object[1];
            Object object2 = objectArray;
            objectArray[0] = n5;
            ((Formatter)object).format("CW %3d:", (Object[])object2);
            for (int i6 = 0; i6 < this.barcodeColumnCount + 2; ++i6) {
                object2 = this.detectionResultColumns[i6];
                if (object2 == null) {
                    ((Formatter)object).format("    |   ", new Object[0]);
                    continue;
                }
                if ((object2 = ((DetectionResultColumn)object2).getCodewords()[i5]) == null) {
                    ((Formatter)object).format("    |   ", new Object[0]);
                    continue;
                }
                Object object3 = object2;
                object2 = ((Codeword)object3).getRowNumber();
                Integer n6 = ((Codeword)object3).getValue();
                Object[] objectArray2 = new Object[2];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = object2;
                objectArray2[1] = n6;
                ((Formatter)object).format(" %3d|%3d", objectArray3);
            }
            ((Formatter)object).format("%n", new Object[0]);
        }
        String string2 = ((Formatter)object).toString();
        ((Formatter)object).close();
        return string2;
    }
}

