/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.pdf417.PDF417Common;
import com.dcloud.zxing2.pdf417.decoder.BarcodeMetadata;
import com.dcloud.zxing2.pdf417.decoder.BarcodeValue;
import com.dcloud.zxing2.pdf417.decoder.BoundingBox;
import com.dcloud.zxing2.pdf417.decoder.Codeword;
import com.dcloud.zxing2.pdf417.decoder.DecodedBitStreamParser;
import com.dcloud.zxing2.pdf417.decoder.DetectionResult;
import com.dcloud.zxing2.pdf417.decoder.DetectionResultColumn;
import com.dcloud.zxing2.pdf417.decoder.DetectionResultRowIndicatorColumn;
import com.dcloud.zxing2.pdf417.decoder.PDF417CodewordDecoder;
import com.dcloud.zxing2.pdf417.decoder.ec.ErrorCorrection;
import java.util.ArrayList;
import java.util.Formatter;

public final class PDF417ScanningDecoder {
    private static final int CODEWORD_SKEW_SIZE = 2;
    private static final int MAX_ERRORS = 3;
    private static final int MAX_EC_CODEWORDS = 512;
    private static final ErrorCorrection errorCorrection = new ErrorCorrection();

    private PDF417ScanningDecoder() {
    }

    public static DecoderResult decode(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint object, ResultPoint resultPoint2, ResultPoint object2, int n5, int n6) throws NotFoundException, FormatException, ChecksumException {
        BoundingBox boundingBox;
        BoundingBox boundingBox2 = boundingBox;
        boundingBox = new BoundingBox(bitMatrix, resultPoint, (ResultPoint)object, resultPoint2, (ResultPoint)object2);
        object = null;
        object2 = null;
        DetectionResult detectionResult = null;
        for (int i5 = 0; i5 < 2; ++i5) {
            if (resultPoint != null) {
                object = PDF417ScanningDecoder.getRowIndicatorColumn(bitMatrix, boundingBox2, resultPoint, true, n5, n6);
            }
            if (resultPoint2 != null) {
                object2 = PDF417ScanningDecoder.getRowIndicatorColumn(bitMatrix, boundingBox2, resultPoint2, false, n5, n6);
            }
            if ((detectionResult = PDF417ScanningDecoder.merge((DetectionResultRowIndicatorColumn)object, (DetectionResultRowIndicatorColumn)object2)) != null) {
                if (i5 == 0 && detectionResult.getBoundingBox() != null && (detectionResult.getBoundingBox().getMinY() < boundingBox2.getMinY() || detectionResult.getBoundingBox().getMaxY() > boundingBox2.getMaxY())) {
                    boundingBox2 = detectionResult.getBoundingBox();
                    continue;
                }
                detectionResult.setBoundingBox(boundingBox2);
                break;
            }
            throw NotFoundException.getNotFoundInstance();
        }
        DetectionResult detectionResult2 = detectionResult;
        int n7 = detectionResult2.getBarcodeColumnCount() + 1;
        detectionResult2.setDetectionResultColumn(0, (DetectionResultColumn)object);
        detectionResult2.setDetectionResultColumn(n7, (DetectionResultColumn)object2);
        boolean bl = object != null;
        for (int i6 = 1; i6 <= n7; ++i6) {
            int n8;
            DetectionResultColumn detectionResultColumn;
            int n9 = bl ? i6 : n7 - i6;
            if (detectionResult.getDetectionResultColumn(n9) != null) continue;
            if (n9 != 0 && n9 != n7) {
                DetectionResultColumn detectionResultColumn2;
                detectionResultColumn = detectionResultColumn2;
                detectionResultColumn2 = new DetectionResultColumn(boundingBox2);
            } else {
                n8 = n9 == 0 ? 1 : 0;
                detectionResultColumn = new DetectionResultRowIndicatorColumn(boundingBox2, n8 != 0);
            }
            detectionResult.setDetectionResultColumn(n9, detectionResultColumn);
            n8 = -1;
            for (int i7 = boundingBox2.getMinY(); i7 <= boundingBox2.getMaxY(); ++i7) {
                int n10 = PDF417ScanningDecoder.getStartColumn(detectionResult, n9, i7, bl);
                if (n10 < 0 || n10 > boundingBox2.getMaxX()) {
                    if (n8 == -1) continue;
                    n10 = n8;
                }
                BoundingBox boundingBox3 = boundingBox2;
                int n11 = boundingBox3.getMinX();
                Codeword codeword = PDF417ScanningDecoder.detectCodeword(bitMatrix, n11, boundingBox3.getMaxX(), bl, n10, i7, n5, n6);
                if (codeword == null) continue;
                detectionResultColumn.setCodeword(i7, codeword);
                n5 = Math.min(n5, codeword.getWidth());
                n6 = Math.max(n6, codeword.getWidth());
                n8 = n10;
            }
        }
        return PDF417ScanningDecoder.createDecoderResult(detectionResult);
    }

    private static DetectionResult merge(DetectionResultRowIndicatorColumn object, DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn) throws NotFoundException, FormatException {
        if (object == null && detectionResultRowIndicatorColumn == null) {
            return null;
        }
        BarcodeMetadata barcodeMetadata = PDF417ScanningDecoder.getBarcodeMetadata((DetectionResultRowIndicatorColumn)object, detectionResultRowIndicatorColumn);
        if (barcodeMetadata == null) {
            return null;
        }
        object = BoundingBox.merge(PDF417ScanningDecoder.adjustBoundingBox((DetectionResultRowIndicatorColumn)object), PDF417ScanningDecoder.adjustBoundingBox(detectionResultRowIndicatorColumn));
        return new DetectionResult(barcodeMetadata, (BoundingBox)object);
    }

    private static BoundingBox adjustBoundingBox(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn) throws NotFoundException, FormatException {
        if (detectionResultRowIndicatorColumn == null) {
            return null;
        }
        int[] nArray = detectionResultRowIndicatorColumn.getRowHeights();
        if (nArray == null) {
            return null;
        }
        int n5 = PDF417ScanningDecoder.getMax(nArray);
        int n6 = 0;
        for (int n7 : nArray) {
            n6 += n5 - n7;
            if (n7 > 0) break;
        }
        Codeword[] codewordArray = detectionResultRowIndicatorColumn.getCodewords();
        int n8 = 0;
        while (n6 > 0 && codewordArray[n8] == null) {
            --n6;
            ++n8;
        }
        n8 = 0;
        for (int n7 = nArray.length - 1; n7 >= 0; --n7) {
            int n9 = nArray[n7];
            n8 += n5 - n9;
            if (n9 > 0) break;
        }
        int n10 = codewordArray.length - 1;
        while (n8 > 0 && codewordArray[n10] == null) {
            --n8;
            --n10;
        }
        return detectionResultRowIndicatorColumn.getBoundingBox().addMissingRows(n6, n8, detectionResultRowIndicatorColumn.isLeft());
    }

    private static int getMax(int[] nArray) {
        int n5 = -1;
        int n6 = nArray.length;
        for (int i5 = 0; i5 < n6; ++i5) {
            n5 = Math.max(n5, nArray[i5]);
        }
        return n5;
    }

    private static BarcodeMetadata getBarcodeMetadata(DetectionResultRowIndicatorColumn object, DetectionResultRowIndicatorColumn object2) {
        if (object != null && (object = ((DetectionResultRowIndicatorColumn)object).getBarcodeMetadata()) != null) {
            if (object2 != null && (object2 = ((DetectionResultRowIndicatorColumn)object2).getBarcodeMetadata()) != null) {
                if (((BarcodeMetadata)object).getColumnCount() != ((BarcodeMetadata)object2).getColumnCount() && ((BarcodeMetadata)object).getErrorCorrectionLevel() != ((BarcodeMetadata)object2).getErrorCorrectionLevel() && ((BarcodeMetadata)object).getRowCount() != ((BarcodeMetadata)object2).getRowCount()) {
                    return null;
                }
                return object;
            }
            return object;
        }
        return object2 == null ? null : ((DetectionResultRowIndicatorColumn)object2).getBarcodeMetadata();
    }

    private static DetectionResultRowIndicatorColumn getRowIndicatorColumn(BitMatrix bitMatrix, BoundingBox boundingBox, ResultPoint resultPoint, boolean bl, int n5, int n6) {
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn;
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2 = detectionResultRowIndicatorColumn;
        detectionResultRowIndicatorColumn = new DetectionResultRowIndicatorColumn(boundingBox, bl);
        for (int i5 = 0; i5 < 2; ++i5) {
            int n7 = i5 == 0 ? 1 : -1;
            int n8 = (int)resultPoint.getX();
            for (int i6 = (int)(v132459).getY(); i6 <= boundingBox.getMaxY() && i6 >= boundingBox.getMinY(); i6 += n7) {
                BitMatrix bitMatrix2 = bitMatrix;
                Codeword codeword = PDF417ScanningDecoder.detectCodeword(bitMatrix2, 0, bitMatrix2.getWidth(), bl, n8, i6, n5, n6);
                if (codeword == null) continue;
                detectionResultRowIndicatorColumn2.setCodeword(i6, codeword);
                n8 = bl ? codeword.getStartX() : codeword.getEndX();
            }
        }
        return detectionResultRowIndicatorColumn2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void adjustCodewordCount(DetectionResult detectionResult, BarcodeValue[][] barcodeValueArray) throws NotFoundException {
        int[] nArray = barcodeValueArray[0][1].getValue();
        int n5 = detectionResult.getBarcodeColumnCount() * detectionResult.getBarcodeRowCount() - PDF417ScanningDecoder.getNumberOfECCodeWords(detectionResult.getBarcodeECLevel());
        if (nArray.length == 0) {
            if (n5 < 1 || n5 > 928) throw NotFoundException.getNotFoundInstance();
            barcodeValueArray[0][1].setValue(n5);
            return;
        } else {
            if (nArray[0] == n5) return;
            barcodeValueArray[0][1].setValue(n5);
        }
    }

    private static DecoderResult createDecoderResult(DetectionResult object) throws FormatException, ChecksumException, NotFoundException {
        int n5;
        ArrayList<Integer> arrayList;
        ArrayList<int[]> arrayList2;
        ArrayList<Integer> arrayList3;
        DetectionResult detectionResult = object;
        BarcodeValue[][] barcodeValueArray = PDF417ScanningDecoder.createBarcodeMatrix(detectionResult);
        PDF417ScanningDecoder.adjustCodewordCount(detectionResult, barcodeValueArray);
        ArrayList<Integer> arrayList4 = arrayList3;
        arrayList3 = new ArrayList<Integer>();
        int[] nArray = new int[detectionResult.getBarcodeRowCount() * ((DetectionResult)object).getBarcodeColumnCount()];
        ArrayList<int[]> arrayList5 = arrayList2;
        arrayList2 = new ArrayList<int[]>();
        ArrayList<Integer> arrayList6 = arrayList;
        arrayList = new ArrayList<Integer>();
        for (int i5 = 0; i5 < ((DetectionResult)object).getBarcodeRowCount(); ++i5) {
            n5 = 0;
            while (n5 < ((DetectionResult)object).getBarcodeColumnCount()) {
                int n6 = n5 + 1;
                int[] nArray2 = barcodeValueArray[i5][n6].getValue();
                n5 = i5 * ((DetectionResult)object).getBarcodeColumnCount() + n5;
                if (nArray2.length == 0) {
                    arrayList4.add(n5);
                } else if (nArray2.length == 1) {
                    nArray[n5] = nArray2[0];
                } else {
                    arrayList6.add(n5);
                    arrayList5.add(nArray2);
                }
                n5 = n6;
            }
        }
        int n7 = arrayList5.size();
        int[][] nArrayArray = new int[n7][];
        for (n5 = 0; n5 < n7; ++n5) {
            nArrayArray[n5] = (int[])arrayList5.get(n5);
        }
        int n8 = ((DetectionResult)object).getBarcodeECLevel();
        object = PDF417Common.toIntArray(arrayList4);
        return PDF417ScanningDecoder.createDecoderResultFromAmbiguousValues(n8, nArray, (int[])object, PDF417Common.toIntArray(arrayList6), nArrayArray);
    }

    private static DecoderResult createDecoderResultFromAmbiguousValues(int n5, int[] nArray, int[] nArray2, int[] nArray3, int[][] nArray4) throws FormatException, ChecksumException {
        int n6 = nArray3.length;
        int[] nArray5 = new int[n6];
        int n7 = 100;
        block2: while (true) {
            int n8;
            int n9;
            int n10 = n7;
            n7 = n10 + -1;
            if (n10 <= 0) break;
            for (n9 = 0; n9 < n6; ++n9) {
                n8 = nArray3[n9];
                nArray[n8] = nArray4[n9][nArray5[n9]];
            }
            try {
                return PDF417ScanningDecoder.decodeCodewords(nArray, n5, nArray2);
            }
            catch (ChecksumException checksumException) {
                if (n6 != 0) {
                    n9 = 0;
                    while (true) {
                        if (n9 >= n6) continue block2;
                        n8 = nArray5[n9];
                        if (n8 < nArray4[n9].length - 1) {
                            nArray5[n9] = n8 + 1;
                            continue block2;
                        }
                        nArray5[n9] = 0;
                        if (n9 == n6 - 1) break;
                        ++n9;
                    }
                    throw ChecksumException.getChecksumInstance();
                }
                throw ChecksumException.getChecksumInstance();
            }
            break;
        }
        throw ChecksumException.getChecksumInstance();
    }

    private static BarcodeValue[][] createBarcodeMatrix(DetectionResult detectionResult) throws FormatException {
        BarcodeValue[][] barcodeValueArray = new BarcodeValue[detectionResult.getBarcodeRowCount()][detectionResult.getBarcodeColumnCount() + 2];
        for (int i5 = 0; i5 < barcodeValueArray.length; ++i5) {
            Object object;
            for (int i6 = 0; i6 < ((BarcodeValue[])(object = barcodeValueArray[i5])).length; ++i6) {
                BarcodeValue barcodeValue;
                BarcodeValue[] barcodeValueArray2 = object;
                object = barcodeValue;
                barcodeValue = new BarcodeValue();
                barcodeValueArray2[i6] = object;
            }
        }
        int n5 = 0;
        for (DetectionResultColumn detectionResultColumn : detectionResult.getDetectionResultColumns()) {
            if (detectionResultColumn != null) {
                for (Codeword codeword : detectionResultColumn.getCodewords()) {
                    int n6;
                    if (codeword == null || (n6 = codeword.getRowNumber()) < 0 || n6 >= barcodeValueArray.length) continue;
                    barcodeValueArray[n6][n5].setValue(codeword.getValue());
                }
            }
            ++n5;
        }
        return barcodeValueArray;
    }

    private static boolean isValidBarcodeColumn(DetectionResult detectionResult, int n5) {
        return n5 >= 0 && n5 <= detectionResult.getBarcodeColumnCount() + 1;
    }

    /*
     * WARNING - void declaration
     */
    private static int getStartColumn(DetectionResult detectionResult, int n5, int n6, boolean bl) {
        void var5_10;
        void var5_7;
        int n7 = bl ? 1 : -1;
        Object object = null;
        int n8 = n5 - n7;
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n8)) {
            Codeword codeword = detectionResult.getDetectionResultColumn(n8).getCodeword(n6);
        }
        if (var5_7 != null) {
            return bl ? var5_7.getEndX() : var5_7.getStartX();
        }
        Codeword codeword = detectionResult.getDetectionResultColumn(n5).getCodewordNearby(n6);
        if (codeword != null) {
            return bl ? codeword.getStartX() : codeword.getEndX();
        }
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n8)) {
            Codeword codeword2 = detectionResult.getDetectionResultColumn(n8).getCodewordNearby(n6);
        }
        if (var5_10 != null) {
            return bl ? var5_10.getEndX() : var5_10.getStartX();
        }
        n6 = 0;
        while (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n5 -= n7)) {
            for (Codeword codeword3 : detectionResult.getDetectionResultColumn(n5).getCodewords()) {
                if (codeword3 == null) continue;
                return (bl ? codeword3.getEndX() : codeword3.getStartX()) + n7 * n6 * (codeword3.getEndX() - codeword3.getStartX());
            }
            ++n6;
        }
        return bl ? detectionResult.getBoundingBox().getMinX() : detectionResult.getBoundingBox().getMaxX();
    }

    private static Codeword detectCodeword(BitMatrix bitMatrix, int n5, int n6, boolean n7, int n8, int n9, int n10, int n11) {
        BitMatrix bitMatrix2 = bitMatrix;
        int n12 = PDF417ScanningDecoder.adjustCodewordStartColumn(bitMatrix2, n5, n6, n7 != 0, n8, n9);
        int[] nArray = PDF417ScanningDecoder.getModuleBitCount(bitMatrix2, n5, n6, n7 != 0, n12, n9);
        if (nArray == null) {
            return null;
        }
        n6 = PDF417Common.getBitCountSum(nArray);
        if (n7 != 0) {
            n7 = n12 + n6;
        } else {
            for (n7 = 0; n7 < nArray.length / 2; ++n7) {
                int[] nArray2 = nArray;
                n8 = nArray[n7];
                nArray2[n7] = nArray[nArray.length - 1 - n7];
                nArray[nArray2.length - 1 - n7] = n8;
            }
            int n13 = n7 = n12 - n6;
            n7 = n12;
            n12 = n13;
        }
        if (!PDF417ScanningDecoder.checkCodewordSkew(n6, n10, n11)) {
            return null;
        }
        int n14 = PDF417CodewordDecoder.getDecodedValue(nArray);
        n6 = PDF417Common.getCodeword(n14);
        if (n6 == -1) {
            return null;
        }
        n14 = PDF417ScanningDecoder.getCodewordBucketNumber(n14);
        return new Codeword(n12, n7, n14, n6);
    }

    private static int[] getModuleBitCount(BitMatrix bitMatrix, int n5, int n6, boolean bl, int n7, int n8) {
        int n9 = 8;
        int[] nArray = new int[8];
        int n10 = 0;
        int n11 = bl ? 1 : -1;
        boolean bl2 = bl;
        while ((bl && n7 < n6 || !bl && n7 >= n5) && n10 < n9) {
            if (bitMatrix.get(n7, n8) == bl2) {
                nArray[n10] = nArray[n10] + 1;
                n7 += n11;
                continue;
            }
            ++n10;
            bl2 ^= true;
        }
        if (!(n10 == n9 || (bl && n7 == n6 || !bl && n7 == n5) && n10 == 7)) {
            return null;
        }
        return nArray;
    }

    private static int getNumberOfECCodeWords(int n5) {
        return 2 << n5;
    }

    private static int adjustCodewordStartColumn(BitMatrix bitMatrix, int n5, int n6, boolean bl, int n7, int n8) {
        int n9 = bl ? -1 : 1;
        int n10 = n7;
        for (int i5 = 0; i5 < 2; ++i5) {
            while ((bl && n10 >= n5 || !bl && n10 < n6) && bl == bitMatrix.get(n10, n8)) {
                if (Math.abs(n7 - n10) > 2) {
                    return n7;
                }
                n10 += n9;
            }
            n9 = -n9;
            bl ^= true;
        }
        return n10;
    }

    private static boolean checkCodewordSkew(int n5, int n6, int n7) {
        return n6 - 2 <= n5 && n5 <= n7 + 2;
    }

    private static DecoderResult decodeCodewords(int[] nArray, int n5, int[] nArray2) throws FormatException, ChecksumException {
        if (nArray.length != 0) {
            int n6 = n5;
            int n7 = 1 << n5 + 1;
            n5 = PDF417ScanningDecoder.correctErrors(nArray, nArray2, n7);
            PDF417ScanningDecoder.verifyCodewordCount(nArray, n7);
            DecoderResult decoderResult = DecodedBitStreamParser.decode(nArray, String.valueOf(n6));
            decoderResult.setErrorsCorrected(n5);
            decoderResult.setErasures(nArray2.length);
            return decoderResult;
        }
        throw FormatException.getFormatInstance();
    }

    private static int correctErrors(int[] nArray, int[] nArray2, int n5) throws ChecksumException {
        if ((nArray2 == null || nArray2.length <= n5 / 2 + 3) && n5 >= 0 && n5 <= 512) {
            return errorCorrection.decode(nArray, n5, nArray2);
        }
        throw ChecksumException.getChecksumInstance();
    }

    private static void verifyCodewordCount(int[] nArray, int n5) throws FormatException {
        if (nArray.length >= 4) {
            int n6 = nArray[0];
            if (n6 <= nArray.length) {
                if (n6 == 0) {
                    if (n5 < nArray.length) {
                        nArray[0] = nArray.length - n5;
                    } else {
                        throw FormatException.getFormatInstance();
                    }
                }
                return;
            }
            throw FormatException.getFormatInstance();
        }
        throw FormatException.getFormatInstance();
    }

    private static int[] getBitCountForCodeword(int n5) {
        int[] nArray = new int[8];
        int n6 = 0;
        int n7 = 7;
        while (true) {
            int n8;
            if ((n8 = n5 & 1) != n6) {
                n6 = n7 + -1;
                if (n6 < 0) {
                    return nArray;
                }
                int n9 = n6;
                n6 = n8;
                n7 = n9;
            }
            nArray[n7] = nArray[n7] + 1;
            n5 >>= 1;
        }
    }

    private static int getCodewordBucketNumber(int n5) {
        return PDF417ScanningDecoder.getCodewordBucketNumber(PDF417ScanningDecoder.getBitCountForCodeword(n5));
    }

    private static int getCodewordBucketNumber(int[] nArray) {
        return (nArray[0] - nArray[2] + nArray[4] - nArray[6] + 9) % 9;
    }

    public static String toString(BarcodeValue[][] barcodeValueArray) {
        Formatter formatter;
        Formatter formatter2 = formatter;
        formatter = new Formatter();
        for (int i5 = 0; i5 < barcodeValueArray.length; ++i5) {
            Integer n5 = i5;
            Object[] objectArray = new Object[1];
            Object object = objectArray;
            objectArray[0] = n5;
            formatter2.format("Row %2d: ", (Object[])object);
            for (int i6 = 0; i6 < ((BarcodeValue[])(object = barcodeValueArray[i5])).length; ++i6) {
                if (((BarcodeValue)(object = object[i6])).getValue().length == 0) {
                    formatter2.format("        ", null);
                    continue;
                }
                Object object2 = object;
                object = ((BarcodeValue)object2).getValue()[0];
                Integer n6 = ((BarcodeValue)object2).getConfidence(((BarcodeValue)object2).getValue()[0]);
                Object[] objectArray2 = new Object[2];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = object;
                objectArray2[1] = n6;
                formatter2.format("%4d(%2d)", objectArray3);
            }
            formatter2.format("%n", new Object[0]);
        }
        String string2 = formatter2.toString();
        formatter2.close();
        return string2;
    }
}

