/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.detector;

import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Detector {
    private static final int[] INDEXES_START_PATTERN = new int[]{0, 4, 1, 5};
    private static final int[] INDEXES_STOP_PATTERN = new int[]{6, 2, 7, 3};
    private static final float MAX_AVG_VARIANCE = 0.42f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.8f;
    private static final int[] START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private static final int MAX_PIXEL_DRIFT = 3;
    private static final int MAX_PATTERN_DRIFT = 5;
    private static final int SKIPPED_ROW_COUNT_MAX = 25;
    private static final int ROW_STEP = 5;
    private static final int BARCODE_MIN_HEIGHT = 10;

    private Detector() {
    }

    public static PDF417DetectorResult detect(BinaryBitmap object, Map<DecodeHintType, ?> list, boolean bl) throws NotFoundException {
        list = Detector.detect(bl, (BitMatrix)(object = ((BinaryBitmap)object).getBlackMatrix()));
        if (list.isEmpty()) {
            object = ((BitMatrix)object).rotate90();
            list = Detector.detect(bl, (BitMatrix)object);
        }
        if (list.isEmpty()) {
            object = ((BitMatrix)object).rotate90();
            list = Detector.detect(bl, (BitMatrix)object);
        }
        if (list.isEmpty()) {
            object = ((BitMatrix)object).rotate90();
            list = Detector.detect(bl, (BitMatrix)object);
        }
        return new PDF417DetectorResult((BitMatrix)object, list);
    }

    private static List<ResultPoint[]> detect(boolean bl, BitMatrix bitMatrix) {
        ArrayList<ResultPoint[]> arrayList;
        ArrayList<ResultPoint[]> arrayList2 = arrayList;
        arrayList = new ArrayList<ResultPoint[]>();
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        while (n5 < bitMatrix.getHeight()) {
            ResultPoint[] resultPointArray = Detector.findVertices(bitMatrix, n5, n6);
            if (resultPointArray[0] == null && resultPointArray[3] == null) {
                if (!bl2) break;
                bl2 = false;
                n6 = 0;
                for (ResultPoint[] resultPointArray2 : arrayList2) {
                    ResultPoint object;
                    ResultPoint resultPoint = resultPointArray2[1];
                    if (resultPoint != null) {
                        n5 = (int)Math.max((float)n5, resultPoint.getY());
                    }
                    if ((object = resultPointArray2[3]) == null) continue;
                    n5 = Math.max(n5, (int)object.getY());
                }
                n5 += 5;
                continue;
            }
            bl2 = true;
            arrayList2.add(resultPointArray);
            if (!bl) break;
            ResultPoint resultPoint = resultPointArray[2];
            if (resultPoint != null) {
                n5 = (int)resultPoint.getX();
                int n7 = n6 = (int)resultPointArray[2].getY();
                n6 = n5;
                n5 = n7;
                continue;
            }
            n5 = (int)resultPointArray[4].getX();
            int n8 = n6 = (int)resultPointArray[4].getY();
            n6 = n5;
            n5 = n8;
        }
        return arrayList2;
    }

    private static ResultPoint[] findVertices(BitMatrix object, int n5, int n6) {
        BitMatrix bitMatrix = object;
        int n7 = bitMatrix.getHeight();
        int n8 = bitMatrix.getWidth();
        ResultPoint[] resultPointArray = new ResultPoint[8];
        Object object2 = START_PATTERN;
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern((BitMatrix)object, n7, n8, n5, n6, (int[])object2), INDEXES_START_PATTERN);
        ResultPoint resultPoint = resultPointArray[4];
        object2 = resultPoint;
        if (resultPoint != null) {
            n6 = (int)((ResultPoint)object2).getX();
            n5 = (int)resultPointArray[4].getY();
        }
        BitMatrix bitMatrix2 = object;
        object = STOP_PATTERN;
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern(bitMatrix2, n7, n8, n5, n6, (int[])object), INDEXES_STOP_PATTERN);
        return resultPointArray;
    }

    private static void copyToResult(ResultPoint[] resultPointArray, ResultPoint[] resultPointArray2, int[] nArray) {
        for (int i5 = 0; i5 < nArray.length; ++i5) {
            int n5 = nArray[i5];
            resultPointArray[n5] = resultPointArray2[i5];
        }
    }

    private static ResultPoint[] findRowsWithPattern(BitMatrix object, int n5, int n6, int n7, int n8, int[] nArray) {
        int[] nArray2;
        int n9 = 4;
        ResultPoint[] resultPointArray = new ResultPoint[4];
        int n10 = 0;
        int[] nArray3 = new int[nArray.length];
        while (n7 < n5) {
            nArray2 = Detector.findGuardPattern((BitMatrix)object, n8, n7, n6, false, nArray, nArray3);
            if (nArray2 != null) {
                ResultPoint resultPoint;
                ResultPoint resultPoint2;
                int[] nArray4;
                while (n7 > 0 && (nArray4 = Detector.findGuardPattern((BitMatrix)object, n8, n10 = n7 + -1, n6, false, nArray, nArray3)) != null) {
                    nArray2 = nArray4;
                    n7 = n10;
                }
                ResultPoint resultPoint3 = resultPoint2;
                float f5 = nArray2[0];
                float f6 = n7;
                resultPoint2 = new ResultPoint(f5, f6);
                resultPointArray[0] = resultPoint3;
                resultPoint3 = resultPoint;
                resultPoint = new ResultPoint(nArray2[1], f6);
                resultPointArray[1] = resultPoint3;
                n10 = 1;
                break;
            }
            n7 += 5;
        }
        if (n10 != 0) {
            ResultPoint resultPoint;
            ResultPoint resultPoint4;
            n10 = 0;
            int[] nArray5 = new int[2];
            nArray2 = nArray5;
            nArray2[0] = (int)resultPointArray[0].getX();
            nArray5[1] = (int)resultPointArray[1].getX();
            for (n8 = n7 + 1; n8 < n5; ++n8) {
                int[] nArray6 = Detector.findGuardPattern((BitMatrix)object, nArray2[0], n8, n6, false, nArray, nArray3);
                if (nArray6 != null && Math.abs(nArray2[0] - nArray6[0]) < 5 && Math.abs(nArray2[1] - nArray6[1]) < 5) {
                    n10 = 0;
                    nArray2 = nArray6;
                    continue;
                }
                if (n10 > 25) break;
                ++n10;
            }
            object = resultPoint4;
            float f7 = nArray2[0];
            float f8 = n8 -= n10 + 1;
            resultPoint4 = new ResultPoint(f7, f8);
            resultPointArray[2] = object;
            object = resultPoint;
            resultPoint = new ResultPoint(nArray2[1], f8);
            resultPointArray[3] = object;
        }
        if (n8 - n7 < 10) {
            for (int i5 = 0; i5 < n9; ++i5) {
                resultPointArray[i5] = null;
            }
        }
        return resultPointArray;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] findGuardPattern(BitMatrix bitMatrix, int n5, int n6, int n7, boolean bl, int[] nArray, int[] nArray2) {
        void var4_7;
        void var5_8;
        void var6_9;
        void v02 = var6_9;
        Arrays.fill((int[])v02, 0, ((void)v02).length, 0);
        int n8 = ((void)var5_8).length;
        int n9 = 0;
        while (bitMatrix.get(n5, n6) && n5 > 0 && n9++ < 3) {
            --n5;
        }
        int n10 = n9 = 0;
        int n11 = n5;
        n9 = bl ? 1 : 0;
        int n12 = n10;
        while (n5 < n7) {
            if ((bitMatrix.get(n5, n6) ^ n9) != 0) {
                var6_9[n12] = var6_9[n12] + true;
            } else {
                int n13 = n8 - 1;
                if (n12 == n13) {
                    if (Detector.patternMatchVariance((int[])var6_9, (int[])var5_8, 0.8f) < 0.42f) {
                        return new int[]{var4_7, n5};
                    }
                    int n14 = n13;
                    void v32 = var6_9;
                    var4_7 += var6_9[0] + var6_9[1];
                    n13 = n8 - 2;
                    System.arraycopy(v32, 2, var6_9, 0, n13);
                    v32[n13] = false;
                    var6_9[n14] = false;
                    --n12;
                } else {
                    ++n12;
                }
                var6_9[n12] = true;
                n9 ^= 1;
            }
            ++n5;
        }
        if (n12 == n8 - 1 && Detector.patternMatchVariance((int[])var6_9, (int[])var5_8, 0.8f) < 0.42f) {
            int n14 = n5 - 1;
            return new int[]{var4_7, n14};
        }
        return null;
    }

    private static float patternMatchVariance(int[] nArray, int[] nArray2, float f5) {
        int n5 = nArray.length;
        int n6 = 0;
        int n7 = 0;
        for (int i5 = 0; i5 < n5; ++i5) {
            n6 += nArray[i5];
            n7 += nArray2[i5];
        }
        if (n6 < n7) {
            return Float.POSITIVE_INFINITY;
        }
        float f6 = f5;
        f5 = n6;
        float f7 = f5 / (float)n7;
        float f8 = f6 * f7;
        float f9 = 0.0f;
        for (int i6 = 0; i6 < n5; ++i6) {
            float f10;
            float f11 = (float)nArray2[i6] * f7;
            float f12 = nArray[i6];
            f11 = f10 > f11 ? f12 - f11 : (f11 -= f12);
            if (f11 > f8) {
                return Float.POSITIVE_INFINITY;
            }
            f9 += f11;
        }
        return f9 / f5;
    }
}

