/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.encoder;

import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.qrcode.decoder.ErrorCorrectionLevel;
import com.dcloud.zxing2.qrcode.decoder.Version;
import com.dcloud.zxing2.qrcode.encoder.ByteMatrix;
import com.dcloud.zxing2.qrcode.encoder.MaskUtil;
import com.dcloud.zxing2.qrcode.encoder.QRCode;

final class MatrixUtil {
    private static final int[][] POSITION_DETECTION_PATTERN;
    private static final int[][] POSITION_ADJUSTMENT_PATTERN;
    private static final int[][] POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE;
    private static final int[][] TYPE_INFO_COORDINATES;
    private static final int VERSION_INFO_POLY = 7973;
    private static final int TYPE_INFO_POLY = 1335;
    private static final int TYPE_INFO_MASK_PATTERN = 21522;

    private MatrixUtil() {
    }

    static void clearMatrix(ByteMatrix byteMatrix) {
        byteMatrix.clear((byte)-1);
    }

    static void buildMatrix(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, Version version, int n5, ByteMatrix byteMatrix) throws WriterException {
        MatrixUtil.clearMatrix(byteMatrix);
        MatrixUtil.embedBasicPatterns(version, byteMatrix);
        MatrixUtil.embedTypeInfo(errorCorrectionLevel, n5, byteMatrix);
        MatrixUtil.maybeEmbedVersionInfo(version, byteMatrix);
        MatrixUtil.embedDataBits(bitArray, n5, byteMatrix);
    }

    static void embedBasicPatterns(Version version, ByteMatrix byteMatrix) throws WriterException {
        ByteMatrix byteMatrix2 = byteMatrix;
        MatrixUtil.embedPositionDetectionPatternsAndSeparators(byteMatrix2);
        MatrixUtil.embedDarkDotAtLeftBottomCorner(byteMatrix2);
        MatrixUtil.maybeEmbedPositionAdjustmentPatterns(version, byteMatrix);
        MatrixUtil.embedTimingPatterns(byteMatrix);
    }

    static void embedTypeInfo(ErrorCorrectionLevel object, int n5, ByteMatrix byteMatrix) throws WriterException {
        BitArray bitArray;
        ErrorCorrectionLevel errorCorrectionLevel = object;
        object = bitArray;
        bitArray = new BitArray();
        MatrixUtil.makeTypeInfoBits(errorCorrectionLevel, n5, (BitArray)object);
        for (n5 = 0; n5 < ((BitArray)object).getSize(); ++n5) {
            Object object2 = object;
            boolean bl = ((BitArray)object2).get(((BitArray)object2).getSize() - 1 - n5);
            int[] nArray = TYPE_INFO_COORDINATES[n5];
            int n6 = nArray[0];
            byteMatrix.set(n6, nArray[1], bl);
            if (n5 < 8) {
                ByteMatrix byteMatrix2 = byteMatrix;
                byteMatrix2.set(byteMatrix2.getWidth() - n5 - 1, 8, bl);
                continue;
            }
            ByteMatrix byteMatrix3 = byteMatrix;
            byteMatrix3.set(8, byteMatrix3.getHeight() - 7 + (n5 - 8), bl);
        }
    }

    static void maybeEmbedVersionInfo(Version object, ByteMatrix byteMatrix) throws WriterException {
        BitArray bitArray;
        if (((Version)object).getVersionNumber() < 7) {
            return;
        }
        Version version = object;
        object = bitArray;
        bitArray = new BitArray();
        MatrixUtil.makeVersionInfoBits(version, (BitArray)object);
        int n5 = 17;
        for (int i5 = 0; i5 < 6; ++i5) {
            for (int i6 = 0; i6 < 3; ++i6) {
                ByteMatrix byteMatrix2 = byteMatrix;
                boolean bl = ((BitArray)object).get(n5);
                --n5;
                byteMatrix2.set(i5, byteMatrix.getHeight() - 11 + i6, bl);
                byteMatrix2.set(byteMatrix2.getHeight() - 11 + i6, i5, bl);
            }
        }
    }

    static void embedDataBits(BitArray bitArray, int n5, ByteMatrix byteMatrix) throws WriterException {
        int n6 = 0;
        int n7 = -1;
        int n8 = byteMatrix.getHeight() - 1;
        for (int i5 = (v164818).getWidth() - 1; i5 > 0; i5 -= 2) {
            if (i5 == 6) {
                --i5;
            }
            while (n8 >= 0 && n8 < byteMatrix.getHeight()) {
                for (int i6 = 0; i6 < 2; ++i6) {
                    boolean bl;
                    int n9 = i5 - i6;
                    if (!MatrixUtil.isEmpty(byteMatrix.get(n9, n8))) continue;
                    if (n6 < bitArray.getSize()) {
                        bl = bitArray.get(n6);
                        ++n6;
                    } else {
                        bl = false;
                    }
                    if (n5 != -1 && MaskUtil.getDataMaskBit(n5, n9, n8)) {
                        bl ^= true;
                    }
                    byteMatrix.set(n9, n8, bl);
                }
                n8 += n7;
            }
            n7 = -n7;
            n8 += n7;
        }
        if (n6 == bitArray.getSize()) {
            return;
        }
        throw new WriterException("Not all bits consumed: " + n6 + '/' + bitArray.getSize());
    }

    static int findMSBSet(int n5) {
        int n6 = 0;
        while (n5 != 0) {
            n5 >>>= 1;
            ++n6;
        }
        return n6;
    }

    static int calculateBCHCode(int n5, int n6) {
        if (n6 != 0) {
            int n7 = n5;
            n5 = MatrixUtil.findMSBSet(n6);
            int n8 = n7 << n5 - 1;
            while (MatrixUtil.findMSBSet(n8) >= n5) {
                n8 ^= n6 << MatrixUtil.findMSBSet(n8) - n5;
            }
            return n8;
        }
        throw new IllegalArgumentException("0 polynomial");
    }

    static void makeTypeInfoBits(ErrorCorrectionLevel errorCorrectionLevel, int n5, BitArray bitArray) throws WriterException {
        if (QRCode.isValidMaskPattern(n5)) {
            BitArray bitArray2 = bitArray;
            int n6 = errorCorrectionLevel.getBits() << 3 | n5;
            bitArray.appendBits(n6, 5);
            bitArray2.appendBits(MatrixUtil.calculateBCHCode(n6, 1335), 10);
            BitArray bitArray3 = new BitArray();
            bitArray3.appendBits(21522, 15);
            bitArray2.xor(bitArray3);
            if (bitArray2.getSize() == 15) {
                return;
            }
            throw new WriterException("should not happen but we got: " + bitArray.getSize());
        }
        throw new WriterException("Invalid mask pattern");
    }

    static void makeVersionInfoBits(Version version, BitArray bitArray) throws WriterException {
        BitArray bitArray2 = bitArray;
        bitArray.appendBits(version.getVersionNumber(), 6);
        bitArray2.appendBits(MatrixUtil.calculateBCHCode(version.getVersionNumber(), 7973), 12);
        if (bitArray2.getSize() == 18) {
            return;
        }
        throw new WriterException("should not happen but we got: " + bitArray.getSize());
    }

    private static boolean isEmpty(int n5) {
        return n5 == -1;
    }

    private static void embedTimingPatterns(ByteMatrix byteMatrix) {
        int n5 = 8;
        while (n5 < byteMatrix.getWidth() - 8) {
            int n6 = n5;
            int n7 = n6 + 1;
            int n8 = n7 % 2;
            if (MatrixUtil.isEmpty(byteMatrix.get(n6, 6))) {
                byteMatrix.set(n5, 6, n8);
            }
            if (MatrixUtil.isEmpty(byteMatrix.get(6, n5))) {
                byteMatrix.set(6, n5, n8);
            }
            n5 = n7;
        }
    }

    private static void embedDarkDotAtLeftBottomCorner(ByteMatrix byteMatrix) throws WriterException {
        ByteMatrix byteMatrix2 = byteMatrix;
        if (byteMatrix2.get(8, byteMatrix2.getHeight() - 8) != 0) {
            ByteMatrix byteMatrix3 = byteMatrix;
            byteMatrix3.set(8, byteMatrix3.getHeight() - 8, 1);
            return;
        }
        throw new WriterException();
    }

    private static void embedHorizontalSeparationPattern(int n5, int n6, ByteMatrix byteMatrix) throws WriterException {
        for (int i5 = 0; i5 < 8; ++i5) {
            int n7 = n5 + i5;
            if (MatrixUtil.isEmpty(byteMatrix.get(n7, n6))) {
                byteMatrix.set(n7, n6, 0);
                continue;
            }
            throw new WriterException();
        }
    }

    private static void embedVerticalSeparationPattern(int n5, int n6, ByteMatrix byteMatrix) throws WriterException {
        for (int i5 = 0; i5 < 7; ++i5) {
            int n7 = n6 + i5;
            if (MatrixUtil.isEmpty(byteMatrix.get(n5, n7))) {
                byteMatrix.set(n5, n7, 0);
                continue;
            }
            throw new WriterException();
        }
    }

    private static void embedPositionAdjustmentPattern(int n5, int n6, ByteMatrix byteMatrix) {
        for (int i5 = 0; i5 < 5; ++i5) {
            for (int i6 = 0; i6 < 5; ++i6) {
                int n7 = n5 + i6;
                int n8 = n6 + i5;
                byteMatrix.set(n7, n8, POSITION_ADJUSTMENT_PATTERN[i5][i6]);
            }
        }
    }

    private static void embedPositionDetectionPattern(int n5, int n6, ByteMatrix byteMatrix) {
        for (int i5 = 0; i5 < 7; ++i5) {
            for (int i6 = 0; i6 < 7; ++i6) {
                int n7 = n5 + i6;
                int n8 = n6 + i5;
                byteMatrix.set(n7, n8, POSITION_DETECTION_PATTERN[i5][i6]);
            }
        }
    }

    private static void embedPositionDetectionPatternsAndSeparators(ByteMatrix byteMatrix) throws WriterException {
        ByteMatrix byteMatrix2 = byteMatrix;
        int n5 = POSITION_DETECTION_PATTERN[0].length;
        MatrixUtil.embedPositionDetectionPattern(0, 0, byteMatrix);
        MatrixUtil.embedPositionDetectionPattern(byteMatrix2.getWidth() - n5, 0, byteMatrix);
        MatrixUtil.embedPositionDetectionPattern(0, byteMatrix2.getWidth() - n5, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(0, 7, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(byteMatrix2.getWidth() - 8, 7, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(0, byteMatrix2.getWidth() - 8, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(7, 0, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(byteMatrix2.getHeight() - 8, 0, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(7, byteMatrix2.getHeight() - 7, byteMatrix);
    }

    private static void maybeEmbedPositionAdjustmentPatterns(Version object, ByteMatrix byteMatrix) {
        if (((Version)object).getVersionNumber() < 2) {
            return;
        }
        int[] nArray = POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[((Version)object).getVersionNumber() - 1];
        object = nArray;
        int n5 = nArray.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            for (int i6 = 0; i6 < n5; ++i6) {
                Object object2 = object;
                Object object3 = object2[i5];
                Object object4 = object2[i6];
                if (object4 == -1 || object3 == -1 || !MatrixUtil.isEmpty(byteMatrix.get((int)object4, (int)object3))) continue;
                MatrixUtil.embedPositionAdjustmentPattern((int)(object4 - 2), (int)(object3 - 2), byteMatrix);
            }
        }
    }

    static {
        int[][] nArrayArray = new int[7][];
        int[] nArray = new int[7];
        Object object = nArray;
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArrayArray[0] = object;
        int[] nArray2 = new int[7];
        object = nArray2;
        nArray2[0] = 1;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        nArray2[4] = 0;
        nArray2[5] = 0;
        nArray2[6] = 1;
        nArrayArray[1] = object;
        int[] nArray3 = new int[7];
        object = nArray3;
        nArray3[0] = 1;
        nArray3[1] = 0;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[5] = 0;
        nArray3[6] = 1;
        nArrayArray[2] = object;
        int[] nArray4 = new int[7];
        object = nArray4;
        nArray4[0] = 1;
        nArray4[1] = 0;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[5] = 0;
        nArray4[6] = 1;
        nArrayArray[3] = object;
        int[] nArray5 = new int[7];
        object = nArray5;
        nArray5[0] = 1;
        nArray5[1] = 0;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArray5[5] = 0;
        nArray5[6] = 1;
        nArrayArray[4] = object;
        int[] nArray6 = new int[7];
        object = nArray6;
        nArray6[0] = 1;
        nArray6[1] = 0;
        nArray6[2] = 0;
        nArray6[3] = 0;
        nArray6[4] = 0;
        nArray6[5] = 0;
        nArray6[6] = 1;
        nArrayArray[5] = object;
        int[] nArray7 = new int[7];
        object = nArray7;
        nArray7[0] = 1;
        nArray7[1] = 1;
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[4] = 1;
        nArray7[5] = 1;
        nArray7[6] = 1;
        nArrayArray[6] = object;
        POSITION_DETECTION_PATTERN = nArrayArray;
        int[][] nArrayArray2 = new int[5][];
        int[] nArray8 = new int[5];
        object = nArray8;
        nArray8[0] = 1;
        nArray8[1] = 1;
        nArray8[2] = 1;
        nArray8[3] = 1;
        nArray8[4] = 1;
        nArrayArray2[0] = object;
        int[] nArray9 = new int[5];
        object = nArray9;
        nArray9[0] = 1;
        nArray9[1] = 0;
        nArray9[2] = 0;
        nArray9[3] = 0;
        nArray9[4] = 1;
        nArrayArray2[1] = object;
        int[] nArray10 = new int[5];
        object = nArray10;
        nArray10[0] = 1;
        nArray10[1] = 0;
        nArray10[2] = 1;
        nArray10[3] = 0;
        nArray10[4] = 1;
        nArrayArray2[2] = object;
        int[] nArray11 = new int[5];
        object = nArray11;
        nArray11[0] = 1;
        nArray11[1] = 0;
        nArray11[2] = 0;
        nArray11[3] = 0;
        nArray11[4] = 1;
        nArrayArray2[3] = object;
        int[] nArray12 = new int[5];
        object = nArray12;
        nArray12[0] = 1;
        nArray12[1] = 1;
        nArray12[2] = 1;
        nArray12[3] = 1;
        nArray12[4] = 1;
        nArrayArray2[4] = object;
        POSITION_ADJUSTMENT_PATTERN = nArrayArray2;
        object = new int[40][];
        int[] nArray13 = new int[7];
        int[] nArray14 = nArray13;
        nArray13[0] = -1;
        nArray13[1] = -1;
        nArray13[2] = -1;
        nArray13[3] = -1;
        nArray13[4] = -1;
        nArray13[5] = -1;
        nArray13[6] = -1;
        object[0] = (int)nArray14;
        int[] nArray15 = new int[7];
        nArray14 = nArray15;
        nArray15[0] = 6;
        nArray15[1] = 18;
        nArray15[2] = -1;
        nArray15[3] = -1;
        nArray15[4] = -1;
        nArray15[5] = -1;
        nArray15[6] = -1;
        object[1] = (int)nArray14;
        int[] nArray16 = new int[7];
        nArray14 = nArray16;
        nArray16[0] = 6;
        nArray16[1] = 22;
        nArray16[2] = -1;
        nArray16[3] = -1;
        nArray16[4] = -1;
        nArray16[5] = -1;
        nArray16[6] = -1;
        object[2] = (int)nArray14;
        int[] nArray17 = new int[7];
        nArray14 = nArray17;
        nArray17[0] = 6;
        nArray17[1] = 26;
        nArray17[2] = -1;
        nArray17[3] = -1;
        nArray17[4] = -1;
        nArray17[5] = -1;
        nArray17[6] = -1;
        object[3] = (int)nArray14;
        int[] nArray18 = new int[7];
        nArray14 = nArray18;
        nArray18[0] = 6;
        nArray18[1] = 30;
        nArray18[2] = -1;
        nArray18[3] = -1;
        nArray18[4] = -1;
        nArray18[5] = -1;
        nArray18[6] = -1;
        object[4] = (int)nArray14;
        int[] nArray19 = new int[7];
        nArray14 = nArray19;
        nArray19[0] = 6;
        nArray19[1] = 34;
        nArray19[2] = -1;
        nArray19[3] = -1;
        nArray19[4] = -1;
        nArray19[5] = -1;
        nArray19[6] = -1;
        object[5] = (int)nArray14;
        int[] nArray20 = new int[7];
        nArray14 = nArray20;
        nArray20[0] = 6;
        nArray20[1] = 22;
        nArray20[2] = 38;
        nArray20[3] = -1;
        nArray20[4] = -1;
        nArray20[5] = -1;
        nArray20[6] = -1;
        object[6] = (int)nArray14;
        int[] nArray21 = new int[7];
        nArray14 = nArray21;
        nArray21[0] = 6;
        nArray21[1] = 24;
        nArray21[2] = 42;
        nArray21[3] = -1;
        nArray21[4] = -1;
        nArray21[5] = -1;
        nArray21[6] = -1;
        object[7] = (int)nArray14;
        int[] nArray22 = new int[7];
        nArray14 = nArray22;
        nArray22[0] = 6;
        nArray22[1] = 26;
        nArray22[2] = 46;
        nArray22[3] = -1;
        nArray22[4] = -1;
        nArray22[5] = -1;
        nArray22[6] = -1;
        object[8] = (int)nArray14;
        int[] nArray23 = new int[7];
        nArray14 = nArray23;
        nArray23[0] = 6;
        nArray23[1] = 28;
        nArray23[2] = 50;
        nArray23[3] = -1;
        nArray23[4] = -1;
        nArray23[5] = -1;
        nArray23[6] = -1;
        object[9] = (int)nArray14;
        int[] nArray24 = new int[7];
        nArray14 = nArray24;
        nArray24[0] = 6;
        nArray24[1] = 30;
        nArray24[2] = 54;
        nArray24[3] = -1;
        nArray24[4] = -1;
        nArray24[5] = -1;
        nArray24[6] = -1;
        object[10] = (int)nArray14;
        int[] nArray25 = new int[7];
        nArray14 = nArray25;
        nArray25[0] = 6;
        nArray25[1] = 32;
        nArray25[2] = 58;
        nArray25[3] = -1;
        nArray25[4] = -1;
        nArray25[5] = -1;
        nArray25[6] = -1;
        object[11] = (int)nArray14;
        int[] nArray26 = new int[7];
        nArray14 = nArray26;
        nArray26[0] = 6;
        nArray26[1] = 34;
        nArray26[2] = 62;
        nArray26[3] = -1;
        nArray26[4] = -1;
        nArray26[5] = -1;
        nArray26[6] = -1;
        object[12] = (int)nArray14;
        int[] nArray27 = new int[7];
        nArray14 = nArray27;
        nArray27[0] = 6;
        nArray27[1] = 26;
        nArray27[2] = 46;
        nArray27[3] = 66;
        nArray27[4] = -1;
        nArray27[5] = -1;
        nArray27[6] = -1;
        object[13] = (int)nArray14;
        int[] nArray28 = new int[7];
        nArray14 = nArray28;
        nArray28[0] = 6;
        nArray28[1] = 26;
        nArray28[2] = 48;
        nArray28[3] = 70;
        nArray28[4] = -1;
        nArray28[5] = -1;
        nArray28[6] = -1;
        object[14] = (int)nArray14;
        int[] nArray29 = new int[7];
        nArray14 = nArray29;
        nArray29[0] = 6;
        nArray29[1] = 26;
        nArray29[2] = 50;
        nArray29[3] = 74;
        nArray29[4] = -1;
        nArray29[5] = -1;
        nArray29[6] = -1;
        object[15] = (int)nArray14;
        int[] nArray30 = new int[7];
        nArray14 = nArray30;
        nArray30[0] = 6;
        nArray30[1] = 30;
        nArray30[2] = 54;
        nArray30[3] = 78;
        nArray30[4] = -1;
        nArray30[5] = -1;
        nArray30[6] = -1;
        object[16] = (int)nArray14;
        int[] nArray31 = new int[7];
        nArray14 = nArray31;
        nArray31[0] = 6;
        nArray31[1] = 30;
        nArray31[2] = 56;
        nArray31[3] = 82;
        nArray31[4] = -1;
        nArray31[5] = -1;
        nArray31[6] = -1;
        object[17] = (int)nArray14;
        int[] nArray32 = new int[7];
        nArray14 = nArray32;
        nArray32[0] = 6;
        nArray32[1] = 30;
        nArray32[2] = 58;
        nArray32[3] = 86;
        nArray32[4] = -1;
        nArray32[5] = -1;
        nArray32[6] = -1;
        object[18] = (int)nArray14;
        int[] nArray33 = new int[7];
        nArray14 = nArray33;
        nArray33[0] = 6;
        nArray33[1] = 34;
        nArray33[2] = 62;
        nArray33[3] = 90;
        nArray33[4] = -1;
        nArray33[5] = -1;
        nArray33[6] = -1;
        object[19] = (int)nArray14;
        int[] nArray34 = new int[7];
        nArray14 = nArray34;
        nArray34[0] = 6;
        nArray34[1] = 28;
        nArray34[2] = 50;
        nArray34[3] = 72;
        nArray34[4] = 94;
        nArray34[5] = -1;
        nArray34[6] = -1;
        object[20] = (int)nArray14;
        int[] nArray35 = new int[7];
        nArray14 = nArray35;
        nArray35[0] = 6;
        nArray35[1] = 26;
        nArray35[2] = 50;
        nArray35[3] = 74;
        nArray35[4] = 98;
        nArray35[5] = -1;
        nArray35[6] = -1;
        object[21] = (int)nArray14;
        int[] nArray36 = new int[7];
        nArray14 = nArray36;
        nArray36[0] = 6;
        nArray36[1] = 30;
        nArray36[2] = 54;
        nArray36[3] = 78;
        nArray36[4] = 102;
        nArray36[5] = -1;
        nArray36[6] = -1;
        object[22] = (int)nArray14;
        int[] nArray37 = new int[7];
        nArray14 = nArray37;
        nArray37[0] = 6;
        nArray37[1] = 28;
        nArray37[2] = 54;
        nArray37[3] = 80;
        nArray37[4] = 106;
        nArray37[5] = -1;
        nArray37[6] = -1;
        object[23] = (int)nArray14;
        int[] nArray38 = new int[7];
        nArray14 = nArray38;
        nArray38[0] = 6;
        nArray38[1] = 32;
        nArray38[2] = 58;
        nArray38[3] = 84;
        nArray38[4] = 110;
        nArray38[5] = -1;
        nArray38[6] = -1;
        object[24] = (int)nArray14;
        int[] nArray39 = new int[7];
        nArray14 = nArray39;
        nArray39[0] = 6;
        nArray39[1] = 30;
        nArray39[2] = 58;
        nArray39[3] = 86;
        nArray39[4] = 114;
        nArray39[5] = -1;
        nArray39[6] = -1;
        object[25] = (int)nArray14;
        int[] nArray40 = new int[7];
        nArray14 = nArray40;
        nArray40[0] = 6;
        nArray40[1] = 34;
        nArray40[2] = 62;
        nArray40[3] = 90;
        nArray40[4] = 118;
        nArray40[5] = -1;
        nArray40[6] = -1;
        object[26] = (int)nArray14;
        int[] nArray41 = new int[7];
        nArray14 = nArray41;
        nArray41[0] = 6;
        nArray41[1] = 26;
        nArray41[2] = 50;
        nArray41[3] = 74;
        nArray41[4] = 98;
        nArray41[5] = 122;
        nArray41[6] = -1;
        object[27] = (int)nArray14;
        int[] nArray42 = new int[7];
        nArray14 = nArray42;
        nArray42[0] = 6;
        nArray42[1] = 30;
        nArray42[2] = 54;
        nArray42[3] = 78;
        nArray42[4] = 102;
        nArray42[5] = 126;
        nArray42[6] = -1;
        object[28] = (int)nArray14;
        int[] nArray43 = new int[7];
        nArray14 = nArray43;
        nArray43[0] = 6;
        nArray43[1] = 26;
        nArray43[2] = 52;
        nArray43[3] = 78;
        nArray43[4] = 104;
        nArray43[5] = 130;
        nArray43[6] = -1;
        object[29] = (int)nArray14;
        int[] nArray44 = new int[7];
        nArray14 = nArray44;
        nArray44[0] = 6;
        nArray44[1] = 30;
        nArray44[2] = 56;
        nArray44[3] = 82;
        nArray44[4] = 108;
        nArray44[5] = 134;
        nArray44[6] = -1;
        object[30] = (int)nArray14;
        int[] nArray45 = new int[7];
        nArray14 = nArray45;
        nArray45[0] = 6;
        nArray45[1] = 34;
        nArray45[2] = 60;
        nArray45[3] = 86;
        nArray45[4] = 112;
        nArray45[5] = 138;
        nArray45[6] = -1;
        object[31] = (int)nArray14;
        int[] nArray46 = new int[7];
        nArray14 = nArray46;
        nArray46[0] = 6;
        nArray46[1] = 30;
        nArray46[2] = 58;
        nArray46[3] = 86;
        nArray46[4] = 114;
        nArray46[5] = 142;
        nArray46[6] = -1;
        object[32] = (int)nArray14;
        int[] nArray47 = new int[7];
        nArray14 = nArray47;
        nArray47[0] = 6;
        nArray47[1] = 34;
        nArray47[2] = 62;
        nArray47[3] = 90;
        nArray47[4] = 118;
        nArray47[5] = 146;
        nArray47[6] = -1;
        object[33] = (int)nArray14;
        int[] nArray48 = new int[7];
        nArray14 = nArray48;
        nArray48[0] = 6;
        nArray48[1] = 30;
        nArray48[2] = 54;
        nArray48[3] = 78;
        nArray48[4] = 102;
        nArray48[5] = 126;
        nArray48[6] = 150;
        object[34] = (int)nArray14;
        int[] nArray49 = new int[7];
        nArray14 = nArray49;
        nArray49[0] = 6;
        nArray49[1] = 24;
        nArray49[2] = 50;
        nArray49[3] = 76;
        nArray49[4] = 102;
        nArray49[5] = 128;
        nArray49[6] = 154;
        object[35] = (int)nArray14;
        int[] nArray50 = new int[7];
        nArray14 = nArray50;
        nArray50[0] = 6;
        nArray50[1] = 28;
        nArray50[2] = 54;
        nArray50[3] = 80;
        nArray50[4] = 106;
        nArray50[5] = 132;
        nArray50[6] = 158;
        object[36] = (int)nArray14;
        int[] nArray51 = new int[7];
        nArray14 = nArray51;
        nArray51[0] = 6;
        nArray51[1] = 32;
        nArray51[2] = 58;
        nArray51[3] = 84;
        nArray51[4] = 110;
        nArray51[5] = 136;
        nArray51[6] = 162;
        object[37] = (int)nArray14;
        int[] nArray52 = new int[7];
        nArray14 = nArray52;
        nArray52[0] = 6;
        nArray52[1] = 26;
        nArray52[2] = 54;
        nArray52[3] = 82;
        nArray52[4] = 110;
        nArray52[5] = 138;
        nArray52[6] = 166;
        object[38] = (int)nArray14;
        int[] nArray53 = new int[7];
        nArray14 = nArray53;
        nArray53[0] = 6;
        nArray53[1] = 30;
        nArray53[2] = 58;
        nArray53[3] = 86;
        nArray53[4] = 114;
        nArray53[5] = 142;
        nArray53[6] = 170;
        object[39] = (int)nArray14;
        POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE = (int[][])object;
        int[][] nArrayArray3 = new int[15][];
        int[] nArray54 = new int[2];
        object = nArray54;
        nArray54[0] = 8;
        nArray54[1] = 0;
        nArrayArray3[0] = object;
        int[] nArray55 = new int[2];
        object = nArray55;
        nArray55[0] = 8;
        nArray55[1] = 1;
        nArrayArray3[1] = object;
        int[] nArray56 = new int[2];
        object = nArray56;
        nArray56[0] = 8;
        nArray56[1] = 2;
        nArrayArray3[2] = object;
        int[] nArray57 = new int[2];
        object = nArray57;
        nArray57[0] = 8;
        nArray57[1] = 3;
        nArrayArray3[3] = object;
        int[] nArray58 = new int[2];
        object = nArray58;
        nArray58[0] = 8;
        nArray58[1] = 4;
        nArrayArray3[4] = object;
        int[] nArray59 = new int[2];
        object = nArray59;
        nArray59[0] = 8;
        nArray59[1] = 5;
        nArrayArray3[5] = object;
        int[] nArray60 = new int[2];
        object = nArray60;
        nArray60[0] = 8;
        nArray60[1] = 7;
        nArrayArray3[6] = object;
        int[] nArray61 = new int[2];
        object = nArray61;
        nArray61[0] = 8;
        nArray61[1] = 8;
        nArrayArray3[7] = object;
        int[] nArray62 = new int[2];
        object = nArray62;
        nArray62[0] = 7;
        nArray62[1] = 8;
        nArrayArray3[8] = object;
        int[] nArray63 = new int[2];
        object = nArray63;
        nArray63[0] = 5;
        nArray63[1] = 8;
        nArrayArray3[9] = object;
        int[] nArray64 = new int[2];
        object = nArray64;
        nArray64[0] = 4;
        nArray64[1] = 8;
        nArrayArray3[10] = object;
        int[] nArray65 = new int[2];
        object = nArray65;
        nArray65[0] = 3;
        nArray65[1] = 8;
        nArrayArray3[11] = object;
        int[] nArray66 = new int[2];
        object = nArray66;
        nArray66[0] = 2;
        nArray66[1] = 8;
        nArrayArray3[12] = object;
        int[] nArray67 = new int[2];
        object = nArray67;
        nArray67[0] = 1;
        nArray67[1] = 8;
        nArrayArray3[13] = object;
        int[] nArray68 = new int[2];
        object = nArray68;
        nArray68[0] = 0;
        nArray68[1] = 8;
        nArrayArray3[14] = object;
        TYPE_INFO_COORDINATES = nArrayArray3;
    }
}

