/*
 * Decompiled with CFR 0.152.
 */
package com.dmcbig.mediapicker.adapter;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.util.Size;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.dcloud.android.widget.toast.ToastCompat;
import com.dmcbig.mediapicker.MediaPickerR;
import com.dmcbig.mediapicker.PickerConfig;
import com.dmcbig.mediapicker.entity.Media;
import com.dmcbig.mediapicker.utils.FileUtils;
import com.dmcbig.mediapicker.utils.ScreenUtils;
import io.dcloud.common.util.HarmonyUtils;
import io.dcloud.common.util.ThreadPool;
import java.io.IOException;
import java.util.ArrayList;

public class MediaGridAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    ArrayList<Media> medias;
    Context context;
    FileUtils fileUtils;
    ArrayList<Media> selectMedias;
    long maxSelect;
    long maxSize;
    boolean isSingle;
    private final Handler handler;
    private OnRecyclerViewItemClickListener mOnItemClickListener;
    private OnPickerSelectMaxListener mOnMaxListener;

    public MediaGridAdapter(ArrayList<Media> arrayList, Context context, ArrayList<Media> arrayList2, int n5, long l5, boolean bl) {
        ArrayList arrayList3;
        FileUtils fileUtils;
        Object object = fileUtils;
        fileUtils = new FileUtils();
        this.fileUtils = object;
        object = arrayList3;
        arrayList3 = new ArrayList();
        this.selectMedias = object;
        this.isSingle = false;
        this.mOnItemClickListener = null;
        this.mOnMaxListener = null;
        if (arrayList2 != null) {
            this.selectMedias = arrayList2;
        }
        MediaGridAdapter mediaGridAdapter = this;
        this.maxSelect = n5;
        this.maxSize = l5;
        this.medias = arrayList;
        this.context = context;
        mediaGridAdapter.isSingle = bl;
        mediaGridAdapter.handler = new Handler(Looper.getMainLooper());
    }

    private static /* synthetic */ void lambda$onBindViewHolder$0(MyViewHolder myViewHolder, Bitmap bitmap) {
        myViewHolder.media_image.setImageBitmap(bitmap);
    }

    int getItemWidth() {
        int n5 = PickerConfig.GridSpanCount;
        return ScreenUtils.getScreenWidth(this.context) / n5 - n5;
    }

    public MyViewHolder onCreateViewHolder(ViewGroup viewGroup, int n5) {
        viewGroup = LayoutInflater.from((Context)viewGroup.getContext()).inflate(MediaPickerR.MP_LAYOUT_MEDIA_VIEW_ITEM, viewGroup, false);
        return new MyViewHolder((View)viewGroup);
    }

    public void onBindViewHolder(final MyViewHolder myViewHolder, int n5) {
        final Media media = this.medias.get(n5);
        Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        int n6 = media.mediaType;
        if (n6 != 1 && n6 == 3) {
            uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        }
        if ((n6 = media.id) != Integer.MIN_VALUE) {
            uri = ContentUris.withAppendedId((Uri)uri, (long)n6);
            if (HarmonyUtils.isHarmonyOs()) {
                ThreadPool.self().addThreadTask(() -> {
                    IOException iOException2;
                    block5: {
                        Bitmap bitmap;
                        block4: {
                            block3: {
                                Size size;
                                Uri uri2;
                                ContentResolver contentResolver;
                                try {
                                    if (Build.VERSION.SDK_INT < 29) break block3;
                                    contentResolver = this.context.getContentResolver();
                                    uri2 = uri;
                                }
                                catch (IOException iOException2) {
                                    break block5;
                                }
                                uri = size;
                                MediaGridAdapter mediaGridAdapter = this;
                                int n5 = mediaGridAdapter.getItemWidth();
                                size = new Size(n5, mediaGridAdapter.getItemWidth());
                                bitmap = contentResolver.loadThumbnail(uri2, (Size)uri, null);
                                break block4;
                            }
                            bitmap = media.mediaType == 3 ? MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)this.context.getContentResolver(), (long)media.id, (int)1, null) : MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)this.context.getContentResolver(), (long)media.id, (int)1, null);
                        }
                        uri = bitmap;
                        this.handler.post(() -> MediaGridAdapter.lambda$onBindViewHolder$0(myViewHolder, (Bitmap)uri));
                        return;
                    }
                    iOException2.printStackTrace();
                });
            } else {
                Glide.with((Context)this.context).load(uri).into(myViewHolder.media_image);
            }
        } else {
            myViewHolder.media_image.setImageResource(Integer.parseInt(media.path));
        }
        if (media.id == Integer.MIN_VALUE) {
            myViewHolder.gif_info.setVisibility(4);
            myViewHolder.video_info.setVisibility(4);
            myViewHolder.textView_size.setVisibility(4);
        } else if (media.mediaType == 3) {
            myViewHolder.gif_info.setVisibility(4);
            myViewHolder.video_info.setVisibility(0);
            myViewHolder.textView_size.setVisibility(0);
            myViewHolder.textView_size.setText((CharSequence)this.fileUtils.getSizeByUnit(media.size));
        } else {
            myViewHolder.video_info.setVisibility(4);
            myViewHolder.textView_size.setVisibility(0);
            uri = myViewHolder.gif_info;
            n6 = ".gif".equalsIgnoreCase(media.extension) ? 0 : 4;
            uri.setVisibility(n6);
        }
        int n7 = this.isSelect(media);
        if (media.id == Integer.MIN_VALUE) {
            myViewHolder.check_image.setVisibility(8);
            myViewHolder.mask_view.setVisibility(8);
        } else if (!this.isSingle) {
            View view = myViewHolder.mask_view;
            int n8 = n7 >= 0 ? 0 : 4;
            view.setVisibility(n8);
            myViewHolder.check_image.setVisibility(0);
            ImageView imageView = myViewHolder.check_image;
            view = n7 >= 0 ? ContextCompat.getDrawable((Context)this.context, (int)MediaPickerR.MP_DRAWABLE_BNT_SELECTED) : ContextCompat.getDrawable((Context)this.context, (int)MediaPickerR.MP_DRAWABLE_BNT_UNSELECTED);
            imageView.setImageDrawable((Drawable)view);
        } else {
            myViewHolder.check_image.setVisibility(8);
            myViewHolder.mask_view.setVisibility(8);
        }
        myViewHolder.media_image.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Media media3 = media2.media;
                if (media3.id == Integer.MIN_VALUE) {
                    media2.MediaGridAdapter.this.mOnItemClickListener.onAddMore();
                    return;
                }
                MediaGridAdapter mediaGridAdapter = media2.MediaGridAdapter.this;
                if (mediaGridAdapter.isSingle) {
                    mediaGridAdapter.mOnItemClickListener.onItemClick(view, media2.media, null);
                    return;
                }
                int n5 = mediaGridAdapter.isSelect(media3);
                mediaGridAdapter = media2.MediaGridAdapter.this;
                if ((long)media2.MediaGridAdapter.this.selectMedias.size() >= mediaGridAdapter.maxSelect && n5 < 0) {
                    if (mediaGridAdapter.mOnMaxListener != null) {
                        media2.MediaGridAdapter.this.mOnMaxListener.onMaxed();
                    }
                } else if (media2.media.size > mediaGridAdapter.maxSize) {
                    ToastCompat.makeText(mediaGridAdapter.context, media2.MediaGridAdapter.this.context.getString(MediaPickerR.MP_STRING_MSG_SIZE_LIMIT) + FileUtils.fileSize(media2.MediaGridAdapter.this.maxSize), 1).show();
                } else {
                    mediaGridAdapter = media2.myViewHolder.mask_view;
                    int n6 = n5 >= 0 ? 4 : 0;
                    mediaGridAdapter.setVisibility(n6);
                    ImageView imageView = media2.myViewHolder.check_image;
                    mediaGridAdapter = n5 >= 0 ? ContextCompat.getDrawable((Context)media2.MediaGridAdapter.this.context, (int)MediaPickerR.MP_DRAWABLE_BNT_UNSELECTED) : ContextCompat.getDrawable((Context)media2.MediaGridAdapter.this.context, (int)MediaPickerR.MP_DRAWABLE_BNT_SELECTED);
                    1 v02 = media2;
                    imageView.setImageDrawable((Drawable)mediaGridAdapter);
                    v02.MediaGridAdapter.this.setSelectMedias(media2.media);
                    1 v12 = media2;
                    Media media2 = v12.media;
                    v02.MediaGridAdapter.this.mOnItemClickListener.onItemClick(view, media2, v12.MediaGridAdapter.this.selectMedias);
                }
            }
        });
    }

    public void setSelectMedias(Media media) {
        int n5 = this.isSelect(media);
        if (n5 == -1) {
            this.selectMedias.add(media);
        } else {
            this.selectMedias.remove(n5);
        }
    }

    public int isSelect(Media media) {
        int n5 = -1;
        if (this.selectMedias.size() <= 0) {
            return n5;
        }
        for (int i5 = 0; i5 < this.selectMedias.size(); ++i5) {
            Media media2 = this.selectMedias.get(i5);
            if (!media2.path.equals(media.path)) continue;
            media2.id = media.id;
            n5 = i5;
            break;
        }
        return n5;
    }

    public void updateSelectAdapter(ArrayList<Media> arrayList) {
        if (arrayList != null) {
            this.selectMedias = arrayList;
        }
        this.notifyDataSetChanged();
    }

    public void updateAdapter(ArrayList<Media> arrayList) {
        this.medias = arrayList;
        this.notifyDataSetChanged();
    }

    public ArrayList<Media> getMedias() {
        return this.medias;
    }

    public void setOnItemClickListener(OnRecyclerViewItemClickListener onRecyclerViewItemClickListener) {
        this.mOnItemClickListener = onRecyclerViewItemClickListener;
    }

    public void setOnMaxListener(OnPickerSelectMaxListener onPickerSelectMaxListener) {
        this.mOnMaxListener = onPickerSelectMaxListener;
    }

    public ArrayList<Media> getSelectMedias() {
        return this.selectMedias;
    }

    public int getItemCount() {
        return this.medias.size();
    }

    public int getItemIndex(Object object) {
        return this.medias.indexOf(object);
    }

    public static interface OnPickerSelectMaxListener {
        public void onMaxed();
    }

    public static interface OnRecyclerViewItemClickListener {
        public void onItemClick(View var1, Media var2, ArrayList<Media> var3);

        public void onAddMore();
    }

    public class MyViewHolder
    extends RecyclerView.ViewHolder {
        public ImageView media_image;
        public ImageView check_image;
        public View mask_view;
        public TextView textView_size;
        public RelativeLayout gif_info;
        public RelativeLayout video_info;

        public MyViewHolder(View view) {
            super(view);
            this.media_image = (ImageView)view.findViewById(MediaPickerR.MP_ID_MEDIA_IMAGE);
            this.check_image = (ImageView)view.findViewById(MediaPickerR.MP_ID_CHECK_IMAGE);
            this.mask_view = view.findViewById(MediaPickerR.MP_ID_MASK_VIEW);
            this.video_info = (RelativeLayout)view.findViewById(MediaPickerR.MP_ID_VIDEO_INFO);
            this.gif_info = (RelativeLayout)view.findViewById(MediaPickerR.MP_ID_GIF_INFO);
            this.textView_size = (TextView)view.findViewById(MediaPickerR.MP_ID_TEXTVIEW_SIZE);
            this.itemView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, MediaGridAdapter.this.getItemWidth()));
        }
    }
}

