/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.CipherSuite;
import dc.squareup.okhttp3.Handshake;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.MediaType;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.ResponseBody;
import dc.squareup.okhttp3.TlsVersion;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.cache.CacheRequest;
import dc.squareup.okhttp3.internal.cache.CacheStrategy;
import dc.squareup.okhttp3.internal.cache.DiskLruCache;
import dc.squareup.okhttp3.internal.cache.InternalCache;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import dc.squareup.okhttp3.internal.http.HttpMethod;
import dc.squareup.okhttp3.internal.http.StatusLine;
import dc.squareup.okhttp3.internal.io.FileSystem;
import dc.squareup.okhttp3.internal.platform.Platform;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.ForwardingSink;
import dc.squareup.okio.ForwardingSource;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class Cache
implements Closeable,
Flushable {
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    final InternalCache internalCache;
    final DiskLruCache cache;
    int writeSuccessCount;
    int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;

    public Cache(File file, long l5) {
        Cache cache = fileSystem;
        FileSystem fileSystem = FileSystem.SYSTEM;
        cache(file, l5, fileSystem);
    }

    Cache(File file, long l5, FileSystem fileSystem) {
        this.internalCache = new InternalCache(){

            @Override
            public Response get(Request request) throws IOException {
                return Cache.this.get(request);
            }

            @Override
            public CacheRequest put(Response response) throws IOException {
                return Cache.this.put(response);
            }

            @Override
            public void remove(Request request) throws IOException {
                Cache.this.remove(request);
            }

            @Override
            public void update(Response response, Response response2) {
                Cache.this.update(response, response2);
            }

            @Override
            public void trackConditionalCacheHit() {
                Cache.this.trackConditionalCacheHit();
            }

            @Override
            public void trackResponse(CacheStrategy cacheStrategy) {
                Cache.this.trackResponse(cacheStrategy);
            }
        };
        this.cache = DiskLruCache.create(fileSystem, file, 201105, 2, l5);
    }

    public static String key(HttpUrl httpUrl) {
        return ByteString.encodeUtf8(httpUrl.toString()).md5().hex();
    }

    private void abortQuietly(@Nullable DiskLruCache.Editor editor) {
        if (editor != null) {
            try {
                editor.abort();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int readInt(BufferedSource object) throws IOException {
        long l5;
        try {
            l5 = object.readDecimalLong();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
        object = object.readUtf8LineStrict();
        if (l5 < 0L) throw new IOException("expected an int but was \"" + l5 + (String)object + "\"");
        if (l5 > Integer.MAX_VALUE) throw new IOException("expected an int but was \"" + l5 + (String)object + "\"");
        if (!((String)object).isEmpty()) throw new IOException("expected an int but was \"" + l5 + (String)object + "\"");
        return (int)l5;
    }

    @Nullable
    Response get(Request request) {
        block6: {
            Entry entry;
            Object object;
            block5: {
                Cache cache = object;
                object = Cache.key(request.url());
                try {
                    object = cache.cache.get((String)object);
                    if (object != null) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            Entry entry2 = entry;
            try {
                entry2(((DiskLruCache.Snapshot)object).getSource(0));
                object = entry2.response((DiskLruCache.Snapshot)object);
                if (entry.matches(request, (Response)object)) break block6;
            }
            catch (IOException iOException) {
                Util.closeQuietly((Closeable)object);
                return null;
            }
            Util.closeQuietly(((Response)object).body());
            return null;
        }
        return object;
    }

    @Nullable
    CacheRequest put(Response response) {
        DiskLruCache.Editor editor;
        Object object;
        block8: {
            Entry entry;
            Response response2 = response;
            object = response2.request().method();
            if (HttpMethod.invalidatesCache(response2.request().method())) {
                try {
                    this.remove(response.request());
                }
                catch (IOException iOException) {}
                return null;
            }
            if (!((String)object).equals("GET")) {
                return null;
            }
            if (HttpHeaders.hasVaryAll(response)) {
                return null;
            }
            object = entry;
            entry = new Entry(response);
            editor = null;
            try {
                editor = this.cache.edit(Cache.key(response.request().url()));
                if (editor != null) break block8;
                return null;
            }
            catch (IOException iOException) {
                this.abortQuietly(editor);
                return null;
            }
        }
        ((Entry)object).writeTo(editor);
        return new CacheRequestImpl(this, editor);
    }

    void remove(Request request) throws IOException {
        this.cache.remove(Cache.key(request.url()));
    }

    void update(Response object, Response object2) {
        block3: {
            Entry entry;
            Response response = object;
            object = entry;
            entry = new Entry((Response)object2);
            object2 = null;
            object2 = ((CacheResponseBody)response.body()).snapshot.edit();
            if (object2 == null) break block3;
            try {
                ((Entry)object).writeTo((DiskLruCache.Editor)object2);
                ((DiskLruCache.Editor)object2).commit();
            }
            catch (IOException iOException) {
                this.abortQuietly((DiskLruCache.Editor)object2);
            }
        }
    }

    public void initialize() throws IOException {
        this.cache.initialize();
    }

    public void delete() throws IOException {
        this.cache.delete();
    }

    public void evictAll() throws IOException {
        this.cache.evictAll();
    }

    public Iterator<String> urls() throws IOException {
        return new Iterator<String>(){
            final Iterator<DiskLruCache.Snapshot> delegate;
            @Nullable
            String nextUrl;
            boolean canRemove;
            {
                this.delegate = Cache.this.cache.snapshots();
            }

            @Override
            public boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    DiskLruCache.Snapshot snapshot;
                    block5: {
                        snapshot = this.delegate.next();
                        try {
                            this.nextUrl = Okio.buffer(snapshot.getSource(0)).readUtf8LineStrict();
                            snapshot.close();
                            return true;
                        }
                        catch (Throwable throwable) {
                        }
                        catch (IOException iOException) {
                            break block5;
                        }
                        snapshot.close();
                        throw throwable;
                    }
                    snapshot.close();
                }
                return false;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    2 v02 = this;
                    v02.nextUrl = null;
                    v02.canRemove = true;
                    return this.nextUrl;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.canRemove) {
                    this.delegate.remove();
                    return;
                }
                throw new IllegalStateException("remove() before next()");
            }
        };
    }

    public synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public long size() throws IOException {
        return this.cache.size();
    }

    public long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    public File directory() {
        return this.cache.getDirectory();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    synchronized void trackResponse(CacheStrategy cacheStrategy) {
        ++this.requestCount;
        if (cacheStrategy.networkRequest != null) {
            ++this.networkCount;
        } else if (cacheStrategy.cacheResponse != null) {
            ++this.hitCount;
        }
    }

    synchronized void trackConditionalCacheHit() {
        ++this.hitCount;
    }

    public synchronized int networkCount() {
        return this.networkCount;
    }

    public synchronized int hitCount() {
        return this.hitCount;
    }

    public synchronized int requestCount() {
        return this.requestCount;
    }

    private static final class Entry {
        private static final String SENT_MILLIS = Platform.get().getPrefix() + "-Sent-Millis";
        private static final String RECEIVED_MILLIS = Platform.get().getPrefix() + "-Received-Millis";
        private final String url;
        private final Headers varyHeaders;
        private final String requestMethod;
        private final Protocol protocol;
        private final int code;
        private final String message;
        private final Headers responseHeaders;
        @Nullable
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Entry(Source var1_1) throws IOException {
            block18: {
                block17: {
                    super();
                    var2_2 /* !! */  = Okio.buffer(var1_1);
                    this.url = var2_2 /* !! */ .readUtf8LineStrict();
                    this.requestMethod = var2_2 /* !! */ .readUtf8LineStrict();
                    var3_3 = v0;
                    try {
                        v0 = new Headers.Builder();
                        var4_4 = Cache.readInt(var2_2 /* !! */ );
                        for (var5_8 = 0; var5_8 < var4_4; ++var5_8) {
                            var3_3.addLenient(var2_2 /* !! */ .readUtf8LineStrict());
                        }
                    }
                    catch (Throwable v1) {}
                    {
                        continue;
                    }
                    v2 = var2_2 /* !! */ ;
                    v3 = this;
                    v4 = v3;
                    v5 = v3;
                    v6 = v3;
                    this.varyHeaders = var3_3.build();
                    var3_3 = StatusLine.parse(var2_2 /* !! */ .readUtf8LineStrict());
                    v5.protocol = var3_3.protocol;
                    v6.code = var3_3.code;
                    v4.message = var3_3.message;
                    var3_3 = v7;
                    v7 = new Headers.Builder();
                    var4_4 = Cache.readInt(v2);
                    break block17;
                    var1_1.close();
                    throw v1;
                }
                for (var5_8 = 0; var5_8 < var4_4; ++var5_8) {
                    var3_3.addLenient(var2_2 /* !! */ .readUtf8LineStrict());
                }
                {
                    var4_5 = Entry.SENT_MILLIS;
                    {
                        var5_9 = var3_3.get(var4_5);
                    }
                }
                {
                    v8 = var3_3;
                    v9 = v8;
                    var6_10 = Entry.RECEIVED_MILLIS;
                    {
                        var7_11 = v8.get(var6_10);
                        v8.removeAll(var4_5);
                    }
                }
                {
                    v9.removeAll(var6_10);
                }
                var4_6 = var5_9 != null ? Long.parseLong((String)var5_9) : 0L;
                {
                    this.sentRequestMillis = var4_6;
                    var4_6 = var7_11 != null ? Long.parseLong(var7_11) : 0L;
                    this.receivedResponseMillis = var4_6;
                    this.responseHeaders = var3_3.build();
                    if (!this.isHttps()) ** GOTO lbl65
                }
                {
                    var3_3 = var2_2 /* !! */ .readUtf8LineStrict();
                    if (var3_3.length() > 0) {
                        throw new IOException("expected \"\" but was \"" + (String)var3_3 + "\"");
                    }
                    v10 = var2_2 /* !! */ ;
                    var3_3 = CipherSuite.forJavaName(v10.readUtf8LineStrict());
                    var4_7 = this.readCertificateList(v10);
                    var5_9 = this.readCertificateList(var2_2 /* !! */ );
                    var2_2 /* !! */  = var2_2 /* !! */ .exhausted() == false ? TlsVersion.forJavaName(var2_2 /* !! */ .readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                    this.handshake = Handshake.get((TlsVersion)var2_2 /* !! */ , (CipherSuite)var3_3, var4_7, (List<Certificate>)var5_9);
                    break block18;
lbl65:
                    // 1 sources

                    this.handshake = null;
                }
            }
            var1_1.close();
        }

        Entry(Response response) {
            this.url = response.request().url().toString();
            this.varyHeaders = HttpHeaders.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
        }

        private boolean isHttps() {
            return this.url.startsWith("https://");
        }

        private List<Certificate> readCertificateList(BufferedSource bufferedSource) throws IOException {
            CertificateException certificateException2;
            block10: {
                ArrayList<Certificate> arrayList;
                int n5 = Cache.readInt(bufferedSource);
                if (n5 == -1) {
                    return Collections.emptyList();
                }
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> arrayList2 = arrayList;
                arrayList = new ArrayList<Certificate>(n5);
                for (int i5 = 0; i5 < n5; ++i5) {
                    String string2;
                    CertificateFactory certificateFactory2;
                    ArrayList<Certificate> arrayList3;
                    try {
                        arrayList3 = arrayList2;
                        certificateFactory2 = certificateFactory;
                        string2 = bufferedSource.readUtf8LineStrict();
                    }
                    catch (CertificateException certificateException2) {
                        break block10;
                    }
                    Buffer buffer = new Buffer();
                    buffer.write(ByteString.decodeBase64(string2));
                    arrayList3.add(certificateFactory2.generateCertificate(buffer.inputStream()));
                }
                return arrayList2;
            }
            throw new IOException(certificateException2.getMessage());
        }

        private void writeCertList(BufferedSink bufferedSink, List<Certificate> list) throws IOException {
            CertificateEncodingException certificateEncodingException2;
            List<Certificate> list2 = list;
            BufferedSink bufferedSink2 = bufferedSink;
            long l5 = list.size();
            bufferedSink2.writeDecimalLong(l5).writeByte(10);
            int n5 = list2.size();
            for (int i5 = 0; i5 < n5; ++i5) {
                try {
                    bufferedSink.writeUtf8(ByteString.of(list.get(i5).getEncoded()).base64()).writeByte(10);
                }
                catch (CertificateEncodingException certificateEncodingException2) {
                }
            }
            return;
            throw new IOException(certificateEncodingException2.getMessage());
        }

        public void writeTo(DiskLruCache.Editor object) throws IOException {
            int n5;
            object = Okio.buffer(((DiskLruCache.Editor)object).newSink(0));
            object.writeUtf8(this.url).writeByte(10);
            object.writeUtf8(this.requestMethod).writeByte(10);
            object.writeDecimalLong(this.varyHeaders.size()).writeByte(10);
            int n6 = this.varyHeaders.size();
            for (n5 = 0; n5 < n6; ++n5) {
                object.writeUtf8(this.varyHeaders.name(n5)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(n5)).writeByte(10);
            }
            Object object2 = object;
            object2.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
            object2.writeDecimalLong(this.responseHeaders.size() + 2).writeByte(10);
            n6 = this.responseHeaders.size();
            for (n5 = 0; n5 < n6; ++n5) {
                object.writeUtf8(this.responseHeaders.name(n5)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(n5)).writeByte(10);
            }
            Object object3 = object;
            object3.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
            object3.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
            if (this.isHttps()) {
                Object object4 = object;
                object4.writeByte(10);
                object4.writeUtf8(this.handshake.cipherSuite().javaName()).writeByte(10);
                List<Certificate> list = this.handshake.peerCertificates();
                this.writeCertList((BufferedSink)object, list);
                list = this.handshake.localCertificates();
                this.writeCertList((BufferedSink)object, list);
                object4.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
            }
            object.close();
        }

        public boolean matches(Request request, Response response) {
            return this.url.equals(request.url().toString()) && this.requestMethod.equals(request.method()) && HttpHeaders.varyMatches(response, this.varyHeaders, request);
        }

        public Response response(DiskLruCache.Snapshot snapshot) {
            Entry entry = this;
            String string2 = entry.responseHeaders.get("Content-Type");
            String string3 = entry.responseHeaders.get("Content-Length");
            Request request = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(request).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, string2, string3)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }
    }

    private final class CacheRequestImpl
    implements CacheRequest {
        private final DiskLruCache.Editor editor;
        private Sink cacheOut;
        private Sink body;
        boolean done;
        final /* synthetic */ Cache this$0;

        CacheRequestImpl(final Cache cache, final DiskLruCache.Editor editor) {
            ForwardingSink forwardingSink;
            Sink sink;
            CacheRequestImpl cacheRequestImpl = this;
            this.this$0 = cache;
            this.editor = editor;
            cacheRequestImpl.cacheOut = sink = editor.newSink(1);
            ForwardingSink forwardingSink2 = forwardingSink;
            forwardingSink = new ForwardingSink(sink){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void close() throws IOException {
                    1 v02 = this;
                    Cache cache2 = v02.CacheRequestImpl.this.this$0;
                    synchronized (cache2) {
                        try {
                            CacheRequestImpl cacheRequestImpl = v02.CacheRequestImpl.this;
                            if (cacheRequestImpl.done) {
                                return;
                            }
                            1 v12 = this;
                            cacheRequestImpl.done = true;
                            ++cacheRequestImpl.this$0.writeSuccessCount;
                            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                            super.close();
                            v12.editor.commit();
                            return;
                        }
                        catch (Throwable throwable) {}
                        throw throwable;
                    }
                }
            };
            cacheRequestImpl.body = forwardingSink2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void abort() {
            CacheRequestImpl cacheRequestImpl = this;
            Cache cache = cacheRequestImpl.this$0;
            // MONITORENTER : cache
            if (cacheRequestImpl.done) {
                // MONITOREXIT : cache
                return;
            }
            CacheRequestImpl cacheRequestImpl2 = this;
            this.done = true;
            ++this.this$0.writeAbortCount;
            // MONITOREXIT : cache
            Util.closeQuietly(cacheRequestImpl2.cacheOut);
            try {
                cacheRequestImpl2.editor.abort();
                return;
            }
            catch (IOException iOException) {}
        }

        @Override
        public Sink body() {
            return this.body;
        }
    }

    private static class CacheResponseBody
    extends ResponseBody {
        final DiskLruCache.Snapshot snapshot;
        private final BufferedSource bodySource;
        @Nullable
        private final String contentType;
        @Nullable
        private final String contentLength;

        CacheResponseBody(final DiskLruCache.Snapshot snapshot, String object, String string2) {
            this.snapshot = snapshot;
            this.contentType = object;
            this.contentLength = string2;
            object = snapshot.getSource(1);
            this.bodySource = Okio.buffer(new ForwardingSource((Source)object){

                @Override
                public void close() throws IOException {
                    1 v02 = this;
                    v02.snapshot.close();
                    super.close();
                }
            });
        }

        @Override
        public MediaType contentType() {
            String string2 = ((CacheResponseBody)((Object)string2)).contentType;
            return string2 != null ? MediaType.parse(string2) : null;
        }

        @Override
        public long contentLength() {
            block5: {
                long l5;
                block4: {
                    block3: {
                        try {
                            String string2 = ((CacheResponseBody)((Object)string2)).contentLength;
                            if (string2 == null) break block3;
                        }
                        catch (NumberFormatException numberFormatException) {
                            break block5;
                        }
                        l5 = Long.parseLong(string2);
                        break block4;
                    }
                    l5 = -1L;
                }
                return l5;
            }
            return -1L;
        }

        @Override
        public BufferedSource source() {
            return this.bodySource;
        }
    }
}

