/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.CipherSuite;
import dc.squareup.okhttp3.TlsVersion;
import dc.squareup.okhttp3.internal.Util;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpec {
    private static final CipherSuite[] RESTRICTED_CIPHER_SUITES;
    private static final CipherSuite[] APPROVED_CIPHER_SUITES;
    public static final ConnectionSpec RESTRICTED_TLS;
    public static final ConnectionSpec MODERN_TLS;
    public static final ConnectionSpec COMPATIBLE_TLS;
    public static final ConnectionSpec CLEARTEXT;
    final boolean tls;
    final boolean supportsTlsExtensions;
    @Nullable
    final String[] cipherSuites;
    @Nullable
    final String[] tlsVersions;

    ConnectionSpec(Builder builder) {
        this.tls = builder.tls;
        this.cipherSuites = builder.cipherSuites;
        this.tlsVersions = builder.tlsVersions;
        this.supportsTlsExtensions = builder.supportsTlsExtensions;
    }

    private ConnectionSpec supportedSpec(SSLSocket stringArray, boolean n5) {
        String[] stringArray2;
        String[] stringArray3;
        if (this.cipherSuites != null) {
            stringArray3 = stringArray.getEnabledCipherSuites();
            stringArray3 = Util.intersect(CipherSuite.ORDER_BY_NAME, stringArray3, this.cipherSuites);
        } else {
            stringArray3 = stringArray.getEnabledCipherSuites();
        }
        if (this.tlsVersions != null) {
            stringArray2 = stringArray.getEnabledProtocols();
            stringArray2 = Util.intersect(Util.NATURAL_ORDER, stringArray2, this.tlsVersions);
        } else {
            stringArray2 = stringArray.getEnabledProtocols();
        }
        int n6 = n5;
        stringArray = stringArray.getSupportedCipherSuites();
        n5 = Util.indexOf(CipherSuite.ORDER_BY_NAME, stringArray, "TLS_FALLBACK_SCSV");
        if (n6 != 0 && n5 != -1) {
            stringArray3 = Util.concat(stringArray3, stringArray[n5]);
        }
        return new Builder(this).cipherSuites(stringArray3).tlsVersions(stringArray2).build();
    }

    static {
        Object object = CipherSuite.TLS_AES_128_GCM_SHA256;
        Object object2 = CipherSuite.TLS_AES_256_GCM_SHA384;
        Object object3 = CipherSuite.TLS_CHACHA20_POLY1305_SHA256;
        CipherSuite cipherSuite = CipherSuite.TLS_AES_128_CCM_SHA256;
        CipherSuite cipherSuite2 = CipherSuite.TLS_AES_256_CCM_8_SHA256;
        CipherSuite cipherSuite3 = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
        CipherSuite cipherSuite4 = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
        CipherSuite cipherSuite5 = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
        CipherSuite cipherSuite6 = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
        CipherSuite cipherSuite7 = CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
        CipherSuite cipherSuite8 = CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
        CipherSuite[] cipherSuiteArray = new CipherSuite[11];
        CipherSuite[] cipherSuiteArray2 = cipherSuiteArray;
        cipherSuiteArray[0] = object;
        cipherSuiteArray[1] = object2;
        cipherSuiteArray[2] = object3;
        cipherSuiteArray[3] = cipherSuite;
        cipherSuiteArray[4] = cipherSuite2;
        cipherSuiteArray[5] = cipherSuite3;
        cipherSuiteArray[6] = cipherSuite4;
        cipherSuiteArray[7] = cipherSuite5;
        cipherSuiteArray[8] = cipherSuite6;
        cipherSuiteArray[9] = cipherSuite7;
        cipherSuiteArray[10] = cipherSuite8;
        RESTRICTED_CIPHER_SUITES = cipherSuiteArray;
        CipherSuite[] cipherSuiteArray3 = new CipherSuite[18];
        CipherSuite[] cipherSuiteArray4 = cipherSuiteArray3;
        cipherSuiteArray3[0] = object;
        cipherSuiteArray4[1] = object2;
        cipherSuiteArray4[2] = object3;
        cipherSuiteArray4[3] = cipherSuite;
        cipherSuiteArray4[4] = cipherSuite2;
        cipherSuiteArray4[5] = cipherSuite3;
        cipherSuiteArray4[6] = cipherSuite4;
        cipherSuiteArray4[7] = cipherSuite5;
        cipherSuiteArray4[8] = cipherSuite6;
        cipherSuiteArray4[9] = cipherSuite7;
        cipherSuiteArray4[10] = cipherSuite8;
        cipherSuiteArray4[11] = object = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA;
        cipherSuiteArray4[12] = object = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA;
        cipherSuiteArray4[13] = object = CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256;
        cipherSuiteArray4[14] = object = CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384;
        cipherSuiteArray4[15] = object = CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA;
        cipherSuiteArray4[16] = object = CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA;
        cipherSuiteArray4[17] = object = CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA;
        APPROVED_CIPHER_SUITES = cipherSuiteArray4;
        object = TlsVersion.TLS_1_3;
        object2 = TlsVersion.TLS_1_2;
        RESTRICTED_TLS = new Builder(true).cipherSuites(cipherSuiteArray2).tlsVersions(new TlsVersion[]{object, object2}).supportsTlsExtensions(true).build();
        object3 = TlsVersion.TLS_1_0;
        MODERN_TLS = new Builder(true).cipherSuites(cipherSuiteArray4).tlsVersions(new TlsVersion[]{object, object2, TlsVersion.TLS_1_1, object3}).supportsTlsExtensions(true).build();
        COMPATIBLE_TLS = new Builder(true).cipherSuites(cipherSuiteArray4).tlsVersions(new TlsVersion[]{object3}).supportsTlsExtensions(true).build();
        CLEARTEXT = new Builder(false).build();
    }

    public boolean isTls() {
        return this.tls;
    }

    @Nullable
    public List<CipherSuite> cipherSuites() {
        String[] stringArray = stringArray.cipherSuites;
        return stringArray.cipherSuites != null ? CipherSuite.forJavaNames(stringArray) : null;
    }

    @Nullable
    public List<TlsVersion> tlsVersions() {
        String[] stringArray = stringArray.tlsVersions;
        return stringArray.tlsVersions != null ? TlsVersion.forJavaNames(stringArray) : null;
    }

    public boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    void apply(SSLSocket sSLSocket, boolean bl) {
        String[] stringArray = stringArray.supportedSpec(sSLSocket, bl);
        String[] stringArray2 = stringArray.tlsVersions;
        if (stringArray.tlsVersions != null) {
            sSLSocket.setEnabledProtocols(stringArray2);
        }
        stringArray = stringArray.cipherSuites;
        if (stringArray.cipherSuites != null) {
            sSLSocket.setEnabledCipherSuites(stringArray);
        }
    }

    public boolean isCompatible(SSLSocket sSLSocket) {
        if (!stringArray2.tls) {
            return false;
        }
        String[] stringArray = stringArray2.tlsVersions;
        if (stringArray2.tlsVersions != null && !Util.nonEmptyIntersection(Util.NATURAL_ORDER, stringArray, sSLSocket.getEnabledProtocols())) {
            return false;
        }
        String[] stringArray2 = stringArray2.cipherSuites;
        return stringArray2.cipherSuites == null || Util.nonEmptyIntersection(CipherSuite.ORDER_BY_NAME, stringArray2, sSLSocket.getEnabledCipherSuites());
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        object = (ConnectionSpec)object;
        boolean bl = this.tls;
        if (bl != ((ConnectionSpec)object).tls) {
            return false;
        }
        if (bl) {
            if (!Arrays.equals(this.cipherSuites, ((ConnectionSpec)object).cipherSuites)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersions, ((ConnectionSpec)object).tlsVersions)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)object).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n5 = 17;
        if (this.tls) {
            n5 = ((527 + Arrays.hashCode(this.cipherSuites)) * 31 + Arrays.hashCode(this.tlsVersions)) * 31 + (this.supportsTlsExtensions ^ 1);
        }
        return n5;
    }

    public String toString() {
        if (!this.tls) {
            return "ConnectionSpec()";
        }
        String string2 = this.cipherSuites != null ? this.cipherSuites().toString() : "[all enabled]";
        String string3 = this.tlsVersions != null ? this.tlsVersions().toString() : "[all enabled]";
        return "ConnectionSpec(cipherSuites=" + string2 + ", tlsVersions=" + string3 + ", supportsTlsExtensions=" + this.supportsTlsExtensions + ")";
    }

    public static final class Builder {
        boolean tls;
        @Nullable
        String[] cipherSuites;
        @Nullable
        String[] tlsVersions;
        boolean supportsTlsExtensions;

        Builder(boolean bl) {
            this.tls = bl;
        }

        public Builder(ConnectionSpec connectionSpec) {
            this.tls = connectionSpec.tls;
            this.cipherSuites = connectionSpec.cipherSuites;
            this.tlsVersions = connectionSpec.tlsVersions;
            this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions;
        }

        public Builder allEnabledCipherSuites() {
            if (this.tls) {
                this.cipherSuites = null;
                return this;
            }
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }

        public Builder cipherSuites(CipherSuite ... cipherSuiteArray) {
            if (this.tls) {
                String[] stringArray = new String[cipherSuiteArray.length];
                for (int i5 = 0; i5 < cipherSuiteArray.length; ++i5) {
                    stringArray[i5] = cipherSuiteArray[i5].javaName;
                }
                return this.cipherSuites(stringArray);
            }
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }

        public Builder cipherSuites(String ... stringArray) {
            if (this.tls) {
                if (stringArray.length != 0) {
                    this.cipherSuites = (String[])stringArray.clone();
                    return this;
                }
                throw new IllegalArgumentException("At least one cipher suite is required");
            }
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }

        public Builder allEnabledTlsVersions() {
            if (this.tls) {
                this.tlsVersions = null;
                return this;
            }
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }

        public Builder tlsVersions(TlsVersion ... tlsVersionArray) {
            if (this.tls) {
                String[] stringArray = new String[tlsVersionArray.length];
                for (int i5 = 0; i5 < tlsVersionArray.length; ++i5) {
                    stringArray[i5] = tlsVersionArray[i5].javaName;
                }
                return this.tlsVersions(stringArray);
            }
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }

        public Builder tlsVersions(String ... stringArray) {
            if (this.tls) {
                if (stringArray.length != 0) {
                    this.tlsVersions = (String[])stringArray.clone();
                    return this;
                }
                throw new IllegalArgumentException("At least one TLS version is required");
            }
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }

        public Builder supportsTlsExtensions(boolean bl) {
            if (this.tls) {
                this.supportsTlsExtensions = bl;
                return this;
            }
            throw new IllegalStateException("no TLS extensions for cleartext connections");
        }

        public ConnectionSpec build() {
            return new ConnectionSpec(this);
        }
    }
}

