/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http.HttpDate;
import dc.squareup.okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Cookie {
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");
    private final String name;
    private final String value;
    private final long expiresAt;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;

    private Cookie(String string2, String string3, long l5, String string4, String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string2;
        this.value = string3;
        this.expiresAt = l5;
        this.domain = string4;
        this.path = string5;
        this.secure = bl;
        this.httpOnly = bl2;
        this.hostOnly = bl3;
        this.persistent = bl4;
    }

    Cookie(Builder builder) {
        String string2 = builder.name;
        if (string2 != null) {
            String string3 = builder.value;
            if (string3 != null) {
                String string4 = builder.domain;
                if (string4 != null) {
                    this.name = string2;
                    this.value = string3;
                    this.expiresAt = builder.expiresAt;
                    this.domain = string4;
                    this.path = builder.path;
                    this.secure = builder.secure;
                    this.httpOnly = builder.httpOnly;
                    this.persistent = builder.persistent;
                    this.hostOnly = builder.hostOnly;
                    return;
                }
                throw new NullPointerException("builder.domain == null");
            }
            throw new NullPointerException("builder.value == null");
        }
        throw new NullPointerException("builder.name == null");
    }

    private static boolean domainMatch(String string2, String string3) {
        if (string2.equals(string3)) {
            return true;
        }
        if (string2.endsWith(string3)) {
            String string4 = string2;
            if (string4.charAt(string4.length() - string3.length() - 1) == '.' && !Util.verifyAsIpAddress(string2)) {
                return true;
            }
        }
        return false;
    }

    private static boolean pathMatch(HttpUrl object, String string2) {
        if (((String)(object = ((HttpUrl)object).encodedPath())).equals(string2)) {
            return true;
        }
        if (((String)object).startsWith(string2)) {
            if (string2.endsWith("/")) {
                return true;
            }
            if (((String)object).charAt(string2.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Cookie parse(HttpUrl httpUrl, String string2) {
        return Cookie.parse(System.currentTimeMillis(), httpUrl, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static Cookie parse(long l5, HttpUrl httpUrl, String string2) {
        int n5;
        long l6;
        String string3 = string2;
        int n6 = 0;
        int n7 = string3.length();
        int n8 = Util.delimiterOffset(string3, n6, n7, ';');
        int n9 = Util.delimiterOffset(string3, n6, n8, '=');
        if (n9 == n8) {
            return null;
        }
        String string4 = Util.trimSubstring(string2, n6, n9);
        if (string4.isEmpty()) return null;
        if (Util.indexOfControlOrNonAscii(string4) != -1) {
            return null;
        }
        String string5 = Util.trimSubstring(string2, n9 + 1, n8);
        if (Util.indexOfControlOrNonAscii(string5) != -1) {
            return null;
        }
        long l7 = 253402300799999L;
        long l8 = -1L;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        ++n8;
        while (n8 < n7) {
            int n10;
            block25: {
                String string8;
                String string9;
                block27: {
                    block26: {
                        boolean bl5;
                        block24: {
                            String string10 = string2;
                            n10 = Util.delimiterOffset(string10, n8, n7, ';');
                            int n11 = Util.delimiterOffset(string10, n8, n10, '=');
                            string9 = Util.trimSubstring(string2, n8, n11);
                            string8 = n11 < n10 ? Util.trimSubstring(string2, n11 + 1, n10) : "";
                            if (string9.equalsIgnoreCase("expires")) {
                                String string11 = string8;
                                int n12 = 0;
                                l7 = Cookie.parseExpires(string11, n12, string11.length());
                                break block24;
                            }
                            if (!string9.equalsIgnoreCase("max-age")) break block26;
                            try {
                                l8 = Cookie.parseMaxAge(string8);
                            }
                            catch (NumberFormatException numberFormatException) {
                                break block25;
                            }
                        }
                        bl4 = bl5 = true;
                        break block25;
                    }
                    if (!string9.equalsIgnoreCase("domain")) break block27;
                    try {
                        boolean bl6;
                        string9 = Cookie.parseDomain(string8);
                        bl3 = bl6 = false;
                        string6 = string9;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break block25;
                }
                if (string9.equalsIgnoreCase("path")) {
                    string7 = string8;
                } else if (string9.equalsIgnoreCase("secure")) {
                    boolean bl7;
                    bl = bl7 = true;
                } else if (string9.equalsIgnoreCase("httponly")) {
                    boolean bl8;
                    bl2 = bl8 = true;
                }
            }
            n8 = n10 + 1;
        }
        if (l8 == Long.MIN_VALUE) {
            l7 = Long.MIN_VALUE;
        } else if (l8 != -1L && ((l7 = l5 + (l6 = l8 <= 9223372036854775L ? l8 * 1000L : Long.MAX_VALUE)) < l5 || l7 > 253402300799999L)) {
            l7 = 253402300799999L;
        }
        String string12 = httpUrl.host();
        if (string6 == null) {
            string6 = string12;
        } else if (!Cookie.domainMatch(string12, string6)) {
            return null;
        }
        if (string12.length() != string6.length() && PublicSuffixDatabase.get().getEffectiveTldPlusOne(string6) == null) {
            return null;
        }
        if (string7 != null) {
            if (string7.startsWith("/")) return new Cookie(string4, string5, l7, string6, string7, bl, bl2, bl3, bl4);
        }
        if ((n5 = (string12 = httpUrl.encodedPath()).lastIndexOf(47)) != 0) {
            string7 = string12 = string12.substring(0, n5);
            return new Cookie(string4, string5, l7, string6, string7, bl, bl2, bl3, bl4);
        }
        string7 = string12 = "/";
        return new Cookie(string4, string5, l7, string6, string7, bl, bl2, bl3, bl4);
    }

    private static long parseExpires(String string2, int n5, int n6) {
        n5 = Cookie.dateCharacterOffset(string2, n5, n6, false);
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        Matcher matcher = TIME_PATTERN.matcher(string2);
        while (n5 < n6) {
            Pattern pattern;
            int n13 = n5;
            n5 = Cookie.dateCharacterOffset(string2, n5 + 1, n6, true);
            matcher.region(n13, n5);
            if (n7 == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                Matcher matcher2 = matcher;
                n7 = Integer.parseInt(matcher2.group(1));
                n8 = Integer.parseInt(matcher2.group(2));
                n9 = Integer.parseInt(matcher2.group(3));
            } else if (n10 == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                n10 = Integer.parseInt(matcher.group(1));
            } else if (n11 == -1 && matcher.usePattern(pattern = MONTH_PATTERN).matches()) {
                String string3 = matcher.group(1).toLowerCase(Locale.US);
                n11 = pattern.pattern().indexOf(string3) / 4;
            } else if (n12 == -1 && matcher.usePattern(YEAR_PATTERN).matches()) {
                n12 = Integer.parseInt(matcher.group(1));
            }
            n5 = Cookie.dateCharacterOffset(string2, n5 + 1, n6, false);
        }
        if (n12 >= 70 && n12 <= 99) {
            n12 += 1900;
        }
        if (n12 >= 0 && n12 <= 69) {
            n12 += 2000;
        }
        if (n12 >= 1601) {
            if (n11 != -1) {
                if (n10 >= 1 && n10 <= 31) {
                    if (n7 >= 0 && n7 <= 23) {
                        if (n8 >= 0 && n8 <= 59) {
                            if (n9 >= 0 && n9 <= 59) {
                                GregorianCalendar gregorianCalendar = new GregorianCalendar(Util.UTC);
                                gregorianCalendar.setLenient(false);
                                gregorianCalendar.set(1, n12);
                                gregorianCalendar.set(2, n11 - 1);
                                gregorianCalendar.set(5, n10);
                                gregorianCalendar.set(11, n7);
                                gregorianCalendar.set(12, n8);
                                gregorianCalendar.set(13, n9);
                                gregorianCalendar.set(14, 0);
                                return gregorianCalendar.getTimeInMillis();
                            }
                            throw new IllegalArgumentException();
                        }
                        throw new IllegalArgumentException();
                    }
                    throw new IllegalArgumentException();
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private static int dateCharacterOffset(String string2, int n5, int n6, boolean bl) {
        while (n5 < n6) {
            char c6 = string2.charAt(n5);
            if ((c6 < ' ' && c6 != '\t' || c6 >= '\u007f' || c6 >= '0' && c6 <= '9' || c6 >= 'a' && c6 <= 'z' || c6 >= 'A' && c6 <= 'Z' || c6 == ':') == (bl ^ true)) {
                return n5;
            }
            ++n5;
        }
        return n6;
    }

    private static long parseMaxAge(String string2) {
        try {
            long l5 = Long.parseLong(string2);
            if (l5 <= 0L) {
                l5 = Long.MIN_VALUE;
            }
            return l5;
        }
        catch (NumberFormatException numberFormatException) {
            if (string2.matches("-?\\d+")) {
                return string2.startsWith("-") ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            throw numberFormatException;
        }
    }

    private static String parseDomain(String string2) {
        if (!string2.endsWith(".")) {
            if (string2.startsWith(".")) {
                string2 = string2.substring(1);
            }
            if ((string2 = Util.canonicalizeHost(string2)) != null) {
                return string2;
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    public static List<Cookie> parseAll(HttpUrl httpUrl, Headers object) {
        object = ((Headers)object).values("Set-Cookie");
        ArrayList<Cookie> arrayList = null;
        int n5 = object.size();
        for (int i5 = 0; i5 < n5; ++i5) {
            Cookie cookie = Cookie.parse(httpUrl, (String)object.get(i5));
            if (cookie == null) continue;
            if (arrayList == null) {
                ArrayList<Cookie> arrayList2;
                arrayList = arrayList2;
                arrayList2 = new ArrayList<Cookie>();
            }
            arrayList.add(cookie);
        }
        return arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public long expiresAt() {
        return this.expiresAt;
    }

    public boolean hostOnly() {
        return this.hostOnly;
    }

    public String domain() {
        return this.domain;
    }

    public String path() {
        return this.path;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public boolean secure() {
        return this.secure;
    }

    public boolean matches(HttpUrl httpUrl) {
        if (!(this.hostOnly ? httpUrl.host().equals(this.domain) : Cookie.domainMatch(httpUrl.host(), this.domain))) {
            return false;
        }
        if (!Cookie.pathMatch(httpUrl, this.path)) {
            return false;
        }
        return !this.secure || httpUrl.isHttps();
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean bl) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder3.append(this.name);
        stringBuilder3.append('=');
        stringBuilder.append(this.value);
        if (this.persistent) {
            if (this.expiresAt == Long.MIN_VALUE) {
                stringBuilder2.append("; max-age=0");
            } else {
                stringBuilder2.append("; expires=").append(HttpDate.format(new Date(this.expiresAt)));
            }
        }
        if (!this.hostOnly) {
            stringBuilder2.append("; domain=");
            if (bl) {
                stringBuilder2.append(".");
            }
            stringBuilder2.append(this.domain);
        }
        stringBuilder2.append("; path=").append(this.path);
        if (this.secure) {
            stringBuilder2.append("; secure");
        }
        if (this.httpOnly) {
            stringBuilder2.append("; httponly");
        }
        return stringBuilder2.toString();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Cookie)) {
            return false;
        }
        object = (Cookie)object;
        return ((Cookie)object).name.equals(this.name) && ((Cookie)object).value.equals(this.value) && ((Cookie)object).domain.equals(this.domain) && ((Cookie)object).path.equals(this.path) && ((Cookie)object).expiresAt == this.expiresAt && ((Cookie)object).secure == this.secure && ((Cookie)object).httpOnly == this.httpOnly && ((Cookie)object).persistent == this.persistent && ((Cookie)object).hostOnly == this.hostOnly;
    }

    public int hashCode() {
        long l5 = this.expiresAt;
        return ((((((((527 + this.name.hashCode()) * 31 + this.value.hashCode()) * 31 + this.domain.hashCode()) * 31 + this.path.hashCode()) * 31 + (int)(l5 ^ l5 >>> 32)) * 31 + (this.secure ^ 1)) * 31 + (this.httpOnly ^ 1)) * 31 + (this.persistent ^ 1)) * 31 + (this.hostOnly ^ 1);
    }

    public static final class Builder {
        @Nullable
        String name;
        @Nullable
        String value;
        long expiresAt = 253402300799999L;
        @Nullable
        String domain;
        String path = "/";
        boolean secure;
        boolean httpOnly;
        boolean persistent;
        boolean hostOnly;

        private Builder domain(String string2, boolean bl) {
            if (string2 != null) {
                String string3 = Util.canonicalizeHost(string2);
                if (string3 != null) {
                    this.domain = string3;
                    this.hostOnly = bl;
                    return this;
                }
                throw new IllegalArgumentException("unexpected domain: " + string2);
            }
            throw new NullPointerException("domain == null");
        }

        public Builder name(String string2) {
            if (string2 != null) {
                if (string2.trim().equals(string2)) {
                    this.name = string2;
                    return this;
                }
                throw new IllegalArgumentException("name is not trimmed");
            }
            throw new NullPointerException("name == null");
        }

        public Builder value(String string2) {
            if (string2 != null) {
                if (string2.trim().equals(string2)) {
                    this.value = string2;
                    return this;
                }
                throw new IllegalArgumentException("value is not trimmed");
            }
            throw new NullPointerException("value == null");
        }

        public Builder expiresAt(long l5) {
            if (l5 <= 0L) {
                l5 = Long.MIN_VALUE;
            }
            if (l5 > 253402300799999L) {
                l5 = 253402300799999L;
            }
            this.expiresAt = l5;
            this.persistent = true;
            return this;
        }

        public Builder domain(String string2) {
            return this.domain(string2, false);
        }

        public Builder hostOnlyDomain(String string2) {
            return this.domain(string2, true);
        }

        public Builder path(String string2) {
            if (string2.startsWith("/")) {
                this.path = string2;
                return this;
            }
            throw new IllegalArgumentException("path must start with '/'");
        }

        public Builder secure() {
            this.secure = true;
            return this;
        }

        public Builder httpOnly() {
            this.httpOnly = true;
            return this;
        }

        public Cookie build() {
            return new Cookie(this);
        }
    }
}

