/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import dc.squareup.okio.Buffer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class HttpUrl {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String USERNAME_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PASSWORD_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET = " \"<>^`{}|/\\?#";
    static final String PATH_SEGMENT_ENCODE_SET_URI = "[]";
    static final String QUERY_ENCODE_SET = " \"'<>#";
    static final String QUERY_COMPONENT_REENCODE_SET = " \"'<>#&=";
    static final String QUERY_COMPONENT_ENCODE_SET = " !\"#$&'(),/:;<=>?@[]\\^`{|}~";
    static final String QUERY_COMPONENT_ENCODE_SET_URI = "\\^`{|}";
    static final String FORM_ENCODE_SET = " \"':;<=>@[]^`{}|/\\?#&!$(),~";
    static final String FRAGMENT_ENCODE_SET = "";
    static final String FRAGMENT_ENCODE_SET_URI = " \"#<>\\^`{|}";
    final String scheme;
    private final String username;
    private final String password;
    final String host;
    final int port;
    private final List<String> pathSegments;
    @Nullable
    private final List<String> queryNamesAndValues;
    @Nullable
    private final String fragment;
    private final String url;

    HttpUrl(Builder builder) {
        this.scheme = builder.scheme;
        this.username = HttpUrl.percentDecode(builder.encodedUsername, false);
        this.password = HttpUrl.percentDecode(builder.encodedPassword, false);
        this.host = builder.host;
        this.port = builder.effectivePort();
        this.pathSegments = this.percentDecode(builder.encodedPathSegments, false);
        Object object = builder.encodedQueryNamesAndValues;
        object = object != null ? this.percentDecode((List<String>)object, true) : null;
        this.queryNamesAndValues = object;
        object = builder.encodedFragment;
        object = object != null ? HttpUrl.percentDecode((String)object, false) : null;
        this.fragment = object;
        this.url = builder.toString();
    }

    public static int defaultPort(String string2) {
        if (string2.equals("http")) {
            return 80;
        }
        if (string2.equals("https")) {
            return 443;
        }
        return -1;
    }

    static void pathSegmentsToString(StringBuilder stringBuilder, List<String> list) {
        int n5 = list.size();
        for (int i5 = 0; i5 < n5; ++i5) {
            stringBuilder.append('/');
            stringBuilder.append(list.get(i5));
        }
    }

    static void namesAndValuesToQueryString(StringBuilder stringBuilder, List<String> list) {
        int n5 = list.size();
        for (int i5 = 0; i5 < n5; i5 += 2) {
            String string2 = list.get(i5);
            String string3 = list.get(i5 + 1);
            if (i5 > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append(string2);
            if (string3 == null) continue;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append('=');
            stringBuilder2.append(string3);
        }
    }

    static List<String> queryStringToNamesAndValues(String string2) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        int n5 = 0;
        while (n5 <= string2.length()) {
            int n6;
            int n7 = string2.indexOf(38, n5);
            if (n7 == -1) {
                n7 = string2.length();
            }
            if ((n6 = string2.indexOf(61, n5)) != -1 && n6 <= n7) {
                arrayList2.add(string2.substring(n5, n6));
                arrayList2.add(string2.substring(n6 + 1, n7));
            } else {
                ArrayList<String> arrayList3 = arrayList2;
                arrayList3.add(string2.substring(n5, n7));
                arrayList3.add(null);
            }
            n5 = n7 + 1;
        }
        return arrayList2;
    }

    @Nullable
    public static HttpUrl parse(String string2) {
        try {
            return HttpUrl.get(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static HttpUrl get(String string2) {
        return new Builder().parse(null, string2).build();
    }

    @Nullable
    public static HttpUrl get(URL uRL) {
        return HttpUrl.parse(uRL.toString());
    }

    @Nullable
    public static HttpUrl get(URI uRI) {
        return HttpUrl.parse(uRI.toString());
    }

    static String percentDecode(String string2, boolean bl) {
        String string3 = string2;
        return HttpUrl.percentDecode(string3, 0, string3.length(), bl);
    }

    private List<String> percentDecode(List<String> list, boolean bl) {
        ArrayList<String> arrayList;
        int n5 = list.size();
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(n5);
        for (int i5 = 0; i5 < n5; ++i5) {
            String string2 = list.get(i5);
            string2 = string2 != null ? HttpUrl.percentDecode(string2, bl) : null;
            arrayList2.add(string2);
        }
        return Collections.unmodifiableList(arrayList2);
    }

    static String percentDecode(String string2, int n5, int n6, boolean bl) {
        for (int i5 = n5; i5 < n6; ++i5) {
            Buffer buffer;
            char c6 = string2.charAt(i5);
            if (!(c6 == '%' || c6 == '+' && bl)) {
                continue;
            }
            Buffer buffer2 = buffer;
            buffer2();
            buffer2.writeUtf8(string2, n5, i5);
            HttpUrl.percentDecode(buffer, string2, i5, n6, bl);
            return buffer.readUtf8();
        }
        return string2.substring(n5, n6);
    }

    /*
     * Unable to fully structure code
     */
    static void percentDecode(Buffer var0, String var1_1, int var2_2, int var3_3, boolean var4_4) {
        while (var2_2 < var3_3) {
            block4: {
                block3: {
                    var5_5 = var1_1.codePointAt(var2_2);
                    if (var5_5 != 37 || (var6_6 = var2_2 + 2) >= var3_3) break block3;
                    var7_7 = Util.decodeHexDigit(var1_1.charAt(var2_2 + 1));
                    var8_8 = Util.decodeHexDigit(var1_1.charAt(var6_6));
                    if (var7_7 == -1 || var8_8 == -1) ** GOTO lbl-1000
                    var0.writeByte((var7_7 << 4) + var8_8);
                    var2_2 = var6_6;
                    break block4;
                }
                if (var5_5 == 43 && var4_4) {
                    var0.writeByte(32);
                } else lbl-1000:
                // 2 sources

                {
                    var0.writeUtf8CodePoint(var5_5);
                }
            }
            var2_2 += Character.charCount(var5_5);
        }
    }

    static boolean percentEncoded(String string2, int n5, int n6) {
        int n7 = n5 + 2;
        return n7 < n6 && string2.charAt(n5) == '%' && Util.decodeHexDigit(string2.charAt(n5 + 1)) != -1 && Util.decodeHexDigit(string2.charAt(n7)) != -1;
    }

    static String canonicalize(String string2, int n5, int n6, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, Charset charset) {
        int n7;
        for (int i5 = n5; i5 < n6; i5 += Character.charCount(n7)) {
            Buffer buffer;
            n7 = string2.codePointAt(i5);
            if (!(n7 < 32 || n7 == 127 || n7 >= 128 && bl4 || string3.indexOf(n7) != -1 || n7 == 37 && (!bl || bl2 && !HttpUrl.percentEncoded(string2, i5, n6)) || n7 == 43 && bl3)) {
                continue;
            }
            Buffer buffer2 = buffer;
            buffer2();
            buffer2.writeUtf8(string2, n5, i5);
            HttpUrl.canonicalize(buffer, string2, i5, n6, string3, bl, bl2, bl3, bl4, charset);
            return buffer.readUtf8();
        }
        return string2.substring(n5, n6);
    }

    static void canonicalize(Buffer buffer, String string2, int n5, int n6, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, Charset charset) {
        Buffer buffer2 = null;
        while (n5 < n6) {
            int n7 = string2.codePointAt(n5);
            if (!bl || n7 != 9 && n7 != 10 && n7 != 12 && n7 != 13) {
                if (n7 == 43 && bl3) {
                    String string4 = bl ? "+" : "%2B";
                    buffer.writeUtf8(string4);
                } else if (!(n7 < 32 || n7 == 127 || n7 >= 128 && bl4 || string3.indexOf(n7) != -1 || n7 == 37 && (!bl || bl2 && !HttpUrl.percentEncoded(string2, n5, n6)))) {
                    buffer.writeUtf8CodePoint(n7);
                } else {
                    if (buffer2 == null) {
                        Buffer buffer3;
                        buffer2 = buffer3;
                        buffer3 = new Buffer();
                    }
                    if (charset != null && !charset.equals(Util.UTF_8)) {
                        buffer2.writeString(string2, n5, n5 + Character.charCount(n7), charset);
                    } else {
                        buffer2.writeUtf8CodePoint(n7);
                    }
                    while (!buffer2.exhausted()) {
                        Buffer buffer4 = buffer;
                        byte by = buffer2.readByte();
                        int n8 = by & 0xFF;
                        buffer4.writeByte(37);
                        char[] cArray = HEX_DIGITS;
                        buffer.writeByte(cArray[n8 >> 4 & 0xF]);
                        buffer4.writeByte(HEX_DIGITS[by & 0xF]);
                    }
                }
            }
            n5 += Character.charCount(n7);
        }
    }

    static String canonicalize(String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, Charset charset) {
        String string4 = string2;
        return HttpUrl.canonicalize(string4, 0, string4.length(), string3, bl, bl2, bl3, bl4, charset);
    }

    static String canonicalize(String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string4 = string2;
        return HttpUrl.canonicalize(string4, 0, string4.length(), string3, bl, bl2, bl3, bl4, null);
    }

    public URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public URI uri() {
        String string2 = ((HttpUrl)((Object)string2)).newBuilder().reencodeForUri().toString();
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                return URI.create(string2.replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]", FRAGMENT_ENCODE_SET));
            }
            catch (Exception exception) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    public String scheme() {
        return this.scheme;
    }

    public boolean isHttps() {
        return this.scheme.equals("https");
    }

    public String encodedUsername() {
        if (this.username.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        HttpUrl httpUrl = this;
        int n5 = httpUrl.scheme.length() + 3;
        String string2 = httpUrl.url;
        int n6 = Util.delimiterOffset(string2, n5, string2.length(), ":@");
        return httpUrl.url.substring(n5, n6);
    }

    public String username() {
        return this.username;
    }

    public String encodedPassword() {
        if (this.password.isEmpty()) {
            return FRAGMENT_ENCODE_SET;
        }
        HttpUrl httpUrl = this;
        int n5 = httpUrl.url.indexOf(58, this.scheme.length() + 3) + 1;
        int n6 = httpUrl.url.indexOf(64);
        return httpUrl.url.substring(n5, n6);
    }

    public String password() {
        return this.password;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int pathSize() {
        return this.pathSegments.size();
    }

    public String encodedPath() {
        HttpUrl httpUrl = this;
        int n5 = httpUrl.url.indexOf(47, this.scheme.length() + 3);
        String string2 = httpUrl.url;
        int n6 = Util.delimiterOffset(string2, n5, string2.length(), "?#");
        return httpUrl.url.substring(n5, n6);
    }

    public List<String> encodedPathSegments() {
        ArrayList<String> arrayList;
        HttpUrl httpUrl = this;
        int n5 = httpUrl.url.indexOf(47, this.scheme.length() + 3);
        String string2 = httpUrl.url;
        int n6 = Util.delimiterOffset(string2, n5, string2.length(), "?#");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        while (n5 < n6) {
            HttpUrl httpUrl2 = this;
            int n7 = Util.delimiterOffset(httpUrl2.url, ++n5, n6, '/');
            arrayList2.add(httpUrl2.url.substring(n5, n7));
            n5 = n7;
        }
        return arrayList2;
    }

    public List<String> pathSegments() {
        return this.pathSegments;
    }

    @Nullable
    public String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        HttpUrl httpUrl = this;
        int n5 = httpUrl.url.indexOf(63) + 1;
        String string2 = httpUrl.url;
        int n6 = Util.delimiterOffset(string2, n5, string2.length(), '#');
        return httpUrl.url.substring(n5, n6);
    }

    @Nullable
    public String query() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HttpUrl.namesAndValuesToQueryString(stringBuilder, this.queryNamesAndValues);
        return stringBuilder.toString();
    }

    public int querySize() {
        List<String> list = ((HttpUrl)((Object)list)).queryNamesAndValues;
        return list != null ? list.size() / 2 : 0;
    }

    @Nullable
    public String queryParameter(String string2) {
        List<String> list = this.queryNamesAndValues;
        if (list == null) {
            return null;
        }
        int n5 = list.size();
        for (int i5 = 0; i5 < n5; i5 += 2) {
            if (!string2.equals(this.queryNamesAndValues.get(i5))) continue;
            return this.queryNamesAndValues.get(i5 + 1);
        }
        return null;
    }

    public Set<String> queryParameterNames() {
        LinkedHashSet<String> linkedHashSet;
        if (this.queryNamesAndValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet2 = linkedHashSet;
        linkedHashSet = new LinkedHashSet<String>();
        int n5 = this.queryNamesAndValues.size();
        for (int i5 = 0; i5 < n5; i5 += 2) {
            linkedHashSet2.add(this.queryNamesAndValues.get(i5));
        }
        return Collections.unmodifiableSet(linkedHashSet2);
    }

    public List<String> queryParameterValues(String string2) {
        ArrayList<String> arrayList;
        if (this.queryNamesAndValues == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        int n5 = this.queryNamesAndValues.size();
        for (int i5 = 0; i5 < n5; i5 += 2) {
            if (!string2.equals(this.queryNamesAndValues.get(i5))) continue;
            arrayList2.add(this.queryNamesAndValues.get(i5 + 1));
        }
        return Collections.unmodifiableList(arrayList2);
    }

    public String queryParameterName(int n5) {
        List<String> list = ((HttpUrl)((Object)list)).queryNamesAndValues;
        if (list != null) {
            return (String)list.get(n5 * 2);
        }
        throw new IndexOutOfBoundsException();
    }

    public String queryParameterValue(int n5) {
        List<String> list = ((HttpUrl)((Object)list)).queryNamesAndValues;
        if (list != null) {
            return (String)list.get(n5 * 2 + 1);
        }
        throw new IndexOutOfBoundsException();
    }

    @Nullable
    public String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        HttpUrl httpUrl = this;
        int n5 = httpUrl.url.indexOf(35) + 1;
        return httpUrl.url.substring(n5);
    }

    @Nullable
    public String fragment() {
        return this.fragment;
    }

    public String redact() {
        return this.newBuilder("/...").username(FRAGMENT_ENCODE_SET).password(FRAGMENT_ENCODE_SET).build().toString();
    }

    @Nullable
    public HttpUrl resolve(String string2) {
        return (this = ((HttpUrl)this).newBuilder(string2)) != null ? ((Builder)this).build() : null;
    }

    public Builder newBuilder() {
        Builder builder;
        Builder builder2 = builder;
        builder2();
        builder2.scheme = this.scheme;
        builder2.encodedUsername = this.encodedUsername();
        builder2.encodedPassword = this.encodedPassword();
        builder.host = this.host;
        int n5 = this.port != HttpUrl.defaultPort(this.scheme) ? this.port : -1;
        Builder builder3 = builder2;
        builder3.port = n5;
        builder3.encodedPathSegments.clear();
        builder3.encodedPathSegments.addAll(this.encodedPathSegments());
        builder2.encodedQuery(this.encodedQuery());
        builder2.encodedFragment = this.encodedFragment();
        return builder2;
    }

    @Nullable
    public Builder newBuilder(String string2) {
        try {
            return new Builder().parse(this, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof HttpUrl && ((HttpUrl)object).url.equals(this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }

    @Nullable
    public String topPrivateDomain() {
        if (Util.verifyAsIpAddress(this.host)) {
            return null;
        }
        return PublicSuffixDatabase.get().getEffectiveTldPlusOne(this.host);
    }

    public static final class Builder {
        static final String INVALID_HOST = "Invalid URL host";
        @Nullable
        String scheme;
        String encodedUsername = "";
        String encodedPassword = "";
        @Nullable
        String host;
        int port = -1;
        final List<String> encodedPathSegments;
        @Nullable
        List<String> encodedQueryNamesAndValues;
        @Nullable
        String encodedFragment;

        public Builder() {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList2();
            this.encodedPathSegments = arrayList2;
            arrayList.add(HttpUrl.FRAGMENT_ENCODE_SET);
        }

        private Builder addPathSegments(String string2, boolean bl) {
            int n5;
            int n6 = 0;
            do {
                boolean bl2 = (n5 = Util.delimiterOffset(string2, n6, string2.length(), "/\\")) < string2.length();
                this.push(string2, n6, n5, bl2, bl);
            } while ((n6 = n5 + 1) <= string2.length());
            return this;
        }

        private void removeAllCanonicalQueryParameters(String string2) {
            for (int i5 = this.encodedQueryNamesAndValues.size() - 2; i5 >= 0; i5 -= 2) {
                if (!string2.equals(this.encodedQueryNamesAndValues.get(i5))) continue;
                Builder builder = this;
                builder.encodedQueryNamesAndValues.remove(i5 + 1);
                builder.encodedQueryNamesAndValues.remove(i5);
                if (!builder.encodedQueryNamesAndValues.isEmpty()) continue;
                this.encodedQueryNamesAndValues = null;
                return;
            }
        }

        private void resolvePath(String string2, int n5, int n6) {
            if (n5 == n6) {
                return;
            }
            int n7 = string2.charAt(n5);
            if (n7 != 47 && n7 != 92) {
                List<String> list = this.encodedPathSegments;
                list.set(list.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
            } else {
                Builder builder = this;
                builder.encodedPathSegments.clear();
                builder.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
                ++n5;
            }
            while (n5 < n6) {
                n7 = Util.delimiterOffset(string2, n5, n6, "/\\");
                boolean bl = n7 < n6;
                this.push(string2, n5, n7, bl, true);
                if (bl) {
                    n5 = n7 + 1;
                    continue;
                }
                n5 = n7;
            }
        }

        private void push(String string2, int n5, int n6, boolean bl, boolean bl2) {
            if (this.isDot(string2 = HttpUrl.canonicalize(string2, n5, n6, HttpUrl.PATH_SEGMENT_ENCODE_SET, bl2, false, false, true, null))) {
                return;
            }
            if (this.isDotDot(string2)) {
                this.pop();
                return;
            }
            List<String> list = this.encodedPathSegments;
            if (list.get(list.size() - 1).isEmpty()) {
                List<String> list2 = this.encodedPathSegments;
                list2.set(list2.size() - 1, string2);
            } else {
                this.encodedPathSegments.add(string2);
            }
            if (bl) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private boolean isDot(String string2) {
            return string2.equals(".") || string2.equalsIgnoreCase("%2e");
        }

        private boolean isDotDot(String string2) {
            return string2.equals("..") || string2.equalsIgnoreCase("%2e.") || string2.equalsIgnoreCase(".%2e") || string2.equalsIgnoreCase("%2e%2e");
        }

        private void pop() {
            List<String> list = this.encodedPathSegments;
            if (list.remove(list.size() - 1).isEmpty() && !this.encodedPathSegments.isEmpty()) {
                List<String> list2 = this.encodedPathSegments;
                list2.set(list2.size() - 1, HttpUrl.FRAGMENT_ENCODE_SET);
            } else {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
        }

        private static int schemeDelimiterOffset(String string2, int n5, int n6) {
            if (n6 - n5 < 2) {
                return -1;
            }
            char c6 = string2.charAt(n5);
            if (c6 >= 'a' && c6 <= 'z' || c6 >= 'A' && c6 <= 'Z') {
                while (++n5 < n6) {
                    c6 = string2.charAt(n5);
                    if (c6 >= 'a' && c6 <= 'z' || c6 >= 'A' && c6 <= 'Z' || c6 >= '0' && c6 <= '9' || c6 == '+' || c6 == '-' || c6 == '.') continue;
                    if (c6 == ':') {
                        return n5;
                    }
                    return -1;
                }
                return -1;
            }
            return -1;
        }

        private static int slashCount(String string2, int n5, int n6) {
            char c6;
            int n7 = 0;
            while (n5 < n6 && ((c6 = string2.charAt(n5)) == '\\' || c6 == '/')) {
                ++n7;
                ++n5;
            }
            return n7;
        }

        private static int portColonOffset(String string2, int n5, int n6) {
            while (n5 < n6) {
                char c6 = string2.charAt(n5);
                if (c6 != ':') {
                    if (c6 == '[') {
                        while (++n5 < n6 && string2.charAt(n5) != ']') {
                        }
                    }
                    ++n5;
                    continue;
                }
                return n5;
            }
            return n6;
        }

        private static String canonicalizeHost(String string2, int n5, int n6) {
            return Util.canonicalizeHost(HttpUrl.percentDecode(string2, n5, n6, false));
        }

        private static int parsePort(String string2, int n5, int n6) {
            try {
                int n7 = Integer.parseInt(HttpUrl.canonicalize(string2, n5, n6, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, true, null));
                if (n7 > 0 && n7 <= 65535) {
                    return n7;
                }
                return -1;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        public Builder scheme(String string2) {
            block2: {
                block5: {
                    block4: {
                        block3: {
                            if (string2 == null) break block2;
                            if (!string2.equalsIgnoreCase("http")) break block3;
                            this.scheme = "http";
                            break block4;
                        }
                        if (!string2.equalsIgnoreCase("https")) break block5;
                        this.scheme = "https";
                    }
                    return this;
                }
                throw new IllegalArgumentException("unexpected scheme: " + string2);
            }
            throw new NullPointerException("scheme == null");
        }

        public Builder username(String string2) {
            if (string2 != null) {
                this.encodedUsername = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
                return this;
            }
            throw new NullPointerException("username == null");
        }

        public Builder encodedUsername(String string2) {
            if (string2 != null) {
                this.encodedUsername = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
                return this;
            }
            throw new NullPointerException("encodedUsername == null");
        }

        public Builder password(String string2) {
            if (string2 != null) {
                this.encodedPassword = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", false, false, false, true);
                return this;
            }
            throw new NullPointerException("password == null");
        }

        public Builder encodedPassword(String string2) {
            if (string2 != null) {
                this.encodedPassword = HttpUrl.canonicalize(string2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true);
                return this;
            }
            throw new NullPointerException("encodedPassword == null");
        }

        public Builder host(String string2) {
            if (string2 != null) {
                String string3 = string2;
                String string4 = Builder.canonicalizeHost(string3, 0, string3.length());
                if (string4 != null) {
                    this.host = string4;
                    return this;
                }
                throw new IllegalArgumentException("unexpected host: " + string2);
            }
            throw new NullPointerException("host == null");
        }

        public Builder port(int n5) {
            if (n5 > 0 && n5 <= 65535) {
                this.port = n5;
                return this;
            }
            throw new IllegalArgumentException("unexpected port: " + n5);
        }

        int effectivePort() {
            int n5 = this.port;
            if (n5 == -1) {
                n5 = HttpUrl.defaultPort(this.scheme);
            }
            return n5;
        }

        public Builder addPathSegment(String string2) {
            if (string2 != null) {
                Builder builder = this;
                int n5 = string2.length();
                builder.push(string2, 0, n5, false, false);
                return builder;
            }
            throw new NullPointerException("pathSegment == null");
        }

        public Builder addPathSegments(String string2) {
            if (string2 != null) {
                return this.addPathSegments(string2, false);
            }
            throw new NullPointerException("pathSegments == null");
        }

        public Builder addEncodedPathSegment(String string2) {
            if (string2 != null) {
                Builder builder = this;
                int n5 = string2.length();
                builder.push(string2, 0, n5, false, true);
                return builder;
            }
            throw new NullPointerException("encodedPathSegment == null");
        }

        public Builder addEncodedPathSegments(String string2) {
            if (string2 != null) {
                return this.addPathSegments(string2, true);
            }
            throw new NullPointerException("encodedPathSegments == null");
        }

        public Builder setPathSegment(int n5, String string2) {
            if (string2 != null) {
                String string3 = string2;
                String string4 = HttpUrl.canonicalize(string3, 0, string3.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, false, false, false, true, null);
                if (!this.isDot(string4) && !this.isDotDot(string4)) {
                    Builder builder = this;
                    builder.encodedPathSegments.set(n5, string4);
                    return builder;
                }
                throw new IllegalArgumentException("unexpected path segment: " + string2);
            }
            throw new NullPointerException("pathSegment == null");
        }

        public Builder setEncodedPathSegment(int n5, String string2) {
            if (string2 != null) {
                String string3 = string2;
                String string4 = HttpUrl.canonicalize(string3, 0, string3.length(), HttpUrl.PATH_SEGMENT_ENCODE_SET, true, false, false, true, null);
                this.encodedPathSegments.set(n5, string4);
                if (!this.isDot(string4) && !this.isDotDot(string4)) {
                    return this;
                }
                throw new IllegalArgumentException("unexpected path segment: " + string2);
            }
            throw new NullPointerException("encodedPathSegment == null");
        }

        public Builder removePathSegment(int n5) {
            Builder builder = this;
            builder.encodedPathSegments.remove(n5);
            if (builder.encodedPathSegments.isEmpty()) {
                this.encodedPathSegments.add(HttpUrl.FRAGMENT_ENCODE_SET);
            }
            return this;
        }

        public Builder encodedPath(String string2) {
            if (string2 != null) {
                if (string2.startsWith("/")) {
                    Builder builder = this;
                    int n5 = string2.length();
                    builder.resolvePath(string2, 0, n5);
                    return builder;
                }
                throw new IllegalArgumentException("unexpected encodedPath: " + string2);
            }
            throw new NullPointerException("encodedPath == null");
        }

        public Builder query(@Nullable String list) {
            list = list != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize((String)((Object)list), HttpUrl.QUERY_ENCODE_SET, false, false, true, true)) : null;
            this.encodedQueryNamesAndValues = list;
            return this;
        }

        public Builder encodedQuery(@Nullable String list) {
            list = list != null ? HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize((String)((Object)list), HttpUrl.QUERY_ENCODE_SET, true, false, true, true)) : null;
            this.encodedQueryNamesAndValues = list;
            return this;
        }

        public Builder addQueryParameter(String object, @Nullable String string2) {
            if (object != null) {
                if (this.encodedQueryNamesAndValues == null) {
                    ArrayList<String> arrayList;
                    ArrayList<String> arrayList2 = arrayList;
                    arrayList = new ArrayList<String>();
                    this.encodedQueryNamesAndValues = arrayList2;
                }
                Builder builder = this;
                builder.encodedQueryNamesAndValues.add(HttpUrl.canonicalize((String)object, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true));
                object = builder.encodedQueryNamesAndValues;
                string2 = string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true) : null;
                object.add(string2);
                return this;
            }
            throw new NullPointerException("name == null");
        }

        public Builder addEncodedQueryParameter(String object, @Nullable String string2) {
            if (object != null) {
                if (this.encodedQueryNamesAndValues == null) {
                    ArrayList<String> arrayList;
                    ArrayList<String> arrayList2 = arrayList;
                    arrayList = new ArrayList<String>();
                    this.encodedQueryNamesAndValues = arrayList2;
                }
                Builder builder = this;
                builder.encodedQueryNamesAndValues.add(HttpUrl.canonicalize((String)object, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
                object = builder.encodedQueryNamesAndValues;
                string2 = string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true) : null;
                object.add(string2);
                return this;
            }
            throw new NullPointerException("encodedName == null");
        }

        public Builder setQueryParameter(String string2, @Nullable String string3) {
            Builder builder = this;
            builder.removeAllQueryParameters(string2);
            builder.addQueryParameter(string2, string3);
            return builder;
        }

        public Builder setEncodedQueryParameter(String string2, @Nullable String string3) {
            Builder builder = this;
            builder.removeAllEncodedQueryParameters(string2);
            builder.addEncodedQueryParameter(string2, string3);
            return builder;
        }

        public Builder removeAllQueryParameters(String string2) {
            if (string2 != null) {
                if (this.encodedQueryNamesAndValues == null) {
                    return this;
                }
                Builder builder = this;
                builder.removeAllCanonicalQueryParameters(HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_ENCODE_SET, false, false, true, true));
                return builder;
            }
            throw new NullPointerException("name == null");
        }

        public Builder removeAllEncodedQueryParameters(String string2) {
            if (string2 != null) {
                if (this.encodedQueryNamesAndValues == null) {
                    return this;
                }
                Builder builder = this;
                builder.removeAllCanonicalQueryParameters(HttpUrl.canonicalize(string2, HttpUrl.QUERY_COMPONENT_REENCODE_SET, true, false, true, true));
                return builder;
            }
            throw new NullPointerException("encodedName == null");
        }

        public Builder fragment(@Nullable String string2) {
            string2 = string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.FRAGMENT_ENCODE_SET, false, false, false, false) : null;
            this.encodedFragment = string2;
            return this;
        }

        public Builder encodedFragment(@Nullable String string2) {
            string2 = string2 != null ? HttpUrl.canonicalize(string2, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false) : null;
            this.encodedFragment = string2;
            return this;
        }

        Builder reencodeForUri() {
            String string2;
            String string3;
            int n5 = this.encodedPathSegments.size();
            for (int i5 = 0; i5 < n5; ++i5) {
                Builder builder = this;
                string3 = builder.encodedPathSegments.get(i5);
                builder.encodedPathSegments.set(i5, HttpUrl.canonicalize(string3, HttpUrl.PATH_SEGMENT_ENCODE_SET_URI, true, true, false, true));
            }
            List<String> list = this.encodedQueryNamesAndValues;
            if (list != null) {
                n5 = list.size();
                for (int i6 = 0; i6 < n5; ++i6) {
                    string3 = this.encodedQueryNamesAndValues.get(i6);
                    if (string3 == null) continue;
                    this.encodedQueryNamesAndValues.set(i6, HttpUrl.canonicalize(string3, HttpUrl.QUERY_COMPONENT_ENCODE_SET_URI, true, true, true, true));
                }
            }
            if ((string2 = this.encodedFragment) != null) {
                this.encodedFragment = HttpUrl.canonicalize(string2, HttpUrl.FRAGMENT_ENCODE_SET_URI, true, true, false, false);
            }
            return this;
        }

        public HttpUrl build() {
            if (this.scheme != null) {
                if (this.host != null) {
                    return new HttpUrl(this);
                }
                throw new IllegalStateException("host == null");
            }
            throw new IllegalStateException("scheme == null");
        }

        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            String string2 = this.scheme;
            if (string2 != null) {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append(string2);
                stringBuilder3.append("://");
            } else {
                stringBuilder2.append("//");
            }
            if (!this.encodedUsername.isEmpty() || !this.encodedPassword.isEmpty()) {
                stringBuilder2.append(this.encodedUsername);
                if (!this.encodedPassword.isEmpty()) {
                    stringBuilder2.append(':');
                    stringBuilder2.append(this.encodedPassword);
                }
                stringBuilder2.append('@');
            }
            if ((string2 = this.host) != null) {
                if (string2.indexOf(58) != -1) {
                    StringBuilder stringBuilder4 = stringBuilder2;
                    stringBuilder2.append('[');
                    stringBuilder4.append(this.host);
                    stringBuilder4.append(']');
                } else {
                    stringBuilder2.append(this.host);
                }
            }
            if (this.port != -1 || this.scheme != null) {
                Builder builder = this;
                int n5 = builder.effectivePort();
                String string3 = builder.scheme;
                if (string3 == null || n5 != HttpUrl.defaultPort(string3)) {
                    StringBuilder stringBuilder5 = stringBuilder2;
                    stringBuilder5.append(':');
                    stringBuilder5.append(n5);
                }
            }
            HttpUrl.pathSegmentsToString(stringBuilder2, this.encodedPathSegments);
            if (this.encodedQueryNamesAndValues != null) {
                stringBuilder2.append('?');
                HttpUrl.namesAndValuesToQueryString(stringBuilder2, this.encodedQueryNamesAndValues);
            }
            if (this.encodedFragment != null) {
                stringBuilder2.append('#');
                stringBuilder2.append(this.encodedFragment);
            }
            return stringBuilder2.toString();
        }

        Builder parse(@Nullable HttpUrl httpUrl, String string2) {
            block19: {
                int n5;
                int n6;
                block22: {
                    int n7;
                    int n8;
                    block21: {
                        int n9;
                        int n10;
                        block20: {
                            block17: {
                                block15: {
                                    block18: {
                                        block16: {
                                            n8 = string2.length();
                                            n8 = Util.skipLeadingAsciiWhitespace(string2, 0, n8);
                                            n7 = string2.length();
                                            n6 = Builder.schemeDelimiterOffset(string2, n8, n7 = Util.skipTrailingAsciiWhitespace(string2, n8, n7));
                                            if (n6 == -1) break block15;
                                            if (!string2.regionMatches(true, n8, "https:", 0, 6)) break block16;
                                            this.scheme = "https";
                                            n8 += 6;
                                            break block17;
                                        }
                                        if (!string2.regionMatches(true, n8, "http:", 0, 5)) break block18;
                                        this.scheme = "http";
                                        n8 += 5;
                                        break block17;
                                    }
                                    throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but was '" + string2.substring(0, n6) + "'");
                                }
                                if (httpUrl == null) break block19;
                                this.scheme = httpUrl.scheme;
                            }
                            n6 = 0;
                            n10 = 0;
                            n9 = Builder.slashCount(string2, n8, n7);
                            if (n9 >= 2 || httpUrl == null || !httpUrl.scheme.equals(this.scheme)) break block20;
                            HttpUrl httpUrl2 = httpUrl;
                            this.encodedUsername = httpUrl2.encodedUsername();
                            this.encodedPassword = httpUrl2.encodedPassword();
                            this.host = httpUrl2.host;
                            this.port = httpUrl2.port;
                            this.encodedPathSegments.clear();
                            this.encodedPathSegments.addAll(httpUrl.encodedPathSegments());
                            if (n8 == n7 || string2.charAt(n8) == '#') {
                                this.encodedQuery(httpUrl.encodedQuery());
                            }
                            break block21;
                        }
                        n5 = n8 + n9;
                        while ((n9 = (n8 = Util.delimiterOffset(string2, n5, n7, "@/\\?#")) != n7 ? (int)string2.charAt(n8) : -1) != -1 && n9 != 35 && n9 != 47 && n9 != 92 && n9 != 63) {
                            if (n9 != 64) continue;
                            if (n10 == 0) {
                                int n11 = n6;
                                n6 = Util.delimiterOffset(string2, n5, n8, ':');
                                String string3 = HttpUrl.canonicalize(string2, n5, n6, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                if (n11 != 0) {
                                    string3 = this.encodedUsername + "%40" + string3;
                                }
                                this.encodedUsername = string3;
                                if (n6 != n8) {
                                    n10 = 1;
                                    this.encodedPassword = HttpUrl.canonicalize(string2, n6 + 1, n8, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                                }
                                n6 = 1;
                            } else {
                                this.encodedPassword = this.encodedPassword + "%40" + HttpUrl.canonicalize(string2, n5, n8, " \"':;<=>@[]^`{}|/\\?#", true, false, false, true, null);
                            }
                            n5 = n8 + 1;
                        }
                        n6 = Builder.portColonOffset(string2, n5, n8);
                        n10 = n6 + 1;
                        if (n10 < n8) {
                            this.host = Builder.canonicalizeHost(string2, n5, n6);
                            this.port = Builder.parsePort(string2, n10, n8);
                            if (this.port == -1) {
                                throw new IllegalArgumentException("Invalid URL port: \"" + string2.substring(n10, n8) + '\"');
                            }
                        } else {
                            this.host = Builder.canonicalizeHost(string2, n5, n6);
                            this.port = HttpUrl.defaultPort(this.scheme);
                        }
                        if (this.host == null) break block22;
                    }
                    int n12 = Util.delimiterOffset(string2, n8, n7, "?#");
                    this.resolvePath(string2, n8, n12);
                    if (n12 < n7 && string2.charAt(n12) == '?') {
                        n8 = Util.delimiterOffset(string2, n12, n7, '#');
                        this.encodedQueryNamesAndValues = HttpUrl.queryStringToNamesAndValues(HttpUrl.canonicalize(string2, n12 + 1, n8, HttpUrl.QUERY_ENCODE_SET, true, false, true, true, null));
                        n12 = n8;
                    }
                    if (n12 < n7 && string2.charAt(n12) == '#') {
                        this.encodedFragment = HttpUrl.canonicalize(string2, n12 + 1, n7, HttpUrl.FRAGMENT_ENCODE_SET, true, false, false, false, null);
                    }
                    return this;
                }
                throw new IllegalArgumentException("Invalid URL host: \"" + string2.substring(n5, n6) + '\"');
            }
            throw new IllegalArgumentException("Expected URL scheme 'http' or 'https' but no colon was found");
        }
    }
}

