/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Address;
import dc.squareup.okhttp3.Authenticator;
import dc.squareup.okhttp3.Cache;
import dc.squareup.okhttp3.Call;
import dc.squareup.okhttp3.CertificatePinner;
import dc.squareup.okhttp3.ConnectionPool;
import dc.squareup.okhttp3.ConnectionSpec;
import dc.squareup.okhttp3.CookieJar;
import dc.squareup.okhttp3.Dispatcher;
import dc.squareup.okhttp3.Dns;
import dc.squareup.okhttp3.EventListener;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.Interceptor;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.RealCall;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.Route;
import dc.squareup.okhttp3.WebSocket;
import dc.squareup.okhttp3.WebSocketListener;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.cache.InternalCache;
import dc.squareup.okhttp3.internal.connection.RealConnection;
import dc.squareup.okhttp3.internal.connection.RouteDatabase;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.platform.Platform;
import dc.squareup.okhttp3.internal.proxy.NullProxySelector;
import dc.squareup.okhttp3.internal.tls.CertificateChainCleaner;
import dc.squareup.okhttp3.internal.tls.OkHostnameVerifier;
import dc.squareup.okhttp3.internal.ws.RealWebSocket;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class OkHttpClient
implements Cloneable,
Call.Factory,
WebSocket.Factory {
    static final List<Protocol> DEFAULT_PROTOCOLS = Util.immutableList(Protocol.HTTP_2, Protocol.HTTP_1_1);
    static final List<ConnectionSpec> DEFAULT_CONNECTION_SPECS = Util.immutableList(ConnectionSpec.MODERN_TLS, ConnectionSpec.CLEARTEXT);
    private static SSLSocketFactory tempSSLFactory;
    final Dispatcher dispatcher;
    @Nullable
    final Proxy proxy;
    final List<Protocol> protocols;
    final List<ConnectionSpec> connectionSpecs;
    final List<Interceptor> interceptors;
    final List<Interceptor> networkInterceptors;
    final EventListener.Factory eventListenerFactory;
    final ProxySelector proxySelector;
    final CookieJar cookieJar;
    @Nullable
    final Cache cache;
    @Nullable
    final InternalCache internalCache;
    final SocketFactory socketFactory;
    final SSLSocketFactory sslSocketFactory;
    final CertificateChainCleaner certificateChainCleaner;
    final HostnameVerifier hostnameVerifier;
    final CertificatePinner certificatePinner;
    final Authenticator proxyAuthenticator;
    final Authenticator authenticator;
    final ConnectionPool connectionPool;
    final Dns dns;
    final boolean followSslRedirects;
    final boolean followRedirects;
    final boolean retryOnConnectionFailure;
    final int callTimeout;
    final int connectTimeout;
    final int readTimeout;
    final int writeTimeout;
    final int pingInterval;

    public OkHttpClient() {
        Builder builder;
        OkHttpClient okHttpClient = builder2;
        Builder builder2 = builder;
        builder = new Builder();
        okHttpClient(builder2);
    }

    OkHttpClient(Builder builder) {
        this.dispatcher = builder.dispatcher;
        this.proxy = builder.proxy;
        this.protocols = builder.protocols;
        this.connectionSpecs = builder.connectionSpecs;
        this.interceptors = Util.immutableList(builder.interceptors);
        this.networkInterceptors = Util.immutableList(builder.networkInterceptors);
        this.eventListenerFactory = builder.eventListenerFactory;
        this.proxySelector = builder.proxySelector;
        this.cookieJar = builder.cookieJar;
        this.cache = builder.cache;
        this.internalCache = builder.internalCache;
        this.socketFactory = builder.socketFactory;
        boolean bl = false;
        for (ConnectionSpec connectionSpec : this.connectionSpecs) {
            if (!bl && !connectionSpec.isTls()) {
                bl = false;
                continue;
            }
            bl = true;
        }
        SSLSocketFactory sSLSocketFactory = builder.sslSocketFactory;
        if (sSLSocketFactory == null && bl) {
            X509TrustManager x509TrustManager = Util.platformTrustManager();
            if (tempSSLFactory == null) {
                tempSSLFactory = OkHttpClient.newSslSocketFactory(x509TrustManager);
            }
            this.sslSocketFactory = tempSSLFactory;
            this.certificateChainCleaner = CertificateChainCleaner.get(x509TrustManager);
        } else {
            this.sslSocketFactory = sSLSocketFactory;
            this.certificateChainCleaner = builder.certificateChainCleaner;
        }
        if (this.sslSocketFactory != null) {
            Platform.get().configureSslSocketFactory(this.sslSocketFactory);
        }
        this.hostnameVerifier = builder.hostnameVerifier;
        this.certificatePinner = builder.certificatePinner.withCertificateChainCleaner(this.certificateChainCleaner);
        this.proxyAuthenticator = builder.proxyAuthenticator;
        this.authenticator = builder.authenticator;
        this.connectionPool = builder.connectionPool;
        this.dns = builder.dns;
        this.followSslRedirects = builder.followSslRedirects;
        this.followRedirects = builder.followRedirects;
        this.retryOnConnectionFailure = builder.retryOnConnectionFailure;
        this.callTimeout = builder.callTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.writeTimeout = builder.writeTimeout;
        this.pingInterval = builder.pingInterval;
        if (!this.interceptors.contains(null)) {
            if (!this.networkInterceptors.contains(null)) {
                return;
            }
            throw new IllegalStateException("Null network interceptor: " + this.networkInterceptors);
        }
        throw new IllegalStateException("Null interceptor: " + this.interceptors);
    }

    private static SSLSocketFactory newSslSocketFactory(X509TrustManager x509TrustManager) {
        SSLContext sSLContext;
        try {
            sSLContext = Platform.get().getSSLContext();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Util.assertionError("No System TLS", generalSecurityException);
        }
        sSLContext.init(null, new TrustManager[]{x509TrustManager}, null);
        return sSLContext.getSocketFactory();
    }

    static {
        Internal.instance = new Internal(){

            @Override
            public void addLenient(Headers.Builder builder, String string2) {
                builder.addLenient(string2);
            }

            @Override
            public void addLenient(Headers.Builder builder, String string2, String string3) {
                builder.addLenient(string2, string3);
            }

            @Override
            public void setCache(Builder builder, InternalCache internalCache) {
                builder.setInternalCache(internalCache);
            }

            @Override
            public boolean connectionBecameIdle(ConnectionPool connectionPool, RealConnection realConnection) {
                return connectionPool.connectionBecameIdle(realConnection);
            }

            @Override
            public RealConnection get(ConnectionPool connectionPool, Address address, StreamAllocation streamAllocation, Route route) {
                return connectionPool.get(address, streamAllocation, route);
            }

            @Override
            public boolean equalsNonHost(Address address, Address address2) {
                return address.equalsNonHost(address2);
            }

            @Override
            public Socket deduplicate(ConnectionPool connectionPool, Address address, StreamAllocation streamAllocation) {
                return connectionPool.deduplicate(address, streamAllocation);
            }

            @Override
            public void put(ConnectionPool connectionPool, RealConnection realConnection) {
                connectionPool.put(realConnection);
            }

            @Override
            public RouteDatabase routeDatabase(ConnectionPool connectionPool) {
                return connectionPool.routeDatabase;
            }

            @Override
            public int code(Response.Builder builder) {
                return builder.code;
            }

            @Override
            public void apply(ConnectionSpec connectionSpec, SSLSocket sSLSocket, boolean bl) {
                connectionSpec.apply(sSLSocket, bl);
            }

            @Override
            public boolean isInvalidHttpUrlHost(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException.getMessage().startsWith("Invalid URL host");
            }

            @Override
            public StreamAllocation streamAllocation(Call call) {
                return ((RealCall)call).streamAllocation();
            }

            @Override
            @Nullable
            public IOException timeoutExit(Call call, @Nullable IOException iOException) {
                return ((RealCall)call).timeoutExit(iOException);
            }

            @Override
            public Call newWebSocketCall(OkHttpClient okHttpClient, Request request) {
                return RealCall.newRealCall(okHttpClient, request, true);
            }
        };
        tempSSLFactory = null;
    }

    public int callTimeoutMillis() {
        return this.callTimeout;
    }

    public int connectTimeoutMillis() {
        return this.connectTimeout;
    }

    public int readTimeoutMillis() {
        return this.readTimeout;
    }

    public int writeTimeoutMillis() {
        return this.writeTimeout;
    }

    public int pingIntervalMillis() {
        return this.pingInterval;
    }

    @Nullable
    public Proxy proxy() {
        return this.proxy;
    }

    public ProxySelector proxySelector() {
        return this.proxySelector;
    }

    public CookieJar cookieJar() {
        return this.cookieJar;
    }

    @Nullable
    public Cache cache() {
        return this.cache;
    }

    InternalCache internalCache() {
        Cache cache = this.cache;
        return cache != null ? cache.internalCache : this.internalCache;
    }

    public Dns dns() {
        return this.dns;
    }

    public SocketFactory socketFactory() {
        return this.socketFactory;
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public CertificatePinner certificatePinner() {
        return this.certificatePinner;
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public Authenticator proxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public ConnectionPool connectionPool() {
        return this.connectionPool;
    }

    public boolean followSslRedirects() {
        return this.followSslRedirects;
    }

    public boolean followRedirects() {
        return this.followRedirects;
    }

    public boolean retryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public Dispatcher dispatcher() {
        return this.dispatcher;
    }

    public List<Protocol> protocols() {
        return this.protocols;
    }

    public List<ConnectionSpec> connectionSpecs() {
        return this.connectionSpecs;
    }

    public List<Interceptor> interceptors() {
        return this.interceptors;
    }

    public List<Interceptor> networkInterceptors() {
        return this.networkInterceptors;
    }

    public EventListener.Factory eventListenerFactory() {
        return this.eventListenerFactory;
    }

    @Override
    public Call newCall(Request request) {
        return RealCall.newRealCall(this, request, false);
    }

    @Override
    public WebSocket newWebSocket(Request request, WebSocketListener webSocketListener) {
        Random random;
        OkHttpClient okHttpClient = random2;
        Random random2 = random;
        random = new Random();
        long l5 = okHttpClient.pingInterval;
        RealWebSocket realWebSocket = new RealWebSocket(request, webSocketListener, random2, l5);
        realWebSocket.connect((OkHttpClient)((Object)random2));
        return realWebSocket;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        Dispatcher dispatcher;
        @Nullable
        Proxy proxy;
        List<Protocol> protocols;
        List<ConnectionSpec> connectionSpecs;
        final List<Interceptor> interceptors;
        final List<Interceptor> networkInterceptors;
        EventListener.Factory eventListenerFactory;
        ProxySelector proxySelector;
        CookieJar cookieJar;
        @Nullable
        Cache cache;
        @Nullable
        InternalCache internalCache;
        SocketFactory socketFactory;
        @Nullable
        SSLSocketFactory sslSocketFactory;
        @Nullable
        CertificateChainCleaner certificateChainCleaner;
        HostnameVerifier hostnameVerifier;
        CertificatePinner certificatePinner;
        Authenticator proxyAuthenticator;
        Authenticator authenticator;
        ConnectionPool connectionPool;
        Dns dns;
        boolean followSslRedirects;
        boolean followRedirects;
        boolean retryOnConnectionFailure;
        int callTimeout;
        int connectTimeout;
        int readTimeout;
        int writeTimeout;
        int pingInterval;

        public Builder() {
            ConnectionPool connectionPool;
            Dispatcher dispatcher;
            ArrayList<Interceptor> arrayList;
            ArrayList<Interceptor> arrayList2;
            Object object = arrayList2;
            arrayList2 = new ArrayList<Interceptor>();
            this.interceptors = object;
            object = arrayList;
            arrayList = new ArrayList<Interceptor>();
            this.networkInterceptors = object;
            object = dispatcher;
            dispatcher = new Dispatcher();
            this.dispatcher = object;
            this.protocols = DEFAULT_PROTOCOLS;
            this.connectionSpecs = DEFAULT_CONNECTION_SPECS;
            this.eventListenerFactory = EventListener.factory(EventListener.NONE);
            this.proxySelector = ProxySelector.getDefault();
            if (this.proxySelector == null) {
                NullProxySelector nullProxySelector;
                object = nullProxySelector;
                nullProxySelector = new NullProxySelector();
                this.proxySelector = object;
            }
            this.cookieJar = CookieJar.NO_COOKIES;
            this.socketFactory = SocketFactory.getDefault();
            this.hostnameVerifier = OkHostnameVerifier.INSTANCE;
            this.certificatePinner = CertificatePinner.DEFAULT;
            this.proxyAuthenticator = object = Authenticator.NONE;
            this.authenticator = object;
            object = connectionPool;
            connectionPool = new ConnectionPool();
            this.connectionPool = object;
            this.dns = Dns.SYSTEM;
            this.followSslRedirects = true;
            this.followRedirects = true;
            this.retryOnConnectionFailure = true;
            this.callTimeout = 0;
            this.connectTimeout = 10000;
            this.readTimeout = 10000;
            this.writeTimeout = 10000;
            this.pingInterval = 0;
        }

        Builder(OkHttpClient okHttpClient) {
            ArrayList<Interceptor> arrayList;
            ArrayList<Interceptor> arrayList2;
            ArrayList<Interceptor> arrayList3 = arrayList2;
            arrayList2 = new ArrayList<Interceptor>();
            this.interceptors = arrayList3;
            ArrayList<Interceptor> arrayList4 = arrayList;
            arrayList4();
            this.networkInterceptors = arrayList4;
            this.dispatcher = okHttpClient.dispatcher;
            this.proxy = okHttpClient.proxy;
            this.protocols = okHttpClient.protocols;
            this.connectionSpecs = okHttpClient.connectionSpecs;
            arrayList3.addAll(okHttpClient.interceptors);
            arrayList.addAll(okHttpClient.networkInterceptors);
            this.eventListenerFactory = okHttpClient.eventListenerFactory;
            this.proxySelector = okHttpClient.proxySelector;
            this.cookieJar = okHttpClient.cookieJar;
            this.internalCache = okHttpClient.internalCache;
            this.cache = okHttpClient.cache;
            this.socketFactory = okHttpClient.socketFactory;
            this.sslSocketFactory = okHttpClient.sslSocketFactory;
            this.certificateChainCleaner = okHttpClient.certificateChainCleaner;
            this.hostnameVerifier = okHttpClient.hostnameVerifier;
            this.certificatePinner = okHttpClient.certificatePinner;
            this.proxyAuthenticator = okHttpClient.proxyAuthenticator;
            this.authenticator = okHttpClient.authenticator;
            this.connectionPool = okHttpClient.connectionPool;
            this.dns = okHttpClient.dns;
            this.followSslRedirects = okHttpClient.followSslRedirects;
            this.followRedirects = okHttpClient.followRedirects;
            this.retryOnConnectionFailure = okHttpClient.retryOnConnectionFailure;
            this.callTimeout = okHttpClient.callTimeout;
            this.connectTimeout = okHttpClient.connectTimeout;
            this.readTimeout = okHttpClient.readTimeout;
            this.writeTimeout = okHttpClient.writeTimeout;
            this.pingInterval = okHttpClient.pingInterval;
        }

        public Builder callTimeout(long l5, TimeUnit timeUnit) {
            this.callTimeout = Util.checkDuration("timeout", l5, timeUnit);
            return this;
        }

        public Builder callTimeout(Duration duration) {
            long l5 = duration.toMillis();
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            this.callTimeout = Util.checkDuration("timeout", l5, timeUnit);
            return this;
        }

        public Builder connectTimeout(long l5, TimeUnit timeUnit) {
            this.connectTimeout = Util.checkDuration("timeout", l5, timeUnit);
            return this;
        }

        public Builder connectTimeout(Duration duration) {
            long l5 = duration.toMillis();
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            this.connectTimeout = Util.checkDuration("timeout", l5, timeUnit);
            return this;
        }

        public Builder readTimeout(long l5, TimeUnit timeUnit) {
            this.readTimeout = Util.checkDuration("timeout", l5, timeUnit);
            return this;
        }

        public Builder readTimeout(Duration duration) {
            long l5 = duration.toMillis();
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            this.readTimeout = Util.checkDuration("timeout", l5, timeUnit);
            return this;
        }

        public Builder writeTimeout(long l5, TimeUnit timeUnit) {
            this.writeTimeout = Util.checkDuration("timeout", l5, timeUnit);
            return this;
        }

        public Builder writeTimeout(Duration duration) {
            long l5 = duration.toMillis();
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            this.writeTimeout = Util.checkDuration("timeout", l5, timeUnit);
            return this;
        }

        public Builder pingInterval(long l5, TimeUnit timeUnit) {
            this.pingInterval = Util.checkDuration("interval", l5, timeUnit);
            return this;
        }

        public Builder pingInterval(Duration duration) {
            long l5 = duration.toMillis();
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            this.pingInterval = Util.checkDuration("timeout", l5, timeUnit);
            return this;
        }

        public Builder proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxySelector(ProxySelector proxySelector) {
            if (proxySelector != null) {
                this.proxySelector = proxySelector;
                return this;
            }
            throw new NullPointerException("proxySelector == null");
        }

        public Builder cookieJar(CookieJar cookieJar) {
            if (cookieJar != null) {
                this.cookieJar = cookieJar;
                return this;
            }
            throw new NullPointerException("cookieJar == null");
        }

        void setInternalCache(@Nullable InternalCache internalCache) {
            Builder builder = this;
            builder.internalCache = internalCache;
            builder.cache = null;
        }

        public Builder cache(@Nullable Cache cache) {
            this.cache = cache;
            this.internalCache = null;
            return this;
        }

        public Builder dns(Dns dns) {
            if (dns != null) {
                this.dns = dns;
                return this;
            }
            throw new NullPointerException("dns == null");
        }

        public Builder socketFactory(SocketFactory socketFactory) {
            if (socketFactory != null) {
                this.socketFactory = socketFactory;
                return this;
            }
            throw new NullPointerException("socketFactory == null");
        }

        public Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            if (sSLSocketFactory != null) {
                this.sslSocketFactory = sSLSocketFactory;
                this.certificateChainCleaner = Platform.get().buildCertificateChainCleaner(sSLSocketFactory);
                return this;
            }
            throw new NullPointerException("sslSocketFactory == null");
        }

        public Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory, X509TrustManager x509TrustManager) {
            if (sSLSocketFactory != null) {
                if (x509TrustManager != null) {
                    this.sslSocketFactory = sSLSocketFactory;
                    this.certificateChainCleaner = CertificateChainCleaner.get(x509TrustManager);
                    return this;
                }
                throw new NullPointerException("trustManager == null");
            }
            throw new NullPointerException("sslSocketFactory == null");
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            if (hostnameVerifier != null) {
                this.hostnameVerifier = hostnameVerifier;
                return this;
            }
            throw new NullPointerException("hostnameVerifier == null");
        }

        public Builder certificatePinner(CertificatePinner certificatePinner) {
            if (certificatePinner != null) {
                this.certificatePinner = certificatePinner;
                return this;
            }
            throw new NullPointerException("certificatePinner == null");
        }

        public Builder authenticator(Authenticator authenticator) {
            if (authenticator != null) {
                this.authenticator = authenticator;
                return this;
            }
            throw new NullPointerException("authenticator == null");
        }

        public Builder proxyAuthenticator(Authenticator authenticator) {
            if (authenticator != null) {
                this.proxyAuthenticator = authenticator;
                return this;
            }
            throw new NullPointerException("proxyAuthenticator == null");
        }

        public Builder connectionPool(ConnectionPool connectionPool) {
            if (connectionPool != null) {
                this.connectionPool = connectionPool;
                return this;
            }
            throw new NullPointerException("connectionPool == null");
        }

        public Builder followSslRedirects(boolean bl) {
            this.followSslRedirects = bl;
            return this;
        }

        public Builder followRedirects(boolean bl) {
            this.followRedirects = bl;
            return this;
        }

        public Builder retryOnConnectionFailure(boolean bl) {
            this.retryOnConnectionFailure = bl;
            return this;
        }

        public Builder dispatcher(Dispatcher dispatcher) {
            if (dispatcher != null) {
                this.dispatcher = dispatcher;
                return this;
            }
            throw new IllegalArgumentException("dispatcher == null");
        }

        public Builder protocols(List<Protocol> object) {
            ArrayList<Protocol> arrayList;
            ArrayList<Protocol> arrayList2 = arrayList;
            if (!new ArrayList<Protocol>((Collection<Protocol>)object).contains(object = Protocol.H2_PRIOR_KNOWLEDGE) && !arrayList2.contains((Object)Protocol.HTTP_1_1)) {
                throw new IllegalArgumentException("protocols must contain h2_prior_knowledge or http/1.1: " + arrayList2);
            }
            if (arrayList2.contains(object) && arrayList2.size() > 1) {
                throw new IllegalArgumentException("protocols containing h2_prior_knowledge cannot use other protocols: " + arrayList2);
            }
            if (!arrayList2.contains((Object)Protocol.HTTP_1_0)) {
                if (!arrayList2.contains(null)) {
                    ArrayList<Protocol> arrayList3 = arrayList2;
                    arrayList3.remove((Object)Protocol.SPDY_3);
                    this.protocols = Collections.unmodifiableList(arrayList3);
                    return this;
                }
                throw new IllegalArgumentException("protocols must not contain null");
            }
            throw new IllegalArgumentException("protocols must not contain http/1.0: " + arrayList2);
        }

        public Builder connectionSpecs(List<ConnectionSpec> list) {
            this.connectionSpecs = Util.immutableList(list);
            return this;
        }

        public List<Interceptor> interceptors() {
            return this.interceptors;
        }

        public Builder addInterceptor(Interceptor interceptor) {
            if (interceptor != null) {
                Builder builder = this;
                builder.interceptors.add(interceptor);
                return builder;
            }
            throw new IllegalArgumentException("interceptor == null");
        }

        public List<Interceptor> networkInterceptors() {
            return this.networkInterceptors;
        }

        public Builder addNetworkInterceptor(Interceptor interceptor) {
            if (interceptor != null) {
                Builder builder = this;
                builder.networkInterceptors.add(interceptor);
                return builder;
            }
            throw new IllegalArgumentException("interceptor == null");
        }

        public Builder eventListener(EventListener eventListener) {
            if (eventListener != null) {
                this.eventListenerFactory = EventListener.factory(eventListener);
                return this;
            }
            throw new NullPointerException("eventListener == null");
        }

        public Builder eventListenerFactory(EventListener.Factory factory) {
            if (factory != null) {
                this.eventListenerFactory = factory;
                return this;
            }
            throw new NullPointerException("eventListenerFactory == null");
        }

        public OkHttpClient build() {
            return new OkHttpClient(this);
        }
    }
}

