/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum TlsVersion {
    TLS_1_3("TLSv1.3"),
    TLS_1_2("TLSv1.2"),
    TLS_1_1("TLSv1.1"),
    TLS_1_0("TLSv1"),
    SSL_3_0("SSLv3");

    final String javaName;

    private TlsVersion(String string3) {
        this.javaName = string3;
    }

    public static TlsVersion forJavaName(String string2) {
        String string3 = string2;
        string3.hashCode();
        int n5 = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 79923350: {
                if (!string2.equals("TLSv1")) break;
                n5 = 4;
                break;
            }
            case 79201641: {
                if (!string2.equals("SSLv3")) break;
                n5 = 3;
                break;
            }
            case -503070501: {
                if (!string2.equals("TLSv1.3")) break;
                n5 = 2;
                break;
            }
            case -503070502: {
                if (!string2.equals("TLSv1.2")) break;
                n5 = 1;
                break;
            }
            case -503070503: {
                if (!string2.equals("TLSv1.1")) break;
                n5 = 0;
            }
        }
        switch (n5) {
            default: {
                throw new IllegalArgumentException("Unexpected TLS version: " + string2);
            }
            case 4: {
                return TLS_1_0;
            }
            case 3: {
                return SSL_3_0;
            }
            case 2: {
                return TLS_1_3;
            }
            case 1: {
                return TLS_1_2;
            }
            case 0: 
        }
        return TLS_1_1;
    }

    static List<TlsVersion> forJavaNames(String ... stringArray) {
        ArrayList<TlsVersion> arrayList;
        ArrayList<TlsVersion> arrayList2 = arrayList;
        arrayList = new ArrayList<TlsVersion>(stringArray.length);
        int n5 = stringArray.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            arrayList2.add(TlsVersion.forJavaName(stringArray[i5]));
        }
        return Collections.unmodifiableList(arrayList2);
    }

    public String javaName() {
        return this.javaName;
    }
}

