/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import androidx.annotation.Nullable;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Options;
import dc.squareup.okio.PeekSource;
import dc.squareup.okio.Segment;
import dc.squareup.okio.SegmentPool;
import dc.squareup.okio.SegmentedByteString;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Buffer
implements BufferedSource,
BufferedSink,
Cloneable,
ByteChannel {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final int REPLACEMENT_CHARACTER = 65533;
    @Nullable
    Segment head;
    long size;

    private void readFrom(InputStream inputStream, long l5, boolean bl) throws IOException {
        if (inputStream != null) {
            while (true) {
                if (l5 <= 0L && !bl) {
                    return;
                }
                Segment segment = this.writableSegment(1);
                int n5 = (int)Math.min(l5, (long)(8192 - segment.limit));
                byte[] byArray = segment.data;
                if ((n5 = inputStream.read(byArray, segment.limit, n5)) == -1) {
                    if (segment.pos == segment.limit) {
                        this.head = segment.pop();
                        SegmentPool.recycle(segment);
                    }
                    if (bl) {
                        return;
                    }
                    throw new EOFException();
                }
                long l6 = l5;
                segment.limit += n5;
                l5 = n5;
                this.size += l5;
                l5 = l6 - l5;
            }
        }
        throw new IllegalArgumentException("in == null");
    }

    private boolean rangeEquals(Segment object, int n5, ByteString byteString, int n6, int n7) {
        Segment segment = object;
        int n8 = segment.limit;
        Object object2 = segment.data;
        while (n6 < n7) {
            if (n5 == n8) {
                Segment segment2 = ((Segment)object).next;
                object = segment2.data;
                n5 = segment2.pos;
                int n9 = segment2.limit;
                Object object3 = object;
                n8 = n9;
                object = segment2;
                object2 = object3;
            }
            if (object2[n5] != byteString.getByte(n6)) {
                return false;
            }
            ++n5;
            ++n6;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteString digest(String var1_1) {
        block8: {
            try {
                var1_1 = MessageDigest.getInstance((String)var1_1);
                var2_2 = this.head;
                if (var2_2 == null) break block8;
                v0 = var2_2;
                var3_3 = v0.data;
                var4_4 = v0.pos;
                var1_1.update(var3_3, var4_4, var2_2.limit - var4_4);
                v1 = this.head;
                ** while ((var2_2 = v1.next) != this.head)
            }
            catch (NoSuchAlgorithmException v2) {
                throw new AssertionError();
            }
lbl-1000:
            // 1 sources

            {
                v1 = var2_2;
                v3 = var1_1;
                v4 = var2_2;
                var3_3 = v4.data;
                var4_4 = v4.pos;
                v5 = var3_3;
                v6 = var2_2.limit;
                v3.update(v5, var4_4, v6 - var4_4);
                continue;
            }
        }
        return ByteString.of(var1_1.digest());
    }

    public final long size() {
        return this.size;
    }

    @Override
    public Buffer buffer() {
        return this;
    }

    @Override
    public Buffer getBuffer() {
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int n5) {
                Buffer.this.writeByte((byte)n5);
            }

            @Override
            public void write(byte[] byArray, int n5, int n6) {
                Buffer.this.write(byArray, n5, n6);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            public String toString() {
                return Buffer.this + ".outputStream()";
            }
        };
    }

    @Override
    public Buffer emitCompleteSegments() {
        return this;
    }

    @Override
    public BufferedSink emit() {
        return this;
    }

    @Override
    public boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public void require(long l5) throws EOFException {
        if (this.size >= l5) {
            return;
        }
        throw new EOFException();
    }

    @Override
    public boolean request(long l5) {
        return this.size >= l5;
    }

    @Override
    public BufferedSource peek() {
        return Okio.buffer(new PeekSource(this));
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() {
                Closeable closeable = closeable.Buffer.this;
                if (((Buffer)closeable).size > 0L) {
                    return ((Buffer)closeable).readByte() & 0xFF;
                }
                return -1;
            }

            @Override
            public int read(byte[] byArray, int n5, int n6) {
                return Buffer.this.read(byArray, n5, n6);
            }

            @Override
            public int available() {
                return (int)Math.min(Buffer.this.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() {
            }

            public String toString() {
                return Buffer.this + ".inputStream()";
            }
        };
    }

    public final Buffer copyTo(OutputStream outputStream) throws IOException {
        long l5 = this.size;
        return this.copyTo(outputStream, 0L, l5);
    }

    public final Buffer copyTo(OutputStream outputStream, long l5, long l6) throws IOException {
        if (outputStream != null) {
            int n5;
            int n6;
            Util.checkOffsetAndCount(this.size, l5, l6);
            if (l6 == 0L) {
                return this;
            }
            Segment segment = this.head;
            while (l5 >= (long)((n6 = segment.limit) - (n5 = segment.pos))) {
                l5 -= (long)(n6 - n5);
                segment = segment.next;
            }
            while (l6 > 0L) {
                Segment segment2 = segment;
                int n7 = (int)((long)segment2.pos + l5);
                int n8 = (int)Math.min((long)(segment2.limit - n7), l6);
                outputStream.write(segment2.data, n7, n8);
                l6 -= (long)n8;
                l5 = 0L;
                segment = segment.next;
            }
            return this;
        }
        throw new IllegalArgumentException("out == null");
    }

    public final Buffer copyTo(Buffer buffer, long l5, long l6) {
        if (buffer != null) {
            int n5;
            int n6;
            Util.checkOffsetAndCount(this.size, l5, l6);
            if (l6 == 0L) {
                return this;
            }
            buffer.size += l6;
            Segment segment = this.head;
            while (l5 >= (long)((n6 = segment.limit) - (n5 = segment.pos))) {
                l5 -= (long)(n6 - n5);
                segment = segment.next;
            }
            while (l6 > 0L) {
                int n7;
                Segment segment2 = segment.sharedCopy();
                segment2.pos = n7 = (int)((long)segment2.pos + l5);
                segment2.limit = Math.min(n7 + (int)l6, segment2.limit);
                Segment segment3 = buffer.head;
                if (segment3 == null) {
                    segment2.prev = segment2;
                    segment2.next = segment2;
                    buffer.head = segment2;
                } else {
                    segment3.prev.push(segment2);
                }
                l6 -= (long)(segment2.limit - segment2.pos);
                l5 = 0L;
                segment = segment.next;
            }
            return this;
        }
        throw new IllegalArgumentException("out == null");
    }

    public final Buffer writeTo(OutputStream outputStream) throws IOException {
        return this.writeTo(outputStream, this.size);
    }

    public final Buffer writeTo(OutputStream outputStream, long l5) throws IOException {
        if (outputStream != null) {
            Buffer buffer = this;
            Util.checkOffsetAndCount(buffer.size, 0L, l5);
            Segment segment = buffer.head;
            while (l5 > 0L) {
                Segment segment2 = segment;
                int n5 = (int)Math.min(l5, (long)(segment.limit - segment.pos));
                byte[] byArray = segment2.data;
                outputStream.write(byArray, segment2.pos, n5);
                int n6 = segment.pos + n5;
                long l6 = l5;
                segment.pos = n6;
                l5 = n5;
                this.size -= l5;
                l5 = l6 - l5;
                if (n6 != segment.limit) continue;
                Segment segment3 = segment;
                this.head = segment = segment.pop();
                SegmentPool.recycle(segment3);
            }
            return this;
        }
        throw new IllegalArgumentException("out == null");
    }

    public final Buffer readFrom(InputStream inputStream) throws IOException {
        Buffer buffer = this;
        buffer.readFrom(inputStream, Long.MAX_VALUE, true);
        return buffer;
    }

    public final Buffer readFrom(InputStream inputStream, long l5) throws IOException {
        if (l5 >= 0L) {
            Buffer buffer = this;
            buffer.readFrom(inputStream, l5, false);
            return buffer;
        }
        throw new IllegalArgumentException("byteCount < 0: " + l5);
    }

    public final long completeSegmentByteCount() {
        long l5 = ((Buffer)((Object)segment)).size;
        if (l5 == 0L) {
            return 0L;
        }
        Segment segment = ((Buffer)((Object)segment)).head.prev;
        int n5 = segment.limit;
        if (n5 < 8192 && segment.owner) {
            l5 -= (long)(n5 - segment.pos);
        }
        return l5;
    }

    @Override
    public byte readByte() {
        long l5 = this.size;
        if (l5 != 0L) {
            Segment segment = this.head;
            int n5 = segment.pos;
            int n6 = segment.limit;
            byte[] byArray = segment.data;
            int n7 = n5 + 1;
            byte by = byArray[n5];
            this.size = l5 - 1L;
            if (n7 == n6) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n7;
            }
            return by;
        }
        throw new IllegalStateException("size == 0");
    }

    public final byte getByte(long l5) {
        Buffer buffer = object;
        Util.checkOffsetAndCount(buffer.size, l5, 1L);
        long l6 = buffer.size;
        if (l6 - l5 > l5) {
            Object object = ((Buffer)object).head;
            while (true) {
                int n5;
                long l7;
                if (l5 < (l7 = (long)(((Segment)object).limit - (n5 = ((Segment)object).pos)))) {
                    return ((Segment)object).data[n5 + (int)l5];
                }
                l5 -= l7;
                object = ((Segment)object).next;
            }
        }
        long l8 = l5 - l6;
        Segment segment = ((Buffer)object).head.prev;
        int n6;
        while ((l6 = l8 + (long)(segment.limit - (n6 = segment.pos))) < 0L) {
            segment = segment.prev;
            l8 = l6;
        }
        return segment.data[n6 + (int)l6];
    }

    @Override
    public short readShort() {
        long l5 = this.size;
        if (l5 >= 2L) {
            Segment segment = this.head;
            int n5 = segment.limit;
            int n6 = segment.pos;
            if (n5 - n6 < 2) {
                return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
            }
            byte[] byArray = segment.data;
            int n7 = n6;
            int n8 = n7 + 1;
            int n9 = (segment.data[n7] & 0xFF) << 8;
            int n10 = n9 | byArray[n8] & 0xFF;
            this.size = l5 - 2L;
            if ((n6 += 2) == n5) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n6;
            }
            return (short)n10;
        }
        throw new IllegalStateException("size < 2: " + this.size);
    }

    @Override
    public int readInt() {
        long l5 = this.size;
        if (l5 >= 4L) {
            int n5;
            Segment segment = this.head;
            int n6 = segment.limit;
            int n7 = segment.pos;
            if (n6 - n7 < 4) {
                return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            }
            byte[] byArray = segment.data;
            int n8 = n7;
            int n9 = n5 = n8 + 1;
            int n10 = n5 = n7 + 2;
            n5 = n7 + 3;
            int n11 = (segment.data[n8] & 0xFF) << 24 | (byArray[n9] & 0xFF) << 16 | (byArray[n10] & 0xFF) << 8;
            int n12 = n11 | byArray[n5] & 0xFF;
            this.size = l5 - 4L;
            if ((n7 += 4) == n6) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n7;
            }
            return n12;
        }
        throw new IllegalStateException("size < 4: " + this.size);
    }

    @Override
    public long readLong() {
        long l5 = this.size;
        if (l5 >= 8L) {
            int n5;
            Segment segment = this.head;
            int n6 = segment.limit;
            int n7 = segment.pos;
            if (n6 - n7 < 8) {
                return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
            }
            byte[] byArray = segment.data;
            int n8 = n7;
            int n9 = n5 = n8 + 1;
            int n10 = n5 = n7 + 2;
            int n11 = n5 = n7 + 3;
            int n12 = n5 = n7 + 4;
            int n13 = n5 = n7 + 5;
            int n14 = n5 = n7 + 6;
            n5 = n7 + 7;
            long l6 = ((long)segment.data[n8] & 0xFFL) << 56 | ((long)byArray[n9] & 0xFFL) << 48 | ((long)byArray[n10] & 0xFFL) << 40 | ((long)byArray[n11] & 0xFFL) << 32 | ((long)byArray[n12] & 0xFFL) << 24 | ((long)byArray[n13] & 0xFFL) << 16 | ((long)byArray[n14] & 0xFFL) << 8;
            long l7 = l5;
            l5 = l6 | (long)byArray[n5] & 0xFFL;
            this.size = l7 - 8L;
            if ((n7 += 8) == n6) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n7;
            }
            return l5;
        }
        throw new IllegalStateException("size < 8: " + this.size);
    }

    @Override
    public short readShortLe() {
        return Util.reverseBytesShort(this.readShort());
    }

    @Override
    public int readIntLe() {
        return Util.reverseBytesInt(this.readInt());
    }

    @Override
    public long readLongLe() {
        return Util.reverseBytesLong(this.readLong());
    }

    @Override
    public long readDecimalLong() {
        block9: {
            if (buffer2.size == 0L) break block9;
            long l5 = 0L;
            int n5 = 0;
            boolean bl = false;
            boolean bl2 = false;
            long l6 = -922337203685477580L;
            long l7 = -7L;
            do {
                Segment segment = buffer2.head;
                byte[] byArray = segment.data;
                int n6 = segment.pos;
                int n7 = segment.limit;
                while (n6 < n7) {
                    byte by;
                    block13: {
                        block12: {
                            block10: {
                                Buffer buffer;
                                block11: {
                                    by = byArray[n6];
                                    if (by < 48 || by > 57) break block10;
                                    int n8 = 48 - by;
                                    if (l5 < l6 || l5 == l6 && (long)n8 < l7) break block11;
                                    l5 = l5 * 10L + (long)n8;
                                    break block12;
                                }
                                Buffer buffer2 = buffer;
                                buffer2();
                                buffer2 = buffer.writeDecimalLong(l5).writeByte(by);
                                if (!bl) {
                                    buffer2.readByte();
                                }
                                throw new NumberFormatException("Number too large: " + buffer2.readUtf8());
                            }
                            if (by != 45 || n5 != 0) break block13;
                            bl = true;
                            --l7;
                        }
                        ++n6;
                        ++n5;
                        continue;
                    }
                    if (n5 != 0) {
                        bl2 = true;
                        break;
                    }
                    throw new NumberFormatException("Expected leading [0-9] or '-' character but was 0x" + Integer.toHexString(by));
                }
                if (n6 == n7) {
                    buffer2.head = segment.pop();
                    SegmentPool.recycle(segment);
                    continue;
                }
                segment.pos = n6;
            } while (!bl2 && buffer2.head != null);
            buffer2.size -= (long)n5;
            if (!bl) {
                l5 = -l5;
            }
            return l5;
        }
        throw new IllegalStateException("size == 0");
    }

    @Override
    public long readHexadecimalUnsignedLong() {
        block8: {
            if (buffer2.size == 0L) break block8;
            long l5 = 0L;
            int n5 = 0;
            boolean bl = false;
            do {
                Segment segment = buffer2.head;
                byte[] byArray = segment.data;
                int n6 = segment.pos;
                int n7 = segment.limit;
                while (n6 < n7) {
                    byte by;
                    block12: {
                        Buffer buffer;
                        int n8;
                        block10: {
                            block11: {
                                block9: {
                                    by = byArray[n6];
                                    if (by < 48 || by > 57) break block9;
                                    n8 = by - 48;
                                    break block10;
                                }
                                if (by < 97 || by > 102) break block11;
                                n8 = by - 87;
                                break block10;
                            }
                            if (by < 65 || by > 70) break block12;
                            n8 = by - 55;
                        }
                        if ((l5 & 0xF000000000000000L) == 0L) {
                            l5 = l5 << 4 | (long)n8;
                            ++n6;
                            ++n5;
                            continue;
                        }
                        Buffer buffer2 = buffer;
                        buffer2();
                        buffer2 = buffer.writeHexadecimalUnsignedLong(l5).writeByte(by);
                        throw new NumberFormatException("Number too large: " + buffer2.readUtf8());
                    }
                    if (n5 != 0) {
                        bl = true;
                        break;
                    }
                    throw new NumberFormatException("Expected leading [0-9a-fA-F] character but was 0x" + Integer.toHexString(by));
                }
                if (n6 == n7) {
                    buffer2.head = segment.pop();
                    SegmentPool.recycle(segment);
                    continue;
                }
                segment.pos = n6;
            } while (!bl && buffer2.head != null);
            buffer2.size -= (long)n5;
            return l5;
        }
        throw new IllegalStateException("size == 0");
    }

    @Override
    public ByteString readByteString() {
        return new ByteString(this.readByteArray());
    }

    @Override
    public ByteString readByteString(long l5) throws EOFException {
        return new ByteString(this.readByteArray(l5));
    }

    @Override
    public int select(Options options) {
        int n5 = this.selectPrefix(options, false);
        if (n5 == -1) {
            return -1;
        }
        try {
            this.skip(options.byteStrings[n5].size());
            return n5;
        }
        catch (EOFException eOFException) {
            throw new AssertionError();
        }
    }

    /*
     * Unable to fully structure code
     */
    int selectPrefix(Options var1_1, boolean var2_3) {
        this = this.head;
        if (this == null) {
            if (var2_3) {
                return -2;
            }
            return var1_1.indexOf(ByteString.EMPTY);
        }
        v0 = var1_1;
        v1 = this;
        var1_1 = v1.data;
        var3_4 = v1.pos;
        var4_6 = v1.limit;
        var5_8 = v0.trie;
        var6_9 = 0;
        var7_10 = -1;
        var8_11 = this;
        block0: while (true) {
            block19: {
                var9_13 = var6_9 + 1;
                var10_14 = var5_8[var6_9];
                var6_9 += 2;
                if ((var9_13 = var5_8[var9_13]) != -1) {
                    var7_10 = var9_13;
                }
                if (var8_11 == null) ** GOTO lbl35
                if (var10_14 >= 0) break block19;
                var9_13 = var6_9 + var10_14 * -1;
                do {
                    block20: {
                        block21: {
                            if ((var1_1[var3_4++] & 255) != var5_8[var6_9++]) {
                                return var7_10;
                            }
                            var10_14 = var6_9 == var9_13 ? 1 : 0;
                            if (var3_4 != var4_6) continue;
                            var1_1 = var8_11.next;
                            var3_4 = var1_1.pos;
                            var4_7 = var1_1.data;
                            var8_12 = var1_1.limit;
                            if (var1_1 != this) break block20;
                            if (var10_14 != 0) break block21;
lbl35:
                            // 2 sources

                            if (var2_3) {
                                return -2;
                            }
                            return var7_10;
                        }
                        v2 = var1_1 = null;
                        var4_6 = var8_12;
                        var1_1 = var4_7;
                        var8_11 = v2;
                        continue;
                    }
                    v3 = var1_1;
                    var4_6 = var8_12;
                    var1_1 = var4_7;
                    var8_11 = v3;
                } while (var10_14 == 0);
                var6_9 = var5_8[var6_9];
                ** GOTO lbl72
            }
            var9_13 = var1_1[var3_4++] & 255;
            var11_15 = var6_9 + var10_14;
            while (true) {
                block22: {
                    if (var6_9 == var11_15) {
                        return var7_10;
                    }
                    if (var9_13 != var5_8[var6_9]) break block22;
                    var6_9 = var5_8[var6_9 + var10_14];
                    if (var3_4 == var4_6) {
                        var8_11 = var8_11.next;
                        var1_2 = var8_11.pos;
                        var3_5 = var8_11.data;
                        var4_6 = var8_11.limit;
                        if (var8_11 == this) {
                            var8_11 = null;
                            var3_4 = var1_2;
                            var1_1 = var3_5;
                        } else {
                            var3_4 = var1_2;
                            var1_1 = var3_5;
                        }
                    }
lbl72:
                    // 5 sources

                    if (var6_9 >= 0) {
                        return var6_9;
                    }
                    var6_9 = -var6_9;
                    continue block0;
                }
                ++var6_9;
            }
            break;
        }
    }

    @Override
    public void readFully(Buffer buffer, long l5) throws EOFException {
        long l6 = this.size;
        if (l6 >= l5) {
            buffer.write(this, l5);
            return;
        }
        buffer.write(this, l6);
        throw new EOFException();
    }

    @Override
    public long readAll(Sink sink) throws IOException {
        long l5 = this.size;
        if (l5 > 0L) {
            sink.write(this, l5);
        }
        return l5;
    }

    @Override
    public String readUtf8() {
        try {
            Buffer buffer = this;
            return buffer.readString(buffer.size, Util.UTF_8);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public String readUtf8(long l5) throws EOFException {
        return this.readString(l5, Util.UTF_8);
    }

    @Override
    public String readString(Charset charset) {
        try {
            Buffer buffer = this;
            return buffer.readString(buffer.size, charset);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public String readString(long l5, Charset charset) throws EOFException {
        Util.checkOffsetAndCount(this.size, 0L, l5);
        if (charset != null) {
            if (l5 <= Integer.MAX_VALUE) {
                int n5;
                String string2;
                if (l5 == 0L) {
                    return "";
                }
                Segment segment = this.head;
                int n6 = segment.pos;
                if ((long)n6 + l5 > (long)segment.limit) {
                    return new String(this.readByteArray(l5), charset);
                }
                String string3 = string2;
                byte[] byArray = segment.data;
                int n7 = (int)l5;
                string2 = new String(byArray, n6, n7, charset);
                segment.pos = n5 = (int)((long)segment.pos + l5);
                this.size -= l5;
                if (n5 == segment.limit) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                }
                return string3;
            }
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l5);
        }
        throw new IllegalArgumentException("charset == null");
    }

    @Override
    @Nullable
    public String readUtf8Line() throws EOFException {
        long l5 = this.indexOf((byte)10);
        if (l5 == -1L) {
            l5 = this.size;
            return l5 != 0L ? this.readUtf8(l5) : null;
        }
        return this.readUtf8Line(l5);
    }

    @Override
    public String readUtf8LineStrict() throws EOFException {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long l5) throws EOFException {
        if (l5 >= 0L) {
            Buffer buffer;
            long l6 = l5 == Long.MAX_VALUE ? Long.MAX_VALUE : l5 + 1L;
            long l7 = this.indexOf((byte)10, 0L, l6);
            if (l7 != -1L) {
                return this.readUtf8Line(l7);
            }
            if (l6 < this.size() && this.getByte(l6 - 1L) == 13 && this.getByte(l6) == 10) {
                return this.readUtf8Line(l6);
            }
            Buffer buffer2 = this;
            Buffer buffer3 = buffer;
            buffer = new Buffer();
            long l8 = buffer2.size();
            l8 = Math.min(32L, l8);
            buffer2.copyTo(buffer3, 0L, l8);
            throw new EOFException("\\n not found: limit=" + Math.min(this.size(), l5) + " content=" + buffer3.readByteString().hex() + '\u2026');
        }
        throw new IllegalArgumentException("limit < 0: " + l5);
    }

    String readUtf8Line(long l5) throws EOFException {
        long l6;
        if (l5 > 0L && this.getByte(l6 = l5 - 1L) == 13) {
            String string2 = this.readUtf8(l6);
            this.skip(2L);
            return string2;
        }
        String string3 = this.readUtf8(l5);
        this.skip(1L);
        return string3;
    }

    @Override
    public int readUtf8CodePoint() throws EOFException {
        block9: {
            block14: {
                int n5;
                int n6;
                int n7;
                int n8;
                block11: {
                    block13: {
                        block12: {
                            block10: {
                                if (this.size == 0L) break block9;
                                n8 = this.getByte(0L);
                                if ((n8 & 0x80) != 0) break block10;
                                n7 = n8 & 0x7F;
                                n6 = 1;
                                n5 = 0;
                                break block11;
                            }
                            if ((n8 & 0xE0) != 192) break block12;
                            n7 = n8 & 0x1F;
                            n6 = 2;
                            n5 = 128;
                            break block11;
                        }
                        if ((n8 & 0xF0) != 224) break block13;
                        n7 = n8 & 0xF;
                        n6 = 3;
                        n5 = 2048;
                        break block11;
                    }
                    if ((n8 & 0xF8) != 240) break block14;
                    n7 = n8 & 7;
                    n6 = 4;
                    n5 = 65536;
                }
                long l5 = n6;
                if (this.size >= l5) {
                    for (n8 = 1; n8 < n6; ++n8) {
                        long l6 = n8;
                        byte by = this.getByte(l6);
                        if ((by & 0xC0) == 128) {
                            n7 = n7 << 6 | by & 0x3F;
                            continue;
                        }
                        this.skip(l6);
                        return 65533;
                    }
                    this.skip(l5);
                    if (n7 > 0x10FFFF) {
                        return 65533;
                    }
                    if (n7 >= 55296 && n7 <= 57343) {
                        return 65533;
                    }
                    if (n7 < n5) {
                        return 65533;
                    }
                    return n7;
                }
                throw new EOFException("size < " + n6 + ": " + this.size + " (to read code point prefixed 0x" + Integer.toHexString(n8) + ")");
            }
            this.skip(1L);
            return 65533;
        }
        throw new EOFException();
    }

    @Override
    public byte[] readByteArray() {
        try {
            Buffer buffer = this;
            return buffer.readByteArray(buffer.size);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public byte[] readByteArray(long l5) throws EOFException {
        Util.checkOffsetAndCount(this.size, 0L, l5);
        if (l5 <= Integer.MAX_VALUE) {
            byte[] byArray = new byte[(int)l5];
            this.readFully(byArray);
            return byArray;
        }
        throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l5);
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray) throws EOFException {
        int n5;
        for (int i5 = 0; i5 < byArray.length; i5 += n5) {
            n5 = this.read(byArray, i5, byArray.length - i5);
            if (n5 != -1) {
                continue;
            }
            throw new EOFException();
        }
    }

    @Override
    public int read(byte[] byArray, int n5, int n6) {
        int n7;
        long l5 = n5;
        long l6 = n6;
        Util.checkOffsetAndCount(byArray.length, l5, l6);
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        Segment segment2 = segment;
        n6 = Math.min(n6, segment.limit - segment.pos);
        System.arraycopy(segment2.data, segment.pos, byArray, n5, n6);
        segment.pos = n7 = segment2.pos + n6;
        this.size -= (long)n6;
        if (n7 == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n6;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n5;
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        Segment segment2 = segment;
        int n6 = Math.min(byteBuffer.remaining(), segment.limit - segment.pos);
        byte[] byArray = segment2.data;
        byteBuffer.put(byArray, segment2.pos, n6);
        segment.pos = n5 = segment.pos + n6;
        this.size -= (long)n6;
        if (n5 == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n6;
    }

    public final void clear() {
        try {
            Buffer buffer = this;
            buffer.skip(buffer.size);
            return;
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public void skip(long l5) throws EOFException {
        while (l5 > 0L) {
            Segment segment = this.head;
            if (segment != null) {
                int n5 = (int)Math.min(l5, (long)(segment.limit - segment.pos));
                long l6 = n5;
                this.size -= l6;
                l6 = l5 - l6;
                Segment segment2 = this.head;
                segment2.pos = n5 = segment2.pos + n5;
                if (n5 == segment2.limit) {
                    this.head = segment2.pop();
                    SegmentPool.recycle(segment2);
                }
                l5 = l6;
                continue;
            }
            throw new EOFException();
        }
    }

    @Override
    public Buffer write(ByteString byteString) {
        if (byteString != null) {
            byteString.write(this);
            return this;
        }
        throw new IllegalArgumentException("byteString == null");
    }

    @Override
    public Buffer writeUtf8(String string2) {
        String string3 = string2;
        return this.writeUtf8(string3, 0, string3.length());
    }

    @Override
    public Buffer writeUtf8(String string2, int n5, int n6) {
        if (string2 != null) {
            if (n5 >= 0) {
                if (n6 >= n5) {
                    if (n6 <= string2.length()) {
                        while (n5 < n6) {
                            int n7 = string2.charAt(n5);
                            if (n7 < 128) {
                                Segment segment = this.writableSegment(1);
                                byte[] byArray = segment.data;
                                int n8 = n7;
                                n7 = segment.limit - n5;
                                int n9 = Math.min(n6, 8192 - n7);
                                int n10 = n7 + n5++;
                                segment.data[n10] = (byte)n8;
                                while (n5 < n9) {
                                    char c6 = string2.charAt(n5);
                                    n10 = c6;
                                    if (c6 >= '\u0080') break;
                                    int n11 = n10;
                                    n10 = n5 + 1;
                                    n5 = n7 + n5;
                                    byArray[n5] = (byte)n11;
                                    n5 = n10;
                                }
                                n7 = n5 + n7;
                                int n12 = segment.limit;
                                segment.limit = n12 + (n7 -= n12);
                                this.size += (long)n7;
                                continue;
                            }
                            if (n7 < 2048) {
                                this.writeByte(n7 >> 6 | 0xC0);
                                this.writeByte(n7 & 0x3F | 0x80);
                                ++n5;
                                continue;
                            }
                            if (n7 >= 55296 && n7 <= 57343) {
                                int n13 = n5 + 1;
                                char c7 = n13 < n6 ? string2.charAt(n13) : (char)'\u0000';
                                if (n7 <= 56319 && c7 >= '\udc00' && c7 <= '\udfff') {
                                    n7 = ((n7 & 0xFFFF27FF) << 10 | c7 & 0xFFFF23FF) + 65536;
                                    this.writeByte(n7 >> 18 | 0xF0);
                                    this.writeByte(n7 >> 12 & 0x3F | 0x80);
                                    this.writeByte(n7 >> 6 & 0x3F | 0x80);
                                    this.writeByte(n7 & 0x3F | 0x80);
                                    n5 += 2;
                                    continue;
                                }
                                this.writeByte(63);
                                n5 = n13;
                                continue;
                            }
                            this.writeByte(n7 >> 12 | 0xE0);
                            this.writeByte(n7 >> 6 & 0x3F | 0x80);
                            this.writeByte(n7 & 0x3F | 0x80);
                            ++n5;
                        }
                        return this;
                    }
                    throw new IllegalArgumentException("endIndex > string.length: " + n6 + " > " + string2.length());
                }
                throw new IllegalArgumentException("endIndex < beginIndex: " + n6 + " < " + n5);
            }
            throw new IllegalArgumentException("beginIndex < 0: " + n5);
        }
        throw new IllegalArgumentException("string == null");
    }

    @Override
    public Buffer writeUtf8CodePoint(int n5) {
        block9: {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            if (n5 >= 128) break block5;
                            this.writeByte(n5);
                            break block6;
                        }
                        if (n5 >= 2048) break block7;
                        this.writeByte(n5 >> 6 | 0xC0);
                        this.writeByte(n5 & 0x3F | 0x80);
                        break block6;
                    }
                    if (n5 >= 65536) break block8;
                    if (n5 >= 55296 && n5 <= 57343) {
                        this.writeByte(63);
                    } else {
                        this.writeByte(n5 >> 12 | 0xE0);
                        this.writeByte(n5 >> 6 & 0x3F | 0x80);
                        this.writeByte(n5 & 0x3F | 0x80);
                    }
                    break block6;
                }
                if (n5 > 0x10FFFF) break block9;
                this.writeByte(n5 >> 18 | 0xF0);
                this.writeByte(n5 >> 12 & 0x3F | 0x80);
                this.writeByte(n5 >> 6 & 0x3F | 0x80);
                this.writeByte(n5 & 0x3F | 0x80);
            }
            return this;
        }
        throw new IllegalArgumentException("Unexpected code point: " + Integer.toHexString(n5));
    }

    @Override
    public Buffer writeString(String string2, Charset charset) {
        String string3 = string2;
        return this.writeString(string3, 0, string3.length(), charset);
    }

    @Override
    public Buffer writeString(String string2, int n5, int n6, Charset charset) {
        if (string2 != null) {
            if (n5 >= 0) {
                if (n6 >= n5) {
                    if (n6 <= string2.length()) {
                        if (charset != null) {
                            if (charset.equals(Util.UTF_8)) {
                                return this.writeUtf8(string2, n5, n6);
                            }
                            byte[] byArray = string2.substring(n5, n6).getBytes(charset);
                            return this.write(byArray, 0, byArray.length);
                        }
                        throw new IllegalArgumentException("charset == null");
                    }
                    throw new IllegalArgumentException("endIndex > string.length: " + n6 + " > " + string2.length());
                }
                throw new IllegalArgumentException("endIndex < beginIndex: " + n6 + " < " + n5);
            }
            throw new IllegalAccessError("beginIndex < 0: " + n5);
        }
        throw new IllegalArgumentException("string == null");
    }

    @Override
    public Buffer write(byte[] byArray) {
        if (byArray != null) {
            return this.write(byArray, 0, byArray.length);
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public Buffer write(byte[] byArray, int n5, int n6) {
        if (byArray != null) {
            long l5 = n5;
            long l6 = n6;
            Util.checkOffsetAndCount(byArray.length, l5, l6);
            n6 = n5 + n6;
            while (n5 < n6) {
                Segment segment = this.writableSegment(1);
                Object object = segment;
                int n7 = n5;
                int n8 = n5;
                Segment segment2 = object;
                n5 = Math.min(n6 - n5, 8192 - ((Segment)object).limit);
                object = segment2.data;
                System.arraycopy(byArray, n8, object, segment2.limit, n5);
                int n9 = n7 + n5;
                segment.limit += n5;
                n5 = n9;
            }
            Buffer buffer = this;
            buffer.size += l6;
            return buffer;
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer != null) {
            int n5;
            int n6 = n5 = byteBuffer.remaining();
            while (n6 > 0) {
                Segment segment = this.writableSegment(1);
                Object object = segment;
                int n7 = n6;
                Segment segment2 = object;
                n6 = Math.min(n6, 8192 - ((Segment)object).limit);
                object = segment2.data;
                byteBuffer.get((byte[])object, segment2.limit, n6);
                int n8 = n7 - n6;
                segment.limit += n6;
                n6 = n8;
            }
            this.size += (long)n5;
            return n5;
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public long writeAll(Source source) throws IOException {
        if (source != null) {
            long l5;
            long l6 = 0L;
            while ((l5 = source.read(this, 8192L)) != -1L) {
                l6 += l5;
            }
            return l6;
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public BufferedSink write(Source source, long l5) throws IOException {
        while (l5 > 0L) {
            long l6 = source.read(this, l5);
            if (l6 != -1L) {
                l5 -= l6;
                continue;
            }
            throw new EOFException();
        }
        return this;
    }

    @Override
    public Buffer writeByte(int n5) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment(1);
        int n6 = segment.limit;
        segment.limit = n6 + 1;
        segment.data[n6] = (byte)n5;
        ++buffer.size;
        return buffer;
    }

    @Override
    public Buffer writeShort(int n5) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment(2);
        int n6 = n5;
        int n7 = segment.limit;
        n5 = n7 + 1;
        segment.data[n7] = (byte)(n6 >>> 8 & 0xFF);
        segment.data[n5] = (byte)(n5 & 0xFF);
        segment.limit = n7 += 2;
        buffer.size += 2L;
        return buffer;
    }

    @Override
    public Buffer writeShortLe(int n5) {
        return this.writeShort(Util.reverseBytesShort((short)n5));
    }

    @Override
    public Buffer writeInt(int n5) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment(4);
        byte[] byArray = segment.data;
        int n6 = n5;
        int n7 = n5;
        int n8 = n5;
        int n9 = n5;
        int n10 = segment.limit;
        n5 = n10 + 1;
        byArray[n10] = (byte)(n9 >>> 24 & 0xFF);
        int n11 = n10 + 2;
        byArray[n5] = (byte)(n8 >>> 16 & 0xFF);
        n5 = n10 + 3;
        byArray[n11] = (byte)(n7 >>> 8 & 0xFF);
        segment.data[n5] = (byte)(n6 & 0xFF);
        segment.limit = n10 += 4;
        buffer.size += 4L;
        return buffer;
    }

    @Override
    public Buffer writeIntLe(int n5) {
        return this.writeInt(Util.reverseBytesInt(n5));
    }

    @Override
    public Buffer writeLong(long l5) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment(8);
        byte[] byArray = segment.data;
        int n5 = segment.limit;
        int n6 = n5 + 1;
        byArray[n5] = (byte)(l5 >>> 56 & 0xFFL);
        int n7 = n5 + 2;
        byArray[n6] = (byte)(l5 >>> 48 & 0xFFL);
        n6 = n5 + 3;
        byArray[n7] = (byte)(l5 >>> 40 & 0xFFL);
        n7 = n5 + 4;
        byArray[n6] = (byte)(l5 >>> 32 & 0xFFL);
        n6 = n5 + 5;
        byArray[n7] = (byte)(l5 >>> 24 & 0xFFL);
        n7 = n5 + 6;
        byArray[n6] = (byte)(l5 >>> 16 & 0xFFL);
        n6 = n5 + 7;
        byArray[n7] = (byte)(l5 >>> 8 & 0xFFL);
        segment.data[n6] = (byte)(l5 & 0xFFL);
        segment.limit = n5 += 8;
        buffer.size += 8L;
        return buffer;
    }

    @Override
    public Buffer writeLongLe(long l5) {
        return this.writeLong(Util.reverseBytesLong(l5));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Buffer writeDecimalLong(long l5) {
        int n5;
        if (l5 == 0L) {
            return this.writeByte(48);
        }
        boolean bl = false;
        if (l5 < 0L) {
            if ((l5 = -l5) < 0L) {
                return this.writeUtf8("-9223372036854775808");
            }
            bl = true;
        }
        int n6 = l5 < 100000000L ? (l5 < 10000L ? (l5 < 100L ? (l5 < 10L ? 1 : 2) : (l5 < 1000L ? 3 : 4)) : (l5 < 1000000L ? (l5 < 100000L ? 5 : 6) : (l5 < 10000000L ? 7 : 8))) : (l5 < 1000000000000L ? (l5 < 10000000000L ? (l5 < 1000000000L ? 9 : 10) : (l5 < 100000000000L ? 11 : 12)) : (l5 < 1000000000000000L ? (l5 < 10000000000000L ? 13 : (l5 < 100000000000000L ? 14 : 15)) : (l5 < 100000000000000000L ? (l5 < 10000000000000000L ? 16 : 17) : (n5 = l5 < 1000000000000000000L ? 18 : 19))));
        if (bl) {
            ++n5;
        }
        Segment segment = this.writableSegment(n5);
        byte[] byArray = segment.data;
        int n7 = segment.limit + n5;
        while (l5 != 0L) {
            int n8 = (int)(l5 % 10L);
            byArray[n7 += -1] = DIGITS[n8];
            l5 /= 10L;
        }
        if (bl) {
            byArray[n7 + -1] = 45;
        }
        Buffer buffer = this;
        segment.limit += n5;
        buffer.size += (long)n5;
        return buffer;
    }

    @Override
    public Buffer writeHexadecimalUnsignedLong(long l5) {
        if (l5 == 0L) {
            return this.writeByte(48);
        }
        int n5 = Long.numberOfTrailingZeros(Long.highestOneBit(l5)) / 4 + 1;
        Segment segment = this.writableSegment(n5);
        byte[] byArray = segment.data;
        int n6 = segment.limit;
        for (int i5 = n6 + n5 - 1; i5 >= n6; --i5) {
            byArray[i5] = DIGITS[(int)(l5 & 0xFL)];
            l5 >>>= 4;
        }
        Buffer buffer = this;
        segment.limit += n5;
        buffer.size += (long)n5;
        return buffer;
    }

    Segment writableSegment(int n5) {
        if (n5 >= 1 && n5 <= 8192) {
            Segment segment = ((Buffer)object).head;
            if (segment == null) {
                Segment segment2;
                ((Buffer)object).head = segment2 = SegmentPool.take();
                segment2.prev = segment2;
                segment2.next = segment2;
                return segment2;
            }
            Object object = segment.prev;
            if (((Segment)object).limit + n5 > 8192 || !((Segment)object).owner) {
                object = ((Segment)object).push(SegmentPool.take());
            }
            return object;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void write(Buffer buffer, long l5) {
        if (buffer != null) {
            if (buffer != this) {
                Util.checkOffsetAndCount(buffer.size, 0L, l5);
                while (l5 > 0L) {
                    Segment segment = buffer.head;
                    if (l5 < (long)(segment.limit - segment.pos)) {
                        long l6;
                        long l7;
                        Segment segment2 = this.head;
                        segment2 = segment2 != null ? segment2.prev : null;
                        if (segment2 != null && segment2.owner && (l7 = l5 + (long)segment2.limit) - (l6 = (long)(segment2.shared ? 0 : segment2.pos)) <= 8192L) {
                            segment.writeTo(segment2, (int)l5);
                            buffer.size -= l5;
                            this.size += l5;
                            return;
                        }
                        buffer.head = segment.split((int)l5);
                    }
                    segment = buffer.head;
                    long l8 = segment.limit - segment.pos;
                    buffer.head = segment.pop();
                    Segment segment3 = this.head;
                    if (segment3 == null) {
                        Segment segment4 = this.head = segment;
                        segment4.prev = segment;
                        segment4.next = segment;
                    } else {
                        segment3.prev.push(segment).compact();
                    }
                    buffer.size -= l8;
                    this.size += l8;
                    l5 -= l8;
                }
                return;
            }
            throw new IllegalArgumentException("source == this");
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public long read(Buffer buffer, long l5) {
        if (buffer != null) {
            if (l5 >= 0L) {
                long l6 = this.size;
                if (l6 == 0L) {
                    return -1L;
                }
                if (l5 > l6) {
                    l5 = l6;
                }
                buffer.write(this, l5);
                return l5;
            }
            throw new IllegalArgumentException("byteCount < 0: " + l5);
        }
        throw new IllegalArgumentException("sink == null");
    }

    @Override
    public long indexOf(byte by) {
        return this.indexOf(by, 0L, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l5) {
        return this.indexOf(by, l5, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l5, long l6) {
        Object object;
        if (l5 >= 0L && l6 >= l5) {
            long l7 = ((Buffer)object).size;
            if (l6 > l7) {
                l6 = l7;
            }
            if (l5 == l6) {
                return -1L;
            }
            object = ((Buffer)object).head;
            if (object == null) {
                return -1L;
            }
            if (l7 - l5 < l5) {
                while (l7 > l5) {
                    object = ((Segment)object).prev;
                    l7 -= (long)(((Segment)object).limit - ((Segment)object).pos);
                }
            } else {
                long l8;
                l7 = 0L;
                while ((l8 = l7 + (long)(((Segment)object).limit - ((Segment)object).pos)) < l5) {
                    object = ((Segment)object).next;
                    l7 = l8;
                }
            }
            while (l7 < l6) {
                Object object2 = object;
                byte[] byArray = ((Segment)object2).data;
                int n5 = (int)Math.min((long)((Segment)object2).limit, (long)((Segment)object).pos + l6 - l7);
                for (int i5 = (int)((long)((Segment)(v245476)).pos + l5 - l7); i5 < n5; ++i5) {
                    if (byArray[i5] != by) continue;
                    return (long)(i5 - ((Segment)object).pos) + l7;
                }
                object = ((Segment)object).next;
                l5 = l7 += (long)(((Segment)object).limit - ((Segment)object).pos);
            }
            return -1L;
        }
        object = ((Buffer)object).size;
        Long l9 = l5;
        Long l10 = l6;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object;
        objectArray[1] = l9;
        objectArray[2] = l10;
        throw new IllegalArgumentException(String.format("size=%s fromIndex=%s toIndex=%s", objectArray2));
    }

    @Override
    public long indexOf(ByteString byteString) throws IOException {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public long indexOf(ByteString byteString, long l5) throws IOException {
        if (byteString.size() != 0) {
            if (l5 >= 0L) {
                Segment segment = this.head;
                if (segment == null) {
                    return -1L;
                }
                long l6 = this.size;
                if (l6 - l5 < l5) {
                    while (l6 > l5) {
                        segment = segment.prev;
                        l6 -= (long)(segment.limit - segment.pos);
                    }
                } else {
                    long l7;
                    l6 = 0L;
                    while ((l7 = l6 + (long)(segment.limit - segment.pos)) < l5) {
                        segment = segment.next;
                        l6 = l7;
                    }
                }
                ByteString byteString2 = byteString;
                byte by = byteString2.getByte(0);
                int n5 = byteString2.size();
                long l8 = this.size - (long)n5 + 1L;
                while (l6 < l8) {
                    Segment segment2 = segment;
                    byte[] byArray = segment2.data;
                    int n6 = (int)Math.min((long)segment2.limit, (long)segment.pos + l8 - l6);
                    for (int i5 = (int)((long)(v245628).pos + l5 - l6); i5 < n6; ++i5) {
                        if (byArray[i5] != by || !this.rangeEquals(segment, i5 + 1, byteString, 1, n5)) continue;
                        return (long)(i5 - segment.pos) + l6;
                    }
                    segment = segment.next;
                    l5 = l6 += (long)(segment.limit - segment.pos);
                }
                return -1L;
            }
            throw new IllegalArgumentException("fromIndex < 0");
        }
        throw new IllegalArgumentException("bytes is empty");
    }

    @Override
    public long indexOfElement(ByteString byteString) {
        return this.indexOfElement(byteString, 0L);
    }

    @Override
    public long indexOfElement(ByteString object, long l5) {
        if (l5 >= 0L) {
            Segment segment = this.head;
            if (segment == null) {
                return -1L;
            }
            long l6 = this.size;
            if (l6 - l5 < l5) {
                while (l6 > l5) {
                    segment = segment.prev;
                    l6 -= (long)(segment.limit - segment.pos);
                }
            } else {
                long l7;
                l6 = 0L;
                while ((l7 = l6 + (long)(segment.limit - segment.pos)) < l5) {
                    segment = segment.next;
                    l6 = l7;
                }
            }
            if (((ByteString)object).size() == 2) {
                ByteString byteString = object;
                byte by = byteString.getByte(0);
                byte by2 = byteString.getByte(1);
                while (l6 < this.size) {
                    Segment segment2 = segment;
                    byte[] byArray = segment2.data;
                    int n5 = segment2.limit;
                    for (int i5 = (int)((long)(v245765).pos + l5 - l6); i5 < n5; ++i5) {
                        byte by3 = byArray[i5];
                        if (by3 != by && by3 != by2) {
                            continue;
                        }
                        return (long)(i5 - segment.pos) + l6;
                    }
                    segment = segment.next;
                    l5 = l6 += (long)(segment.limit - segment.pos);
                }
            } else {
                object = ((ByteString)object).internalArray();
                while (l6 < this.size) {
                    Segment segment3 = segment;
                    byte[] byArray = segment3.data;
                    int n6 = segment3.limit;
                    for (int i6 = (int)((long)(v245817).pos + l5 - l6); i6 < n6; ++i6) {
                        byte by = byArray[i6];
                        int n7 = ((Object)object).length;
                        for (int i7 = 0; i7 < n7; ++i7) {
                            if (by != object[i7]) continue;
                            return (long)(i6 - segment.pos) + l6;
                        }
                    }
                    segment = segment.next;
                    l5 = l6 += (long)(segment.limit - segment.pos);
                }
            }
            return -1L;
        }
        throw new IllegalArgumentException("fromIndex < 0");
    }

    @Override
    public boolean rangeEquals(long l5, ByteString byteString) {
        int n5 = byteString.size();
        return this.rangeEquals(l5, byteString, 0, n5);
    }

    @Override
    public boolean rangeEquals(long l5, ByteString byteString, int n5, int n6) {
        if (l5 >= 0L && n5 >= 0 && n6 >= 0 && this.size - l5 >= (long)n6 && byteString.size() - n5 >= n6) {
            for (int i5 = 0; i5 < n6; ++i5) {
                if (this.getByte(l5 + (long)i5) == byteString.getByte(n5 + i5)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public Timeout timeout() {
        return Timeout.NONE;
    }

    List<Integer> segmentSizes() {
        ArrayList<Integer> arrayList;
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList2();
        Segment segment = this.head;
        arrayList.add(segment.limit - segment.pos);
        segment = this.head.next;
        while (segment != this.head) {
            arrayList2.add(segment.limit - segment.pos);
            segment = segment.next;
        }
        return arrayList2;
    }

    public final ByteString md5() {
        return this.digest("MD5");
    }

    public final ByteString sha1() {
        return this.digest("SHA-1");
    }

    public final ByteString sha256() {
        return this.digest("SHA-256");
    }

    public final ByteString sha512() {
        return this.digest("SHA-512");
    }

    public boolean equals(Object object) {
        long l5;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Buffer)) {
            return false;
        }
        object = (Buffer)object;
        long l6 = this.size;
        if (l6 != ((Buffer)object).size) {
            return false;
        }
        if (l6 == 0L) {
            return true;
        }
        Object object2 = object;
        object = this.head;
        Segment segment = ((Buffer)object2).head;
        int n5 = ((Segment)object).pos;
        int n6 = segment.pos;
        for (long i5 = 0L; i5 < this.size; i5 += l5) {
            l5 = Math.min(((Segment)object).limit - n5, segment.limit - n6);
            int n7 = 0;
            while ((long)n7 < l5) {
                if (((Segment)object).data[n5++] != segment.data[n6++]) {
                    return false;
                }
                ++n7;
            }
            if (n5 == ((Segment)object).limit) {
                object = ((Segment)object).next;
                n5 = ((Segment)object).pos;
            }
            if (n6 != segment.limit) continue;
            segment = segment.next;
            n6 = segment.pos;
        }
        return true;
    }

    public int hashCode() {
        Segment segment = this.head;
        if (segment == null) {
            return 0;
        }
        int n5 = 1;
        do {
            int n6 = segment.limit;
            for (int i5 = (v246082).pos; i5 < n6; ++i5) {
                n5 = n5 * 31 + segment.data[i5];
            }
        } while ((segment = segment.next) != this.head);
        return n5;
    }

    public String toString() {
        return this.snapshot().toString();
    }

    public Buffer clone() {
        Buffer buffer;
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        if (this.size == 0L) {
            return buffer2;
        }
        Buffer buffer3 = this;
        buffer2.head.prev = buffer2.head = buffer3.head.sharedCopy();
        buffer2.head.next = buffer2.head;
        Segment segment = buffer3.head.next;
        while (segment != this.head) {
            buffer2.head.prev.push(segment.sharedCopy());
            segment = segment.next;
        }
        buffer2.size = this.size;
        return buffer2;
    }

    public final ByteString snapshot() {
        long l5 = this.size;
        if (l5 <= Integer.MAX_VALUE) {
            return this.snapshot((int)l5);
        }
        throw new IllegalArgumentException("size > Integer.MAX_VALUE: " + this.size);
    }

    public final ByteString snapshot(int n5) {
        if (n5 == 0) {
            return ByteString.EMPTY;
        }
        return new SegmentedByteString(this, n5);
    }

    public final UnsafeCursor readUnsafe() {
        return this.readUnsafe(new UnsafeCursor());
    }

    public final UnsafeCursor readUnsafe(UnsafeCursor unsafeCursor) {
        if (unsafeCursor.buffer == null) {
            unsafeCursor.buffer = this;
            unsafeCursor.readWrite = false;
            return unsafeCursor;
        }
        throw new IllegalStateException("already attached to a buffer");
    }

    public final UnsafeCursor readAndWriteUnsafe() {
        return this.readAndWriteUnsafe(new UnsafeCursor());
    }

    public final UnsafeCursor readAndWriteUnsafe(UnsafeCursor unsafeCursor) {
        if (unsafeCursor.buffer == null) {
            unsafeCursor.buffer = this;
            unsafeCursor.readWrite = true;
            return unsafeCursor;
        }
        throw new IllegalStateException("already attached to a buffer");
    }

    public static final class UnsafeCursor
    implements Closeable {
        public Buffer buffer;
        public boolean readWrite;
        private Segment segment;
        public long offset = -1L;
        public byte[] data;
        public int start = -1;
        public int end = -1;

        public final int next() {
            long l5 = this.offset;
            if (l5 != this.buffer.size) {
                if (l5 == -1L) {
                    return this.seek(0L);
                }
                return this.seek(l5 + (long)(this.end - this.start));
            }
            throw new IllegalStateException();
        }

        public final int seek(long l5) {
            if (l5 >= -1L) {
                Object object = ((UnsafeCursor)((Object)l12)).buffer;
                long l6 = ((Buffer)object).size;
                if (l5 <= l6) {
                    if (l5 != -1L && l5 != l6) {
                        int n5;
                        int n6;
                        long l7;
                        long l8;
                        Object object2;
                        long l9 = 0L;
                        object = ((Buffer)object).head;
                        Segment segment = ((UnsafeCursor)((Object)l12)).segment;
                        if (segment != null) {
                            long l10 = ((UnsafeCursor)((Object)l12)).offset - (long)(((UnsafeCursor)((Object)l12)).start - segment.pos);
                            if (l10 > l5) {
                                object2 = object;
                                object = segment;
                                l8 = l9;
                                l7 = l10;
                            } else {
                                object2 = segment;
                                l8 = l10;
                                l7 = l6;
                            }
                        } else {
                            object2 = object;
                            l8 = l9;
                            l7 = l6;
                        }
                        if (l7 - l5 > l5 - l8) {
                            int n7;
                            int n8;
                            while (l5 >= l8 + (long)((n8 = ((Segment)object2).limit) - (n7 = ((Segment)object2).pos))) {
                                l8 += (long)(n8 - n7);
                                object2 = ((Segment)object2).next;
                            }
                        } else {
                            object2 = object;
                            l8 = l7;
                            while (l8 > l5) {
                                object = ((Segment)object2).prev;
                                l7 = l8 - (long)(((Segment)object).limit - ((Segment)object).pos);
                                object2 = object;
                                l8 = l7;
                            }
                        }
                        if (((UnsafeCursor)((Object)l12)).readWrite && ((Segment)object2).shared) {
                            Segment segment2 = ((Segment)object2).unsharedCopy();
                            Buffer buffer = ((UnsafeCursor)((Object)l12)).buffer;
                            if (buffer.head == object2) {
                                buffer.head = segment2;
                            }
                            object2 = ((Segment)object2).push(segment2);
                            ((Segment)object2).prev.pop();
                        }
                        ((UnsafeCursor)((Object)l12)).segment = object2;
                        ((UnsafeCursor)((Object)l12)).offset = l5;
                        ((UnsafeCursor)((Object)l12)).data = ((Segment)object2).data;
                        ((UnsafeCursor)((Object)l12)).start = n6 = ((Segment)object2).pos + (int)(l5 - l8);
                        ((UnsafeCursor)((Object)l12)).end = n5 = ((Segment)object2).limit;
                        return n5 - n6;
                    }
                    Long l11 = l12;
                    ((UnsafeCursor)((Object)l11)).segment = null;
                    ((UnsafeCursor)((Object)l11)).offset = l5;
                    ((UnsafeCursor)((Object)l11)).data = null;
                    ((UnsafeCursor)((Object)l11)).start = -1;
                    ((UnsafeCursor)((Object)l11)).end = -1;
                    return -1;
                }
            }
            UnsafeCursor unsafeCursor = l12;
            Long l12 = l5;
            Long l13 = unsafeCursor.buffer.size;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = l12;
            objectArray[1] = l13;
            throw new ArrayIndexOutOfBoundsException(String.format("offset=%s > size=%s", objectArray2));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final long resizeBuffer(long l5) {
            Buffer buffer = this.buffer;
            if (buffer == null) throw new IllegalStateException("not attached to a buffer");
            if (!this.readWrite) throw new IllegalStateException("resizeBuffer() only permitted for read/write buffers");
            long l6 = buffer.size;
            if (l5 <= l6) {
                long l7;
                if (l5 < 0L) throw new IllegalArgumentException("newSize < 0: " + l5);
                for (long i5 = l6 - l5; i5 > 0L; i5 -= l7) {
                    Buffer buffer2 = this.buffer;
                    Segment segment = buffer2.head.prev;
                    int n5 = segment.limit;
                    l7 = n5 - segment.pos;
                    if (l7 <= i5) {
                        buffer2.head = segment.pop();
                        SegmentPool.recycle(segment);
                        continue;
                    }
                    segment.limit = (int)((long)n5 - i5);
                    break;
                }
                UnsafeCursor unsafeCursor = this;
                unsafeCursor.segment = null;
                unsafeCursor.offset = l5;
                unsafeCursor.data = null;
                unsafeCursor.start = -1;
                unsafeCursor.end = -1;
            } else if (l5 > l6) {
                boolean bl = true;
                long l8 = l5 - l6;
                while (l8 > 0L) {
                    int n6;
                    Segment segment = this.buffer.writableSegment(1);
                    int n7 = (int)Math.min(l8, (long)(8192 - segment.limit));
                    segment.limit = n6 = segment.limit + n7;
                    long l9 = l8 - (long)n7;
                    if (bl) {
                        this.segment = segment;
                        this.offset = l6;
                        this.data = segment.data;
                        this.start = n6 - n7;
                        this.end = n6;
                        bl = false;
                    }
                    l8 = l9;
                }
            }
            this.buffer.size = l5;
            return l6;
        }

        public final long expandBuffer(int n5) {
            if (n5 > 0) {
                if (n5 <= 8192) {
                    Buffer buffer = this.buffer;
                    if (buffer != null) {
                        if (this.readWrite) {
                            long l5 = buffer.size;
                            Segment segment = buffer.writableSegment(n5);
                            int n6 = 8192 - segment.limit;
                            segment.limit = 8192;
                            Buffer buffer2 = this.buffer;
                            long l6 = n6;
                            UnsafeCursor unsafeCursor = this;
                            buffer2.size = l5 + l6;
                            this.segment = segment;
                            this.offset = l5;
                            unsafeCursor.data = segment.data;
                            unsafeCursor.start = 8192 - n6;
                            unsafeCursor.end = 8192;
                            return l6;
                        }
                        throw new IllegalStateException("expandBuffer() only permitted for read/write buffers");
                    }
                    throw new IllegalStateException("not attached to a buffer");
                }
                throw new IllegalArgumentException("minByteCount > Segment.SIZE: " + n5);
            }
            throw new IllegalArgumentException("minByteCount <= 0: " + n5);
        }

        @Override
        public void close() {
            if (this.buffer != null) {
                UnsafeCursor unsafeCursor = this;
                unsafeCursor.buffer = null;
                unsafeCursor.segment = null;
                unsafeCursor.offset = -1L;
                unsafeCursor.data = null;
                unsafeCursor.start = -1;
                unsafeCursor.end = -1;
                return;
            }
            throw new IllegalStateException("not attached to a buffer");
        }
    }
}

