/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Segment;
import dc.squareup.okio.SegmentPool;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import java.io.IOException;
import java.util.zip.Deflater;

public final class DeflaterSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private boolean closed;

    public DeflaterSink(Sink sink, Deflater deflater) {
        this(Okio.buffer(sink), deflater);
    }

    DeflaterSink(BufferedSink bufferedSink, Deflater deflater) {
        if (bufferedSink != null) {
            if (deflater != null) {
                DeflaterSink deflaterSink = this;
                deflaterSink.sink = bufferedSink;
                deflaterSink.deflater = deflater;
                return;
            }
            throw new IllegalArgumentException("inflater == null");
        }
        throw new IllegalArgumentException("source == null");
    }

    private void deflate(boolean bl) throws IOException {
        Segment segment;
        Buffer buffer = this.sink.buffer();
        while (true) {
            int n5;
            int n6;
            segment = buffer.writableSegment(1);
            if (bl) {
                Segment segment2 = segment;
                byte[] byArray = segment2.data;
                n6 = segment2.limit;
                n5 = this.deflater.deflate(byArray, n6, 8192 - n6, 2);
            } else {
                Segment segment3 = segment;
                byte[] byArray = segment3.data;
                n6 = segment3.limit;
                n5 = this.deflater.deflate(byArray, n6, 8192 - n6);
            }
            if (n5 > 0) {
                segment.limit += n5;
                buffer.size += (long)n5;
                this.sink.emitCompleteSegments();
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
        if (segment.pos == segment.limit) {
            buffer.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }

    @Override
    public void write(Buffer buffer, long l5) throws IOException {
        Util.checkOffsetAndCount(buffer.size, 0L, l5);
        while (l5 > 0L) {
            DeflaterSink deflaterSink = this;
            Segment segment = buffer.head;
            int n5 = (int)Math.min(l5, (long)(segment.limit - segment.pos));
            Segment segment2 = segment;
            byte[] byArray = segment2.data;
            deflaterSink.deflater.setInput(byArray, segment2.pos, n5);
            deflaterSink.deflate(false);
            long l6 = n5;
            buffer.size -= l6;
            segment.pos = n5 = segment.pos + n5;
            if (n5 == segment.limit) {
                buffer.head = segment.pop();
                SegmentPool.recycle(segment);
            }
            l5 -= l6;
        }
    }

    @Override
    public void flush() throws IOException {
        DeflaterSink deflaterSink = this;
        deflaterSink.deflate(true);
        deflaterSink.sink.flush();
    }

    void finishDeflate() throws IOException {
        DeflaterSink deflaterSink = this;
        deflaterSink.deflater.finish();
        deflaterSink.deflate(false);
    }

    @Override
    public void close() throws IOException {
        Throwable throwable;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                throwable = null;
                try {
                    this.finishDeflate();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block8;
                    throwable = throwable3;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable4) {
                if (throwable != null) break block9;
                throwable = throwable4;
            }
        }
        this.closed = true;
        if (throwable != null) {
            Util.sneakyRethrow(throwable);
        }
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    public String toString() {
        return "DeflaterSink(" + this.sink + ")";
    }
}

