/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import androidx.annotation.Nullable;
import dc.squareup.okio.SegmentPool;

final class Segment {
    static final int SIZE = 8192;
    static final int SHARE_MINIMUM = 1024;
    final byte[] data;
    int pos;
    int limit;
    boolean shared;
    boolean owner;
    Segment next;
    Segment prev;

    Segment() {
        this.data = new byte[8192];
        this.owner = true;
        this.shared = false;
    }

    Segment(byte[] byArray, int n5, int n6, boolean bl, boolean bl2) {
        this.data = byArray;
        this.pos = n5;
        this.limit = n6;
        this.shared = bl;
        this.owner = bl2;
    }

    final Segment sharedCopy() {
        ((Segment)object).shared = true;
        Segment segment = object;
        Object object = segment.data;
        int n5 = segment.pos;
        int n6 = segment.limit;
        return new Segment((byte[])object, n5, n6, true, false);
    }

    final Segment unsharedCopy() {
        Segment segment = object;
        Object object = (byte[])segment.data.clone();
        int n5 = segment.pos;
        int n6 = segment.limit;
        return new Segment((byte[])object, n5, n6, false, true);
    }

    @Nullable
    public final Segment pop() {
        Segment segment = segment3.next;
        Segment segment2 = segment != segment3 ? segment : null;
        Segment segment3 = segment3.prev;
        segment3.prev.next = segment;
        v0.next.prev = segment3;
        v0.next = null;
        v0.prev = null;
        return segment2;
    }

    public final Segment push(Segment segment) {
        segment.prev = this;
        segment.next = this.next;
        this.next.prev = segment;
        this.next = segment;
        return segment;
    }

    public final Segment split(int n5) {
        if (n5 > 0 && n5 <= this.limit - this.pos) {
            Segment segment;
            if (n5 >= 1024) {
                segment = this.sharedCopy();
            } else {
                segment = SegmentPool.take();
                int n6 = this.pos;
                System.arraycopy(this.data, n6, segment.data, 0, n5);
            }
            Segment segment2 = this;
            segment.limit = segment.pos + n5;
            segment2.pos += n5;
            segment2.prev.push(segment);
            return segment;
        }
        throw new IllegalArgumentException();
    }

    public final void compact() {
        Segment segment = this.prev;
        if (segment != this) {
            if (!segment.owner) {
                return;
            }
            Segment segment2 = segment;
            int n5 = this.limit - this.pos;
            int n6 = 8192 - segment2.limit;
            int n7 = segment2.shared ? 0 : segment.pos;
            if (n5 > n6 + n7) {
                return;
            }
            Segment segment3 = this;
            segment3.writeTo(segment, n5);
            segment3.pop();
            SegmentPool.recycle(segment3);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void writeTo(Segment object, int n5) {
        if (!((Segment)object).owner) throw new IllegalArgumentException();
        int n6 = ((Segment)object).limit;
        if (n6 + n5 > 8192) {
            if (((Segment)object).shared) throw new IllegalArgumentException();
            int n7 = ((Segment)object).pos;
            if (n6 + n5 - n7 > 8192) throw new IllegalArgumentException();
            Object object2 = object;
            byte[] byArray = ((Segment)object2).data;
            System.arraycopy(((Segment)object2).data, n7, byArray, 0, n6 -= n7);
            ((Segment)object2).limit -= ((Segment)object).pos;
            ((Segment)object2).pos = 0;
        }
        Object object3 = object;
        Object object4 = object;
        int n8 = this.pos;
        object = ((Segment)object4).data;
        n6 = ((Segment)object4).limit;
        System.arraycopy(this.data, n8, object, n6, n5);
        ((Segment)object3).limit += n5;
        this.pos += n5;
    }
}

