/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Segment;
import dc.squareup.okio.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

final class SegmentedByteString
extends ByteString {
    final transient byte[][] segments;
    final transient int[] directory;

    SegmentedByteString(Buffer buffer, int n5) {
        int n6;
        Buffer buffer2 = buffer;
        super(null);
        long l5 = n5;
        Util.checkOffsetAndCount(buffer2.size, 0L, l5);
        int n7 = 0;
        int n8 = 0;
        Segment segment = buffer2.head;
        while (n7 < n5) {
            n6 = segment.limit;
            int n9 = segment.pos;
            if (n6 != n9) {
                n7 += n6 - n9;
                ++n8;
                segment = segment.next;
                continue;
            }
            throw new AssertionError((Object)"s.limit == s.pos");
        }
        this.segments = new byte[n8][];
        this.directory = new int[n8 * 2];
        int n10 = 0;
        n7 = 0;
        Object object = buffer.head;
        while (n10 < n5) {
            byte[][] byArray = this.segments;
            this.segments[n7] = ((Segment)object).data;
            int n11 = ((Segment)object).pos;
            n6 = n10 + (((Segment)object).limit - n11);
            if (n6 > n5) {
                n6 = n5;
            }
            Segment segment2 = object;
            object = this.directory;
            object[n7] = n6;
            this.directory[n7 + byArray.length] = n11;
            segment2.shared = true;
            ++n7;
            object = segment2.next;
            n10 = n6;
        }
    }

    private int segment(int n5) {
        int n6 = n5 + 1;
        if ((n6 = Arrays.binarySearch(this.directory, 0, this.segments.length, n6)) < 0) {
            n6 ^= 0xFFFFFFFF;
        }
        return n6;
    }

    private ByteString toByteString() {
        return new ByteString(this.toByteArray());
    }

    private Object writeReplace() {
        return this.toByteString();
    }

    @Override
    public String utf8() {
        return this.toByteString().utf8();
    }

    @Override
    public String string(Charset charset) {
        return this.toByteString().string(charset);
    }

    @Override
    public String base64() {
        return this.toByteString().base64();
    }

    @Override
    public String hex() {
        return this.toByteString().hex();
    }

    @Override
    public ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    @Override
    public ByteString toAsciiUppercase() {
        return this.toByteString().toAsciiUppercase();
    }

    @Override
    public ByteString md5() {
        return this.toByteString().md5();
    }

    @Override
    public ByteString sha1() {
        return this.toByteString().sha1();
    }

    @Override
    public ByteString sha256() {
        return this.toByteString().sha256();
    }

    @Override
    public String base64Url() {
        return this.toByteString().base64Url();
    }

    @Override
    public ByteString substring(int n5) {
        return this.toByteString().substring(n5);
    }

    @Override
    public ByteString substring(int n5, int n6) {
        return this.toByteString().substring(n5, n6);
    }

    @Override
    public byte getByte(int n5) {
        Util.checkOffsetAndCount(((SegmentedByteString)object).directory[((SegmentedByteString)object).segments.length - 1], n5, 1L);
        int n6 = ((SegmentedByteString)object).segment(n5);
        int n7 = n6 == 0 ? 0 : ((SegmentedByteString)object).directory[n6 - 1];
        SegmentedByteString segmentedByteString = object;
        Object object = segmentedByteString.directory;
        byte[][] byArray = segmentedByteString.segments;
        Object object2 = object[n6 + byArray.length];
        return segmentedByteString.segments[n6][n5 - n7 + object2];
    }

    @Override
    public int size() {
        return this.directory[this.segments.length - 1];
    }

    @Override
    public byte[] toByteArray() {
        SegmentedByteString segmentedByteString = this;
        Object[] objectArray = segmentedByteString.directory;
        objectArray = new byte[objectArray[segmentedByteString.segments.length - 1]];
        int n5 = 0;
        int n6 = segmentedByteString.segments.length;
        for (int i5 = 0; i5 < n6; ++i5) {
            SegmentedByteString segmentedByteString2 = this;
            int n7 = segmentedByteString2.directory[n6 + i5];
            int n8 = segmentedByteString2.directory[i5];
            int n9 = n7;
            n7 = n8 - n5;
            System.arraycopy(segmentedByteString2.segments[i5], n9, objectArray, n5, n7);
            n5 = n8;
        }
        return objectArray;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.toByteArray()).asReadOnlyBuffer();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            int n5 = 0;
            int n6 = this.segments.length;
            for (int i5 = 0; i5 < n6; ++i5) {
                int n7 = this.directory[n6 + i5];
                int n8 = this.directory[i5];
                byte[] byArray = this.segments[i5];
                int n9 = n8 - n5;
                outputStream.write(byArray, n7, n9);
                n5 = n8;
            }
            return;
        }
        throw new IllegalArgumentException("out == null");
    }

    @Override
    void write(Buffer buffer) {
        int n5 = 0;
        int n6 = this.segments.length;
        for (int i5 = 0; i5 < n6; ++i5) {
            Segment segment;
            int n7 = this.directory[n6 + i5];
            int n8 = this.directory[i5];
            Segment segment2 = segment;
            byte[] byArray = this.segments[i5];
            n5 = n7 + n8 - n5;
            segment = new Segment(byArray, n7, n5, true, false);
            Segment segment3 = buffer.head;
            if (segment3 == null) {
                segment2.prev = segment2;
                segment2.next = segment2;
                buffer.head = segment2;
            } else {
                segment3.prev.push(segment2);
            }
            n5 = n8;
        }
        buffer.size += (long)n5;
    }

    @Override
    public boolean rangeEquals(int n5, ByteString byteString, int n6, int n7) {
        if (n5 >= 0 && n5 <= this.size() - n7) {
            int n8 = this.segment(n5);
            while (n7 > 0) {
                int n9 = n8 == 0 ? 0 : this.directory[n8 - 1];
                SegmentedByteString segmentedByteString = this;
                int n10 = Math.min(n7, n9 + (this.directory[n8] - n9) - n5);
                int[] nArray = segmentedByteString.directory;
                byte[][] byArray = segmentedByteString.segments;
                int n11 = n9;
                n9 = nArray[byArray.length + n8];
                if (!byteString.rangeEquals(n6, segmentedByteString.segments[n8], n9 = n5 - n11 + n9, n10)) {
                    return false;
                }
                n5 += n10;
                n6 += n10;
                n7 -= n10;
                ++n8;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean rangeEquals(int n5, byte[] byArray, int n6, int n7) {
        if (n5 >= 0 && n5 <= this.size() - n7 && n6 >= 0 && n6 <= byArray.length - n7) {
            int n8 = this.segment(n5);
            while (n7 > 0) {
                int n9 = n8 == 0 ? 0 : this.directory[n8 - 1];
                SegmentedByteString segmentedByteString = this;
                int n10 = Math.min(n7, n9 + (this.directory[n8] - n9) - n5);
                int[] nArray = segmentedByteString.directory;
                byte[][] byArray2 = segmentedByteString.segments;
                int n11 = n9;
                n9 = nArray[byArray2.length + n8];
                if (!Util.arrayRangeEquals(segmentedByteString.segments[n8], n9 = n5 - n11 + n9, byArray, n6, n10)) {
                    return false;
                }
                n5 += n10;
                n6 += n10;
                n7 -= n10;
                ++n8;
            }
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(byte[] byArray, int n5) {
        return this.toByteString().indexOf(byArray, n5);
    }

    @Override
    public int lastIndexOf(byte[] byArray, int n5) {
        return this.toByteString().lastIndexOf(byArray, n5);
    }

    @Override
    byte[] internalArray() {
        return this.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) return false;
        if (((ByteString)(object = (ByteString)object)).size() != this.size()) return false;
        SegmentedByteString segmentedByteString = this;
        int n5 = segmentedByteString.size();
        if (!segmentedByteString.rangeEquals(0, (ByteString)object, 0, n5)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int n5 = this.hashCode;
        if (n5 != 0) {
            return n5;
        }
        n5 = 1;
        int n6 = 0;
        int n7 = this.segments.length;
        for (int i5 = 0; i5 < n7; ++i5) {
            int n8;
            SegmentedByteString segmentedByteString = this;
            byte[] byArray = segmentedByteString.segments[i5];
            int[] nArray = segmentedByteString.directory;
            int n9 = nArray[i5];
            n6 = n8 + (n9 - n6);
            for (n8 = segmentedByteString.directory[n7 + i5]; n8 < n6; ++n8) {
                n5 = n5 * 31 + byArray[n8];
            }
            n6 = n9;
        }
        this.hashCode = n5;
        return n5;
    }

    @Override
    public String toString() {
        return this.toByteString().toString();
    }
}

