/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.ui;

import android.os.Build;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaWebview;
import io.dcloud.common.adapter.ui.RecordView;
import java.util.regex.Pattern;

public class CustomeizedInputConnection
extends InputConnectionWrapper {
    static Pattern patternPhone = Pattern.compile("^1[0-9]{10}$");
    static Pattern patternID18 = Pattern.compile("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9]|X)$");
    static Pattern patternID15 = Pattern.compile("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$");
    static Pattern patternEmail = Pattern.compile("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$");
    public static int sDefaultInputType = -1;
    int mInputType;
    IWebview mWebview;
    StringBuffer mInputString;
    int mCursorPos;
    InputConnection mTarget;
    CustomeizedInputConnection mLastCustomeizedInputConnection;
    String composingText;

    public CustomeizedInputConnection(IWebview iWebview, InputConnection inputConnection, EditorInfo editorInfo, CustomeizedInputConnection customeizedInputConnection) {
        StringBuffer stringBuffer;
        CustomeizedInputConnection customeizedInputConnection2 = object;
        super(inputConnection, false);
        customeizedInputConnection2.mInputType = -1;
        customeizedInputConnection2.mWebview = null;
        Object object = stringBuffer;
        stringBuffer = new StringBuffer();
        customeizedInputConnection2.mInputString = object;
        customeizedInputConnection2.mCursorPos = -1;
        customeizedInputConnection2.composingText = null;
        customeizedInputConnection2.mTarget = inputConnection;
        customeizedInputConnection2.mWebview = iWebview;
        customeizedInputConnection2.mLastCustomeizedInputConnection = customeizedInputConnection;
        customeizedInputConnection2.checkLastInputConnection();
        customeizedInputConnection2.recordInputType(editorInfo);
        customeizedInputConnection2.recordText();
        customeizedInputConnection2.clearComposingText();
    }

    private void recordInputType(EditorInfo editorInfo) {
        int n5;
        this.mInputType = n5 = sDefaultInputType;
        int n6 = editorInfo.inputType;
        int n7 = n6 & 0xF;
        if (n7 != 1) {
            this.mInputType = n7 != 3 ? n5 : 1;
        } else {
            n5 = n6 & 0xFF0;
            if (n5 == 32 || n5 == 208) {
                this.mInputType = 2;
            }
        }
        this.log("AssistantInput", "recordInputType mInputType =" + this.mInputType + ";typeClass=" + n7);
        RecordView recordView = AdaWebview.mRecordView;
        if (recordView != null && recordView.mShowed) {
            CustomeizedInputConnection customeizedInputConnection = this;
            int n8 = recordView.mAnchorY;
            customeizedInputConnection.showRecordView(n8, customeizedInputConnection.mInputType);
        }
    }

    private void log(String string2, String string3) {
    }

    private void clearComposingText() {
        this.composingText = null;
    }

    private void recordText() {
        CharSequence charSequence = super.getTextBeforeCursor(255, 0);
        if (charSequence != null && charSequence.length() > 0) {
            CustomeizedInputConnection customeizedInputConnection = this;
            CustomeizedInputConnection customeizedInputConnection2 = this;
            StringBuffer stringBuffer = customeizedInputConnection2.mInputString;
            stringBuffer.delete(0, stringBuffer.length());
            CharSequence charSequence2 = super.getTextAfterCursor(255, 0);
            customeizedInputConnection.mCursorPos = charSequence.length();
            customeizedInputConnection.mInputString.append(charSequence).append(charSequence2);
            customeizedInputConnection.log("AssistantInput", "recordText mCursorPos=" + this.mCursorPos + ";mInputString=" + this.mInputString);
        }
    }

    private boolean needRecord(int n5, String string2) {
        boolean bl = n5 != 1 ? (n5 != 2 ? (n5 != 7 ? RecordView.Utils.needRecord(n5) : string2.length() == 18 && patternID18.matcher(string2).find() || string2.length() == 15 && patternID15.matcher(string2).find()) : patternEmail.matcher(string2).find()) : patternPhone.matcher(string2).find();
        return bl;
    }

    void checkLastInputConnection() {
        CustomeizedInputConnection customeizedInputConnection = customeizedInputConnection.mLastCustomeizedInputConnection;
        if (customeizedInputConnection != null && Build.VERSION.SDK_INT >= 24) {
            customeizedInputConnection.finishComposingText();
        }
    }

    void updateInputType(int n5) {
        this.mInputType = n5;
    }

    /*
     * WARNING - void declaration
     */
    public void showRecordView(int n5, boolean bl) {
        void var2_5;
        if (!bl) {
            int n6 = -1;
        } else {
            int n7 = this.mInputType;
        }
        this.showRecordView(n5, (int)var2_5);
    }

    public void showRecordView(int n5, int n6) {
        if (customeizedInputConnection2.mWebview.obtainApp() == null) {
            return;
        }
        if (AdaWebview.mRecordView == null) {
            CustomeizedInputConnection customeizedInputConnection = customeizedInputConnection2;
            CustomeizedInputConnection customeizedInputConnection2 = (ViewGroup)customeizedInputConnection.mWebview.obtainApp().obtainWebAppRootView().obtainMainView();
            AdaWebview.mRecordView = new RecordView(customeizedInputConnection2.mWebview.getContext(), (ViewGroup)customeizedInputConnection2, customeizedInputConnection.mWebview.obtainApp().obtainAppId());
        }
        AdaWebview.mRecordView.update(n5, n6);
        AdaWebview.mRecordView.mShowed = true;
    }

    public void closeRecordView() {
        RecordView recordView = AdaWebview.mRecordView;
        if (recordView != null) {
            RecordView recordView2 = recordView;
            recordView2.update(recordView2.mAnchorY, -1);
            AdaWebview.mRecordView.conceal();
            AdaWebview.mRecordView.mShowed = false;
        }
    }

    public CharSequence getTextBeforeCursor(int n5, int n6) {
        CustomeizedInputConnection customeizedInputConnection = this;
        customeizedInputConnection.log("AssistantInput", "getTextBeforeCursor mCursorPos=" + this.mCursorPos + ";n=" + n5);
        customeizedInputConnection.recordText();
        customeizedInputConnection.clearComposingText();
        return super.getTextBeforeCursor(n5, n6);
    }

    public boolean finishComposingText() {
        String string2 = this.mInputString.toString();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (!TextUtils.isEmpty((CharSequence)this.composingText) && string2.contains(this.composingText)) {
                int n5 = string2.indexOf(this.composingText);
                string2 = string2.substring(0, n5) + string2.substring(n5 + this.composingText.length());
            }
            string2 = string2.trim();
            this.log("AssistantInput", "finishComposingText mInputType=" + this.mInputType + ";msg=" + string2);
            if (AdaWebview.mRecordView != null) {
                CustomeizedInputConnection customeizedInputConnection = this;
                if (customeizedInputConnection.needRecord(customeizedInputConnection.mInputType, string2)) {
                    AdaWebview.mRecordView.record(string2, this.mInputType);
                    int n6 = this.mInputType;
                    if (n6 != -1 && n6 == AdaWebview.sCustomeizedInputConnection.mInputType) {
                        RecordView recordView = AdaWebview.mRecordView;
                        recordView.update(recordView.mAnchorY, n6);
                    }
                    StringBuffer stringBuffer = this.mInputString;
                    stringBuffer.delete(0, stringBuffer.length());
                }
            }
        }
        return (this = this.mTarget) != null ? this.finishComposingText() : true;
    }

    public boolean setComposingText(CharSequence charSequence, int n5) {
        this.composingText = charSequence.toString();
        this.log("AssistantInput", "setComposingText mCursorPos=" + this.mCursorPos + ";msg=" + charSequence);
        return super.setComposingText(charSequence, n5);
    }

    public boolean commitText(CharSequence charSequence, int n5) {
        CustomeizedInputConnection customeizedInputConnection = this;
        customeizedInputConnection.recordText();
        int n6 = customeizedInputConnection.mCursorPos;
        if (n6 >= 0 && n6 < this.mInputString.length()) {
            this.mInputString.insert(this.mCursorPos, charSequence);
        } else {
            this.mInputString.append(charSequence);
        }
        this.log("AssistantInput", "commitText mCursorPos=" + this.mCursorPos + ";msg=" + this.mInputString);
        return super.commitText(charSequence, n5);
    }

    public void update(int n5) {
        int n6 = 0;
        int n7 = n5 > 0 ? 22 : 21;
        KeyEvent keyEvent = new KeyEvent(n6, n7);
        super.sendKeyEvent(keyEvent);
    }

    public boolean setSelection(int n5, int n6) {
        if (n5 == n6) {
            this.mCursorPos = n5;
        }
        return super.setSelection(n5, n6);
    }

    public void setText(String string2) {
        this.clearComposingText();
        if (TextUtils.equals((CharSequence)Build.MODEL, (CharSequence)"ZTE B880")) {
            String string3 = string2;
            CustomeizedInputConnection customeizedInputConnection = this;
            StringBuffer stringBuffer = this.mInputString;
            stringBuffer.delete(0, stringBuffer.length());
            customeizedInputConnection.mCursorPos = string2.length();
            customeizedInputConnection.mInputString.append(string2);
            customeizedInputConnection.deleteSurroundingText(-2147483647, Integer.MAX_VALUE);
            super.setSelection(0, Integer.MAX_VALUE);
            super.commitText((CharSequence)string3, string3.length());
        } else {
            CustomeizedInputConnection customeizedInputConnection = this;
            customeizedInputConnection.recordText();
            customeizedInputConnection.deleteSurroundingText(-2147483647, Integer.MAX_VALUE);
            super.setSelection(0, Integer.MAX_VALUE);
            super.commitText((CharSequence)string2, string2.length());
        }
    }
}

