/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.ui;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import io.dcloud.base.R;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.adapter.ui.AdaWebview;
import io.dcloud.common.adapter.ui.fresh.ILoadingLayout;
import io.dcloud.common.adapter.ui.fresh.PullToRefreshBase;
import io.dcloud.common.adapter.util.CanvasHelper;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;

public class RefreshView
implements PullToRefreshBase.OnStateChangeListener {
    public static final String TAG = "RefreshView";
    private Rect src;
    private RectF dst;
    Bitmap mIcon;
    float mFontScale;
    int changeStateHeight;
    int maxPullHeight;
    float startX;
    float startY;
    AdaFrameView mFrameView;
    AdaWebview mWebview;
    private float mWebviewScale;
    JSONObject mJSONObject;
    Paint paint;
    int index;
    int MAX_FRAME_COUNT;
    int HEIGHT;
    Timer mUpdateProgressBar;
    private int contentLeft;
    private int contentTop;
    int icon_x;
    int icon_y;
    int fontSize;
    String mContent_down;
    String mContent_over;
    String mContent_refresh;
    String mShowContent;
    ILoadingLayout.State mState;

    public RefreshView(AdaFrameView adaFrameView, AdaWebview adaWebview) {
        Paint paint;
        AdaFrameView adaFrameView2 = adaFrameView;
        this.mIcon = null;
        this.mFontScale = 1.2f;
        this.changeStateHeight = 100;
        this.maxPullHeight = 100;
        Paint paint2 = paint;
        paint = new Paint();
        this.paint = paint2;
        this.index = 0;
        this.MAX_FRAME_COUNT = 9;
        this.HEIGHT = 25;
        this.mUpdateProgressBar = null;
        this.contentLeft = 0;
        this.contentTop = 0;
        this.mShowContent = null;
        this.mState = ILoadingLayout.State.RESET;
        this.mFrameView = adaFrameView;
        this.mContent_down = adaFrameView2.getContext().getString(R.string.dcloud_drop_down_refresh1);
        this.mContent_over = adaFrameView2.getContext().getString(R.string.dcloud_drop_down_refresh2);
        this.mContent_refresh = adaFrameView2.getContext().getString(R.string.dcloud_drop_down_refresh3);
        this.mWebview = adaWebview;
        this.mWebviewScale = adaWebview.getScale();
        this.paint.setAntiAlias(true);
    }

    private void stopUpdateScreenTimer() {
        Timer timer = this.mUpdateProgressBar;
        if (timer != null) {
            timer.cancel();
            this.mUpdateProgressBar = null;
        }
    }

    private void startUpdateScreenTimer() {
        RefreshView refreshView = this;
        refreshView.stopUpdateScreenTimer();
        if (refreshView.mFrameView.obtainMainView() != null) {
            TimerTask timerTask;
            Timer timer;
            Object object = timer;
            ((Timer)object)();
            this.mUpdateProgressBar = object;
            object = timerTask;
            timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (RefreshView.this.mFrameView.obtainMainView() == null) {
                        this.cancel();
                    }
                    1 v02 = this;
                    v02.RefreshView.this.updateScreen();
                    View view = v02.RefreshView.this.mFrameView.obtainMainView();
                    1 v22 = this;
                    int n5 = 0;
                    int n6 = v22.RefreshView.this.mFrameView.obtainFrameOptions().width;
                    int n7 = v22.RefreshView.this.maxPullHeight;
                    try {
                        view.postInvalidate(0, n5, n6, n7);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            timer.schedule((TimerTask)object, 0L, 100L);
        }
    }

    private void updateScreen() {
        int n5;
        this.index = n5 = this.index + 1;
        if (n5 >= this.MAX_FRAME_COUNT) {
            this.index = 0;
        }
        n5 = this.HEIGHT;
        int n6 = this.index;
        int n7 = n5 * n6;
        int n8 = n5 * (n6 + 1);
        this.src.set(n7, 0, n8, n5);
    }

    private void computePosition(Paint paint) {
        int n5;
        int n6;
        RefreshView refreshView = this;
        Paint.FontMetricsInt fontMetricsInt = paint.getFontMetricsInt();
        int n7 = this.HEIGHT;
        this.icon_y = n6 = refreshView.changeStateHeight - n7 >> 1;
        refreshView.contentTop = n6 + (n7 - (fontMetricsInt.bottom - fontMetricsInt.top)) / 2;
        float f5 = paint.measureText(this.mShowContent);
        float f6 = refreshView.mFrameView.obtainApp().getInt(0);
        float f7 = f6 * 0.02f;
        int n8 = this.HEIGHT;
        refreshView.icon_x = n5 = (int)(f6 - f7 - (float)n8 - f5) / 2;
        refreshView.contentLeft = (int)((float)n5 + f7 + (float)n8);
    }

    protected void paint(Canvas object, int n5, int n6) {
        RefreshView refreshView = this;
        object.drawColor(-1907998);
        refreshView.paint.setColor(-16777216);
        refreshView.paint.setTextSize((float)this.fontSize);
        if (refreshView.mShowContent != null && this.mIcon != null) {
            Canvas canvas = object;
            RefreshView refreshView2 = this;
            Canvas canvas2 = object;
            RefreshView refreshView3 = this;
            refreshView3.computePosition(refreshView3.paint);
            object = refreshView3.mShowContent;
            int n7 = refreshView3.contentLeft + n5;
            int n8 = refreshView3.contentTop + n6;
            Paint paint = refreshView3.paint;
            CanvasHelper.drawString(canvas2, (String)object, n7, n8, 17, paint);
            int n9 = n6;
            int n10 = n6;
            int n11 = this.icon_x;
            float f5 = n5 + n11;
            n6 = this.icon_y;
            float f6 = n10 + n6;
            int n12 = this.HEIGHT;
            float f7 = n5 + n11 + n12;
            float f8 = n9 + n6 + n12;
            refreshView2.dst.set(f5, f6, f7, f8);
            Bitmap bitmap = refreshView2.mIcon;
            Rect rect = refreshView2.src;
            RectF rectF = refreshView2.dst;
            Paint paint2 = refreshView2.paint;
            canvas.drawBitmap(bitmap, rect, rectF, paint2);
        }
    }

    public void init(String string2) {
        int n5;
        BitmapFactory.Options options;
        this.fontSize = (int)(DeviceInfo.DEFAULT_FONT_SIZE * DeviceInfo.sDensity * this.mFontScale);
        this.paint.setAntiAlias(true);
        string2 = options;
        new BitmapFactory.Options().inScaled = false;
        string2 = BitmapFactory.decodeStream((InputStream)PlatformUtil.getResInputStream("res/dcloud_prograss_snow1.png"), null, (BitmapFactory.Options)string2);
        this.mIcon = string2;
        int n6 = n5 = (this.HEIGHT = string2.getHeight());
        this.src = new Rect(0, 0, n6, n6);
        int n7 = this.HEIGHT;
        float f5 = n7;
        float f6 = n7;
        this.dst = new RectF(0.0f, 150.0f, f5, f6);
        Logger.d(TAG, "height=" + this.changeStateHeight + ";range=" + this.maxPullHeight + ";contentdown=" + this.mShowContent);
        this.MAX_FRAME_COUNT = string2.getWidth() / this.HEIGHT;
    }

    void onResize() {
        RefreshView refreshView = this;
        refreshView.parseJsonOption(refreshView.mJSONObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseJsonOption(JSONObject jSONObject) {
        JSONException jSONException2;
        block8: {
            float f5;
            int n5;
            int n6;
            try {
                jSONObject = JSONUtil.combinJSONObject(this.mJSONObject, jSONObject);
            }
            catch (JSONException jSONException2) {
                break block8;
            }
            this.mJSONObject = jSONObject;
            if (!jSONObject.isNull("height")) {
                RefreshView refreshView = this;
                n6 = refreshView.mWebview.mFrameView.mViewOptions.height;
                n5 = refreshView.changeStateHeight;
                f5 = refreshView.mWebviewScale;
                this.changeStateHeight = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject, "height"), n6, n5, f5);
            }
            if (!jSONObject.isNull("range")) {
                RefreshView refreshView = this;
                n6 = refreshView.mWebview.mFrameView.mViewOptions.height;
                n5 = refreshView.maxPullHeight;
                f5 = refreshView.mWebviewScale;
                this.maxPullHeight = PdrUtil.convertToScreenInt(jSONObject.getString("range"), n6, n5, f5);
            }
            if (!jSONObject.isNull("contentdown")) {
                this.mContent_down = JSONUtil.getString(jSONObject.getJSONObject("contentdown"), "caption");
            }
            if (!jSONObject.isNull("contentover")) {
                this.mContent_over = JSONUtil.getString(jSONObject.getJSONObject("contentover"), "caption");
            }
            if (!jSONObject.isNull("contentrefresh")) {
                this.mContent_refresh = JSONUtil.getString(jSONObject.getJSONObject("contentrefresh"), "caption");
            }
            this.init(null);
            return;
        }
        jSONException2.printStackTrace();
    }

    public void changeStringInfo(String string2) {
        int n5;
        this.mShowContent = string2;
        int n6 = string2.length();
        float[] fArray = new float[n6];
        this.paint.getTextWidths(string2, fArray);
        for (n5 = 0; n5 < n6; ++n5) {
            float cfr_ignored_0 = fArray[n5];
        }
        RefreshView refreshView = this;
        int n7 = refreshView.mFrameView.obtainFrameOptions().width;
        n5 = refreshView.maxPullHeight;
        this.mFrameView.obtainMainView().postInvalidate(0, 0, n7, n5);
    }

    @Override
    public void onStateChanged(ILoadingLayout.State state, boolean bl) {
        ((RefreshView)object).mState = state;
        if (((RefreshView)object).mState != state) {
            if (state == ILoadingLayout.State.RESET) {
                RefreshView refreshView = object;
                Logger.d("refresh", "RefreshView RESET");
                refreshView.changeStringInfo(refreshView.mContent_down);
                refreshView.stopUpdateScreenTimer();
            } else if (state == ILoadingLayout.State.PULL_TO_REFRESH) {
                RefreshView refreshView = object;
                Logger.d("refresh", "RefreshView PULL_TO_REFRESH");
                refreshView.changeStringInfo(refreshView.mContent_down);
            } else if (state == ILoadingLayout.State.RELEASE_TO_REFRESH) {
                RefreshView refreshView = object;
                Logger.d("refresh", "RefreshView RELEASE_TO_REFRESH");
                refreshView.changeStringInfo(refreshView.mContent_over);
            } else if (state == ILoadingLayout.State.REFRESHING) {
                RefreshView refreshView = object;
                Logger.d("refresh", "RefreshView REFRESHING");
                refreshView.changeStringInfo(refreshView.mContent_refresh);
                refreshView.startUpdateScreenTimer();
                Object object = refreshView.mWebview;
                if (object != null && (object = ((AdaWebview)object).mWebViewImpl) != null) {
                    object.onRefresh(3);
                }
            }
        }
    }
}

