/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.ui.fresh;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import io.dcloud.common.adapter.ui.fresh.HeaderLoadingLayout;
import io.dcloud.common.adapter.ui.fresh.ILoadingLayout;
import io.dcloud.common.adapter.ui.fresh.IPullToRefresh;
import io.dcloud.common.adapter.ui.fresh.LoadingLayout;
import io.dcloud.common.adapter.util.Logger;

@SuppressLint(value={"NewApi"})
public abstract class PullToRefreshBase<T extends View>
extends LinearLayout
implements IPullToRefresh<T> {
    private static final int SCROLL_DURATION = 150;
    private static final float OFFSET_RADIO = 2.5f;
    private float mLastMotionY = -1.0f;
    private float mLastMotionX = -1.0f;
    private boolean mCanDoPullDownEvent = false;
    OnPullUpListener mOnPullUpListener;
    private OnRefreshListener<T> mRefreshListener;
    OnStateChangeListener mOnStateChangeListener;
    private LoadingLayout mHeaderLayout;
    private LoadingLayout mFooterLayout;
    private int mHeaderPullDownMaxHeight;
    private int mHeaderHeight;
    private int mFooterHeight;
    private boolean mPullRefreshEnabled = true;
    private boolean mPullLoadEnabled = false;
    private boolean mScrollLoadEnabled = false;
    private boolean mInterceptEventEnable = true;
    private boolean mIsHandledTouchEvent = false;
    private int mTouchSlop;
    private ILoadingLayout.State mPullDownState;
    private ILoadingLayout.State mPullUpState;
    T mRefreshableView;
    private SmoothScrollRunnable mSmoothScrollRunnable;
    private String mAppId;
    float mLastMotionY_pullup;
    final int UP;
    final int DOWN;
    final int LEFT;
    final int RIGHT;
    boolean mBeginPullRefresh;

    public PullToRefreshBase(Context context) {
        super(context);
        Object object = ILoadingLayout.State.NONE;
        v0.mPullDownState = object;
        v0.mPullUpState = object;
        v0.mLastMotionY_pullup = -1.0f;
        v0.UP = 0;
        v0.DOWN = 1;
        v0.LEFT = 2;
        v0.RIGHT = 3;
        v0.mBeginPullRefresh = false;
    }

    private boolean handlePullUpEvent(MotionEvent motionEvent) {
        int n5 = motionEvent.getAction();
        if (n5 == 1) {
            float f5;
            this.mLastMotionY_pullup = motionEvent.getY() - this.mLastMotionY_pullup;
            if (f5 < -3.0f && this.isReadyForPullUp()) {
                this.mOnPullUpListener.onPlusScrollBottom();
                return false;
            }
        } else if (n5 == 0) {
            this.mLastMotionY_pullup = motionEvent.getY();
        }
        return false;
    }

    private double getAngle(float f5, float f6, float f7, float f8) {
        return Math.atan2(f8 - f6, f7 - f5) * 180.0 / Math.PI;
    }

    private int getDirectionByAngle(double d6) {
        if (d6 < -45.0 && d6 > -135.0) {
            return 0;
        }
        if (d6 >= 45.0 && d6 < 135.0) {
            return 1;
        }
        if (!(d6 >= 135.0) && !(d6 <= -135.0)) {
            if (d6 >= -45.0 && d6 <= 45.0) {
                return 3;
            }
            return -1;
        }
        return 2;
    }

    private boolean canDoPullDownEvent(float f5, float f6) {
        float f7;
        float f8 = this.mLastMotionY;
        if (f6 < f7) {
            return true;
        }
        if (!this.mCanDoPullDownEvent) {
            PullToRefreshBase pullToRefreshBase = this;
            boolean bl = 1 == pullToRefreshBase.getDirectionByAngle(pullToRefreshBase.getAngle(pullToRefreshBase.mLastMotionX, f8, f5, f6));
            this.mCanDoPullDownEvent = bl;
        }
        return this.mCanDoPullDownEvent;
    }

    private void setScrollTo(int n5, int n6) {
        this.scrollTo(n5, n6);
    }

    private void setScrollBy(int n5, int n6) {
        this.scrollBy(n5, n6);
    }

    private int getScrollYValue() {
        return this.getScrollY();
    }

    private void smoothScrollTo(int n5, long l5, long l6) {
        int n6;
        boolean bl;
        SmoothScrollRunnable smoothScrollRunnable = this.mSmoothScrollRunnable;
        if (smoothScrollRunnable != null) {
            smoothScrollRunnable.stop();
        }
        if (bl = (n6 = this.getScrollYValue()) != n5) {
            SmoothScrollRunnable smoothScrollRunnable2;
            SmoothScrollRunnable smoothScrollRunnable3 = smoothScrollRunnable2;
            smoothScrollRunnable2 = new SmoothScrollRunnable(n6, n5, l5);
            this.mSmoothScrollRunnable = smoothScrollRunnable3;
        }
        if (bl) {
            if (l6 > 0L) {
                PullToRefreshBase pullToRefreshBase = this;
                pullToRefreshBase.postDelayed(pullToRefreshBase.mSmoothScrollRunnable, l6);
            } else {
                PullToRefreshBase pullToRefreshBase = this;
                pullToRefreshBase.post(pullToRefreshBase.mSmoothScrollRunnable);
            }
        }
    }

    public void setAppId(String string2) {
        this.mAppId = string2;
    }

    public String getAppId() {
        return this.mAppId;
    }

    public void init(Context context) {
        PullToRefreshBase pullToRefreshBase = this;
        this.setOrientation(1);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mHeaderLayout = this.createHeaderLoadingLayout(context);
        this.mFooterLayout = this.createFooterLoadingLayout(context);
        pullToRefreshBase.addHeaderAndFooter(context);
        pullToRefreshBase.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                1 v02 = this;
                v02.PullToRefreshBase.this.refreshLoadingViewsSize();
                v02.PullToRefreshBase.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
        pullToRefreshBase.smoothScrollTo(0);
    }

    public void setHeaderHeight(int n5) {
        this.mHeaderHeight = n5;
    }

    public void setHeaderPullDownMaxHeight(int n5) {
        this.mHeaderPullDownMaxHeight = n5;
    }

    public void refreshLoadingViewsSize() {
        PullToRefreshBase pullToRefreshBase = this;
        int n5 = pullToRefreshBase.mHeaderHeight;
        LoadingLayout loadingLayout = pullToRefreshBase.mFooterLayout;
        int n6 = loadingLayout != null ? loadingLayout.getContentSize() : 0;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        this.mHeaderHeight = n5;
        this.mFooterHeight = n6;
        LoadingLayout loadingLayout2 = this.mHeaderLayout;
        int n7 = loadingLayout2 != null ? loadingLayout2.getMeasuredHeight() : 0;
        Logger.d("View_Visible_Path", "PullToRefreshBase.refreshLoadingViewsSize mHeaderHeight=" + this.mHeaderHeight + ";headerHeight=" + n7);
        LoadingLayout loadingLayout3 = this.mFooterLayout;
        int n8 = loadingLayout3 != null ? loadingLayout3.getMeasuredHeight() : 0;
        if (n8 == 0) {
            n8 = this.mFooterHeight;
        }
        int n9 = n8;
        int n10 = n7;
        PullToRefreshBase pullToRefreshBase2 = this;
        int n11 = pullToRefreshBase2.getPaddingLeft();
        pullToRefreshBase2.getPaddingTop();
        n7 = pullToRefreshBase2.getPaddingRight();
        pullToRefreshBase2.getPaddingBottom();
        n8 = -n10;
        int n12 = -n9;
        this.setPadding(n11, n8, n7, n12);
    }

    protected final void onSizeChanged(int n5, int n6, int n7, int n8) {
        Runnable runnable;
        PullToRefreshBase pullToRefreshBase = this;
        super.onSizeChanged(n5, n6, n7, n8);
        pullToRefreshBase.refreshLoadingViewsSize();
        pullToRefreshBase.refreshRefreshableViewSize(n5, n6);
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                PullToRefreshBase.this.requestLayout();
            }
        };
        pullToRefreshBase.post(runnable2);
    }

    public void setOrientation(int n5) {
        if (1 == n5) {
            super.setOrientation(n5);
            return;
        }
        throw new IllegalArgumentException("This class only supports VERTICAL orientation.");
    }

    public final boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (!this.isInterceptTouchEventEnabled()) {
            return false;
        }
        if (!this.isPullLoadEnabled() && !this.isPullRefreshEnabled()) {
            return false;
        }
        int n5 = motionEvent.getAction();
        if (n5 != 3 && n5 != 1) {
            if (n5 != 0 && this.mIsHandledTouchEvent) {
                return true;
            }
            if (n5 != 0) {
                if (n5 == 2) {
                    float f5;
                    MotionEvent motionEvent2 = motionEvent;
                    float f6 = motionEvent2.getX();
                    if (this.canDoPullDownEvent(f6, f5 = motionEvent2.getY()) && (Math.abs(f6 = motionEvent.getY() - this.mLastMotionY) > (float)this.mTouchSlop || this.isPullRefreshing() || !this.isPullLoading())) {
                        this.mLastMotionY = motionEvent.getY();
                        if (this.isPullRefreshEnabled() && this.isReadyForPullDown()) {
                            boolean bl = Math.abs(this.getScrollYValue()) > 0 || f6 > 0.5f;
                            this.mIsHandledTouchEvent = bl;
                            if (bl) {
                                this.mRefreshableView.onTouchEvent(motionEvent);
                                this.requestDisallowInterceptTouchEvent(true);
                            }
                        } else if (this.isPullLoadEnabled() && this.isReadyForPullUp()) {
                            boolean bl = Math.abs(this.getScrollYValue()) > 0 || f6 < -0.5f;
                            this.mIsHandledTouchEvent = bl;
                            if (bl) {
                                this.requestDisallowInterceptTouchEvent(true);
                            }
                        }
                    }
                }
            } else {
                MotionEvent motionEvent3 = motionEvent;
                this.mLastMotionY = motionEvent3.getY();
                this.mLastMotionX = motionEvent3.getX();
                this.mIsHandledTouchEvent = false;
                this.mCanDoPullDownEvent = false;
            }
            boolean bl = this.mIsHandledTouchEvent;
            if (!bl) {
                bl = super.onTouchEvent(motionEvent);
            }
            return bl;
        }
        this.mIsHandledTouchEvent = false;
        this.mCanDoPullDownEvent = false;
        return false;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isInterceptTouchEventEnabled()) {
            return false;
        }
        boolean bl = false;
        switch (motionEvent.getAction()) {
            default: {
                break;
            }
            case 2: {
                MotionEvent motionEvent2 = motionEvent;
                float f5 = motionEvent2.getY() - this.mLastMotionY;
                this.mLastMotionY = motionEvent2.getY();
                if (this.isPullRefreshEnabled() && this.isReadyForPullDown()) {
                    this.pullHeaderLayout(f5 / 2.5f);
                    bl = true;
                    break;
                }
                if (this.isPullLoadEnabled() && this.isReadyForPullUp()) {
                    this.pullFooterLayout(f5 / 2.5f);
                    bl = true;
                    break;
                }
                this.mIsHandledTouchEvent = false;
                break;
            }
            case 1: 
            case 3: {
                if (this.mIsHandledTouchEvent) {
                    this.mIsHandledTouchEvent = false;
                    if (this.isReadyForPullDown()) {
                        if (this.mPullRefreshEnabled && this.mPullDownState == ILoadingLayout.State.RELEASE_TO_REFRESH) {
                            this.startRefreshing();
                            bl = true;
                        }
                        this.resetHeaderLayout();
                    } else if (this.isReadyForPullUp()) {
                        if (this.isPullLoadEnabled() && this.mPullUpState == ILoadingLayout.State.RELEASE_TO_REFRESH) {
                            this.startLoading();
                            bl = true;
                        }
                        this.resetFooterLayout();
                    }
                }
                this.requestDisallowInterceptTouchEvent(false);
                break;
            }
            case 0: {
                this.mLastMotionY = motionEvent.getY();
                this.mIsHandledTouchEvent = false;
            }
        }
        return bl;
    }

    @Override
    public void setPullRefreshEnabled(boolean bl) {
        this.mPullRefreshEnabled = bl;
    }

    @Override
    public void setPullLoadEnabled(boolean bl) {
        this.mPullLoadEnabled = bl;
    }

    @Override
    public void setScrollLoadEnabled(boolean bl) {
        this.mScrollLoadEnabled = bl;
    }

    @Override
    public boolean isPullRefreshEnabled() {
        return this.mPullRefreshEnabled && this.mHeaderLayout != null;
    }

    @Override
    public boolean isPullLoadEnabled() {
        return this.mPullLoadEnabled && this.mFooterLayout != null;
    }

    @Override
    public boolean isScrollLoadEnabled() {
        return this.mScrollLoadEnabled;
    }

    public void setOnOnPullUpListener(OnPullUpListener onPullUpListener) {
        this.mOnPullUpListener = onPullUpListener;
    }

    @Override
    public void setOnRefreshListener(OnRefreshListener<T> onRefreshListener) {
        this.mRefreshListener = onRefreshListener;
    }

    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.mOnStateChangeListener = onStateChangeListener;
    }

    public void beginPullRefresh() {
        if (!this.mBeginPullRefresh) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){
                int deltaY = 0;

                @Override
                public void run() {
                    3 v02 = this;
                    int n5 = Math.abs(v02.PullToRefreshBase.this.getScrollYValue());
                    if (v02.PullToRefreshBase.this.isPullRefreshEnabled() && PullToRefreshBase.this.isReadyForPullDown()) {
                        if (n5 < PullToRefreshBase.this.mHeaderHeight) {
                            3 v12 = this;
                            v12.PullToRefreshBase.this.pullHeaderLayout((float)this.deltaY / 2.5f);
                            v12.deltaY += 3;
                            v12.PullToRefreshBase.this.postDelayed(this, 5L);
                        } else {
                            PullToRefreshBase.this.startRefreshing();
                            PullToRefreshBase.this.mBeginPullRefresh = false;
                        }
                    }
                }
            };
            this.postDelayed(runnable2, 5L);
            this.mBeginPullRefresh = true;
        }
    }

    @Override
    public void onPullDownRefreshComplete() {
        if (this.isPullRefreshing()) {
            Runnable runnable;
            Object object;
            PullToRefreshBase pullToRefreshBase = this;
            pullToRefreshBase.mPullDownState = object = ILoadingLayout.State.RESET;
            pullToRefreshBase.onStateChanged((ILoadingLayout.State)((Object)object), true);
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    4 v02 = this;
                    v02.PullToRefreshBase.this.setInterceptTouchEventEnabled(true);
                    v02.PullToRefreshBase.this.mHeaderLayout.setState(ILoadingLayout.State.RESET);
                }
            };
            long l5 = pullToRefreshBase.getSmoothScrollDuration();
            pullToRefreshBase.postDelayed((Runnable)object, l5);
            pullToRefreshBase.resetHeaderLayout();
            pullToRefreshBase.setInterceptTouchEventEnabled(false);
        }
    }

    @Override
    public void onPullUpRefreshComplete() {
        if (this.isPullLoading()) {
            Runnable runnable;
            Object object;
            PullToRefreshBase pullToRefreshBase = this;
            pullToRefreshBase.mPullUpState = object = ILoadingLayout.State.RESET;
            pullToRefreshBase.onStateChanged((ILoadingLayout.State)((Object)object), false);
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    5 v02 = this;
                    v02.PullToRefreshBase.this.setInterceptTouchEventEnabled(true);
                    v02.PullToRefreshBase.this.mFooterLayout.setState(ILoadingLayout.State.RESET);
                }
            };
            long l5 = pullToRefreshBase.getSmoothScrollDuration();
            pullToRefreshBase.postDelayed((Runnable)object, l5);
            pullToRefreshBase.resetFooterLayout();
            pullToRefreshBase.setInterceptTouchEventEnabled(false);
        }
    }

    @Override
    public T getRefreshableView() {
        return this.mRefreshableView;
    }

    @Override
    public LoadingLayout getHeaderLoadingLayout() {
        return this.mHeaderLayout;
    }

    @Override
    public LoadingLayout getFooterLoadingLayout() {
        return this.mFooterLayout;
    }

    @Override
    public void setLastUpdatedLabel(CharSequence charSequence) {
        LoadingLayout loadingLayout = ((PullToRefreshBase)this).mHeaderLayout;
        if (loadingLayout != null) {
            loadingLayout.setLastUpdatedLabel(charSequence);
        }
        if ((this = ((PullToRefreshBase)this).mFooterLayout) != null) {
            ((LoadingLayout)this).setLastUpdatedLabel(charSequence);
        }
    }

    public void doPullRefreshing(final boolean bl, long l5) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                6 v02 = this;
                int n5 = -v02.PullToRefreshBase.this.mHeaderHeight;
                int n6 = v02.bl ? 150 : 0;
                6 v12 = this;
                v12.PullToRefreshBase.this.startRefreshing();
                v12.PullToRefreshBase.this.smoothScrollTo(n5, n6, 0L);
            }
        };
        this.postDelayed(runnable2, l5);
    }

    public void setRefreshableView(T t5) {
        this.mRefreshableView = t5;
    }

    protected abstract boolean isReadyForPullDown();

    protected abstract boolean isReadyForPullUp();

    protected LoadingLayout createHeaderLoadingLayout(Context context) {
        LoadingLayout loadingLayout = ((PullToRefreshBase)((Object)loadingLayout)).mHeaderLayout;
        if (loadingLayout == null) {
            return new HeaderLoadingLayout(context);
        }
        return loadingLayout;
    }

    protected LoadingLayout createFooterLoadingLayout(Context context) {
        return null;
    }

    protected long getSmoothScrollDuration() {
        return 150L;
    }

    protected void refreshRefreshableViewSize(int n5, int n6) {
        Object object = this.mRefreshableView;
        if (object != null) {
            object = (LinearLayout.LayoutParams)object.getLayoutParams();
            if (((LinearLayout.LayoutParams)object).height != n6) {
                ((LinearLayout.LayoutParams)object).height = n6;
                this.mRefreshableView.requestLayout();
            }
        }
    }

    protected void onAddRefreshableView(LinearLayout.LayoutParams layoutParams) {
    }

    public void addRefreshableView(T t5) {
        LinearLayout.LayoutParams layoutParams;
        PullToRefreshBase pullToRefreshBase = pullToRefreshBase2;
        PullToRefreshBase pullToRefreshBase2 = layoutParams;
        layoutParams = new LinearLayout.LayoutParams(-1, -1);
        pullToRefreshBase.onAddRefreshableView((LinearLayout.LayoutParams)pullToRefreshBase2);
        pullToRefreshBase.addView((View)t5, (ViewGroup.LayoutParams)pullToRefreshBase2);
    }

    protected void addHeaderAndFooter(Context context) {
        LinearLayout.LayoutParams layoutParams;
        context = layoutParams;
        layoutParams = new LinearLayout.LayoutParams(-1, -2);
        LoadingLayout loadingLayout = this.mHeaderLayout;
        LoadingLayout loadingLayout2 = this.mFooterLayout;
        if (loadingLayout != null) {
            if (this == loadingLayout.getParent()) {
                this.removeView((View)loadingLayout);
            }
            this.addView((View)loadingLayout, 0, (ViewGroup.LayoutParams)context);
        }
        if (loadingLayout2 != null) {
            if (this == loadingLayout2.getParent()) {
                this.removeView((View)loadingLayout2);
            }
            this.addView((View)loadingLayout2, -1, (ViewGroup.LayoutParams)context);
        }
    }

    protected void pullHeaderLayout(float f5) {
        int n5 = this.getScrollYValue();
        if (f5 > 0.0f && Math.abs(n5) >= this.mHeaderPullDownMaxHeight) {
            return;
        }
        if (f5 < 0.0f && (float)n5 - f5 >= 0.0f) {
            this.setScrollTo(0, 0);
            return;
        }
        PullToRefreshBase pullToRefreshBase = this;
        pullToRefreshBase.setScrollBy(0, -((int)f5));
        if (pullToRefreshBase.mHeaderLayout != null && this.mHeaderHeight != 0) {
            PullToRefreshBase pullToRefreshBase2 = this;
            f5 = (float)Math.abs(pullToRefreshBase2.getScrollYValue()) / (float)this.mHeaderHeight;
            pullToRefreshBase2.mHeaderLayout.onPull(f5);
        }
        PullToRefreshBase pullToRefreshBase3 = this;
        int n6 = Math.abs(pullToRefreshBase3.getScrollYValue());
        if (pullToRefreshBase3.isPullRefreshEnabled() && !this.isPullRefreshing()) {
            this.mPullDownState = n6 >= this.mHeaderHeight ? ILoadingLayout.State.RELEASE_TO_REFRESH : ILoadingLayout.State.PULL_TO_REFRESH;
            PullToRefreshBase pullToRefreshBase4 = this;
            pullToRefreshBase4.mHeaderLayout.setState(this.mPullDownState);
            pullToRefreshBase4.onStateChanged(pullToRefreshBase4.mPullDownState, true);
        }
    }

    protected void pullFooterLayout(float f5) {
        int n5 = this.getScrollYValue();
        if (f5 > 0.0f && (float)n5 - f5 <= 0.0f) {
            this.setScrollTo(0, 0);
            return;
        }
        PullToRefreshBase pullToRefreshBase = this;
        pullToRefreshBase.setScrollBy(0, -((int)f5));
        if (pullToRefreshBase.mFooterLayout != null && this.mFooterHeight != 0) {
            PullToRefreshBase pullToRefreshBase2 = this;
            f5 = (float)Math.abs(pullToRefreshBase2.getScrollYValue()) / (float)this.mFooterHeight;
            pullToRefreshBase2.mFooterLayout.onPull(f5);
        }
        PullToRefreshBase pullToRefreshBase3 = this;
        int n6 = Math.abs(pullToRefreshBase3.getScrollYValue());
        if (pullToRefreshBase3.isPullLoadEnabled() && !this.isPullLoading()) {
            this.mPullUpState = n6 >= this.mFooterHeight ? ILoadingLayout.State.RELEASE_TO_REFRESH : ILoadingLayout.State.PULL_TO_REFRESH;
            PullToRefreshBase pullToRefreshBase4 = this;
            pullToRefreshBase4.mFooterLayout.setState(this.mPullUpState);
            pullToRefreshBase4.onStateChanged(pullToRefreshBase4.mPullUpState, false);
        }
    }

    protected void resetHeaderLayout() {
        PullToRefreshBase pullToRefreshBase = this;
        int n5 = Math.abs(pullToRefreshBase.getScrollYValue());
        boolean bl = pullToRefreshBase.isPullRefreshing();
        if (bl && n5 <= this.mHeaderHeight) {
            return;
        }
        if (bl) {
            PullToRefreshBase pullToRefreshBase2 = this;
            pullToRefreshBase2.smoothScrollTo(-pullToRefreshBase2.mHeaderHeight);
        } else {
            this.smoothScrollTo(0);
        }
    }

    protected void resetFooterLayout() {
        PullToRefreshBase pullToRefreshBase = this;
        int n5 = Math.abs(pullToRefreshBase.getScrollYValue());
        boolean bl = pullToRefreshBase.isPullLoading();
        if (bl && n5 <= this.mFooterHeight) {
            this.smoothScrollTo(0);
            return;
        }
        if (bl) {
            PullToRefreshBase pullToRefreshBase2 = this;
            pullToRefreshBase2.smoothScrollTo(pullToRefreshBase2.mFooterHeight);
        } else {
            this.smoothScrollTo(0);
        }
    }

    protected boolean isPullRefreshing() {
        return this.mPullDownState == ILoadingLayout.State.REFRESHING;
    }

    protected boolean isPullLoading() {
        return this.mPullUpState == ILoadingLayout.State.REFRESHING;
    }

    protected void startRefreshing() {
        Object object;
        if (this.isPullRefreshing()) {
            return;
        }
        PullToRefreshBase pullToRefreshBase = this;
        pullToRefreshBase.mPullDownState = object = ILoadingLayout.State.REFRESHING;
        pullToRefreshBase.onStateChanged((ILoadingLayout.State)((Object)object), true);
        LoadingLayout loadingLayout = pullToRefreshBase.mHeaderLayout;
        if (loadingLayout != null) {
            loadingLayout.setState((ILoadingLayout.State)((Object)object));
        }
        if (this.mRefreshListener != null) {
            Runnable runnable;
            PullToRefreshBase pullToRefreshBase2 = this;
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    PullToRefreshBase.this.mRefreshListener.onPullDownToRefresh(PullToRefreshBase.this);
                }
            };
            long l5 = pullToRefreshBase2.getSmoothScrollDuration();
            pullToRefreshBase2.postDelayed((Runnable)object, l5);
        }
    }

    protected void startLoading() {
        Object object;
        if (this.isPullLoading()) {
            return;
        }
        PullToRefreshBase pullToRefreshBase = this;
        pullToRefreshBase.mPullUpState = object = ILoadingLayout.State.REFRESHING;
        pullToRefreshBase.onStateChanged((ILoadingLayout.State)((Object)object), false);
        LoadingLayout loadingLayout = pullToRefreshBase.mFooterLayout;
        if (loadingLayout != null) {
            loadingLayout.setState((ILoadingLayout.State)((Object)object));
        }
        if (this.mRefreshListener != null) {
            Runnable runnable;
            PullToRefreshBase pullToRefreshBase2 = this;
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    PullToRefreshBase.this.mRefreshListener.onPullUpToRefresh(PullToRefreshBase.this);
                }
            };
            long l5 = pullToRefreshBase2.getSmoothScrollDuration();
            pullToRefreshBase2.postDelayed((Runnable)object, l5);
        }
    }

    protected void onStateChanged(ILoadingLayout.State state, boolean bl) {
        OnStateChangeListener onStateChangeListener = ((PullToRefreshBase)((Object)onStateChangeListener)).mOnStateChangeListener;
        if (onStateChangeListener != null) {
            onStateChangeListener.onStateChanged(state, bl);
        }
    }

    public void smoothScrollTo(int n5) {
        PullToRefreshBase pullToRefreshBase = this;
        long l5 = pullToRefreshBase.getSmoothScrollDuration();
        pullToRefreshBase.smoothScrollTo(n5, l5, 0L);
    }

    public void setInterceptTouchEventEnabled(boolean bl) {
        this.mInterceptEventEnable = bl;
    }

    public boolean isInterceptTouchEventEnabled() {
        return this.mInterceptEventEnable;
    }

    public static interface OnRefreshListener<V extends View> {
        public void onPullDownToRefresh(PullToRefreshBase<V> var1);

        public void onPullUpToRefresh(PullToRefreshBase<V> var1);
    }

    public static interface OnPullUpListener {
        public void onPlusScrollBottom();
    }

    public static interface OnStateChangeListener {
        public void onStateChanged(ILoadingLayout.State var1, boolean var2);
    }

    final class SmoothScrollRunnable
    implements Runnable {
        private final Interpolator mInterpolator;
        private final int mScrollToY;
        private final int mScrollFromY;
        private final long mDuration;
        private boolean mContinueRunning = true;
        private long mStartTime = -1L;
        private int mCurrentY = -1;

        public SmoothScrollRunnable(int n5, int n6, long l5) {
            DecelerateInterpolator decelerateInterpolator;
            smoothScrollRunnable.mScrollFromY = n5;
            smoothScrollRunnable.mScrollToY = n6;
            smoothScrollRunnable.mDuration = l5;
            SmoothScrollRunnable smoothScrollRunnable = decelerateInterpolator;
            decelerateInterpolator = new DecelerateInterpolator();
            v1.mInterpolator = smoothScrollRunnable;
        }

        @Override
        public void run() {
            if (this.mDuration <= 0L) {
                PullToRefreshBase.this.setScrollTo(0, this.mScrollToY);
                return;
            }
            if (this.mStartTime == -1L) {
                this.mStartTime = System.currentTimeMillis();
            } else {
                SmoothScrollRunnable smoothScrollRunnable = this;
                long l5 = Math.max(Math.min((System.currentTimeMillis() - this.mStartTime) * 1000L / this.mDuration, 1000L), 0L);
                int n5 = Math.round((float)(smoothScrollRunnable.mScrollFromY - this.mScrollToY) * this.mInterpolator.getInterpolation((float)l5 / 1000.0f));
                smoothScrollRunnable.mCurrentY = n5 = smoothScrollRunnable.mScrollFromY - n5;
                smoothScrollRunnable.PullToRefreshBase.this.setScrollTo(0, n5);
            }
            if (this.mContinueRunning && this.mScrollToY != this.mCurrentY) {
                PullToRefreshBase.this.postDelayed(this, 16L);
            }
        }

        public void stop() {
            this.mContinueRunning = false;
            PullToRefreshBase.this.removeCallbacks(this);
        }
    }
}

