/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.audio.recorder;

import android.media.AudioRecord;
import android.os.Handler;
import android.os.Message;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.feature.audio.aac.AacEncode;
import io.dcloud.feature.audio.mp3.SimpleLame;
import io.dcloud.feature.audio.recorder.DataEncodeThread;
import io.dcloud.feature.audio.recorder.HighGradeRecorder;
import io.dcloud.feature.audio.recorder.RecordOption;
import io.dcloud.feature.audio.recorder.RecorderUtil;
import java.io.File;
import java.io.FileNotFoundException;

public class RecorderTask
extends Thread {
    private static final String TAG = "RecorderTask";
    private static final int DEFAULT_LAME_MP3_QUALITY = 5;
    public static final int DEFAULT_LAME_MP3_BIT_RATE = 128;
    private static final int FRAME_COUNT = 220;
    private int[] sampleRates;
    private final int[] configs;
    private final int[] formats;
    private AudioRecord audioRecord;
    int bufsize;
    private boolean mShouldRun;
    private boolean mShouldRecord;
    private long startTime;
    private long duration;
    private int maxDuration;
    private short[] mPCMBuffer;
    private byte[] mAacBuffer;
    private DataEncodeThread mEncodeThread;
    private File outputFile;
    private double mDuration;
    private HighGradeRecorder.Callback mDurationListener;
    HighGradeRecorder mRecorder;
    boolean reallyStart;
    Handler handler;
    int waitingTime;
    private String mFormat;

    public RecorderTask(File file, HighGradeRecorder highGradeRecorder, RecordOption object) {
        RecorderTask recorderTask = this;
        this.sampleRates = new int[]{44100, 22050, 11025, 8000};
        this.configs = new int[]{16, 12};
        this.formats = new int[]{2, 3};
        this.audioRecord = null;
        this.bufsize = -2;
        this.mShouldRun = false;
        this.mShouldRecord = false;
        this.startTime = 0L;
        this.duration = 0L;
        this.outputFile = file;
        recorderTask.mRecorder = highGradeRecorder;
        recorderTask.handler = new Handler();
        this.mFormat = ((RecordOption)object).mFormat;
        if (!((RecordOption)object).isRateDeft) {
            int n5 = ((RecordOption)object).mSamplingRate;
            int[] nArray = new int[5];
            object = nArray;
            nArray[0] = n5;
            nArray[1] = 44100;
            nArray[2] = 22050;
            nArray[3] = 11025;
            nArray[4] = 8000;
            this.sampleRates = (int[])object;
        }
        this.waitingTime = highGradeRecorder.getRecorderState() == 1 ? 1000 : 10000;
    }

    private int mapFormat(int n5) {
        if (n5 != 2) {
            if (n5 != 3) {
                return 0;
            }
            return 8;
        }
        return 16;
    }

    private void cancel() {
        this.stopRecord();
    }

    private double calVolume(short[] sArray, double d6) {
        long l5 = 0L;
        for (int i5 = 0; i5 < sArray.length; ++i5) {
            short s5 = sArray[i5];
            l5 += (long)(s5 * s5);
        }
        return Math.log10((double)l5 / d6) * 10.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        FileNotFoundException fileNotFoundException2;
        block13: {
            DataEncodeThread dataEncodeThread;
            block10: {
                block11: {
                    int n5 = this.audioRecord.getAudioFormat() == 2 ? 2 : 1;
                    int n6 = this.bufsize / n5;
                    int n7 = n6 % 220;
                    if (n7 != 0) {
                        this.bufsize = (n6 + (220 - n7)) * n5;
                    }
                    int n8 = this.bufsize;
                    this.mPCMBuffer = new short[n8];
                    this.mAacBuffer = new byte[n8];
                    if (this.mFormat.equalsIgnoreCase("aac")) {
                        AacEncode.getAacEncode(this.audioRecord.getSampleRate(), this.audioRecord.getChannelCount());
                    } else {
                        SimpleLame.init((int)this.audioRecord.getSampleRate(), (int)this.audioRecord.getChannelCount(), (int)this.audioRecord.getSampleRate(), (int)128, (int)5);
                    }
                    if (this.outputFile.exists()) break block10;
                    File file = this.outputFile.getParentFile();
                    if (file.exists()) break block11;
                    file.mkdirs();
                }
                this.outputFile.createNewFile();
            }
            DataEncodeThread dataEncodeThread2 = dataEncodeThread;
            try {
                this.mEncodeThread = dataEncodeThread2;
                new DataEncodeThread(this.outputFile, this.bufsize, this.mFormat).start();
                DataEncodeThread dataEncodeThread3 = this.mEncodeThread;
                this.audioRecord.setRecordPositionUpdateListener((AudioRecord.OnRecordPositionUpdateListener)dataEncodeThread3, dataEncodeThread3.getHandler());
                this.audioRecord.setPositionNotificationPeriod(220);
                return;
            }
            catch (Exception exception) {
            }
            catch (FileNotFoundException fileNotFoundException2) {
                break block13;
            }
            exception.printStackTrace();
            return;
        }
        fileNotFoundException2.printStackTrace();
    }

    private boolean isFound() {
        boolean bl = false;
        int n5 = 0;
        while (!bl) {
            int[] nArray = this.formats;
            if (n5 >= this.formats.length) break;
            int n6 = nArray[n5];
            int n7 = 0;
            while (!bl) {
                int[] nArray2 = this.sampleRates;
                if (n7 >= this.sampleRates.length) break;
                int n8 = nArray2[n7];
                int n9 = 0;
                while (!bl) {
                    int[] nArray3 = this.configs;
                    if (n9 >= this.configs.length) break;
                    int n10 = nArray3[n9];
                    Logger.e(TAG, "Trying to create AudioRecord use: " + n6 + "/" + n10 + "/" + n8);
                    this.bufsize = AudioRecord.getMinBufferSize((int)n8, (int)n10, (int)n6);
                    Logger.e(TAG, "Bufsize: " + this.bufsize);
                    int n11 = this.bufsize;
                    if (-2 == n11) {
                        Logger.i(TAG, "invaild params!");
                    } else if (-1 == n11) {
                        Logger.i(TAG, "Unable to query hardware!");
                    } else {
                        try {
                            RecorderTask recorderTask = this;
                            recorderTask.createRecord(n8, n10, n6);
                            if (recorderTask.audioRecord.getState() == 1) {
                                bl = true;
                                break;
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            Logger.i(TAG, "Failed to set up recorder!");
                            this.audioRecord = null;
                        }
                    }
                    ++n9;
                }
                ++n7;
            }
            ++n5;
        }
        return bl;
    }

    private void createRecord(int n5, int n6, int n7) {
        AudioRecord audioRecord;
        AudioRecord audioRecord2 = audioRecord;
        int n8 = this.bufsize;
        audioRecord = new AudioRecord(1, n5, n6, n7, n8);
        this.audioRecord = audioRecord2;
    }

    public void setMaxDuration(int n5) {
        this.maxDuration = n5;
    }

    public void setCallback(HighGradeRecorder.Callback callback) {
        this.mDurationListener = callback;
    }

    public void startRecording() {
        this.mShouldRecord = true;
    }

    public void resumeRecord() {
        this.mShouldRecord = true;
    }

    public void pauseRecord() {
        this.mShouldRecord = false;
    }

    public void stopRecord() {
        this.mShouldRecord = false;
        this.mShouldRun = false;
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.stop();
            this.audioRecord.release();
            this.audioRecord = null;
        }
        Message.obtain((Handler)this.mEncodeThread.getHandler(), (int)1).sendToTarget();
    }

    public int getDuration() {
        return (int)this.mDuration;
    }

    @Override
    public void run() {
        super.run();
        if (!this.isFound()) {
            Logger.e(TAG, "Sample rate, channel config or format not supported!");
            return;
        }
        this.init();
        this.mShouldRun = true;
        int n5 = 0;
        int n6 = this.audioRecord.getSampleRate() * this.mapFormat(this.audioRecord.getAudioFormat()) / 8 * this.audioRecord.getChannelCount();
        this.mDuration = 0.0;
        while (this.mShouldRun) {
            AudioRecord audioRecord;
            int n7 = this.mShouldRecord;
            if (n7 != n5) {
                block14: {
                    if (n7 != 0) {
                        long l5;
                        this.startTime = l5 = System.currentTimeMillis();
                        this.audioRecord.startRecording();
                        if (this.mDuration != 0.0) break block14;
                        try {
                            this.reallyStart = true;
                            RecorderUtil.postTaskSafely(new Runnable(){

                                @Override
                                public void run() {
                                    RecorderTask.this.mRecorder.onstart();
                                }
                            });
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        this.audioRecord.stop();
                    }
                }
                n5 = this.mShouldRecord;
            }
            if (!this.mShouldRecord) continue;
            if (this.mFormat.equalsIgnoreCase("aac")) {
                n7 = this.audioRecord.read(this.mAacBuffer, 0, this.bufsize);
                if (n7 <= 0) continue;
                this.mEncodeThread.addTask(this.mAacBuffer, n7);
                continue;
            }
            n7 = this.audioRecord.read(this.mPCMBuffer, 0, this.bufsize);
            if (n7 <= 0) continue;
            final double d6 = n7;
            double d7 = d6 * 1000.0 * 2.0 / (double)n6;
            d6 = this.calVolume(this.mPCMBuffer, d6);
            this.mDuration = d7 = this.mDuration + d7;
            if (this.mDurationListener != null) {
                RecorderUtil.postTaskSafely(new Runnable(){

                    @Override
                    public void run() {
                        2 v02 = this;
                        2 v12 = this;
                        double d62 = v12.RecorderTask.this.mDuration;
                        double d7 = v12.d6;
                        v02.RecorderTask.this.mDurationListener.onRecording(d62, d7);
                        if (v02.RecorderTask.this.maxDuration > 0 && RecorderTask.this.mDuration >= (double)RecorderTask.this.maxDuration) {
                            2 v22 = this;
                            v22.RecorderTask.this.mRecorder.stop(2);
                            v22.RecorderTask.this.mDurationListener.onMaxDurationReached();
                        }
                    }
                });
            }
            if ((audioRecord = this.audioRecord) != null && audioRecord.getChannelCount() == 1) {
                this.mEncodeThread.addTask(this.mPCMBuffer, n7);
                continue;
            }
            audioRecord = this.audioRecord;
            if (audioRecord == null || audioRecord.getChannelCount() != 2) continue;
            int n8 = n7 / 2;
            short[] sArray = new short[n8];
            short[] sArray2 = new short[n8];
            for (int i5 = 0; i5 < n8; i5 += 2) {
                short[] sArray3 = this.mPCMBuffer;
                int n9 = i5 * 2;
                sArray[i5] = this.mPCMBuffer[n9];
                int n10 = n9 + 1;
                if (n10 < n7) {
                    int n11 = i5 + 1;
                    sArray[n11] = sArray3[n10];
                }
                if ((n10 = n9 + 2) < n7) {
                    sArray2[i5] = sArray3[n10];
                }
                if ((n9 += 3) >= n7) continue;
                int n12 = i5 + 1;
                sArray2[n12] = sArray3[n9];
            }
            this.mEncodeThread.addTask(sArray, sArray2, n8);
        }
    }

    public boolean isRecording() {
        return this.mShouldRecord;
    }
}

