/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import com.dcloud.zxing2.ResultPoint;
import io.dcloud.feature.barcode2.decoding.IBarHandler;
import io.dcloud.feature.barcode2.view.DetectorViewConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public final class ViewfinderView
extends View {
    private static final long ANIMATION_DELAY = 100L;
    private static final int OPAQUE = 255;
    private final Paint paint;
    private Collection<ResultPoint> possibleResultPoints;
    private Collection<ResultPoint> lastPossibleResultPoints;
    IBarHandler barHandler = null;
    private Rect lastRect = null;
    ShapeDrawable laserBitmap = null;
    int laserY = -DetectorViewConfig.LASER_WIDTH;
    Timer mUpdateProgressBar = null;
    private boolean running = false;

    public ViewfinderView(Context context, IBarHandler iBarHandler) {
        super(context);
        this.barHandler = iBarHandler;
        this.paint = new Paint();
        this.getResources();
        this.possibleResultPoints = new HashSet<ResultPoint>(5);
    }

    private void drawResultPoint(Canvas canvas, Rect rect) {
        float f5;
        ViewfinderView viewfinderView = this;
        Iterator<ResultPoint> iterator = viewfinderView.possibleResultPoints;
        Object object = viewfinderView.lastPossibleResultPoints;
        if (iterator.isEmpty()) {
            this.lastPossibleResultPoints = null;
        } else {
            ViewfinderView viewfinderView2 = this;
            this.possibleResultPoints = new HashSet<ResultPoint>(5);
            viewfinderView2.lastPossibleResultPoints = iterator;
            viewfinderView2.paint.setAlpha(255);
            viewfinderView2.paint.setColor(DetectorViewConfig.resultPointColor);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Rect rect2 = rect;
                ResultPoint resultPoint = iterator.next();
                float f6 = (float)rect2.left + resultPoint.getX();
                f5 = (float)rect2.top + resultPoint.getY();
                Paint paint = this.paint;
                canvas.drawCircle(f6, f5, 6.0f, paint);
            }
        }
        if (object != null) {
            ViewfinderView viewfinderView3 = this;
            viewfinderView3.paint.setAlpha(127);
            viewfinderView3.paint.setColor(DetectorViewConfig.resultPointColor);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                Rect rect3 = rect;
                object = iterator.next();
                f5 = (float)rect3.left + ((ResultPoint)object).getX();
                float f7 = (float)rect3.top + ((ResultPoint)object).getY();
                Paint paint = this.paint;
                canvas.drawCircle(f5, f7, 3.0f, paint);
            }
        }
    }

    private void drawLaserLine(Canvas canvas, Rect rect) {
        if (this.laserBitmap == null) {
            RadialGradient radialGradient;
            this.laserBitmap = new ShapeDrawable((Shape)new OvalShape());
            RadialGradient radialGradient2 = radialGradient;
            int n5 = DetectorViewConfig.laserColor;
            int n6 = n5 & 0xFFFFFF;
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            radialGradient = new RadialGradient((float)(rect.width() / 2), (float)(DetectorViewConfig.LASER_WIDTH / 2), 240.0f, n5, n6, tileMode);
            this.laserBitmap.getPaint().setShader((Shader)radialGradient2);
        }
        ViewfinderView viewfinderView = this;
        viewfinderView.paint.setAntiAlias(true);
        int n7 = rect.left;
        int n8 = this.laserY;
        int n9 = n7 + rect.width();
        int n10 = this.laserY + DetectorViewConfig.LASER_WIDTH;
        viewfinderView.laserBitmap.setBounds(n7, n8, n9, n10);
        viewfinderView.laserBitmap.draw(canvas);
        viewfinderView.paint.setShader(null);
    }

    private void updateScreen() {
        Rect rect = DetectorViewConfig.getInstance().getDetectorRect();
        int n5 = this.laserY;
        this.laserY = n5 > rect.bottom ? rect.top : n5 + 1;
        this.postInvalidate();
    }

    private void drawNonDetectorArea(Canvas canvas, Rect rect, Rect rect2) {
        Rect rect3 = rect2;
        Rect rect4 = rect;
        Rect rect5 = rect;
        Rect rect6 = rect2;
        Rect rect7 = rect;
        Rect rect8 = rect;
        this.paint.setColor(DetectorViewConfig.maskColor);
        float f5 = rect2.right;
        float f6 = rect.top;
        rect = this.paint;
        canvas.drawRect(0.0f, 0.0f, f5, f6, (Paint)rect);
        f5 = rect8.top;
        f6 = rect8.left;
        float f7 = rect8.bottom;
        rect2 = this.paint;
        canvas.drawRect(0.0f, f5, f6, f7, (Paint)rect2);
        f5 = rect7.right;
        f6 = rect7.top;
        f7 = rect6.right;
        float f8 = rect5.bottom;
        Paint paint = this.paint;
        canvas.drawRect(f5, f6, f7, f8, paint);
        f5 = rect4.bottom;
        f6 = rect3.right;
        f7 = rect3.bottom;
        Paint paint2 = this.paint;
        canvas.drawRect(0.0f, f5, f6, f7, paint2);
    }

    private void drawDetectorCorner(Canvas canvas, Rect rect) {
        Rect rect2 = rect;
        Rect rect3 = rect;
        Rect rect4 = rect;
        Rect rect5 = rect;
        Rect rect6 = rect;
        Rect rect7 = rect;
        Rect rect8 = rect;
        Rect rect9 = rect;
        this.paint.setColor(DetectorViewConfig.cornerColor);
        int n5 = DetectorViewConfig.CORNER_WIDTH / 2;
        int n6 = DetectorViewConfig.CORNER_HEIGHT;
        int n7 = rect9.left;
        float f5 = n7 - n5;
        int n8 = rect9.top;
        float f6 = n8 - n5;
        float f7 = n7 + n6;
        float f8 = n8 + n5;
        Paint paint = this.paint;
        canvas.drawRect(f5, f6, f7, f8, paint);
        int n9 = rect8.left;
        f5 = n9 - n5;
        int n10 = rect8.top;
        float f9 = n10;
        float f10 = n9 + n5;
        f8 = n10 + n6;
        paint = this.paint;
        canvas.drawRect(f5, f9, f10, f8, paint);
        int n11 = rect7.right;
        f5 = n11 - n6;
        int n12 = rect7.top;
        float f11 = n12 - n5;
        f10 = n11 + n5;
        f8 = n12 + n5;
        paint = this.paint;
        canvas.drawRect(f5, f11, f10, f8, paint);
        int n13 = rect6.right;
        f5 = n13 - n5;
        int n14 = rect6.top;
        float f12 = n14;
        float f13 = n13 + n5;
        f8 = n14 + n6;
        paint = this.paint;
        canvas.drawRect(f5, f12, f13, f8, paint);
        int n15 = rect5.left;
        f5 = n15 - n5;
        int n16 = rect5.bottom;
        float f14 = n16 - n6;
        f13 = n15 + n5;
        f8 = n16;
        paint = this.paint;
        canvas.drawRect(f5, f14, f13, f8, paint);
        int n17 = rect4.left;
        f5 = n17 - n5;
        int n18 = rect4.bottom;
        float f15 = n18 - n5;
        float f16 = n17 + n6;
        f8 = n18 + n5;
        paint = this.paint;
        canvas.drawRect(f5, f15, f16, f8, paint);
        int n19 = rect3.right;
        f5 = n19 - n6;
        int n20 = rect3.bottom;
        float f17 = n20 - n5;
        f16 = n19 + n5;
        f8 = n20 + n5;
        paint = this.paint;
        canvas.drawRect(f5, f17, f16, f8, paint);
        int n21 = rect2.right;
        f5 = n21 - n5;
        int n22 = rect2.bottom;
        float f18 = n22 - n6;
        float f19 = n21 + n5;
        float f20 = n22 + n5;
        Paint paint2 = this.paint;
        canvas.drawRect(f5, f18, f19, f20, paint2);
    }

    public void onDraw(Canvas canvas) {
        Rect rect = DetectorViewConfig.getInstance().getDetectorRect();
        Rect rect2 = DetectorViewConfig.getInstance().gatherRect;
        if (rect == null) {
            return;
        }
        ViewfinderView viewfinderView = this;
        this.drawNonDetectorArea(canvas, rect, rect2);
        viewfinderView.drawDetectorCorner(canvas, rect);
        if (viewfinderView.running) {
            this.drawLaserLine(canvas, rect);
        } else {
            this.lastRect = rect;
            this.drawLaserLine(canvas, rect);
        }
    }

    public void stopUpdateScreenTimer() {
        if (this.running) {
            Timer timer = this.mUpdateProgressBar;
            if (timer != null) {
                timer.cancel();
                this.mUpdateProgressBar = null;
            }
            this.running = false;
            this.updateScreen();
        }
    }

    public void startUpdateScreenTimer() {
        if (!this.running) {
            this.stopUpdateScreenTimer();
            this.laserY = DetectorViewConfig.getInstance().getDetectorRect().top;
            this.mUpdateProgressBar = new Timer();
            this.mUpdateProgressBar.schedule(new TimerTask(){

                @Override
                public void run() {
                    ViewfinderView.this.updateScreen();
                }
            }, 0L, 10L);
            this.running = true;
        }
    }

    public void drawViewfinder() {
        this.invalidate();
    }

    public void addPossibleResultPoint(ResultPoint resultPoint) {
        this.possibleResultPoints.add(resultPoint);
    }
}

