/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.nativeObj.photoview.subscaleview.decoder;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.dcloud.feature.nativeObj.photoview.subscaleview.SubsamplingScaleImageView;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.ImageRegionDecoder;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SkiaImageRegionDecoder
implements ImageRegionDecoder {
    private static final String FILE_PREFIX = "file://";
    private static final String ASSET_PREFIX = "file:///android_asset/";
    private static final String RESOURCE_PREFIX = "android.resource://";
    private BitmapRegionDecoder decoder;
    private final ReadWriteLock decoderLock;
    private final Bitmap.Config bitmapConfig;

    @Keep
    public SkiaImageRegionDecoder() {
        this(null);
    }

    public SkiaImageRegionDecoder(@Nullable Bitmap.Config config) {
        ReentrantReadWriteLock reentrantReadWriteLock;
        ReentrantReadWriteLock reentrantReadWriteLock2 = reentrantReadWriteLock;
        reentrantReadWriteLock = new ReentrantReadWriteLock(true);
        this.decoderLock = reentrantReadWriteLock2;
        reentrantReadWriteLock2 = SubsamplingScaleImageView.getPreferredBitmapConfig();
        this.bitmapConfig = config != null ? config : (reentrantReadWriteLock2 != null ? reentrantReadWriteLock2 : Bitmap.Config.RGB_565);
    }

    private Lock getDecodeLock() {
        if (Build.VERSION.SDK_INT < 21) {
            return this.decoderLock.writeLock();
        }
        return this.decoderLock.readLock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NonNull
    public Point init(Context object, @NonNull Uri uri) throws Exception {
        String string2 = uri.toString();
        if (string2.startsWith(RESOURCE_PREFIX)) {
            string2 = uri.getAuthority();
            Resources resources = object.getPackageName().equals(string2) ? object.getResources() : object.getPackageManager().getResourcesForApplication(string2);
            int n5 = 0;
            List list = uri.getPathSegments();
            int n6 = list.size();
            if (n6 == 2 && ((String)list.get(0)).equals("drawable")) {
                n5 = resources.getIdentifier((String)list.get(1), "drawable", string2);
            } else if (n6 == 1 && TextUtils.isDigitsOnly((CharSequence)((CharSequence)list.get(0)))) {
                try {
                    n5 = Integer.parseInt((String)list.get(0));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.decoder = BitmapRegionDecoder.newInstance((InputStream)object.getResources().openRawResource(n5), (boolean)false);
            return new Point(this.decoder.getWidth(), this.decoder.getHeight());
        }
        if (string2.startsWith(ASSET_PREFIX)) {
            Object object2 = object;
            object = string2.substring(22);
            this.decoder = BitmapRegionDecoder.newInstance((InputStream)object2.getAssets().open((String)object, 1), (boolean)false);
            return new Point(this.decoder.getWidth(), this.decoder.getHeight());
        }
        if (string2.startsWith(FILE_PREFIX)) {
            this.decoder = BitmapRegionDecoder.newInstance((String)string2.substring(7), (boolean)false);
            return new Point(this.decoder.getWidth(), this.decoder.getHeight());
        }
        Object object3 = object;
        object = null;
        try {
            object = object3.getContentResolver().openInputStream(uri);
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((InputStream)object).close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        this.decoder = BitmapRegionDecoder.newInstance((InputStream)object, (boolean)false);
        if (object == null) return new Point(this.decoder.getWidth(), this.decoder.getHeight());
        try {
            ((InputStream)object).close();
            return new Point(this.decoder.getWidth(), this.decoder.getHeight());
        }
        catch (Exception exception) {}
        return new Point(this.decoder.getWidth(), this.decoder.getHeight());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public Bitmap decodeRegion(@NonNull Rect rect, int n5) {
        Throwable throwable2;
        block6: {
            block5: {
                block7: {
                    BitmapFactory.Options options;
                    SkiaImageRegionDecoder skiaImageRegionDecoder;
                    BitmapRegionDecoder bitmapRegionDecoder;
                    SkiaImageRegionDecoder skiaImageRegionDecoder2 = this;
                    skiaImageRegionDecoder2.getDecodeLock().lock();
                    try {
                        bitmapRegionDecoder = skiaImageRegionDecoder2.decoder;
                        if (bitmapRegionDecoder == null) break block5;
                    }
                    catch (Throwable throwable2) {
                        break block6;
                    }
                    {
                        if (bitmapRegionDecoder.isRecycled()) break block5;
                        skiaImageRegionDecoder = this;
                    }
                    bitmapRegionDecoder = options;
                    {
                        bitmapRegionDecoder();
                        bitmapRegionDecoder.inSampleSize = n5;
                        options.inPreferredConfig = this.bitmapConfig;
                        rect = skiaImageRegionDecoder.decoder.decodeRegion(rect, (BitmapFactory.Options)bitmapRegionDecoder);
                        if (rect == null) break block7;
                        this.getDecodeLock().unlock();
                        return rect;
                    }
                }
                throw new RuntimeException("Skia image decoder returned null bitmap - image format may not be supported");
            }
            throw new IllegalStateException("Cannot decode region after decoder has been recycled");
        }
        this.getDecodeLock().unlock();
        throw throwable2;
    }

    @Override
    public synchronized boolean isReady() {
        SkiaImageRegionDecoder skiaImageRegionDecoder = skiaImageRegionDecoder.decoder;
        return skiaImageRegionDecoder != null && !skiaImageRegionDecoder.isRecycled();
    }

    @Override
    public synchronized void recycle() {
        SkiaImageRegionDecoder skiaImageRegionDecoder = this;
        skiaImageRegionDecoder.decoderLock.writeLock().lock();
        try {
            skiaImageRegionDecoder.decoder.recycle();
            skiaImageRegionDecoder.decoder = null;
            skiaImageRegionDecoder.decoderLock.writeLock().unlock();
            return;
        }
        catch (Throwable throwable) {
            this.decoderLock.writeLock().unlock();
            throw throwable;
        }
    }
}

