/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.sdk.core.util;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Method;

public class ProcessUtil {
    private static String a;

    public static boolean isMainProcess(@NonNull Context context) {
        if (context != null) {
            try {
                return context.getPackageName().equals(ProcessUtil.getCurrentProcessName(context));
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static String getCurrentProcessName(@NonNull Context context) {
        if (!TextUtils.isEmpty((CharSequence)a)) {
            return a;
        }
        a = ProcessUtil.getCurrentProcessNameByApplication();
        if (!TextUtils.isEmpty((CharSequence)a)) {
            return a;
        }
        a = ProcessUtil.getCurrentProcessNameByActivityThread();
        if (!TextUtils.isEmpty((CharSequence)a)) {
            return a;
        }
        a = ProcessUtil.getCurrentProcessNameByActivityManager(context);
        return a;
    }

    public static String getCurrentProcessNameByApplication() {
        if (Build.VERSION.SDK_INT >= 28) {
            return Application.getProcessName();
        }
        return null;
    }

    public static String getCurrentProcessNameByActivityThread() {
        String string2;
        block6: {
            string2 = null;
            String string3 = "android.app.ActivityThread";
            Method method = Class.forName(string3, false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", null);
            Method method2 = method;
            method.setAccessible(true);
            Object object = method2.invoke(null, null);
            if (!(object instanceof String)) break block6;
            try {
                string2 = (String)object;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return string2;
    }

    public static String getCurrentProcessNameByActivityManager(@NonNull Context context) {
        if (context == null) {
            return null;
        }
        int n5 = Process.myPid();
        Object object = (ActivityManager)context.getSystemService("activity");
        if (object != null && (object = object.getRunningAppProcesses()) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                if (runningAppProcessInfo.pid != n5) continue;
                return runningAppProcessInfo.processName;
            }
        }
        return null;
    }
}

