/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.Writer;
import com.dcloud.zxing2.aztec.encoder.AztecCode;
import com.dcloud.zxing2.aztec.encoder.Encoder;
import com.dcloud.zxing2.common.BitMatrix;
import java.nio.charset.Charset;
import java.util.Map;

public final class AztecWriter
implements Writer {
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");

    private static BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6, Charset charset, int n7, int n8) {
        if (barcodeFormat == BarcodeFormat.AZTEC) {
            return AztecWriter.renderResult(Encoder.encode(string2.getBytes(charset), n7, n8), n5, n6);
        }
        throw new IllegalArgumentException("Can only encode AZTEC, but got " + (Object)((Object)barcodeFormat));
    }

    private static BitMatrix renderResult(AztecCode object, int n5, int n6) {
        if ((object = ((AztecCode)object).getMatrix()) != null) {
            BitMatrix bitMatrix;
            int n7 = n6;
            int n8 = n5;
            Object object2 = object;
            n5 = ((BitMatrix)object2).getWidth();
            n6 = ((BitMatrix)object2).getHeight();
            int n9 = Math.max(n8, n5);
            int n10 = Math.max(n7, n6);
            int n11 = Math.min(n9 / n5, n10 / n6);
            int n12 = (n9 - n5 * n11) / 2;
            int n13 = (n10 - n6 * n11) / 2;
            BitMatrix bitMatrix2 = bitMatrix;
            bitMatrix = new BitMatrix(n9, n10);
            n9 = 0;
            while (n9 < n6) {
                n10 = 0;
                int n14 = n12;
                while (n10 < n5) {
                    if (((BitMatrix)object).get(n10, n9)) {
                        int n15 = n11;
                        bitMatrix2.setRegion(n14, n13, n15, n15);
                    }
                    ++n10;
                    n14 += n11;
                }
                ++n9;
                n13 += n11;
            }
            return bitMatrix2;
        }
        throw new IllegalStateException();
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6) {
        return this.encode(string2, barcodeFormat, n5, n6, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6, Map<EncodeHintType, ?> map) {
        Object object = DEFAULT_CHARSET;
        int n7 = 33;
        int n8 = 0;
        if (map != null) {
            EncodeHintType encodeHintType = EncodeHintType.CHARACTER_SET;
            if (map.containsKey((Object)encodeHintType)) {
                object = Charset.forName(map.get((Object)encodeHintType).toString());
            }
            if (map.containsKey((Object)(encodeHintType = EncodeHintType.ERROR_CORRECTION))) {
                n7 = Integer.parseInt(map.get((Object)encodeHintType).toString());
            }
            if (map.containsKey((Object)(encodeHintType = EncodeHintType.AZTEC_LAYERS))) {
                n8 = Integer.parseInt(map.get((Object)encodeHintType).toString());
            }
        }
        return AztecWriter.encode(string2, barcodeFormat, n5, n6, (Charset)object, n7, n8);
    }
}

