/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode;

import android.os.Handler;
import android.os.Message;
import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.BinaryBitmap;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Reader;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultMetadataType;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.DetectorResult;
import com.dcloud.zxing2.qrcode.decoder.Decoder;
import com.dcloud.zxing2.qrcode.decoder.QRCodeDecoderMetaData;
import com.dcloud.zxing2.qrcode.detector.Detector;
import java.util.List;
import java.util.Map;

public class QRCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder;
    private Handler hostHandler;

    public QRCodeReader() {
        Decoder decoder;
        Decoder decoder2 = decoder;
        decoder = new Decoder();
        v1.decoder = decoder2;
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray != null && nArray2 != null) {
            float f5 = QRCodeReader.moduleSize(nArray, bitMatrix);
            int n5 = nArray[1];
            int n6 = nArray2[1];
            int n7 = nArray[0];
            int n8 = nArray2[0];
            if (n7 < n8 && n5 < n6) {
                int n9 = n6 - n5;
                if (n9 != n8 - n7) {
                    n8 = n7 + n9;
                }
                int n10 = Math.round((float)(n8 - n7 + 1) / f5);
                n9 = Math.round((float)(n9 + 1) / f5);
                if (n10 > 0 && n9 > 0) {
                    if (n9 == n10) {
                        BitMatrix bitMatrix2;
                        int n11 = n7;
                        int n12 = n5;
                        n5 = (int)(f5 / 2.0f);
                        n7 = n12 + n5;
                        int n13 = n11 + n5;
                        if ((n8 = n13 + (int)((float)(n10 - 1) * f5) - n8) > 0) {
                            if (n8 <= n5) {
                                n13 -= n8;
                            } else {
                                throw NotFoundException.getNotFoundInstance();
                            }
                        }
                        if ((n8 = n7 + (int)((float)(n9 - 1) * f5) - n6) > 0) {
                            if (n8 <= n5) {
                                n7 -= n8;
                            } else {
                                throw NotFoundException.getNotFoundInstance();
                            }
                        }
                        BitMatrix bitMatrix3 = bitMatrix2;
                        bitMatrix2 = new BitMatrix(n10, n9);
                        for (n5 = 0; n5 < n9; ++n5) {
                            n6 = n7 + (int)((float)n5 * f5);
                            for (int i5 = 0; i5 < n10; ++i5) {
                                if (!bitMatrix.get(n13 + (int)((float)i5 * f5), n6)) continue;
                                bitMatrix3.set(i5, n5);
                            }
                        }
                        return bitMatrix3;
                    }
                    throw NotFoundException.getNotFoundInstance();
                }
                throw NotFoundException.getNotFoundInstance();
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static float moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n5;
        BitMatrix bitMatrix2 = bitMatrix;
        int n6 = bitMatrix2.getHeight();
        int n7 = bitMatrix2.getWidth();
        int n8 = nArray[0];
        boolean bl = true;
        int n9 = 0;
        for (n5 = nArray[1]; n8 < n7 && n5 < n6; ++n8, ++n5) {
            if (bl == bitMatrix.get(n8, n5)) continue;
            if (++n9 == 5) break;
            bl ^= true;
        }
        if (n8 != n7 && n5 != n6) {
            return (float)(n8 - nArray[0]) / 7.0f;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected final Decoder getDecoder() {
        return this.decoder;
    }

    public void updateHandler(Handler handler) {
        this.hostHandler = handler;
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Result decode(BinaryBitmap object, Map<DecodeHintType, ?> object2) throws NotFoundException, ChecksumException, FormatException {
        String string2;
        Result result;
        void var1_5;
        Object object3;
        Result result2;
        Object var3_9 = null;
        if (result2 != null && result2.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            QRCodeReader qRCodeReader = object3;
            object3 = QRCodeReader.extractPureBits(((BinaryBitmap)object).getBlackMatrix());
            object3 = qRCodeReader.decoder.decode((BitMatrix)object3, (Map<DecodeHintType, ?>)((Object)result2));
            ResultPoint[] resultPointArray = NO_POINTS;
        } else {
            void var3_11;
            DetectorResult detectorResult;
            block9: {
                detectorResult = new Detector(((BinaryBitmap)object).getBlackMatrix()).detect((Map<DecodeHintType, ?>)((Object)result2));
                try {
                    DecoderResult decoderResult = ((QRCodeReader)object3).decoder.decode(detectorResult.getBits(), (Map<DecodeHintType, ?>)((Object)result2));
                }
                catch (Exception exception) {
                    Message message;
                    if (((QRCodeReader)object3).hostHandler == null || detectorResult == null) break block9;
                    Object object4 = object3;
                    object3 = message;
                    object3();
                    ((Message)object3).what = 1010;
                    message.obj = Float.valueOf(detectorResult.moduleSize);
                    ((QRCodeReader)object4).hostHandler.sendMessage((Message)object3);
                }
            }
            object3 = var3_11;
            if (object3 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint[] resultPointArray = detectorResult.getPoints();
        }
        if (((DecoderResult)object3).getOther() instanceof QRCodeDecoderMetaData) {
            ((QRCodeDecoderMetaData)((DecoderResult)object3).getOther()).applyMirroredCorrection((ResultPoint[])var1_5);
        }
        result2 = result;
        Object object5 = object3;
        String string3 = ((DecoderResult)object5).getText();
        byte[] byArray = ((DecoderResult)object5).getRawBytes();
        BarcodeFormat barcodeFormat = BarcodeFormat.QR_CODE;
        result2(string3, byArray, (ResultPoint[])var1_5, barcodeFormat);
        result.textCharset = ((DecoderResult)object3).textCharset;
        List<byte[]> list = ((DecoderResult)object3).getByteSegments();
        if (list != null) {
            result2.putMetadata(ResultMetadataType.BYTE_SEGMENTS, list);
        }
        if ((string2 = ((DecoderResult)object3).getECLevel()) != null) {
            result2.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string2);
        }
        if (((DecoderResult)object3).hasStructuredAppend()) {
            Result result3 = result2;
            result3.putMetadata(ResultMetadataType.STRUCTURED_APPEND_SEQUENCE, ((DecoderResult)object3).getStructuredAppendSequenceNumber());
            result3.putMetadata(ResultMetadataType.STRUCTURED_APPEND_PARITY, ((DecoderResult)object3).getStructuredAppendParity());
        }
        return result2;
    }

    @Override
    public void reset() {
    }
}

