/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.decoder;

import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonDecoder;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonException;
import com.dcloud.zxing2.qrcode.decoder.BitMatrixParser;
import com.dcloud.zxing2.qrcode.decoder.DataBlock;
import com.dcloud.zxing2.qrcode.decoder.DecodedBitStreamParser;
import com.dcloud.zxing2.qrcode.decoder.ErrorCorrectionLevel;
import com.dcloud.zxing2.qrcode.decoder.QRCodeDecoderMetaData;
import com.dcloud.zxing2.qrcode.decoder.Version;
import java.util.Map;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.QR_CODE_FIELD_256);

    private DecoderResult decode(BitMatrixParser object, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        BitMatrixParser bitMatrixParser = object;
        object = bitMatrixParser.readVersion();
        ErrorCorrectionLevel errorCorrectionLevel = bitMatrixParser.readFormatInformation().getErrorCorrectionLevel();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(bitMatrixParser.readCodewords(), (Version)object, errorCorrectionLevel);
        int n5 = 0;
        int n6 = dataBlockArray.length;
        for (int i5 = 0; i5 < n6; ++i5) {
            n5 += dataBlockArray[i5].getNumDataCodewords();
        }
        byte[] byArray = new byte[n5];
        n6 = 0;
        for (DataBlock dataBlock : dataBlockArray) {
            byte[] byArray2 = dataBlock.getCodewords();
            int n7 = dataBlock.getNumDataCodewords();
            this.correctErrors(byArray2, n7);
            for (int i6 = 0; i6 < n7; ++i6) {
                int n8 = n6 + 1;
                byArray[n6] = byArray2[i6];
                n6 = n8;
            }
        }
        return DecodedBitStreamParser.decode(byArray, (Version)object, errorCorrectionLevel, map);
    }

    private void correctErrors(byte[] byArray, int n5) throws ChecksumException {
        int n6 = byArray.length;
        int[] nArray = new int[n6];
        for (int i5 = 0; i5 < n6; ++i5) {
            nArray[i5] = byArray[i5] & 0xFF;
        }
        int n7 = byArray.length - n5;
        try {
            this.rsDecoder.decode(nArray, n7);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (n7 = 0; n7 < n5; ++n7) {
            byArray[n7] = (byte)nArray[n7];
        }
        return;
    }

    public DecoderResult decode(boolean[][] blArray) throws ChecksumException, FormatException {
        return this.decode(blArray, null);
    }

    public DecoderResult decode(boolean[][] blArray, Map<DecodeHintType, ?> map) throws ChecksumException, FormatException {
        BitMatrix bitMatrix;
        int n5 = blArray.length;
        BitMatrix bitMatrix2 = bitMatrix;
        bitMatrix = new BitMatrix(n5);
        for (int i5 = 0; i5 < n5; ++i5) {
            for (int i6 = 0; i6 < n5; ++i6) {
                if (!blArray[i5][i6]) continue;
                bitMatrix2.set(i6, i5);
            }
        }
        return this.decode(bitMatrix2, map);
    }

    public DecoderResult decode(BitMatrix bitMatrix) throws ChecksumException, FormatException {
        return this.decode(bitMatrix, null);
    }

    /*
     * WARNING - void declaration
     */
    public DecoderResult decode(BitMatrix bitMatrix, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        QRCodeDecoderMetaData qRCodeDecoderMetaData;
        BitMatrixParser bitMatrixParser;
        BitMatrixParser bitMatrixParser2 = bitMatrixParser;
        bitMatrixParser = new BitMatrixParser(bitMatrix);
        bitMatrix = null;
        Object var4_8 = null;
        try {
            return ((Decoder)((Object)qRCodeDecoderMetaData2)).decode(bitMatrixParser, map);
        }
        catch (ChecksumException checksumException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        Decoder decoder = qRCodeDecoderMetaData2;
        BitMatrixParser bitMatrixParser3 = bitMatrixParser2;
        BitMatrixParser bitMatrixParser4 = bitMatrixParser3;
        BitMatrixParser bitMatrixParser5 = bitMatrixParser3;
        bitMatrixParser3.remask();
        bitMatrixParser3.setMirror(true);
        bitMatrixParser3.readVersion();
        bitMatrixParser5.readFormatInformation();
        bitMatrixParser4.mirror();
        DecoderResult decoderResult = decoder.decode(bitMatrixParser2, map);
        DecoderResult decoderResult2 = decoderResult;
        DecoderResult decoderResult3 = decoderResult;
        QRCodeDecoderMetaData qRCodeDecoderMetaData2 = qRCodeDecoderMetaData;
        try {
            qRCodeDecoderMetaData = new QRCodeDecoderMetaData(true);
            decoderResult2.setOther(qRCodeDecoderMetaData2);
            return decoderResult3;
        }
        catch (ChecksumException checksumException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        if (bitMatrix == null) {
            void var0_3;
            if (var4_8 != null) {
                throw var4_8;
            }
            throw var0_3;
        }
        throw bitMatrix;
    }
}

