/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Address;
import dc.squareup.okhttp3.Route;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.connection.RealConnection;
import dc.squareup.okhttp3.internal.connection.RouteDatabase;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.platform.Platform;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ConnectionPool {
    private static final Executor executor;
    static final /* synthetic */ boolean $assertionsDisabled;
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private final Runnable cleanupRunnable;
    private final Deque<RealConnection> connections;
    final RouteDatabase routeDatabase;
    boolean cleanupRunning;

    public ConnectionPool() {
        ConnectionPool connectionPool = object;
        Object object = TimeUnit.MINUTES;
        connectionPool(5, 5L, (TimeUnit)((Object)object));
    }

    public ConnectionPool(int n5, long l5, TimeUnit timeUnit) {
        this.cleanupRunnable = new Runnable(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                while (true) {
                    long l5;
                    if ((l5 = ConnectionPool.this.cleanup(System.nanoTime())) == -1L) {
                        return;
                    }
                    if (l5 <= 0L) continue;
                    1 v02 = this;
                    long l6 = l5;
                    l5 = l6 / 1000000L;
                    long l7 = l6 - l5 * 1000000L;
                    ConnectionPool connectionPool = v02.ConnectionPool.this;
                    // MONITORENTER : connectionPool
                    try {
                        v02.ConnectionPool.this.wait(l5, (int)l7);
                    }
                    catch (InterruptedException interruptedException) {}
                    // MONITOREXIT : connectionPool
                    continue;
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        };
        this.connections = new ArrayDeque<RealConnection>();
        this.routeDatabase = new RouteDatabase();
        this.maxIdleConnections = n5;
        this.keepAliveDurationNs = timeUnit.toNanos(l5);
        if (l5 > 0L) {
            return;
        }
        throw new IllegalArgumentException("keepAliveDuration <= 0: " + l5);
    }

    private int pruneAndGetAllocationCount(RealConnection realConnection, long l5) {
        List<Reference<StreamAllocation>> list = realConnection.allocations;
        int n5 = 0;
        while (n5 < list.size()) {
            StreamAllocation.StreamAllocationReference streamAllocationReference = list.get(n5);
            if (streamAllocationReference.get() != null) {
                ++n5;
                continue;
            }
            streamAllocationReference = streamAllocationReference;
            Platform.get().logCloseableLeak("A connection to " + realConnection.route().address().url() + " was leaked. Did you forget to close a response body?", streamAllocationReference.callStackTrace);
            list.remove(n5);
            realConnection.noNewStreams = true;
            if (!list.isEmpty()) continue;
            realConnection.idleAtNanos = l5 - this.keepAliveDurationNs;
            return 0;
        }
        return list.size();
    }

    static {
        SynchronousQueue<Runnable> synchronousQueue;
        $assertionsDisabled = ConnectionPool.class.desiredAssertionStatus() ^ true;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        SynchronousQueue<Runnable> synchronousQueue2 = synchronousQueue;
        synchronousQueue = new SynchronousQueue<Runnable>();
        ThreadFactory threadFactory = Util.threadFactory("OkHttp ConnectionPool", true);
        executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, timeUnit, synchronousQueue2, threadFactory);
    }

    public synchronized int idleConnectionCount() {
        int n5 = 0;
        Iterator<RealConnection> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().allocations.isEmpty()) continue;
            ++n5;
        }
        return n5;
    }

    public synchronized int connectionCount() {
        return this.connections.size();
    }

    @Nullable
    RealConnection get(Address address, StreamAllocation streamAllocation, Route route) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        for (RealConnection realConnection : ((ConnectionPool)this).connections) {
            if (!realConnection.isEligible(address, route)) continue;
            streamAllocation.acquire(realConnection, true);
            return realConnection;
        }
        return null;
    }

    @Nullable
    Socket deduplicate(Address address, StreamAllocation streamAllocation) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        for (RealConnection realConnection : ((ConnectionPool)this).connections) {
            if (!realConnection.isEligible(address, null) || !realConnection.isMultiplexed() || realConnection == streamAllocation.connection()) continue;
            return streamAllocation.releaseAndAcquire(realConnection);
        }
        return null;
    }

    void put(RealConnection realConnection) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!this.cleanupRunning) {
            this.cleanupRunning = true;
            executor.execute(this.cleanupRunnable);
        }
        this.connections.add(realConnection);
    }

    boolean connectionBecameIdle(RealConnection realConnection) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!realConnection.noNewStreams && this.maxIdleConnections != 0) {
            this.notifyAll();
            return false;
        }
        this.connections.remove(realConnection);
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void evictAll() {
        v0 = this;
        var1_2 = v1;
        v1 = new ArrayList<RealConnection>();
        synchronized (v0) {
            block9: {
                try {
                    var2_3 = v0.connections.iterator();
lbl7:
                    // 3 sources

                    while (var2_3.hasNext()) {
                        var3_5 = var2_3.next();
                        ** GOTO lbl-1000
                    }
                    break block9;
                }
                catch (Throwable v2) {
                    ** GOTO lbl-1000
                }
lbl-1000:
                // 1 sources

                {
                    if (!var3_5.allocations.isEmpty()) ** GOTO lbl7
                    v3 = var2_3;
                    var3_5.noNewStreams = true;
                    var1_2.add(var3_5);
                }
                v3.remove();
                ** GOTO lbl7
            }
            // ** MonitorExit[this] (shouldn't be in output)
            var0_1 = 0;
            var2_4 = var1_2.size();
            while (true) {
                if (var0_1 >= var2_4) {
                    return;
                }
                v4 = var1_2.get(var0_1);
                ++var0_1;
                Util.closeQuietly(((RealConnection)v4).socket());
            }
lbl-1000:
            // 1 sources

            {
                // ** MonitorExit[this] (shouldn't be in output)
            }
            throw v2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    long cleanup(long l5) {
        RealConnection realConnection;
        block13: {
            int n5;
            block14: {
                ConnectionPool connectionPool = this;
                n5 = 0;
                int n6 = 0;
                realConnection = null;
                long l6 = Long.MIN_VALUE;
                // MONITORENTER : connectionPool
                for (RealConnection realConnection2 : connectionPool.connections) {
                    if (this.pruneAndGetAllocationCount(realConnection2, l5) > 0) {
                        ++n5;
                        continue;
                    }
                    ++n6;
                    long l7 = l5 - realConnection2.idleAtNanos;
                    if (l7 <= l6) continue;
                    l6 = l7;
                    realConnection = realConnection2;
                }
                l5 = this.keepAliveDurationNs;
                if (l6 >= l5) break block13;
                if (n6 > this.maxIdleConnections) break block13;
                if (n6 <= 0) break block14;
                // MONITOREXIT : this
                return l5 - l6;
            }
            if (n5 > 0) {
                // MONITOREXIT : this
                return l5;
            }
            this.cleanupRunning = false;
            // MONITOREXIT : this
            return -1L;
        }
        ConnectionPool connectionPool = this;
        ConnectionPool connectionPool2 = connectionPool;
        connectionPool.connections.remove(realConnection);
        Util.closeQuietly(realConnection.socket());
        return 0L;
    }
}

