/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.tls;

import dc.squareup.okhttp3.internal.tls.TrustRootIndex;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public final class BasicTrustRootIndex
implements TrustRootIndex {
    private final Map<X500Principal, Set<X509Certificate>> subjectToCaCerts;

    public BasicTrustRootIndex(X509Certificate ... x509CertificateArray) {
        LinkedHashMap<X500Principal, Set<X509Certificate>> linkedHashMap;
        LinkedHashMap<X500Principal, Set<X509Certificate>> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<X500Principal, Set<X509Certificate>>();
        this.subjectToCaCerts = linkedHashMap2;
        for (X509Certificate x509Certificate : x509CertificateArray) {
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            LinkedHashSet<X509Certificate> linkedHashSet = this.subjectToCaCerts.get(x500Principal);
            if (linkedHashSet == null) {
                LinkedHashSet<X509Certificate> linkedHashSet2;
                linkedHashSet = linkedHashSet2;
                linkedHashSet2 = new LinkedHashSet<X509Certificate>(1);
                this.subjectToCaCerts.put(x500Principal, linkedHashSet);
            }
            linkedHashSet.add(x509Certificate);
        }
    }

    @Override
    public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
        BasicTrustRootIndex basicTrustRootIndex = object;
        Object object = x509Certificate.getIssuerX500Principal();
        if ((object = basicTrustRootIndex.subjectToCaCerts.get(object)) == null) {
            return null;
        }
        object = object.iterator();
        while (object.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)object.next();
            try {
                x509Certificate.verify(x509Certificate2.getPublicKey());
                return x509Certificate2;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof BasicTrustRootIndex && ((BasicTrustRootIndex)object).subjectToCaCerts.equals(this.subjectToCaCerts);
    }

    public int hashCode() {
        return this.subjectToCaCerts.hashCode();
    }
}

