/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.ws;

import dc.squareup.okhttp3.internal.ws.WebSocketProtocol;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

final class WebSocketReader {
    final boolean isClient;
    final BufferedSource source;
    final FrameCallback frameCallback;
    boolean closed;
    int opcode;
    long frameLength;
    boolean isFinalFrame;
    boolean isControlFrame;
    private final Buffer controlFrameBuffer;
    private final Buffer messageFrameBuffer;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;

    WebSocketReader(boolean bl, BufferedSource object, FrameCallback frameCallback) {
        Buffer buffer;
        Buffer buffer2;
        Buffer buffer3 = buffer2;
        buffer2 = new Buffer();
        this.controlFrameBuffer = buffer3;
        buffer3 = buffer;
        buffer = new Buffer();
        this.messageFrameBuffer = buffer3;
        if (object != null) {
            if (frameCallback != null) {
                Buffer.UnsafeCursor unsafeCursor;
                WebSocketReader webSocketReader = this;
                webSocketReader.isClient = bl;
                webSocketReader.source = object;
                webSocketReader.frameCallback = frameCallback;
                object = bl ? null : (Object)new byte[4];
                this.maskKey = (byte[])object;
                if (bl) {
                    unsafeCursor = null;
                } else {
                    Buffer.UnsafeCursor unsafeCursor2;
                    unsafeCursor = unsafeCursor2;
                    unsafeCursor2 = new Buffer.UnsafeCursor();
                }
                this.maskCursor = unsafeCursor;
                return;
            }
            throw new NullPointerException("frameCallback == null");
        }
        throw new NullPointerException("source == null");
    }

    private void readHeader() throws IOException {
        if (!((WebSocketReader)((Object)string2)).closed) {
            byte by;
            long l5 = ((WebSocketReader)((Object)string2)).source.timeout().timeoutNanos();
            ((WebSocketReader)((Object)string2)).source.timeout().clearTimeout();
            try {
                by = ((WebSocketReader)((Object)string2)).source.readByte();
                ((WebSocketReader)((Object)string2)).source.timeout().timeout(l5, TimeUnit.NANOSECONDS);
            }
            catch (Throwable throwable) {
                ((WebSocketReader)((Object)string2)).source.timeout().timeout(l5, TimeUnit.NANOSECONDS);
                throw throwable;
            }
            ((WebSocketReader)((Object)string2)).opcode = by & 0xF;
            byte by2 = (by & 0x80) != 0 ? (byte)1 : 0;
            ((WebSocketReader)((Object)string2)).isFinalFrame = by2;
            boolean bl = (by & 8) != 0;
            ((WebSocketReader)((Object)string2)).isControlFrame = bl;
            if (bl && by2 == 0) {
                throw new ProtocolException("Control frames must be final.");
            }
            by2 = (by & 0x40) != 0 ? (byte)1 : 0;
            bl = (by & 0x20) != 0;
            by = (by & 0x10) != 0 ? (byte)1 : 0;
            if (by2 == 0 && !bl && by == 0) {
                long l6;
                by2 = ((WebSocketReader)((Object)string2)).source.readByte();
                bl = (by2 & 0x80) != 0;
                if (bl == ((WebSocketReader)((Object)string2)).isClient) {
                    ProtocolException protocolException;
                    String string2 = ((WebSocketReader)((Object)string2)).isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.";
                    ProtocolException protocolException2 = protocolException;
                    protocolException2(string2);
                    throw protocolException2;
                }
                ((WebSocketReader)((Object)string2)).frameLength = l6 = (long)(by2 & 0x7F);
                if (l6 == 126L) {
                    ((WebSocketReader)((Object)string2)).frameLength = l6 = (long)((WebSocketReader)((Object)string2)).source.readShort() & 0xFFFFL;
                } else if (l6 == 127L) {
                    ((WebSocketReader)((Object)string2)).frameLength = l6 = ((WebSocketReader)((Object)string2)).source.readLong();
                    if (l6 < 0L) {
                        throw new ProtocolException("Frame length 0x" + Long.toHexString(((WebSocketReader)((Object)string2)).frameLength) + " > 0x7FFFFFFFFFFFFFFF");
                    }
                }
                if (((WebSocketReader)((Object)string2)).isControlFrame && ((WebSocketReader)((Object)string2)).frameLength > 125L) {
                    throw new ProtocolException("Control frame must be less than 125B.");
                }
                if (bl) {
                    ((WebSocketReader)((Object)string2)).source.readFully(((WebSocketReader)((Object)string2)).maskKey);
                    return;
                }
                return;
            }
            throw new ProtocolException("Reserved flags are unsupported.");
        }
        throw new IOException("closed");
    }

    private void readControlFrame() throws IOException {
        long l5 = this.frameLength;
        if (l5 > 0L) {
            this.source.readFully(this.controlFrameBuffer, l5);
            if (!this.isClient) {
                this.controlFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                this.maskCursor.seek(0L);
                WebSocketProtocol.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        }
        switch (this.opcode) {
            default: {
                throw new ProtocolException("Unknown control opcode: " + Integer.toHexString(this.opcode));
            }
            case 10: {
                this.frameCallback.onReadPong(this.controlFrameBuffer.readByteString());
                return;
            }
            case 9: {
                this.frameCallback.onReadPing(this.controlFrameBuffer.readByteString());
                return;
            }
            case 8: 
        }
        int n5 = 1005;
        String string2 = "";
        long l6 = this.controlFrameBuffer.size();
        if (l6 != 1L) {
            if (l6 != 0L) {
                short s5 = this.controlFrameBuffer.readShort();
                n5 = s5;
                string2 = this.controlFrameBuffer.readUtf8();
                String string3 = WebSocketProtocol.closeCodeExceptionMessage(s5);
                if (string3 != null) {
                    throw new ProtocolException(string3);
                }
            }
            this.frameCallback.onReadClose(n5, string2);
            this.closed = true;
            return;
        }
        throw new ProtocolException("Malformed close payload length of 1.");
    }

    private void readMessageFrame() throws IOException {
        int n5 = this.opcode;
        if (n5 != 1 && n5 != 2) {
            throw new ProtocolException("Unknown opcode: " + Integer.toHexString(n5));
        }
        this.readMessage();
        if (n5 == 1) {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readUtf8());
            return;
        }
        this.frameCallback.onReadMessage(this.messageFrameBuffer.readByteString());
    }

    private void readUntilNonControlFrame() throws IOException {
        while (!this.closed) {
            WebSocketReader webSocketReader = this;
            webSocketReader.readHeader();
            if (!webSocketReader.isControlFrame) break;
            this.readControlFrame();
        }
    }

    private void readMessage() throws IOException {
        while (!this.closed) {
            long l5 = this.frameLength;
            if (l5 > 0L) {
                WebSocketReader webSocketReader = this;
                webSocketReader.source.readFully(this.messageFrameBuffer, l5);
                if (!webSocketReader.isClient) {
                    WebSocketReader webSocketReader2 = this;
                    webSocketReader2.messageFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                    webSocketReader2.maskCursor.seek(this.messageFrameBuffer.size() - this.frameLength);
                    WebSocketProtocol.toggleMask(webSocketReader2.maskCursor, this.maskKey);
                    webSocketReader2.maskCursor.close();
                }
            }
            if (this.isFinalFrame) {
                return;
            }
            WebSocketReader webSocketReader = this;
            webSocketReader.readUntilNonControlFrame();
            if (webSocketReader.opcode == 0) continue;
            throw new ProtocolException("Expected continuation opcode. Got: " + Integer.toHexString(this.opcode));
        }
        throw new IOException("closed");
    }

    void processNextFrame() throws IOException {
        WebSocketReader webSocketReader = this;
        webSocketReader.readHeader();
        if (webSocketReader.isControlFrame) {
            this.readControlFrame();
            return;
        }
        this.readMessageFrame();
    }

    public static interface FrameCallback {
        public void onReadMessage(String var1) throws IOException;

        public void onReadMessage(ByteString var1) throws IOException;

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);

        public void onReadClose(int var1, String var2);
    }
}

