/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.camera;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.feature.barcode2.camera.CameraManager;
import io.dcloud.feature.barcode2.view.DetectorViewConfig;
import java.util.regex.Pattern;

final class CameraConfigurationManager {
    private static final String TAG = "CameraConfigurationManager";
    private static final int TEN_DESIRED_ZOOM = 27;
    private static final int DESIRED_SHARPNESS = 30;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private final Context context;
    private Point cameraResolution;
    private int previewFormat;
    private String previewFormatString;
    private Camera.Parameters parameters;

    CameraConfigurationManager(Context context) {
        this.context = context;
    }

    public static Point getCameraResolution(Camera.Parameters parameters, Point point) {
        String string2 = parameters.get("preview-size-values");
        if (string2 == null) {
            string2 = parameters.get("preview-size-value");
        }
        parameters = null;
        if (string2 != null) {
            Logger.i(TAG, "preview-size-values parameter: " + string2);
            parameters = CameraConfigurationManager.findBestPreviewSizeValue(string2, point);
        }
        if (parameters == null) {
            return new Point(point.x >> 3 << 3, point.y >> 3 << 3);
        }
        return parameters;
    }

    private static Point findBestPreviewSizeValue0(CharSequence stringArray, Point point) {
        int n5 = 0;
        int n6 = 0;
        stringArray = COMMA_PATTERN.split((CharSequence)stringArray);
        int n7 = 0;
        for (int i5 = 0; i5 < stringArray.length; ++i5) {
            String string2 = (n7 != 0 && n7 != 1 ? stringArray[stringArray.length - 1 - i5] : stringArray[i5]).trim();
            int n8 = string2.indexOf(120);
            if (n8 < 0) {
                Log.w((String)TAG, (String)("Bad preview-size: " + string2));
                continue;
            }
            int n9 = n7;
            String string3 = string2;
            int n10 = n8;
            n8 = Integer.parseInt(string2.substring(0, n8));
            try {
                n6 = Integer.parseInt(string3.substring(n10 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)TAG, (String)("Bad preview-size: " + string2));
            }
            if (n9 != 0) {
                if (n5 > 0 && n8 <= point.y && n6 <= point.x) {
                    n5 = n8;
                    break;
                }
            } else if (n5 != 0) {
                if (n8 > n5) {
                    n5 = -1;
                    i5 = -1;
                    n6 = 0;
                    n7 = 0;
                    int n11 = n5;
                    int n12 = n6;
                    n6 = n7;
                    n5 = n12;
                    n7 = n11;
                    continue;
                }
                n5 = 1;
                i5 = -1;
                n6 = 0;
                n7 = 0;
                int n13 = n5;
                int n14 = n6;
                n6 = n7;
                n5 = n14;
                n7 = n13;
                continue;
            }
            n5 = n8;
            continue;
        }
        if (n5 > 0 && n6 > 0) {
            return new Point(n5, n6);
        }
        return null;
    }

    private static Point findBestPreviewSizeValue(CharSequence stringArray, Point point) {
        int n5 = 0;
        int n6 = 0;
        int n7 = Integer.MAX_VALUE;
        stringArray = COMMA_PATTERN.split((CharSequence)stringArray);
        int n8 = stringArray.length;
        for (int i5 = 0; i5 < n8; ++i5) {
            int n9;
            String string2 = stringArray[i5].trim();
            int n10 = string2.indexOf(120);
            if (n10 < 0) {
                Log.w((String)TAG, (String)("Bad preview-size: " + string2));
                continue;
            }
            int n11 = Integer.parseInt(string2.substring(0, n10));
            try {
                n9 = Integer.parseInt(string2.substring(n10 + 1));
                if (n11 < n9) continue;
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)TAG, (String)("Bad preview-size: " + string2));
            }
            n10 = Math.abs(n11 - point.x) + Math.abs(n9 - point.y);
            if (n10 == 0) {
                n6 = n9;
                n5 = n11;
                break;
            }
            if (n10 >= n7) continue;
            n6 = n9;
            n5 = n11;
            n7 = n10;
            continue;
        }
        if (n5 > 0 && n6 > 0) {
            return new Point(n5, n6);
        }
        return null;
    }

    private static int findBestMotZoomValue(CharSequence stringArray, int n5) {
        int n6 = 0;
        stringArray = COMMA_PATTERN.split((CharSequence)stringArray);
        int n7 = stringArray.length;
        for (int i5 = 0; i5 < n7; ++i5) {
            double d6;
            try {
                d6 = Double.parseDouble(stringArray[i5].trim());
            }
            catch (NumberFormatException numberFormatException) {
                return n5;
            }
            int n8 = (int)(d6 * 10.0);
            if (!(Math.abs((double)n5 - d6) < (double)Math.abs(n5 - n6))) continue;
            n6 = n8;
        }
        return n6;
    }

    private void setFlash(Camera.Parameters parameters) {
        if (Build.MODEL.contains("Behold II") && CameraManager.SDK_INT == 3) {
            parameters.set("flash-value", 1);
        } else {
            parameters.set("flash-value", 2);
        }
        parameters.set("flash-mode", "off");
    }

    private void setZoom(Camera.Parameters parameters) {
        String string2 = parameters.get("zoom-supported");
        if (string2 == null || Boolean.parseBoolean(string2)) {
            String string3;
            String string4;
            String string5;
            int n5;
            block16: {
                String string6;
                n5 = 27;
                string5 = parameters.get("max-zoom");
                if (string5 != null) {
                    double d6 = 10.0;
                    try {
                        int n6 = (int)(Double.parseDouble(string5) * d6);
                        if (n5 > n6) {
                            n5 = n6;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.w((String)TAG, (String)("Bad max-zoom: " + string5));
                    }
                }
                if ((string4 = parameters.get("taking-picture-zoom-max")) != null) {
                    try {
                        int n7 = Integer.parseInt(string4);
                        if (n5 > n7) {
                            n5 = n7;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.w((String)TAG, (String)("Bad taking-picture-zoom-max: " + string4));
                    }
                }
                if ((string3 = parameters.get("mot-zoom-values")) != null) {
                    n5 = CameraConfigurationManager.findBestMotZoomValue(string3, n5);
                }
                if ((string6 = parameters.get("mot-zoom-step")) != null) {
                    int n8;
                    try {
                        n8 = (int)(Double.parseDouble(string6.trim()) * 10.0);
                        if (n8 <= 1) break block16;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    int n9 = n5;
                    n5 = n9 - n9 % n8;
                }
            }
            if (string5 != null || string3 != null) {
                parameters.set("zoom", String.valueOf((double)n5 / 10.0));
            }
            if (string4 != null) {
                parameters.set("taking-picture-zoom", n5);
            }
        }
    }

    private void setSharpness(Camera.Parameters parameters) {
        int n5 = 30;
        String string2 = parameters.get("sharpness-max");
        if (string2 != null) {
            try {
                int n6 = Integer.parseInt(string2);
                if (n5 > n6) {
                    n5 = n6;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.w((String)TAG, (String)("Bad sharpness-max: " + string2));
            }
        }
        parameters.set("sharpness", n5);
    }

    void initFromCameraParameters(Camera camera) {
        if (this.parameters == null) {
            this.parameters = camera.getParameters();
        }
        CameraConfigurationManager cameraConfigurationManager = this;
        cameraConfigurationManager.previewFormat = cameraConfigurationManager.parameters.getPreviewFormat();
        cameraConfigurationManager.previewFormatString = cameraConfigurationManager.parameters.get("preview-format");
        Log.d((String)TAG, (String)("Default preview format: " + this.previewFormat + '/' + this.previewFormatString));
        Rect rect = DetectorViewConfig.getInstance().gatherRect;
        int n5 = rect.width();
        int n6 = rect.height();
        if (cameraConfigurationManager.context.getResources().getConfiguration().orientation == 1) {
            this.cameraResolution = CameraConfigurationManager.getCameraResolution(this.parameters, new Point(n6, n5));
            return;
        }
        this.cameraResolution = CameraConfigurationManager.getCameraResolution(this.parameters, new Point(n5, n6));
    }

    void setDesiredCameraParameters(Camera camera) {
        if (this.parameters == null) {
            this.parameters = camera.getParameters();
        }
        CameraConfigurationManager cameraConfigurationManager = this;
        Log.d((String)TAG, (String)("Setting preview size: " + this.cameraResolution));
        Point point = this.cameraResolution;
        int n5 = point.x;
        cameraConfigurationManager.parameters.setPreviewSize(n5, point.y);
        cameraConfigurationManager.setFlash(cameraConfigurationManager.parameters);
        cameraConfigurationManager.setZoom(cameraConfigurationManager.parameters);
        try {
            camera.setParameters(cameraConfigurationManager.parameters);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    int getPreviewFormat() {
        return this.previewFormat;
    }

    String getPreviewFormatString() {
        return this.previewFormatString;
    }
}

