/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.decoding;

import android.content.Intent;
import android.net.Uri;
import com.dcloud.zxing2.BarcodeFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

final class DecodeFormatManager {
    private static final Pattern COMMA_PATTERN;
    static final Vector<BarcodeFormat> PRODUCT_FORMATS;
    static final Vector<BarcodeFormat> ONE_D_FORMATS;
    static final Vector<BarcodeFormat> QR_CODE_FORMATS;
    static final Vector<BarcodeFormat> DATA_MATRIX_FORMATS;

    private DecodeFormatManager() {
    }

    static Vector<BarcodeFormat> parseDecodeFormats(Intent intent) {
        List<String> list = null;
        String string2 = intent.getStringExtra("SCAN_FORMATS");
        if (string2 != null) {
            list = Arrays.asList(COMMA_PATTERN.split(string2));
        }
        return DecodeFormatManager.parseDecodeFormats(list, intent.getStringExtra("SCAN_MODE"));
    }

    static Vector<BarcodeFormat> parseDecodeFormats(Uri uri) {
        List<String> list = uri.getQueryParameters("SCAN_FORMATS");
        if (list != null && list.size() == 1 && list.get(0) != null) {
            list = Arrays.asList(COMMA_PATTERN.split((CharSequence)list.get(0)));
        }
        return DecodeFormatManager.parseDecodeFormats((Iterable<String>)list, uri.getQueryParameter("SCAN_MODE"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Vector<BarcodeFormat> parseDecodeFormats(Iterable<String> vector, String string2) {
        Iterator iterator;
        block9: {
            if (vector != null) {
                Vector<BarcodeFormat> vector2;
                Vector<BarcodeFormat> vector3 = vector;
                vector = vector2;
                vector2 = new Vector<BarcodeFormat>();
                try {
                    iterator = vector3.iterator();
                    break block9;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (string2 != null) {
                if ("PRODUCT_MODE".equals(string2)) {
                    return PRODUCT_FORMATS;
                }
                if ("QR_CODE_MODE".equals(string2)) {
                    return QR_CODE_FORMATS;
                }
                if ("DATA_MATRIX_MODE".equals(string2)) {
                    return DATA_MATRIX_FORMATS;
                }
                if ("ONE_D_MODE".equals(string2)) {
                    return ONE_D_FORMATS;
                }
            }
            return null;
        }
        while (iterator.hasNext()) {
            vector.add(BarcodeFormat.valueOf((String)iterator.next()));
        }
        return vector;
    }

    static {
        Vector<BarcodeFormat> vector;
        COMMA_PATTERN = Pattern.compile(",");
        Vector<BarcodeFormat> vector2 = vector;
        PRODUCT_FORMATS = new Vector<BarcodeFormat>(5);
        vector2.add(BarcodeFormat.UPC_A);
        vector2.add(BarcodeFormat.UPC_E);
        vector2.add(BarcodeFormat.EAN_13);
        vector2.add(BarcodeFormat.EAN_8);
        vector2.add(BarcodeFormat.RSS_14);
        ONE_D_FORMATS = new Vector<BarcodeFormat>(vector2.size() + 4);
        ONE_D_FORMATS.addAll(vector2);
        ONE_D_FORMATS.add(BarcodeFormat.CODE_39);
        ONE_D_FORMATS.add(BarcodeFormat.CODE_93);
        ONE_D_FORMATS.add(BarcodeFormat.CODE_128);
        ONE_D_FORMATS.add(BarcodeFormat.ITF);
        QR_CODE_FORMATS = new Vector<BarcodeFormat>(1);
        QR_CODE_FORMATS.add(BarcodeFormat.QR_CODE);
        DATA_MATRIX_FORMATS = new Vector<BarcodeFormat>(1);
        DATA_MATRIX_FORMATS.add(BarcodeFormat.DATA_MATRIX);
    }
}

