/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget.toast;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.view.View;
import android.widget.Toast;
import com.dcloud.android.widget.toast.SafeToastContext;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

public final class ToastCompat
extends Toast {
    private final Toast toast;

    public ToastCompat(Context context) {
        super(context);
        this.toast = this;
    }

    private ToastCompat(Context context, Toast toast) {
        super(context);
        this.toast = toast;
    }

    public static ToastCompat makeText(Context context, CharSequence charSequence, int n5) {
        charSequence = Toast.makeText((Context)context, (CharSequence)charSequence, (int)n5);
        ToastCompat.setContextCompat(charSequence.getView(), (Context)new SafeToastContext(context));
        return new ToastCompat(context, (Toast)charSequence);
    }

    public static ToastCompat makeText(Context context, int n5, int n6) throws Resources.NotFoundException {
        Context context2 = context;
        return ToastCompat.makeText(context2, context2.getResources().getText(n5), n6);
    }

    private static void setContextCompat(View view, Context context) {
        if (Build.VERSION.SDK_INT == 25) {
            Field field;
            try {
                field = View.class.getDeclaredField("mContext");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            ((AccessibleObject)field).setAccessible(true);
            field.set(view, context);
            return;
        }
    }

    public void show() {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            super.show();
            return;
        }
        toast.show();
    }

    public void setDuration(int n5) {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            super.setDuration(n5);
            return;
        }
        toast.setDuration(n5);
    }

    public void setGravity(int n5, int n6, int n7) {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            super.setGravity(n5, n6, n7);
            return;
        }
        toast.setGravity(n5, n6, n7);
    }

    public void setMargin(float f5, float f6) {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            super.setMargin(f5, f6);
            return;
        }
        toast.setMargin(f5, f6);
    }

    public void setText(int n5) {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            super.setText(n5);
            return;
        }
        toast.setText(n5);
    }

    public void setText(CharSequence charSequence) {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            super.setText(charSequence);
            return;
        }
        toast.setText(charSequence);
    }

    public void setView(View view) {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            super.setView(view);
        } else {
            toast.setView(view);
        }
        ToastCompat.setContextCompat(view, (Context)new SafeToastContext(view.getContext()));
    }

    public float getHorizontalMargin() {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            return super.getHorizontalMargin();
        }
        return toast.getHorizontalMargin();
    }

    public float getVerticalMargin() {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            return super.getVerticalMargin();
        }
        return toast.getVerticalMargin();
    }

    public int getDuration() {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            return super.getDuration();
        }
        return toast.getDuration();
    }

    public int getGravity() {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            return super.getGravity();
        }
        return toast.getGravity();
    }

    public int getXOffset() {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            return super.getXOffset();
        }
        return toast.getXOffset();
    }

    public int getYOffset() {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            return super.getYOffset();
        }
        return toast.getYOffset();
    }

    public View getView() {
        Toast toast = this.toast;
        if (toast instanceof ToastCompat) {
            return super.getView();
        }
        return toast.getView();
    }

    public Toast getBaseToast() {
        return this.toast;
    }
}

