/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.common.WXRuntimeException;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.basic.WXBasicComponent;
import com.taobao.weex.ui.flat.widget.Widget;
import com.taobao.weex.ui.flat.widget.WidgetGroup;
import com.taobao.weex.ui.view.WXFrameLayout;
import com.taobao.weex.ui.view.border.BorderDrawable;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.atomic.AtomicInteger;

public class WXViewUtils {
    @Deprecated
    public static final int TRANSLUCENT = -3;
    @Deprecated
    public static final int TRANSPARENT = -2;
    @Deprecated
    public static final int OPAQUE = -1;
    public static final int DIMENSION_UNSET = -1;
    private static final boolean mUseWebPx = false;
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);
    private static int mScreenWidth;
    private static int mScreenHeight;

    @SuppressLint(value={"NewApi"})
    public static int generateViewId() {
        if (Build.VERSION.SDK_INT < 17) {
            int n;
            int n2;
            AtomicInteger atomicInteger;
            do {
                if ((n = (n2 = (atomicInteger = sNextGeneratedId).get()) + 1) <= 0xFFFFFF) continue;
                n = 1;
            } while (!atomicInteger.compareAndSet(n2, n));
            return n2;
        }
        return View.generateViewId();
    }

    public static int getWeexHeight(String object) {
        object = WXSDKManager.getInstance().getSDKInstance((String)object);
        if (object != null) {
            int n = ((WXSDKInstance)object).getWeexHeight();
            if (n < 0 && n != -2) {
                return WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
            }
            return n;
        }
        return -3;
    }

    public static int getWeexWidth(String object) {
        object = WXSDKManager.getInstance().getSDKInstance((String)object);
        if (object != null) {
            int n = ((WXSDKInstance)object).getWeexWidth();
            if (n < 0 && n != -2) {
                return WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication);
            }
            return n;
        }
        return -3;
    }

    @Deprecated
    public static int getScreenWidth() {
        return WXViewUtils.getScreenWidth((Context)WXEnvironment.sApplication);
    }

    @Deprecated
    public static int setScreenWidth(int n) {
        mScreenWidth = n;
        return mScreenWidth;
    }

    public static float getScreenDensity(Context context) {
        if (context != null) {
            try {
                return context.getResources().getDisplayMetrics().density;
            }
            catch (Exception exception) {
                WXLogUtils.e("getScreenDensityDpi exception:" + exception.getMessage());
            }
        }
        return 3.0f;
    }

    public static void updateApplicationScreen(Context context) {
        if (context != null && WXEnvironment.sApplication != null) {
            context = context.getResources().getDisplayMetrics();
            DisplayMetrics displayMetrics = WXEnvironment.sApplication.getResources().getDisplayMetrics();
            displayMetrics.heightPixels = context.heightPixels;
            displayMetrics.widthPixels = context.widthPixels;
            displayMetrics.density = context.density;
            displayMetrics.densityDpi = context.densityDpi;
            displayMetrics.scaledDensity = context.scaledDensity;
            WXEnvironment.sApplication.getResources().getDisplayMetrics().xdpi = context.xdpi;
            return;
        }
    }

    public static int getScreenWidth(Context context) {
        block8: {
            block7: {
                block6: {
                    if (context == null) break block6;
                    context = context.getResources();
                    mScreenWidth = context.getDisplayMetrics().widthPixels;
                    if (WXEnvironment.SETTING_FORCE_VERTICAL_SCREEN) {
                        int n;
                        mScreenHeight = n = context.getDisplayMetrics().heightPixels;
                        int n2 = mScreenWidth;
                        if (n > n2) {
                            n = n2;
                        }
                        mScreenWidth = n;
                    }
                    break block7;
                }
                if (WXEnvironment.isApkDebugable()) break block8;
            }
            return mScreenWidth;
        }
        throw new WXRuntimeException("Error Context is null When getScreenHeight");
    }

    public static int getStatusBarHeight(Context context) {
        int n = (context = context.getResources()).getIdentifier("status_bar_height", "dimen", "android");
        if (n > 0) {
            return context.getDimensionPixelSize(n);
        }
        return -1;
    }

    @Deprecated
    public static int getScreenHeight() {
        return WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
    }

    public static int getScreenHeight(String string2) {
        if (WXSDKManager.getInstance().getSDKInstance(string2).isFullScreenHeightEnabled()) {
            return WXViewUtils.getFullScreenHeight((Context)WXEnvironment.sApplication);
        }
        return WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication);
    }

    public static int getFullScreenHeight(Context context) {
        block10: {
            block9: {
                block8: {
                    WindowManager windowManager;
                    if (context == null) break block8;
                    Resources resources = context.getResources();
                    if (Build.VERSION.SDK_INT >= 17 && (windowManager = (WindowManager)context.getSystemService("window")) != null && windowManager.getDefaultDisplay() != null) {
                        Point point;
                        context = point;
                        context();
                        windowManager.getDefaultDisplay().getRealSize((Point)context);
                        mScreenHeight = point.y;
                    } else {
                        mScreenHeight = context.getResources().getDisplayMetrics().heightPixels;
                    }
                    if (WXEnvironment.SETTING_FORCE_VERTICAL_SCREEN) {
                        int n;
                        mScreenWidth = n = resources.getDisplayMetrics().widthPixels;
                        int n2 = mScreenHeight;
                        if (n2 > n) {
                            n = n2;
                        }
                        mScreenHeight = n;
                    }
                    break block9;
                }
                if (WXEnvironment.isApkDebugable()) break block10;
            }
            return mScreenHeight;
        }
        throw new WXRuntimeException("Error Context is null When getScreenHeight");
    }

    public static int getScreenHeight(Context context) {
        block8: {
            block7: {
                block6: {
                    if (context == null) break block6;
                    context = context.getResources();
                    mScreenHeight = context.getDisplayMetrics().heightPixels;
                    if (WXEnvironment.SETTING_FORCE_VERTICAL_SCREEN) {
                        int n;
                        mScreenWidth = n = context.getDisplayMetrics().widthPixels;
                        int n2 = mScreenHeight;
                        if (n2 > n) {
                            n = n2;
                        }
                        mScreenHeight = n;
                    }
                    break block7;
                }
                if (WXEnvironment.isApkDebugable()) break block8;
            }
            return mScreenHeight;
        }
        throw new WXRuntimeException("Error Context is null When getScreenHeight");
    }

    @Deprecated
    public static float getRealPxByWidth(float f) {
        return WXViewUtils.realPxByWidth(f, 750.0f);
    }

    public static float getRealPxByWidth(float f, float f2) {
        return WXViewUtils.realPxByWidth(f, f2);
    }

    public static float getRealPxByWidth(float f, int n) {
        return WXViewUtils.realPxByWidth(f, n);
    }

    private static float realPxByWidth(float f, float f2) {
        double d;
        if (Float.isNaN(f)) {
            return f;
        }
        f = f * (float)WXViewUtils.getScreenWidth() / f2;
        double d2 = f;
        if (d > 0.005 && f < 1.0f) {
            return 1.0f;
        }
        return (float)Math.rint(d2);
    }

    @Deprecated
    public static float getRealSubPxByWidth(float f) {
        return WXViewUtils.realSubPxByWidth(f, 750.0f);
    }

    public static float getRealSubPxByWidth(float f, float f2) {
        return WXViewUtils.realSubPxByWidth(f, f2);
    }

    public static float getRealSubPxByWidth(float f, int n) {
        return WXViewUtils.realSubPxByWidth(f, n);
    }

    private static float realSubPxByWidth(float f, float f2) {
        float f3;
        if (Float.isNaN(f)) {
            return f;
        }
        f = f * (float)WXViewUtils.getScreenWidth() / f2;
        if ((double)f3 > 0.005 && f < 1.0f) {
            return 1.0f;
        }
        return f;
    }

    @Deprecated
    public static float getWeexPxByReal(float f) {
        return WXViewUtils.weexPxByReal(f, 750.0f);
    }

    public static float getWeexPxByReal(float f, float f2) {
        return WXViewUtils.weexPxByReal(f, f2);
    }

    public static float getWeexPxByReal(float f, int n) {
        return WXViewUtils.weexPxByReal(f, n);
    }

    private static float weexPxByReal(float f, float f2) {
        if (Float.isNaN(f)) {
            return f;
        }
        return f * f2 / (float)WXViewUtils.getScreenWidth();
    }

    @Deprecated
    public static float getRealPxByWidth2(float f) {
        return WXViewUtils.realPxByWidth2(f, 750.0f);
    }

    public static int getRealPxByWidth2(float f, float f2) {
        return WXViewUtils.realPxByWidth2(f, f2);
    }

    public static int getRealPxByWidth2(float f, int n) {
        return WXViewUtils.realPxByWidth2(f, n);
    }

    private static int realPxByWidth2(float f, float f2) {
        float f3;
        f = f * (float)WXViewUtils.getScreenWidth() / f2;
        if ((double)f3 > 0.005 && f < 1.0f) {
            return 1;
        }
        return (int)f - 1;
    }

    @Deprecated
    public static float getWebPxByWidth(float f) {
        return WXViewUtils.webPxByWidth(f, 750.0f);
    }

    public static float getWebPxByWidth(float f, float f2) {
        return WXViewUtils.webPxByWidth(f, f2);
    }

    public static float getWebPxByWidth(float f, int n) {
        return WXViewUtils.webPxByWidth(f, n);
    }

    private static float webPxByWidth(float f, float f2) {
        float f3;
        double d;
        double d2 = f;
        if (d < -1.9999 && d2 > -2.005) {
            return Float.NaN;
        }
        f = f * f2 / (float)WXViewUtils.getScreenWidth();
        if ((double)f3 > 0.005 && f < 1.0f) {
            return 1.0f;
        }
        return f;
    }

    public static int dip2px(float f) {
        float f2;
        float f3 = 2.0f;
        try {
            f3 = WXEnvironment.getApplication().getResources().getDisplayMetrics().density;
        }
        catch (Exception exception) {
            WXLogUtils.e("[WXViewUtils] dip2px:", exception);
        }
        f = f * f3 + 0.5f;
        return f2 > 0.0f && f < 1.0f ? 1 : (int)f;
    }

    public static boolean onScreenArea(View view) {
        if (view != null && view.getVisibility() == 0) {
            View view2 = view;
            int[] nArray = new int[2];
            view2.getLocationOnScreen(nArray);
            ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
            int n = layoutParams != null ? layoutParams.height : view.getHeight();
            int n2 = nArray[1];
            return n2 > 0 && n2 - WXViewUtils.getScreenHeight((Context)WXEnvironment.sApplication) < 0 || n + (n = nArray[1]) > 0 && n <= 0;
        }
        return false;
    }

    public static int multiplyColorAlpha(int n, int n2) {
        if (n2 == 255) {
            return n;
        }
        if (n2 == 0) {
            return n & 0xFFFFFF;
        }
        int n3 = n2;
        n2 = n3 + (n3 >> 7);
        return (n >>> 24) * n2 >> 8 << 24 | n & 0xFFFFFF;
    }

    public static int getOpacityFromColor(int n) {
        if ((n >>>= 24) == 255) {
            return -1;
        }
        if (n == 0) {
            return -2;
        }
        return -3;
    }

    public static void setBackGround(View object, Drawable drawable2, WXComponent wXComponent) {
        if (Build.VERSION.SDK_INT < 16) {
            object.setBackgroundDrawable(drawable2);
            return;
        }
        try {
            object.setBackground(drawable2);
            return;
        }
        catch (Exception exception) {
            if (wXComponent == null) {
                return;
            }
            object = WXErrorCode.WX_RENDER_ERR_TEXTURE_SETBACKGROUND;
            WXExceptionUtils.commitCriticalExceptionRT(wXComponent.getInstanceId(), (WXErrorCode)((Object)object), wXComponent.getComponentType() + " setBackGround for android view", ((WXErrorCode)((Object)object)).getErrorMsg() + ": TextureView doesn't support displaying a background drawable!", null);
            return;
        }
    }

    @Nullable
    public static BorderDrawable getBorderDrawable(@NonNull View view) {
        if ((view = view.getBackground()) instanceof BorderDrawable) {
            return (BorderDrawable)view;
        }
        if (view instanceof LayerDrawable && (view = (LayerDrawable)view).getNumberOfLayers() > 1) {
            for (int i = 0; i < view.getNumberOfLayers(); ++i) {
                Drawable drawable2 = view.getDrawable(i);
                if (!(drawable2 instanceof BorderDrawable)) continue;
                return (BorderDrawable)drawable2;
            }
        }
        return null;
    }

    public static void clipCanvasWithinBorderBox(View object, Canvas canvas) {
        BorderDrawable borderDrawable;
        if (WXViewUtils.clipCanvasDueToAndroidVersion(canvas) && WXViewUtils.clipCanvasIfAnimationExist((View)object) && (borderDrawable = WXViewUtils.getBorderDrawable((View)object)) instanceof BorderDrawable && borderDrawable.isRounded() && WXViewUtils.clipCanvasIfBackgroundImageExist((View)object, borderDrawable)) {
            RectF rectF;
            BorderDrawable borderDrawable2 = borderDrawable;
            borderDrawable = rectF;
            View view = object;
            float f = view.getWidth();
            float f2 = view.getHeight();
            Path path = borderDrawable2.getContentPath(new RectF(0.0f, 0.0f, f, f2));
            if (object instanceof WXFrameLayout) {
                if ((object = ((WXFrameLayout)object).getComponent()) != null) {
                    Object object2 = ((WXBasicComponent)object).getAttrs().get("rotateFix");
                    if (object2 != null && object2.toString().equals("true")) {
                        canvas.clipRect((RectF)borderDrawable);
                        return;
                    }
                    if (((WXBasicComponent)object).getStyles() != null && "hidden".equals(((WXBasicComponent)object).getStyles().getOverflow()) || Build.VERSION.SDK_INT < 24) {
                        canvas.clipPath(path);
                        return;
                    }
                }
            } else {
                canvas.clipPath(path);
                return;
            }
        }
    }

    public static void clipCanvasWithinBorderBox(Widget widget, Canvas canvas) {
        BorderDrawable borderDrawable;
        if (WXViewUtils.clipCanvasDueToAndroidVersion(canvas) && WXViewUtils.clipCanvasIfAnimationExist(null) && (borderDrawable = widget.getBackgroundAndBorder()) != null) {
            if (borderDrawable.isRounded() && WXViewUtils.clipCanvasIfBackgroundImageExist(widget, borderDrawable)) {
                Widget widget2 = widget;
                float f = widget2.getBorderBox().width();
                float f2 = widget2.getBorderBox().height();
                canvas.clipPath(borderDrawable.getContentPath(new RectF(0.0f, 0.0f, f, f2)));
                return;
            }
            canvas.clipRect(widget.getBorderBox());
            return;
        }
    }

    private static boolean clipCanvasDueToAndroidVersion(Canvas canvas) {
        return Build.VERSION.SDK_INT >= 18 || !canvas.isHardwareAccelerated();
        {
        }
    }

    private static boolean clipCanvasIfAnimationExist(View view) {
        return Build.VERSION.SDK_INT < 24;
    }

    private static boolean clipCanvasIfBackgroundImageExist(@NonNull View view, @NonNull BorderDrawable borderDrawable) {
        if (view instanceof ViewGroup) {
            view = (ViewGroup)view;
            int n = view.getChildCount();
            for (int i = 0; i < n; ++i) {
                BorderDrawable borderDrawable2 = WXViewUtils.getBorderDrawable(view.getChildAt(i));
                if (borderDrawable2 == null || !borderDrawable2.hasImage() || Build.VERSION.SDK_INT >= 21) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean clipCanvasIfBackgroundImageExist(@NonNull Widget object, @NonNull BorderDrawable borderDrawable) {
        if (object instanceof WidgetGroup) {
            object = ((WidgetGroup)object).getChildren().iterator();
            while (object.hasNext()) {
                if (!((Widget)object.next()).getBackgroundAndBorder().hasImage() || Build.VERSION.SDK_INT >= 21) continue;
                return false;
            }
        }
        return true;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Opacity {
    }
}

