/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.downloader.core.thread;

import android.os.Process;
import android.util.Log;
import com.dcloud.android.downloader.config.Config;
import com.dcloud.android.downloader.core.DownloadResponse;
import com.dcloud.android.downloader.domain.DownloadInfo;
import com.dcloud.android.downloader.domain.DownloadThreadInfo;
import com.dcloud.android.downloader.exception.DownloadException;
import com.dcloud.android.downloader.exception.DownloadPauseException;
import io.dcloud.common.adapter.util.DCloudTrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;

public class DownloadThread
implements Runnable {
    public static final String TAG = "DownloadThread";
    private final DownloadThreadInfo downloadThreadInfo;
    private final DownloadResponse downloadResponse;
    private final Config config;
    private final DownloadInfo downloadInfo;
    private final DownloadProgressListener downloadProgressListener;
    private long lastProgress;
    private InputStream inputStream;
    private int retryDownloadCount = 0;

    public DownloadThread(DownloadThreadInfo downloadThreadInfo, DownloadResponse downloadResponse, Config config, DownloadInfo downloadInfo, DownloadProgressListener downloadProgressListener) {
        this.downloadThreadInfo = downloadThreadInfo;
        this.downloadResponse = downloadResponse;
        this.config = config;
        this.downloadInfo = downloadInfo;
        this.lastProgress = downloadThreadInfo.getProgress();
        this.downloadProgressListener = downloadProgressListener;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeDownload() {
        block33: {
            block32: {
                block31: {
                    var1_6 = null;
                    var1_6 = (HttpURLConnection)new URL(this.downloadThreadInfo.getUri()).openConnection();
                    if (!(var1_6 instanceof HttpsURLConnection)) ** GOTO lbl11
                    var2_7 = DCloudTrustManager.getSSLSocketFactory();
                    if (var2_7 == null) break block31;
                    ((HttpsURLConnection)var1_6).setSSLSocketFactory(var2_7);
                }
                ((HttpsURLConnection)var1_6).setHostnameVerifier((HostnameVerifier)DCloudTrustManager.getHostnameVerifier(false));
lbl11:
                // 2 sources

                v0 = var1_6;
                v0.setConnectTimeout(this.config.getConnectTimeout());
                v0.setReadTimeout(this.config.getReadTimeout());
                v0.setRequestMethod(this.config.getMethod());
                var2_8 = this.downloadThreadInfo.getStart() + this.lastProgress;
                if (this.downloadInfo.isSupportRanges()) {
                    if (var2_8 > this.downloadThreadInfo.getEnd()) {
                        var2_8 = 0L;
                        this.lastProgress = 0L;
                    }
                    if (this.config.getEachDownloadThread() == 1) {
                        var1_6.setRequestProperty("Range", "bytes=" + var2_8 + "-");
                    } else {
                        var1_6.setRequestProperty("Range", "bytes=" + var2_8 + "-" + this.downloadThreadInfo.getEnd());
                    }
                }
                v1 = var1_6;
                var4_10 = v1.getResponseCode();
                var5_12 = (long)Integer.parseInt(v1.getHeaderField("Content-Length")) + var2_8;
                if (this.config.getEachDownloadThread() != 1 || var5_12 == this.downloadThreadInfo.getEnd()) ** GOTO lbl38
                if (var5_12 - this.downloadThreadInfo.getEnd() != 1L) break block32;
                --var2_8;
                var5_12 = this.lastProgress - 1L;
                this.lastProgress = var5_12;
                ** GOTO lbl38
            }
            throw new DownloadException(5, "IO error Data source change");
lbl38:
            // 2 sources

            if (var4_10 == 206 || var4_10 == 200) ** GOTO lbl41
            throw new DownloadException(8, "UnSupported response code:" + var4_10);
lbl41:
            // 1 sources

            this.inputStream = var1_6.getInputStream();
            var4_11 = v2;
            v2 = new RandomAccessFile(this.downloadInfo.getPath(), "rwd");
            if (this.config.getEachDownloadThread() != 1 || var4_11.length() >= this.lastProgress) ** GOTO lbl48
            try {
                throw new DownloadException(5, "IO error Have small download size");
lbl48:
                // 1 sources

                var4_11.seek(var2_8);
                var2_9 = new byte[4096];
                var3_14 = 0;
                break block33;
            }
            catch (Throwable var0_1) {}
            if (var1_6 != null) {
                var1_6.disconnect();
            }
            throw var0_1;
            catch (KeyManagementException var0_2) {}
            {
                throw new DownloadException(5, "Key management", var0_2);
            }
            catch (NoSuchAlgorithmException var0_3) {}
            {
                throw new DownloadException(5, "NO such", var0_3);
            }
            catch (DownloadPauseException v3) {}
            if (var1_6 != null) {
                var1_6.disconnect();
            }
            return;
            catch (IOException var0_4) {}
            {
                throw new DownloadException(5, "IO error", var0_4);
            }
            catch (ProtocolException var0_5) {}
            {
                throw new DownloadException(4, "Protocol error", var0_5);
            }
        }
        while (true) {
            this.checkPause();
            var5_13 = this.inputStream.read(var2_9);
            if (var5_13 != -1) ** GOTO lbl-1000
            {
                this.downloadProgressListener.onDownloadSuccess();
                this.checkPause();
                var1_6.disconnect();
                return;
            }
lbl-1000:
            // 1 sources

            {
                var4_11.write(var2_9, 0, var5_13);
                this.downloadThreadInfo.setProgress(this.lastProgress + (long)(var3_14 += var5_13));
                this.downloadProgressListener.onProgress();
                Log.d((String)"DownloadThread", (String)("downloadInfo:" + this.downloadInfo.getId() + " thread:" + this.downloadThreadInfo.getThreadId() + " progress:" + this.downloadThreadInfo.getProgress() + ",start:" + this.downloadThreadInfo.getStart() + ",end:" + this.downloadThreadInfo.getEnd()));
            }
        }
    }

    private void checkPause() {
        if (!this.downloadInfo.isPause()) {
            return;
        }
        throw new DownloadPauseException(7);
    }

    @Override
    public void run() {
        DownloadThread downloadThread = this;
        Process.setThreadPriority((int)10);
        downloadThread.checkPause();
        try {
            downloadThread.executeDownload();
            return;
        }
        catch (Exception exception) {
            DownloadException downloadException;
            DownloadThread downloadThread2 = this;
            DownloadException downloadException2 = downloadException;
            downloadException = new DownloadException(9, "other error", exception);
            downloadThread2.downloadInfo.setStatus(6);
            downloadThread2.downloadInfo.setException(downloadException2);
            downloadThread2.downloadResponse.onStatusChanged(this.downloadInfo);
            downloadThread2.downloadResponse.handleException(downloadException2);
        }
        catch (DownloadException downloadException) {
            DownloadThread downloadThread3 = this;
            downloadThread3.downloadInfo.setStatus(6);
            downloadThread3.downloadInfo.setException(downloadException);
            downloadThread3.downloadResponse.onStatusChanged(this.downloadInfo);
            downloadThread3.downloadResponse.handleException(downloadException);
        }
    }

    public static interface DownloadProgressListener {
        public void onProgress();

        public void onDownloadSuccess();
    }
}

