/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder.ec;

import com.dcloud.zxing2.pdf417.decoder.ec.ModulusPoly;

public final class ModulusGF {
    public static final ModulusGF PDF417_GF = new ModulusGF(929, 3);
    private final int[] expTable;
    private final int[] logTable;
    private final ModulusPoly zero;
    private final ModulusPoly one;
    private final int modulus;

    private ModulusGF(int n5, int n6) {
        ModulusPoly modulusPoly;
        ModulusPoly modulusPoly2;
        this.modulus = n5;
        this.expTable = new int[n5];
        this.logTable = new int[n5];
        int n7 = 1;
        for (int i5 = 0; i5 < n5; ++i5) {
            this.expTable[i5] = n7;
            n7 = n7 * n6 % n5;
        }
        for (n6 = 0; n6 < n5 - 1; ++n6) {
            this.logTable[this.expTable[n6]] = n6;
        }
        ModulusGF modulusGF = this;
        ModulusPoly modulusPoly3 = modulusPoly2;
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        modulusPoly2 = new ModulusPoly(this, nArray2);
        modulusGF.zero = modulusPoly3;
        modulusPoly3 = modulusPoly;
        int[] nArray3 = new int[1];
        nArray2 = nArray3;
        nArray3[0] = 1;
        modulusPoly = new ModulusPoly(this, nArray2);
        modulusGF.one = modulusPoly3;
    }

    ModulusPoly getZero() {
        return this.zero;
    }

    ModulusPoly getOne() {
        return this.one;
    }

    ModulusPoly buildMonomial(int n5, int n6) {
        if (n5 >= 0) {
            if (n6 == 0) {
                return this.zero;
            }
            int[] nArray = new int[n5 + 1];
            int[] nArray2 = nArray;
            nArray[0] = n6;
            return new ModulusPoly(this, nArray2);
        }
        throw new IllegalArgumentException();
    }

    int add(int n5, int n6) {
        return (n5 + n6) % this.modulus;
    }

    int subtract(int n5, int n6) {
        int n7 = this.modulus;
        return (n7 + n5 - n6) % n7;
    }

    int exp(int n5) {
        return this.expTable[n5];
    }

    int log(int n5) {
        if (n5 != 0) {
            return this.logTable[n5];
        }
        throw new IllegalArgumentException();
    }

    int inverse(int n5) {
        if (n5 != 0) {
            return this.expTable[this.modulus - this.logTable[n5] - 1];
        }
        throw new ArithmeticException();
    }

    int multiply(int n5, int n6) {
        if (n5 != 0 && n6 != 0) {
            int[] nArray = this.logTable;
            return this.expTable[(this.logTable[n5] + nArray[n6]) % (this.modulus - 1)];
        }
        return 0;
    }

    int getSize() {
        return this.modulus;
    }
}

