/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.encoder;

import com.dcloud.zxing2.qrcode.encoder.ByteMatrix;

final class MaskUtil {
    private static final int N1 = 3;
    private static final int N2 = 3;
    private static final int N3 = 40;
    private static final int N4 = 10;

    private MaskUtil() {
    }

    static int applyMaskPenaltyRule1(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, true) + MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, false);
    }

    static int applyMaskPenaltyRule2(ByteMatrix byteMatrix) {
        ByteMatrix byteMatrix2 = byteMatrix;
        int n5 = 0;
        byte[][] byArray = byteMatrix2.getArray();
        int n6 = byteMatrix2.getWidth();
        int n7 = byteMatrix2.getHeight();
        for (int i5 = 0; i5 < n7 - 1; ++i5) {
            int n8 = 0;
            while (n8 < n6 - 1) {
                byte[] byArray2;
                byte[] byArray3 = byArray[i5];
                byte by = byArray3[n8];
                int n9 = n8 + 1;
                if (by == byArray3[n9] && by == (byArray2 = byArray[i5 + 1])[n8] && by == byArray2[n9]) {
                    ++n5;
                }
                n8 = n9;
            }
        }
        return n5 * 3;
    }

    static int applyMaskPenaltyRule3(ByteMatrix byteMatrix) {
        ByteMatrix byteMatrix2 = byteMatrix;
        int n5 = 0;
        byte[][] byArray = byteMatrix2.getArray();
        int n6 = byteMatrix2.getWidth();
        int n7 = byteMatrix2.getHeight();
        for (int i5 = 0; i5 < n7; ++i5) {
            for (int i6 = 0; i6 < n6; ++i6) {
                int n8;
                byte[] byArray2 = byArray[i5];
                int n9 = i6 + 6;
                if (n9 < n6 && byArray2[i6] == 1 && byArray2[i6 + 1] == 0 && byArray2[i6 + 2] == 1 && byArray2[i6 + 3] == 1 && byArray2[i6 + 4] == 1 && byArray2[i6 + 5] == 0 && byArray2[n9] == 1 && (MaskUtil.isWhiteHorizontal(byArray2, i6 - 4, i6) || MaskUtil.isWhiteHorizontal(byArray2, i6 + 7, i6 + 11))) {
                    ++n5;
                }
                if ((n8 = i5 + 6) >= n7 || byArray[i5][i6] != 1 || byArray[i5 + 1][i6] != 0 || byArray[i5 + 2][i6] != 1 || byArray[i5 + 3][i6] != 1 || byArray[i5 + 4][i6] != 1 || byArray[i5 + 5][i6] != 0 || byArray[n8][i6] != 1 || !MaskUtil.isWhiteVertical(byArray, i6, i5 - 4, i5) && !MaskUtil.isWhiteVertical(byArray, i6, i5 + 7, n8 = i5 + 11)) continue;
                ++n5;
            }
        }
        return n5 * 40;
    }

    private static boolean isWhiteHorizontal(byte[] byArray, int n5, int n6) {
        while (n5 < n6) {
            if (n5 >= 0 && n5 < byArray.length && byArray[n5] == 1) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    private static boolean isWhiteVertical(byte[][] byArray, int n5, int n6, int n7) {
        while (n6 < n7) {
            if (n6 >= 0 && n6 < byArray.length && byArray[n6][n5] == 1) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    static int applyMaskPenaltyRule4(ByteMatrix byteMatrix) {
        ByteMatrix byteMatrix2 = byteMatrix;
        int n5 = 0;
        byte[][] byArray = byteMatrix2.getArray();
        int n6 = byteMatrix2.getWidth();
        int n7 = byteMatrix2.getHeight();
        for (int i5 = 0; i5 < n7; ++i5) {
            byte[] byArray2 = byArray[i5];
            for (int i6 = 0; i6 < n6; ++i6) {
                if (byArray2[i6] != 1) continue;
                ++n5;
            }
        }
        int n8 = byteMatrix.getHeight() * byteMatrix.getWidth();
        return Math.abs(n5 * 2 - n8) * 10 / n8 * 10;
    }

    static boolean getDataMaskBit(int n5, int n6, int n7) {
        int n8;
        switch (n5) {
            default: {
                throw new IllegalArgumentException("Invalid mask pattern: " + n5);
            }
            case 7: {
                n8 = n7 * n6 % 3 + (n7 + n6 & 1) & 1;
                break;
            }
            case 6: {
                n5 = n7 * n6;
                n8 = (n5 & 1) + n5 % 3 & 1;
                break;
            }
            case 5: {
                n5 = n7 * n6;
                n8 = (n5 & 1) + n5 % 3;
                break;
            }
            case 4: {
                n8 = n7 / 2 + n6 / 3 & 1;
                break;
            }
            case 3: {
                n8 = (n7 + n6) % 3;
                break;
            }
            case 2: {
                n8 = n6 % 3;
                break;
            }
            case 1: {
                n8 = n7 & 1;
                break;
            }
            case 0: {
                n8 = n7 + n6 & 1;
            }
        }
        return n8 == 0;
    }

    private static int applyMaskPenaltyRule1Internal(ByteMatrix object, boolean bl) {
        int n5 = 0;
        int n6 = bl ? ((ByteMatrix)object).getHeight() : ((ByteMatrix)object).getWidth();
        int n7 = bl ? ((ByteMatrix)object).getWidth() : ((ByteMatrix)object).getHeight();
        object = ((ByteMatrix)object).getArray();
        for (int i5 = 0; i5 < n6; ++i5) {
            int n8 = 0;
            Object object2 = -1;
            for (int i6 = 0; i6 < n7; ++i6) {
                Object object3 = bl ? object[i5][i6] : object[i6][i5];
                if (object3 == object2) {
                    ++n8;
                    continue;
                }
                if (n8 >= 5) {
                    n5 += n8 - 2;
                }
                n8 = 1;
                object2 = object3;
            }
            if (n8 < 5) continue;
            n5 += n8 - 2;
        }
        return n5;
    }
}

