/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.util;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class Logger {
    public static final String Capture_TAG = "Capture_Tag";
    public static final String Event_TAG = "Event_Tag";
    public static final String AppMgr_TAG = "appmgr";
    public static final String StreamApp_TAG = "stream_manager";
    public static final String AutoGC_TAG = "AutoGC_Path";
    public static final String Android_System_TAG = "Android_System_Path";
    public static final String LAYOUT_TAG = "Layout_Path";
    public static final String MAIN_TAG = "Main_Path";
    public static final String AUTO_POP_PUSH_TAG = "Auto_Pop_Push_Path";
    public static final String ANIMATION_TAG = "Animation_Path";
    public static final String MAP_TAG = "Map_Path";
    public static final String VIEW_VISIBLE_TAG = "View_Visible_Path";
    private static final String MSC_TAG = "DCloud_";
    private static final String LOGTAG = "DCloud_LOG";
    private static final String STREAMSDKLOGTAG = "DCLOUD_STREAMSDK_LOG";
    private static final String EXCEPTION_TAG = "DCloud_Exception";
    private static File mLogFile;
    private static String LogPath = "";
    private static boolean isStoreLog = false;
    private static long TIMES = 432000000L;
    private static boolean isOpen = true;
    private static boolean isHasDevFile = false;
    protected static String I = "I";
    protected static String D = "D";
    protected static String E = "E";
    protected static String W = "W";
    static String pkg = "";
    private static HandlerThread mWriteLogToSdCardThread;
    private static WriteLogToSdCardThreadHandler mWriteLogToSdCardThreadHandler;
    private static HashMap<String, SimpleDateFormat> mSimpleDateFormatCache;
    private static int MAX_CRASH_FILE_COUNT = 3;
    public static final String TIMESTAMP_HH_MM_SS_SSS = "HH:mm:ss.SSS";
    public static final String TIMESTAMP_YYYY_MM_DD = "yyyyMMdd";
    public static final String TIMESTAMP_YYYY_MM_DD_HH_MM_SS_SSS = "yyyyMMdd HH:mm:ss.SSS";

    public static void initLogger(Context context) {
        Context context2 = context;
        pkg = context2.getPackageName();
        isHasDevFile = DHFile.hasFile();
        isOpen = BaseInfo.isBase(context2) || isHasDevFile;
        isOpen = isOpen | BaseInfo.ISDEBUG;
        if ("mounted".equalsIgnoreCase(Environment.getExternalStorageState())) {
            LogPath = BaseInfo.getCrashLogsPath(context);
        }
        if (isOpen) {
            Logger.init(LogPath, "crash");
            Logger.init(LogPath + "crash/", null);
        }
        Logger.setOpen(isOpen);
    }

    private static void init(final String string2, final String string3) {
        try {
            ThreadPool.self().addThreadTask(new Runnable(){

                @Override
                public void run() {
                    block4: {
                        File[] fileArray = new File(string2).listFiles();
                        if (fileArray == null || fileArray.length <= MAX_CRASH_FILE_COUNT) break block4;
                        if (fileArray[0].getName().compareTo(fileArray[1].getName()) < 0) {
                            for (int i5 = 0; i5 < fileArray.length - MAX_CRASH_FILE_COUNT; ++i5) {
                                if (TextUtils.equals((CharSequence)string3, (CharSequence)fileArray[i5].getName())) continue;
                                fileArray[i5].delete();
                            }
                        } else {
                            for (int i6 = fileArray.length - 1; i6 >= MAX_CRASH_FILE_COUNT; --i6) {
                                if (TextUtils.equals((CharSequence)string3, (CharSequence)fileArray[i6].getName())) continue;
                                fileArray[i6].delete();
                            }
                        }
                    }
                }
            });
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void setOpen(boolean bl) {
        isOpen = bl;
        if (isOpen) {
            Logger.canStoreLogToSDcard();
            Logger.storeLogToSDcard();
            return;
        }
    }

    public static boolean isOpen() {
        return isOpen;
    }

    public static void d(String string2, String string3) {
        if (isOpen) {
            if (!BaseInfo.ISDEBUG) {
                Log.i((String)string2, (String)string3);
            } else {
                Log.d((String)string2, (String)string3);
            }
            Logger.WriteLogToSDcard(D, string2, string3);
            return;
        }
    }

    public static void d(String string2, Object ... objectArray) {
        if (isOpen) {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer = new StringBuffer();
            if (objectArray != null) {
                int n5 = objectArray.length;
                for (int i5 = 0; i5 < n5; ++i5) {
                    stringBuffer2.append(objectArray[i5]).append(";");
                }
            }
            if (!BaseInfo.ISDEBUG) {
                Log.i((String)string2, (String)stringBuffer2.toString());
            } else {
                Log.d((String)string2, (String)stringBuffer2.toString());
            }
            Logger.WriteLogToSDcard(D, string2, stringBuffer2.toString());
            return;
        }
    }

    public static void d(String string2) {
        Logger.d(LOGTAG, string2);
    }

    public static void i(String string2, String string3) {
        if (isOpen && string3 != null) {
            Log.i((String)string2, (String)string3);
            Logger.WriteLogToSDcard(I, string2, string3);
            return;
        }
    }

    public static void i(String string2) {
        Logger.i(LOGTAG, string2);
    }

    public static void w(String string2, Throwable throwable) {
        if (isOpen) {
            if (throwable != null) {
                throwable.printStackTrace();
            }
            Log.w((String)EXCEPTION_TAG, (String)string2, (Throwable)throwable);
            Logger.WriteExceptionToSDcard(W, EXCEPTION_TAG, string2, throwable);
            return;
        }
    }

    public static void w(Throwable throwable) {
        Logger.w("", throwable);
    }

    public static void e(String string2, String string3) {
        if (isOpen) {
            Log.e((String)string2, (String)string3);
            Logger.WriteLogToSDcard(E, string2, string3);
            return;
        }
    }

    public static void e(String string2) {
        Logger.e(LOGTAG, string2);
    }

    public static void es(String string2, String string3) {
        if (isOpen) {
            Log.e((String)string2, (String)string3);
            Logger.WriteLogToSDcard(E, string2, string3);
            return;
        }
    }

    public static void es(String string2) {
        if (isOpen) {
            Logger.es(STREAMSDKLOGTAG, string2);
            return;
        }
    }

    public static void p(String string2, String string3) {
        Logger.privacyLog(string2, string3);
    }

    public static void p(String string2) {
        Logger.privacyLog(LOGTAG, string2);
    }

    private static void privacyLog(String string2, String string3) {
        if (isHasDevFile) {
            Log.e((String)string2, (String)string3);
            return;
        }
    }

    public static boolean isTurnOn() {
        return isStoreLog;
    }

    public static void turnOff() {
        isStoreLog = false;
    }

    protected static boolean isSDcardExists() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    private static String concatString(String string2, String string3) {
        String string4 = null;
        if (string2 != null && string3 != null) {
            int n5 = string2.length() + string3.length();
            StringBuffer stringBuffer = new StringBuffer(n5);
            stringBuffer.append(string2).append(string3);
            return stringBuffer.toString();
        }
        return string4;
    }

    public static boolean canStoreLogToSDcard() {
        if (Logger.isSDcardExists() && isOpen) {
            File file;
            File file2 = file;
            if (new File(LogPath).exists()) {
                Logger.deleteOldLog(file2);
            }
            if (file2.exists() && file2.canWrite()) {
                isStoreLog = true;
            }
        }
        return isStoreLog;
    }

    protected static String generateLog(String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Logger.generateTimeStamp(Boolean.TRUE)).append(" ").append(string2).append(" ").append("-").append(" ").append(string3).append(" ").append(string4).append("\n");
        return stringBuffer.toString();
    }

    private static void WriteExceptionToSDcard(String string2, String string3, String string4, Throwable stackTraceElementArray) {
        if (stackTraceElementArray != null) {
            Logger.WriteLogToSDcard(string2, string3, Logger.generateLog(string2, EXCEPTION_TAG, stackTraceElementArray.getClass().getName()));
            stackTraceElementArray = stackTraceElementArray.getStackTrace();
            if (stackTraceElementArray != null) {
                Logger.WriteLogToSDcard(string2, string3, string4);
                int n5 = stackTraceElementArray.length;
                for (int i5 = 0; i5 < n5; ++i5) {
                    Logger.WriteLogToSDcard(string2, string3, Logger.generateLog(string2, EXCEPTION_TAG, "    at " + stackTraceElementArray[i5].toString()));
                }
            }
        }
    }

    private static void WriteLogToSDcard(String string2, String string3, String string4) {
        File file;
        if (isOpen && (file = mLogFile) != null && file.exists()) {
            Logger.initWriteLogToSdCardThread();
            file = Message.obtain();
            Message.obtain().obj = new String[]{string2, string3, string4};
            if (!PdrUtil.isEmpty((Object)mWriteLogToSdCardThreadHandler)) {
                mWriteLogToSdCardThreadHandler.sendMessage((Message)file);
                return;
            }
        }
    }

    public static String generateTimeStamp(Boolean bl) {
        return Logger.generateTimeStamp(bl != false ? TIMESTAMP_HH_MM_SS_SSS : TIMESTAMP_YYYY_MM_DD, new Date());
    }

    public static String generateTimeStamp(String string2, Date date) {
        SimpleDateFormat simpleDateFormat = Logger.getDateFormatFromCache(string2);
        simpleDateFormat.applyPattern(string2);
        return simpleDateFormat.format(date);
    }

    private static SimpleDateFormat getDateFormatFromCache(String string2) {
        if (mSimpleDateFormatCache == null) {
            mSimpleDateFormatCache = new HashMap();
        }
        if (!mSimpleDateFormatCache.containsKey(string2)) {
            SimpleDateFormat simpleDateFormat;
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            simpleDateFormat = new SimpleDateFormat(string2, Locale.ENGLISH);
            mSimpleDateFormatCache.put(string2, simpleDateFormat2);
            return simpleDateFormat;
        }
        return mSimpleDateFormatCache.get(string2);
    }

    public static void storeLogToSDcard() {
        if (isStoreLog) {
            StringBuffer stringBuffer;
            CharSequence charSequence = stringBuffer;
            String string2 = Logger.generateTimeStamp(Boolean.FALSE) + ".log";
            new StringBuffer().append(LogPath).append(string2);
            mLogFile = new File(charSequence.toString());
            if (!mLogFile.exists()) {
                try {
                    mLogFile.createNewFile();
                }
                catch (IOException iOException) {
                    mLogFile = null;
                    iOException.printStackTrace();
                }
            }
            charSequence = "path=" + charSequence.toString();
            Logger.WriteLogToSDcard("\u65e5\u5fd7\u8def\u5f84:", "Logger", (String)charSequence);
            return;
        }
    }

    protected static void deleteOldLog(File fileArray) {
        Date date;
        fileArray = fileArray.listFiles();
        Date date2 = date;
        date = new Date();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (file.isDirectory()) continue;
                Object object = file.getName().substring(0, 8);
                object = new SimpleDateFormat(TIMESTAMP_YYYY_MM_DD).parse((String)object);
                long l5 = date2.getTime() - ((Date)object).getTime();
                if (l5 <= TIMES) continue;
                try {
                    file.delete();
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
        }
    }

    private static void initWriteLogToSdCardThread() {
        if (mWriteLogToSdCardThread == null) {
            mWriteLogToSdCardThread = new HandlerThread("WriteLogToSdCardThread");
            mWriteLogToSdCardThread.start();
            mWriteLogToSdCardThreadHandler = new WriteLogToSdCardThreadHandler(mWriteLogToSdCardThread.getLooper());
            return;
        }
    }

    public static void stopWriteLogToSdCardThread() {
        if (mWriteLogToSdCardThread != null) {
            WriteLogToSdCardThreadHandler writeLogToSdCardThreadHandler = mWriteLogToSdCardThreadHandler;
            if (writeLogToSdCardThreadHandler != null) {
                writeLogToSdCardThreadHandler.removeCallbacksAndMessages(null);
            }
            mWriteLogToSdCardThreadHandler = null;
            if (Build.VERSION.SDK_INT >= 18) {
                mWriteLogToSdCardThread.quitSafely();
            } else {
                mWriteLogToSdCardThread.quit();
            }
            mWriteLogToSdCardThread = null;
            return;
        }
    }

    static /* synthetic */ File access$100() {
        return mLogFile;
    }

    static class WriteLogToSdCardThreadHandler
    extends Handler {
        public WriteLogToSdCardThreadHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message var1_4) {
            block15: {
                super.handleMessage(var1_4);
                this = var1_4.obj;
                if (this == null) return;
                if (!(this instanceof String[])) {
                    return;
                }
                if (((String[])(this = (String[])this)).length < 3) {
                    return;
                }
                v0 = this[0];
                this = this[1];
                this = Logger.generateLog(v0, (String)this, this[2]);
                if (Logger.access$100() == null) return;
                if (Logger.access$100().exists() == false) return;
                if (this == null) return;
                var1_4 = null;
                var2_5 = v1;
                try {
                    v2 = this;
                    var2_5(Logger.access$100(), true);
                }
                catch (Throwable var0_2) {
                    break block15;
                }
                catch (Exception v3) {
                    // empty catch block
                    ** GOTO lbl-1000
                }
                try {
                    v1.write(v2.getBytes());
                    v1.flush();
                }
                catch (Throwable var0_1) {
                    var1_4 = var2_5;
                    break block15;
                }
                catch (Exception v3) {
                    var1_4 = var2_5;
                    ** GOTO lbl-1000
                }
                {
                    v1.close();
                    return;
                }
lbl-1000:
                // 2 sources

                {
                    v3.printStackTrace();
                    if (var1_4 == null) return;
                }
                {
                    var1_4.close();
                    return;
                }
            }
            if (var1_4 == null) throw var0_3;
            try {
                var1_4.close();
                throw var0_3;
            }
            catch (IOException v4) {
                v4.printStackTrace();
            }
            throw var0_3;
        }
    }
}

