/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.nativeObj.photoview.subscaleview;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.Uri;
import androidx.annotation.NonNull;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public final class ImageSource {
    static final String FILE_SCHEME = "file:///";
    static final String ASSET_SCHEME = "file:///android_asset/";
    private final Uri uri;
    private final Bitmap bitmap;
    private final Integer resource;
    private boolean tile;
    private int sWidth;
    private int sHeight;
    private Rect sRegion;
    private boolean cached;

    private ImageSource(Bitmap bitmap, boolean bl) {
        ImageSource imageSource = this;
        imageSource.bitmap = bitmap;
        imageSource.uri = null;
        imageSource.resource = null;
        imageSource.tile = false;
        this.sWidth = bitmap.getWidth();
        this.sHeight = bitmap.getHeight();
        this.cached = bl;
    }

    private ImageSource(@NonNull Uri uri) {
        String string2 = uri.toString();
        if (string2.startsWith(FILE_SCHEME) && !new File(string2.substring(7)).exists()) {
            try {
                uri = Uri.parse((String)URLDecoder.decode(string2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        ImageSource imageSource = this;
        imageSource.bitmap = null;
        imageSource.uri = uri;
        imageSource.resource = null;
        imageSource.tile = true;
    }

    private ImageSource(int n5) {
        ImageSource imageSource = this;
        this.bitmap = null;
        this.uri = null;
        imageSource.resource = n5;
        imageSource.tile = true;
    }

    @NonNull
    public static ImageSource resource(int n5) {
        return new ImageSource(n5);
    }

    @NonNull
    public static ImageSource asset(@NonNull String string2) {
        if (string2 != null) {
            return ImageSource.uri(ASSET_SCHEME + string2);
        }
        throw new NullPointerException("Asset name must not be null");
    }

    @NonNull
    public static ImageSource uri(@NonNull String string2) {
        if (string2 != null) {
            if (!string2.contains("://")) {
                if (string2.startsWith("/")) {
                    string2 = string2.substring(1);
                }
                string2 = FILE_SCHEME + string2;
            }
            return new ImageSource(Uri.parse((String)string2));
        }
        throw new NullPointerException("Uri must not be null");
    }

    @NonNull
    public static ImageSource uri(@NonNull Uri uri) {
        if (uri != null) {
            return new ImageSource(uri);
        }
        throw new NullPointerException("Uri must not be null");
    }

    @NonNull
    public static ImageSource bitmap(@NonNull Bitmap bitmap) {
        if (bitmap != null) {
            return new ImageSource(bitmap, false);
        }
        throw new NullPointerException("Bitmap must not be null");
    }

    @NonNull
    public static ImageSource cachedBitmap(@NonNull Bitmap bitmap) {
        if (bitmap != null) {
            return new ImageSource(bitmap, true);
        }
        throw new NullPointerException("Bitmap must not be null");
    }

    private void setInvariants() {
        Rect rect = this.sRegion;
        if (rect != null) {
            this.tile = true;
            this.sWidth = rect.width();
            this.sHeight = this.sRegion.height();
            return;
        }
    }

    @NonNull
    public ImageSource tilingEnabled() {
        return this.tiling(true);
    }

    @NonNull
    public ImageSource tilingDisabled() {
        return this.tiling(false);
    }

    @NonNull
    public ImageSource tiling(boolean bl) {
        this.tile = bl;
        return this;
    }

    @NonNull
    public ImageSource region(Rect rect) {
        ImageSource imageSource = this;
        imageSource.sRegion = rect;
        imageSource.setInvariants();
        return imageSource;
    }

    @NonNull
    public ImageSource dimensions(int n5, int n6) {
        if (this.bitmap == null) {
            ImageSource imageSource = this;
            imageSource.sWidth = n5;
            imageSource.sHeight = n6;
        }
        ImageSource imageSource = this;
        imageSource.setInvariants();
        return imageSource;
    }

    protected final Uri getUri() {
        return this.uri;
    }

    protected final Bitmap getBitmap() {
        return this.bitmap;
    }

    protected final Integer getResource() {
        return this.resource;
    }

    protected final boolean getTile() {
        return this.tile;
    }

    protected final int getSWidth() {
        return this.sWidth;
    }

    protected final int getSHeight() {
        return this.sHeight;
    }

    protected final Rect getSRegion() {
        return this.sRegion;
    }

    protected final boolean isCached() {
        return this.cached;
    }
}

