/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.sqlite;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.DHInterface.StandardFeature;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.constant.DOMException;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataBaseFeature
extends StandardFeature {
    public HashMap<String, SQLiteDatabase> map = new HashMap();
    private String resultMessage = "{'code':%d,'message':\"%s\"}";

    public void openDatabase(IWebview pWebview, JSONArray array) {
        SQLiteDatabase database;
        String callBackID = array.optString(0);
        String name = array.optString(1);
        String path = array.optString(2);
        if (PdrUtil.isEmpty((Object)name) || PdrUtil.isEmpty((Object)path)) {
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1404, DOMException.toString((String)"parameter can't be null")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
            return;
        }
        int dbFlag = path.startsWith("_www") ? 1 : (PdrUtil.isDeviceRootDir((String)path) ? 0x10000000 : (path.startsWith("_doc") || path.startsWith("_documents") || path.startsWith("_downloads") ? 0x10000000 : 1));
        String toPath = path = pWebview.obtainApp().convert2AbsFullPath(pWebview.obtainFullUrl(), path);
        if (!PdrUtil.isDeviceRootDir((String)path)) {
            toPath = DeviceInfo.sBaseFsRootPath + path;
            if (!new File(toPath).exists()) {
                DHFile.copyAssetsFile((String)path, (String)toPath);
            }
            toPath = pWebview.obtainApp().convert2AbsFullPath(pWebview.obtainFullUrl(), toPath);
            dbFlag = 1;
        }
        if (!new File(toPath).exists() && dbFlag == 1) {
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1403, DOMException.toString((String)"Cannot create file private directory,such as:\\'www\\'")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
            return;
        }
        File file = new File(toPath);
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.map.containsKey(name)) {
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1402, DOMException.toString((String)"Same Name Already Open")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
            return;
        }
        try {
            database = SQLiteDatabase.openDatabase((String)toPath, null, (int)dbFlag, null);
        }
        catch (Exception e) {
            JSONObject object = new JSONObject();
            try {
                object.put("code", -1404);
                object.put("message", (Object)DOMException.toString((String)e.toString()));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (JSONObject)object, (int)JSUtil.ERROR, (boolean)false);
            return;
        }
        this.map.put(name, database);
        JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)"{}", (int)JSUtil.OK, (boolean)true, (boolean)false);
    }

    public String isOpenDatabase(IWebview pwebview, JSONArray array) {
        JSONObject param = array.optJSONObject(0);
        if (PdrUtil.isEmpty((Object)param)) {
            return JSUtil.wrapJsVar((String)"undefined", (boolean)false);
        }
        String dbName = param.optString("name");
        String dbPath = param.optString("path");
        if (PdrUtil.isEmpty((Object)dbName) || PdrUtil.isEmpty((Object)dbPath)) {
            return JSUtil.wrapJsVar((String)"undefined", (boolean)false);
        }
        for (String key : this.map.keySet()) {
            SQLiteDatabase db = this.map.get(key);
            String realPath = pwebview.obtainApp().convert2AbsFullPath(pwebview.obtainFullUrl(), dbPath);
            if (!PdrUtil.isDeviceRootDir((String)realPath)) {
                realPath = DeviceInfo.sBaseFsRootPath + realPath;
            }
            if (!realPath.equalsIgnoreCase(db.getPath())) continue;
            return JSUtil.wrapJsVar((boolean)true);
        }
        if (this.map.containsKey(dbName)) {
            return JSUtil.wrapJsVar((boolean)true);
        }
        return JSUtil.wrapJsVar((boolean)false);
    }

    public void closeDatabase(IWebview pWebview, JSONArray array) {
        String callBackID = array.optString(0);
        String name = array.optString(1);
        SQLiteDatabase database = this.map.get(name);
        if (PdrUtil.isEmpty((Object)name)) {
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1404, DOMException.toString((String)"parameter can't be null")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
            return;
        }
        if (database != null) {
            database.close();
            this.map.remove(name);
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)"{}", (int)JSUtil.OK, (boolean)true, (boolean)false);
        } else {
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1401, DOMException.toString((String)"Not Open")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
        }
    }

    public void transaction(IWebview pWebview, JSONArray array) {
        String callBackID = array.optString(0);
        String name = array.optString(1);
        SQLiteDatabase database = this.map.get(name);
        String operation = array.optString(2);
        if (PdrUtil.isEmpty((Object)name) || PdrUtil.isEmpty((Object)operation)) {
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1404, DOMException.toString((String)"parameter can't be null")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
            return;
        }
        if (database != null) {
            try {
                if (operation.equals("begin")) {
                    database.beginTransaction();
                } else if (operation.equals("commit")) {
                    database.setTransactionSuccessful();
                    database.endTransaction();
                } else if (operation.equals("rollback")) {
                    database.endTransaction();
                } else {
                    JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1404, DOMException.toString((String)"Operation Error")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
                }
                JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)"{}", (int)JSUtil.OK, (boolean)true, (boolean)false);
            }
            catch (Exception e) {
                JSONObject object = new JSONObject();
                try {
                    object.put("code", -1404);
                    object.put("message", (Object)DOMException.toString((String)e.toString()));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (JSONObject)object, (int)JSUtil.ERROR, (boolean)false);
            }
        } else {
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1401, DOMException.toString((String)"Not Open")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
        }
    }

    public void executeSql(IWebview pWebview, JSONArray array) {
        String callBackID = array.optString(0);
        String name = array.optString(1);
        SQLiteDatabase database = this.map.get(name);
        String sql = array.optString(2);
        if (PdrUtil.isEmpty((Object)name) || PdrUtil.isEmpty((Object)sql)) {
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1404, DOMException.toString((String)"parameter can't be null")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
            return;
        }
        if (database != null) {
            try {
                JSONArray sqls = new JSONArray(sql);
                if (sqls.length() > 0) {
                    for (int i = 0; i < sqls.length(); ++i) {
                        String s = sqls.optString(i);
                        if (TextUtils.isEmpty((CharSequence)s.trim())) continue;
                        database.execSQL(s);
                    }
                    JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)"{}", (int)JSUtil.OK, (boolean)true, (boolean)false);
                } else {
                    JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1404, DOMException.toString((String)"parameter can't be null")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
                }
                return;
            }
            catch (Exception e) {
                try {
                    if (e instanceof SQLException) {
                        JSONObject object = new JSONObject();
                        try {
                            object.put("code", -1404);
                            object.put("message", (Object)DOMException.toString((String)e.toString()));
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (JSONObject)object, (int)JSUtil.ERROR, (boolean)false);
                        return;
                    }
                    database.execSQL(sql);
                }
                catch (Exception e2) {
                    JSONObject object = new JSONObject();
                    try {
                        object.put("code", -1404);
                        object.put("message", (Object)DOMException.toString((String)e2.toString()));
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (JSONObject)object, (int)JSUtil.ERROR, (boolean)false);
                    return;
                }
                JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)"{}", (int)JSUtil.OK, (boolean)true, (boolean)false);
            }
        } else {
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1401, DOMException.toString((String)"Not Open")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
        }
    }

    public void selectSql(IWebview pWebview, JSONArray array) {
        Cursor cursor;
        String callBackID = array.optString(0);
        String name = array.optString(1);
        SQLiteDatabase database = this.map.get(name);
        if (database == null) {
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1401, DOMException.toString((String)"Not Open")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
            return;
        }
        String sql = array.optString(2);
        if (PdrUtil.isEmpty((Object)name) || PdrUtil.isEmpty((Object)sql)) {
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (String)StringUtil.format((String)this.resultMessage, (Object[])new Object[]{-1404, DOMException.toString((String)"parameter can't be null")}), (int)JSUtil.ERROR, (boolean)true, (boolean)false);
            return;
        }
        try {
            cursor = database.rawQuery(sql, null);
        }
        catch (Exception e) {
            JSONObject object = new JSONObject();
            try {
                object.put("code", -1404);
                object.put("message", (Object)DOMException.toString((String)e.toString()));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (JSONObject)object, (int)JSUtil.ERROR, (boolean)false);
            return;
        }
        JSONArray arr = new JSONArray();
        try {
            if (cursor.moveToFirst()) {
                String[] names = cursor.getColumnNames();
                do {
                    JSONObject res = new JSONObject();
                    for (int i = 0; i < names.length; ++i) {
                        int type = cursor.getType(i);
                        try {
                            switch (type) {
                                case 0: {
                                    res.put(names[i], JSONObject.NULL);
                                    break;
                                }
                                case 3: {
                                    res.put(names[i], (Object)cursor.getString(i));
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    BigDecimal decimal = new BigDecimal(String.valueOf(cursor.getDouble(i)));
                                    res.put(names[i], decimal.doubleValue());
                                    break;
                                }
                                case 4: {
                                    res.put(names[i], (Object)Arrays.toString(cursor.getBlob(i)));
                                }
                            }
                            continue;
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                    arr.put((Object)res);
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        catch (Exception e) {
            JSONObject object = new JSONObject();
            try {
                object.put("code", -1404);
                object.put("message", (Object)DOMException.toString((String)e.toString()));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (JSONObject)object, (int)JSUtil.ERROR, (boolean)false);
            return;
        }
        JSUtil.execCallback((IWebview)pWebview, (String)callBackID, (JSONArray)arr, (int)JSUtil.OK, (boolean)false);
    }
}

