/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import androidx.annotation.Nullable;
import dc.squareup.okio.Base64;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class ByteString
implements Serializable,
Comparable<ByteString> {
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long serialVersionUID = 1L;
    public static final ByteString EMPTY = ByteString.of(new byte[0]);
    final byte[] data;
    transient int hashCode;
    transient String utf8;

    ByteString(byte[] byArray) {
        this.data = byArray;
    }

    public static ByteString of(byte ... byArray) {
        if (byArray != null) {
            return new ByteString((byte[])byArray.clone());
        }
        throw new IllegalArgumentException("data == null");
    }

    public static ByteString of(byte[] byArray, int n5, int n6) {
        if (byArray != null) {
            long l5 = n5;
            long l6 = n6;
            Util.checkOffsetAndCount(byArray.length, l5, l6);
            byte[] byArray2 = new byte[n6];
            System.arraycopy(byArray, n5, byArray2, 0, n6);
            return new ByteString(byArray2);
        }
        throw new IllegalArgumentException("data == null");
    }

    public static ByteString of(ByteBuffer object) {
        if (object != null) {
            ByteBuffer byteBuffer = object;
            byte[] byArray = new byte[byteBuffer.remaining()];
            object = byArray;
            byteBuffer.get(byArray);
            return new ByteString((byte[])object);
        }
        throw new IllegalArgumentException("data == null");
    }

    public static ByteString encodeUtf8(String string2) {
        if (string2 != null) {
            new ByteString(string2.getBytes(Util.UTF_8)).utf8 = string2;
            return new ByteString(string2.getBytes(Util.UTF_8));
        }
        throw new IllegalArgumentException("s == null");
    }

    public static ByteString encodeString(String string2, Charset charset) {
        if (string2 != null) {
            if (charset != null) {
                return new ByteString(string2.getBytes(charset));
            }
            throw new IllegalArgumentException("charset == null");
        }
        throw new IllegalArgumentException("s == null");
    }

    private ByteString digest(String string2) {
        try {
            return ByteString.of(MessageDigest.getInstance(string2).digest(this.data));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    @Nullable
    public static ByteString decodeBase64(String object) {
        if (object != null) {
            byte[] byArray = Base64.decode((String)object);
            object = byArray;
            if (byArray != null) {
                return new ByteString((byte[])object);
            }
            return null;
        }
        throw new IllegalArgumentException("base64 == null");
    }

    public static ByteString decodeHex(String string2) {
        if (string2 != null) {
            if (string2.length() % 2 == 0) {
                int n5 = string2.length() / 2;
                byte[] byArray = new byte[n5];
                for (int i5 = 0; i5 < n5; ++i5) {
                    int n6 = i5 * 2;
                    byArray[i5] = (byte)((ByteString.decodeHexDigit(string2.charAt(n6)) << 4) + ByteString.decodeHexDigit(string2.charAt(n6 + 1)));
                }
                return ByteString.of(byArray);
            }
            throw new IllegalArgumentException("Unexpected hex string: " + string2);
        }
        throw new IllegalArgumentException("hex == null");
    }

    private static int decodeHexDigit(char c6) {
        if (c6 >= '0' && c6 <= '9') {
            return c6 - 48;
        }
        if (c6 >= 'a' && c6 <= 'f') {
            return c6 - 87;
        }
        if (c6 >= 'A' && c6 <= 'F') {
            return c6 - 55;
        }
        throw new IllegalArgumentException("Unexpected hex digit: " + c6);
    }

    public static ByteString read(InputStream inputStream, int n5) throws IOException {
        if (inputStream != null) {
            if (n5 >= 0) {
                int n6;
                byte[] byArray = new byte[n5];
                for (int i5 = 0; i5 < n5; i5 += n6) {
                    n6 = n5 - i5;
                    if ((n6 = inputStream.read(byArray, i5, n6)) != -1) {
                        continue;
                    }
                    throw new EOFException();
                }
                return new ByteString(byArray);
            }
            throw new IllegalArgumentException("byteCount < 0: " + n5);
        }
        throw new IllegalArgumentException("in == null");
    }

    static int codePointIndexToCharIndex(String string2, int n5) {
        int n6;
        int n7 = 0;
        int n8 = string2.length();
        for (int i5 = 0; i5 < n8; i5 += Character.charCount(n6)) {
            if (n7 == n5) {
                return i5;
            }
            n6 = string2.codePointAt(i5);
            if (Character.isISOControl(n6) && n6 != 10 && n6 != 13 || n6 == 65533) {
                return -1;
            }
            ++n7;
        }
        return string2.length();
    }

    private void readObject(ObjectInputStream object) throws IOException {
        block5: {
            ObjectInputStream objectInputStream = object;
            object = ByteString.read(objectInputStream, objectInputStream.readInt());
            Field field = ByteString.class.getDeclaredField("data");
            try {
                ((AccessibleObject)field).setAccessible(true);
                field.set(this, ((ByteString)object).data);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                break block5;
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.write(this.data);
    }

    public String utf8() {
        String string2;
        String string3 = this.utf8;
        if (string3 != null) {
            return string3;
        }
        string3 = string2;
        string3(this.data, Util.UTF_8);
        this.utf8 = string3;
        return string2;
    }

    public String string(Charset charset) {
        if (charset != null) {
            return new String(this.data, charset);
        }
        throw new IllegalArgumentException("charset == null");
    }

    public String base64() {
        return Base64.encode(this.data);
    }

    public ByteString md5() {
        return this.digest("MD5");
    }

    public ByteString sha1() {
        return this.digest("SHA-1");
    }

    public ByteString sha256() {
        return this.digest("SHA-256");
    }

    public ByteString sha512() {
        return this.digest("SHA-512");
    }

    public String base64Url() {
        return Base64.encodeUrl(this.data);
    }

    public String hex() {
        Object object = ((ByteString)object).data;
        char[] cArray = new char[((ByteString)object).data.length * 2];
        int n5 = 0;
        int n6 = ((ByteString)object).data.length;
        for (int i5 = 0; i5 < n6; ++i5) {
            Object object2 = object[i5];
            int n7 = n5 + 1;
            char[] cArray2 = HEX_DIGITS;
            cArray[n5] = cArray2[object2 >> 4 & 0xF];
            n5 += 2;
            cArray[n7] = HEX_DIGITS[object2 & 0xF];
        }
        return new String(cArray);
    }

    public ByteString toAsciiLowercase() {
        int n5 = 0;
        while (true) {
            byte[] byArray = ((ByteString)object).data;
            if (n5 >= ((ByteString)object).data.length) break;
            byte by = byArray[n5];
            if (by >= 65 && by <= 90) {
                byte[] byArray2 = (byte[])byArray.clone();
                Object object = byArray2;
                byArray2[n5++] = (byte)(by - -32);
                while (n5 < ((Object)object).length) {
                    Object object2 = object[n5];
                    if (object2 >= 65 && object2 <= 90) {
                        object[n5] = (byte)(object2 - -32);
                    }
                    ++n5;
                }
                return new ByteString((byte[])object);
            }
            ++n5;
        }
        return object;
    }

    public ByteString toAsciiUppercase() {
        int n5 = 0;
        while (true) {
            byte[] byArray = ((ByteString)object).data;
            if (n5 >= ((ByteString)object).data.length) break;
            byte by = byArray[n5];
            if (by >= 97 && by <= 122) {
                byte[] byArray2 = (byte[])byArray.clone();
                Object object = byArray2;
                byArray2[n5++] = (byte)(by - 32);
                while (n5 < ((Object)object).length) {
                    Object object2 = object[n5];
                    if (object2 >= 97 && object2 <= 122) {
                        object[n5] = (byte)(object2 - 32);
                    }
                    ++n5;
                }
                return new ByteString((byte[])object);
            }
            ++n5;
        }
        return object;
    }

    public ByteString substring(int n5) {
        return this.substring(n5, this.data.length);
    }

    public ByteString substring(int n5, int n6) {
        if (n5 >= 0) {
            byte[] byArray = ((ByteString)object).data;
            if (n6 <= ((ByteString)object).data.length) {
                int n7 = n6 - n5;
                if (n7 >= 0) {
                    if (n5 == 0 && n6 == byArray.length) {
                        return object;
                    }
                    Object object = new byte[n7];
                    System.arraycopy(byArray, n5, object, 0, n7);
                    return new ByteString((byte[])object);
                }
                throw new IllegalArgumentException("endIndex < beginIndex");
            }
            throw new IllegalArgumentException("endIndex > length(" + ((ByteString)object).data.length + ")");
        }
        throw new IllegalArgumentException("beginIndex < 0");
    }

    public byte getByte(int n5) {
        return this.data[n5];
    }

    public int size() {
        return this.data.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.data.clone();
    }

    byte[] internalArray() {
        return this.data;
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.data).asReadOnlyBuffer();
    }

    public void write(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            outputStream.write(this.data);
            return;
        }
        throw new IllegalArgumentException("out == null");
    }

    void write(Buffer buffer) {
        Object object = ((ByteString)object).data;
        int n5 = ((ByteString)object).data.length;
        buffer.write((byte[])object, 0, n5);
    }

    public boolean rangeEquals(int n5, ByteString byteString, int n6, int n7) {
        return byteString.rangeEquals(n6, this.data, n5, n7);
    }

    public boolean rangeEquals(int n5, byte[] byArray, int n6, int n7) {
        if (n5 >= 0) {
            Object object = ((ByteString)object).data;
            if (n5 <= ((ByteString)object).data.length - n7 && n6 >= 0 && n6 <= byArray.length - n7 && Util.arrayRangeEquals((byte[])object, n5, byArray, n6, n7)) {
                return true;
            }
        }
        return false;
    }

    public final boolean startsWith(ByteString byteString) {
        int n5 = byteString.size();
        return this.rangeEquals(0, byteString, 0, n5);
    }

    public final boolean startsWith(byte[] byArray) {
        int n5 = byArray.length;
        return this.rangeEquals(0, byArray, 0, n5);
    }

    public final boolean endsWith(ByteString byteString) {
        int n5 = this.size() - byteString.size();
        int n6 = byteString.size();
        return this.rangeEquals(n5, byteString, 0, n6);
    }

    public final boolean endsWith(byte[] byArray) {
        int n5 = this.size() - byArray.length;
        int n6 = byArray.length;
        return this.rangeEquals(n5, byArray, 0, n6);
    }

    public final int indexOf(ByteString byteString) {
        return this.indexOf(byteString.internalArray(), 0);
    }

    public final int indexOf(ByteString byteString, int n5) {
        return this.indexOf(byteString.internalArray(), n5);
    }

    public final int indexOf(byte[] byArray) {
        return this.indexOf(byArray, 0);
    }

    public int indexOf(byte[] byArray, int n5) {
        int n6 = this.data.length - byArray.length;
        for (n5 = Math.max(n5, 0); n5 <= n6; ++n5) {
            int n7 = byArray.length;
            if (!Util.arrayRangeEquals(this.data, n5, byArray, 0, n7)) continue;
            return n5;
        }
        return -1;
    }

    public final int lastIndexOf(ByteString byteString) {
        ByteString byteString2 = object;
        Object object = byteString.internalArray();
        return byteString2.lastIndexOf((byte[])object, byteString2.size());
    }

    public final int lastIndexOf(ByteString byteString, int n5) {
        return this.lastIndexOf(byteString.internalArray(), n5);
    }

    public final int lastIndexOf(byte[] byArray) {
        return this.lastIndexOf(byArray, this.size());
    }

    public int lastIndexOf(byte[] byArray, int n5) {
        for (n5 = Math.min(n5, this.data.length - byArray.length); n5 >= 0; --n5) {
            int n6 = byArray.length;
            if (!Util.arrayRangeEquals(this.data, n5, byArray, 0, n6)) continue;
            return n5;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == object2) {
            return true;
        }
        if (object instanceof ByteString) {
            int n5;
            object = (ByteString)object;
            Object object2 = ((ByteString)object2).data;
            if (((ByteString)object).size() == ((ByteString)object2).data.length && ((ByteString)object).rangeEquals(0, (byte[])object2, 0, n5 = ((Object)object2).length)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n5 = this.hashCode;
        if (n5 != 0) {
            return n5;
        }
        this.hashCode = Arrays.hashCode(this.data);
        return this.hashCode;
    }

    @Override
    public int compareTo(ByteString byteString) {
        int n5 = this.size();
        int n6 = byteString.size();
        int n7 = Math.min(n5, n6);
        for (int i5 = 0; i5 < n7; ++i5) {
            int n8;
            int n9 = this.getByte(i5) & 0xFF;
            if (n9 == (n8 = byteString.getByte(i5) & 0xFF)) {
                continue;
            }
            if (n9 < n8) {
                return -1;
            }
            return 1;
        }
        if (n5 == n6) {
            return 0;
        }
        if (n5 < n6) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        if (this.data.length == 0) {
            return "[size=0]";
        }
        String string2 = this.utf8();
        int n5 = ByteString.codePointIndexToCharIndex(string2, 64);
        if (n5 == -1) {
            if (this.data.length <= 64) {
                return "[hex=" + this.hex() + "]";
            }
            return "[size=" + this.data.length + " hex=" + this.substring(0, 64).hex() + "\u2026]";
        }
        String string3 = string2;
        string2 = string3.substring(0, n5).replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r");
        if (n5 < string3.length()) {
            return "[size=" + this.data.length + " text=" + string2 + "\u2026]";
        }
        return "[text=" + string2 + "]";
    }
}

