/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.camera;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import io.dcloud.feature.barcode2.camera.AutoFocusCallback;
import io.dcloud.feature.barcode2.camera.CameraConfigurationManager;
import io.dcloud.feature.barcode2.camera.FlashlightManager;
import io.dcloud.feature.barcode2.camera.PlanarYUVLuminanceSource;
import io.dcloud.feature.barcode2.camera.PreviewCallback;
import io.dcloud.feature.barcode2.decoding.IBarHandler;
import io.dcloud.feature.barcode2.view.DetectorViewConfig;
import java.io.IOException;

public final class CameraManager {
    private static final String TAG = "CameraManager";
    private static final int MIN_FRAME_WIDTH = 240;
    private static final int MIN_FRAME_HEIGHT = 240;
    private static final int MAX_FRAME_WIDTH = 640;
    private static final int MAX_FRAME_HEIGHT = 640;
    private static CameraManager cameraManager;
    public static int sScreenWidth;
    public static int sScreenAllHeight;
    static final int SDK_INT;
    private static boolean mIsVerticalScreen;
    private static Camera.Parameters parameters;
    private final Context context;
    private final CameraConfigurationManager configManager;
    private Camera camera;
    private Rect framingRect;
    private boolean initialized;
    private boolean previewing;
    private boolean useOneShotPreviewCallback;
    private final PreviewCallback previewCallback;
    private final AutoFocusCallback autoFocusCallback;
    private boolean horizontalOrientation;

    public static void init(Context context) {
        if (cameraManager == null) {
            cameraManager = new CameraManager(context);
            return;
        }
    }

    public static void init(Context context, boolean bl) {
        mIsVerticalScreen = bl;
        CameraManager.init(context);
    }

    public static CameraManager get() {
        return cameraManager;
    }

    private CameraManager(Context context) {
        AutoFocusCallback autoFocusCallback;
        PreviewCallback previewCallback;
        CameraConfigurationManager cameraConfigurationManager;
        CameraManager cameraManager = autoFocusCallback2;
        ((CameraManager)((Object)autoFocusCallback2)).horizontalOrientation = false;
        cameraManager.context = context;
        CameraConfigurationManager cameraConfigurationManager2 = cameraConfigurationManager;
        cameraManager.configManager = new CameraConfigurationManager(context);
        boolean bl = Integer.parseInt(Build.VERSION.SDK) > 3;
        CameraManager cameraManager2 = autoFocusCallback2;
        cameraManager2.useOneShotPreviewCallback = bl;
        PreviewCallback previewCallback2 = previewCallback;
        previewCallback = new PreviewCallback(cameraConfigurationManager2, ((CameraManager)((Object)autoFocusCallback2)).useOneShotPreviewCallback);
        cameraManager2.previewCallback = previewCallback2;
        cameraManager2.useOneShotPreviewCallback = false;
        AutoFocusCallback autoFocusCallback2 = autoFocusCallback;
        autoFocusCallback = new AutoFocusCallback();
        cameraManager2.autoFocusCallback = autoFocusCallback2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Point getCR(int n5, int n6) {
        Exception exception2;
        Camera camera;
        Point point;
        block11: {
            Point point2;
            block9: {
                Camera.Parameters parameters;
                block10: {
                    Point point3;
                    block8: {
                        Point point4;
                        point = null;
                        camera = null;
                        try {
                            camera = Camera.open();
                            if (CameraManager.parameters != null) break block8;
                            CameraManager.parameters = camera.getParameters();
                            break block8;
                        }
                        catch (Exception exception2) {}
                        point2 = point4;
                        point4 = new Point(n5, n6);
                        parameters = CameraManager.parameters;
                        if (parameters == null) break block9;
                        break block10;
                    }
                    Point point5 = point3;
                    {
                        point3 = new Point(n5, n6);
                        point = CameraConfigurationManager.getCameraResolution(CameraManager.parameters, point5);
                    }
                    {
                        camera.release();
                        return point;
                    }
                }
                point = CameraConfigurationManager.getCameraResolution(parameters, point2);
                break block11;
            }
            if (camera != null) {
                try {
                    Camera camera2 = camera;
                    parameters = camera2.getParameters();
                    point = CameraConfigurationManager.getCameraResolution(parameters, point2);
                    camera2.release();
                    camera = null;
                }
                catch (Exception exception3) {}
            }
        }
        if (camera != null) {
            camera.release();
        }
        exception2.printStackTrace();
        return point;
    }

    static {
        int n5;
        try {
            n5 = Integer.parseInt(Build.VERSION.SDK);
        }
        catch (NumberFormatException numberFormatException) {
            n5 = 10000;
        }
        SDK_INT = n5;
        mIsVerticalScreen = true;
        parameters = null;
    }

    public void setHorizontalOrientation(boolean bl) {
        this.horizontalOrientation = bl;
    }

    public byte[] getLastBitmapData() {
        PreviewCallback previewCallback = ((CameraManager)((Object)previewCallback)).previewCallback;
        if (previewCallback == null) {
            return null;
        }
        return previewCallback.getLastBitmapData();
    }

    public void clearLastBitmapData() {
        PreviewCallback previewCallback = ((CameraManager)((Object)previewCallback)).previewCallback;
        if (previewCallback != null) {
            previewCallback.setLastBitmapData(null);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openDriver(SurfaceTexture surfaceTexture) throws IOException, RuntimeException {
        Exception exception2;
        block7: {
            Camera camera;
            if (this.camera != null) {
                return;
            }
            try {
                camera = Camera.open();
            }
            catch (Exception exception2) {
                break block7;
            }
            this.camera = camera;
            if (camera == null) {
                throw new IOException();
            }
            camera.setPreviewTexture(surfaceTexture);
            if (mIsVerticalScreen) {
                this.camera.setDisplayOrientation(90);
            } else {
                CameraManager cameraManager = this;
                surfaceTexture = cameraManager.camera;
                int n5 = cameraManager.horizontalOrientation ? 180 : 0;
                surfaceTexture.setDisplayOrientation(n5);
            }
            CameraManager cameraManager = this;
            cameraManager.configManager.initFromCameraParameters(this.camera);
            cameraManager.configManager.setDesiredCameraParameters(this.camera);
            return;
        }
        exception2.printStackTrace();
    }

    public void setFlashlight(boolean bl) {
        if (bl) {
            FlashlightManager.enableFlashlight();
            return;
        }
        FlashlightManager.disableFlashlight();
    }

    public Camera getCameraHandler() {
        return this.camera;
    }

    public void closeDriver() {
        if (this.camera != null) {
            CameraManager cameraManager = this;
            FlashlightManager.disableFlashlight();
            cameraManager.camera.setPreviewCallback(null);
            cameraManager.camera.release();
            cameraManager.camera = null;
            return;
        }
    }

    public void startPreview() {
        block4: {
            Camera camera;
            try {
                camera = this.camera;
                if (camera == null) break block4;
            }
            catch (Exception exception) {}
            if (this.previewing) break block4;
            camera.startPreview();
            this.previewing = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopPreview() {
        try {
            Camera camera = this.camera;
            if (camera == null) return;
            if (!this.previewing) return;
            if (!this.useOneShotPreviewCallback) {
                camera.setPreviewCallback(null);
            }
            CameraManager cameraManager = this;
            cameraManager.camera.stopPreview();
            cameraManager.previewCallback.setHandler(null, null, 0, mIsVerticalScreen);
            cameraManager.autoFocusCallback.setHandler(null, 0);
            cameraManager.previewing = false;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void requestPreviewFrame(IBarHandler iBarHandler, Handler handler, int n5) {
        if (this.camera != null && this.previewing) {
            CameraManager cameraManager = this;
            boolean bl = mIsVerticalScreen;
            cameraManager.previewCallback.setHandler(iBarHandler, handler, n5, bl);
            if (cameraManager.useOneShotPreviewCallback) {
                this.camera.setOneShotPreviewCallback((Camera.PreviewCallback)this.previewCallback);
                return;
            }
            this.camera.setPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            return;
        }
    }

    public void requestAutoFocus(Handler handler, int n5) {
        if (this.camera != null && this.previewing) {
            CameraManager cameraManager = this;
            cameraManager.autoFocusCallback.setHandler(handler, n5);
            try {
                cameraManager.camera.autoFocus((Camera.AutoFocusCallback)this.autoFocusCallback);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public void removeAutoFocus() {
        CameraManager cameraManager = cameraManager.camera;
        if (cameraManager != null) {
            try {
                cameraManager.cancelAutoFocus();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public Rect getFramingRectInPreview() {
        if (mIsVerticalScreen) {
            return this.getPortraitFramingRectInPreview();
        }
        return this.getLandscapeFramingRectInPreview();
    }

    public Rect getPortraitFramingRectInPreview() {
        CameraManager cameraManager = cameraManager.configManager.getCameraResolution();
        Rect rect = DetectorViewConfig.getInstance().getDetectorRect();
        Rect rect2 = DetectorViewConfig.getInstance().surfaceViewRect;
        int cfr_ignored_0 = rect2.width() / ((Point)cameraManager).y;
        int n5 = (rect.top - DetectorViewConfig.detectorRectOffestTop) * ((Point)cameraManager).x / rect2.height();
        int n6 = n5 + rect.height() * ((Point)cameraManager).x / rect2.height();
        int n7 = (rect2.right - rect.right) * ((Point)cameraManager).y / rect2.width();
        int n8 = n7 + rect.width() * ((Point)cameraManager).x / rect2.height();
        return new Rect(n5, n7, n6, n8);
    }

    public Rect getLandscapeFramingRectInPreview() {
        CameraManager cameraManager = cameraManager.configManager.getCameraResolution();
        Rect rect = DetectorViewConfig.getInstance().getDetectorRect();
        Rect rect2 = DetectorViewConfig.getInstance().surfaceViewRect;
        int cfr_ignored_0 = rect2.width() / ((Point)cameraManager).y;
        int n5 = (rect.left - DetectorViewConfig.detectorRectOffestLeft) * ((Point)cameraManager).x / rect2.width();
        int n6 = n5 + rect.height() * ((Point)cameraManager).y / rect2.height();
        int n7 = (rect2.bottom - rect.bottom) * ((Point)cameraManager).y / rect2.height();
        int n8 = n7 + rect.width() * ((Point)cameraManager).y / rect2.height();
        return new Rect(n5, n7, n6, n8);
    }

    public PlanarYUVLuminanceSource buildLuminanceSource(byte[] byArray, int n5, int n6) {
        CameraManager cameraManager = string2;
        Rect rect = cameraManager.getFramingRectInPreview();
        int n7 = cameraManager.configManager.getPreviewFormat();
        String string2 = ((CameraManager)((Object)string2)).configManager.getPreviewFormatString();
        if (n7 != 16 && n7 != 17) {
            if ("yuv420p".equals(string2)) {
                Rect rect2 = rect;
                int n8 = rect2.left;
                int n9 = rect2.top;
                n7 = rect2.width();
                int n10 = rect2.height();
                return new PlanarYUVLuminanceSource(byArray, n5, n6, n8, n9, n7, n10);
            }
            throw new IllegalArgumentException("Unsupported picture format: " + n7 + '/' + (String)string2);
        }
        Rect rect3 = rect;
        int n11 = rect3.left;
        int n12 = rect3.top;
        n7 = rect3.width();
        int n13 = rect3.height();
        return new PlanarYUVLuminanceSource(byArray, n5, n6, n11, n12, n7, n13);
    }

    public AutoFocusCallback getAutoFocusCallback() {
        return this.autoFocusCallback;
    }
}

