/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.camera;

import android.hardware.Camera;
import android.os.Build;
import android.os.IBinder;
import android.util.Log;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.MobilePhoneModel;
import io.dcloud.feature.barcode2.camera.CameraManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class FlashlightManager {
    private static final String TAG = "FlashlightManager";
    private static final Object iHardwareService;
    private static final Method setFlashEnabledMethod;

    private FlashlightManager() {
    }

    private static Object getHardwareService() {
        Object object = FlashlightManager.maybeForName("android.os.ServiceManager");
        if (object == null) {
            return null;
        }
        Class[] classArray = object;
        Class[] classArray2 = new Class[1];
        object = classArray2;
        classArray2[0] = String.class;
        if ((object = FlashlightManager.maybeGetMethod(classArray, "getService", object)) == null) {
            return null;
        }
        Object object2 = object;
        Object[] objectArray = new Object[1];
        object = objectArray;
        objectArray[0] = "hardware";
        if ((object = FlashlightManager.invoke((Method)object2, null, object)) == null) {
            return null;
        }
        Object[] objectArray2 = FlashlightManager.maybeForName("android.os.IHardwareService$Stub");
        if (objectArray2 == null) {
            return null;
        }
        Class[] classArray3 = objectArray2;
        Class[] classArray4 = new Class[1];
        objectArray2 = classArray4;
        classArray4[0] = IBinder.class;
        if ((objectArray2 = FlashlightManager.maybeGetMethod(classArray3, "asInterface", objectArray2)) == null) {
            return null;
        }
        Object object3 = objectArray2;
        Object[] objectArray3 = new Object[1];
        objectArray2 = objectArray3;
        objectArray3[0] = object;
        return FlashlightManager.invoke((Method)object3, null, objectArray2);
    }

    private static Method getSetFlashEnabledMethod(Object classArray) {
        if (classArray == null) {
            return null;
        }
        Class<?> clazz = classArray.getClass();
        Class[] classArray2 = new Class[1];
        classArray = classArray2;
        classArray2[0] = Boolean.TYPE;
        return FlashlightManager.maybeGetMethod(clazz, "setFlashlightEnabled", classArray);
    }

    private static Class<?> maybeForName(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)TAG, (String)("Unexpected error while finding class " + string2), (Throwable)runtimeException);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Method maybeGetMethod(Class<?> clazz, String string2, Class<?> ... classArray) {
        try {
            return clazz.getMethod(string2, classArray);
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)TAG, (String)("Unexpected error while finding method " + string2), (Throwable)runtimeException);
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Object invoke(Method object, Object object2, Object ... objectArray) {
        try {
            return ((Method)object).invoke(object2, objectArray);
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)TAG, (String)("Unexpected error while invoking " + object), (Throwable)runtimeException);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            object = "Unexpected error while invoking " + object;
            Log.w((String)TAG, (String)object, (Throwable)invocationTargetException.getCause());
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.w((String)TAG, (String)("Unexpected error while invoking " + object), (Throwable)illegalAccessException);
            return null;
        }
    }

    static void enableFlashlight() {
        try {
            FlashlightManager.setFlashlight(true);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static void disableFlashlight() {
        try {
            FlashlightManager.setFlashlight(false);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void setFlashlight(boolean bl) {
        Camera camera = CameraManager.get().getCameraHandler();
        Camera.Parameters parameters = camera.getParameters();
        if (bl) {
            parameters.setFlashMode("torch");
        } else {
            parameters.setFlashMode("off");
        }
        camera.setParameters(parameters);
        if (DeviceInfo.sBrand.equalsIgnoreCase(MobilePhoneModel.XIAOMI) && Build.VERSION.SDK_INT == 19) {
            Camera camera2 = camera;
            camera2.stopPreview();
            camera2.startPreview();
            camera2.autoFocus((Camera.AutoFocusCallback)CameraManager.get().getAutoFocusCallback());
            return;
        }
    }

    static {
        String string2 = FlashlightManager.class.getSimpleName();
        iHardwareService = FlashlightManager.getHardwareService();
        setFlashEnabledMethod = FlashlightManager.getSetFlashEnabledMethod(iHardwareService);
        if (iHardwareService == null) {
            Log.v((String)string2, (String)"This device does supports control of a flashlight");
        } else {
            Log.v((String)string2, (String)"This device does not support control of a flashlight");
        }
    }
}

