/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.detector;

import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.ResultPointCallback;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.qrcode.detector.FinderPattern;
import com.dcloud.zxing2.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FinderPatternFinder {
    private static final int CENTER_QUORUM = 2;
    protected static final int MIN_SKIP = 3;
    protected static final int MAX_MODULES = 57;
    private final BitMatrix image;
    private final List<FinderPattern> possibleCenters;
    private boolean hasSkipped;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    public FinderPatternFinder(BitMatrix bitMatrix) {
        this(bitMatrix, null);
    }

    public FinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        FinderPatternFinder finderPatternFinder = this;
        finderPatternFinder.image = bitMatrix;
        finderPatternFinder.possibleCenters = new ArrayList<FinderPattern>();
        finderPatternFinder.crossCheckStateCount = new int[5];
        this.resultPointCallback = resultPointCallback;
    }

    private static float centerFromEnd(int[] nArray, int n5) {
        return (float)(n5 - nArray[4] - nArray[3]) - (float)nArray[2] / 2.0f;
    }

    protected static boolean foundPatternCross(int[] nArray) {
        float f5;
        int n5 = 0;
        for (int i5 = 0; i5 < 5; ++i5) {
            int n6 = nArray[i5];
            if (n6 == 0) {
                return false;
            }
            n5 += n6;
        }
        if (n5 < 7) {
            return false;
        }
        float f6 = (float)n5 / 7.0f;
        float f7 = f6 / 2.0f;
        return Math.abs(f5 - (float)nArray[0]) < f7 && Math.abs(f6 - (float)nArray[1]) < f7 && Math.abs(f6 * 3.0f - (float)nArray[2]) < f7 * 3.0f && Math.abs(f6 - (float)nArray[3]) < f7 && Math.abs(f6 - (float)nArray[4]) < f7;
    }

    private int[] getCrossCheckStateCount() {
        int[] nArray = this.crossCheckStateCount;
        int[] nArray2 = this.crossCheckStateCount;
        nArray[0] = 0;
        nArray2[1] = 0;
        nArray[2] = 0;
        nArray2[3] = 0;
        nArray[4] = 0;
        return nArray2;
    }

    private boolean crossCheckDiagonal(int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int[] nArray = this.getCrossCheckStateCount();
        for (n10 = 0; n5 >= n10 && n6 >= n10 && this.image.get(n9 = n6 - n10, n5 - n10); ++n10) {
            nArray[2] = n9 = nArray[2] + 1;
        }
        if (n5 >= n10 && n6 >= n10) {
            while (n5 >= n10 && n6 >= n10 && !this.image.get(n9 = n6 - n10, n5 - n10) && (n9 = nArray[1]) <= n7) {
                nArray[1] = ++n9;
                ++n10;
            }
            if (n5 >= n10 && n6 >= n10 && nArray[1] <= n7) {
                int n11;
                int n12;
                while (n5 >= n10 && n6 >= n10 && this.image.get(n9 = n6 - n10, n5 - n10) && (n9 = nArray[0]) <= n7) {
                    nArray[0] = ++n9;
                    ++n10;
                }
                if (nArray[0] > n7) {
                    return false;
                }
                FinderPatternFinder finderPatternFinder = this;
                n10 = finderPatternFinder.image.getHeight();
                n9 = finderPatternFinder.image.getWidth();
                int n13 = 1;
                while ((n12 = n5 + n13) < n10 && (n11 = n6 + n13) < n9 && this.image.get(n11, n12)) {
                    nArray[2] = n12 = nArray[2] + 1;
                    ++n13;
                }
                if (n12 < n10 && n6 + n13 < n9) {
                    while ((n12 = n5 + n13) < n10 && (n11 = n6 + n13) < n9 && !this.image.get(n11, n12) && (n11 = nArray[3]) < n7) {
                        nArray[3] = n12 = n11 + 1;
                        ++n13;
                    }
                    if (n12 < n10 && n6 + n13 < n9 && nArray[3] < n7) {
                        while ((n12 = n5 + n13) < n10 && (n11 = n6 + n13) < n9 && this.image.get(n11, n12) && (n12 = nArray[4]) < n7) {
                            nArray[4] = ++n12;
                            ++n13;
                        }
                        int n14 = nArray[4];
                        if (n14 >= n7) {
                            return false;
                        }
                        return Math.abs(nArray[0] + nArray[1] + nArray[2] + nArray[3] + n14 - n8) < n8 * 2 && FinderPatternFinder.foundPatternCross(nArray);
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private float crossCheckVertical(int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        FinderPatternFinder finderPatternFinder = bitMatrix;
        BitMatrix bitMatrix = finderPatternFinder.image;
        int n11 = bitMatrix.getHeight();
        int[] nArray = finderPatternFinder.getCrossCheckStateCount();
        for (n10 = n5; n10 >= 0 && bitMatrix.get(n6, n10); --n10) {
            nArray[2] = n9 = nArray[2] + 1;
        }
        if (n10 < 0) {
            return Float.NaN;
        }
        while (n10 >= 0 && !bitMatrix.get(n6, n10) && (n9 = nArray[1]) <= n7) {
            nArray[1] = ++n9;
            --n10;
        }
        if (n10 >= 0 && nArray[1] <= n7) {
            while (n10 >= 0 && bitMatrix.get(n6, n10) && (n9 = nArray[0]) <= n7) {
                nArray[0] = ++n9;
                --n10;
            }
            if (nArray[0] > n7) {
                return Float.NaN;
            }
            ++n5;
            while (n5 < n11 && bitMatrix.get(n6, n5)) {
                nArray[2] = n10 = nArray[2] + 1;
                ++n5;
            }
            if (n5 == n11) {
                return Float.NaN;
            }
            while (n5 < n11 && !bitMatrix.get(n6, n5) && (n10 = nArray[3]) < n7) {
                nArray[3] = ++n10;
                ++n5;
            }
            if (n5 != n11 && nArray[3] < n7) {
                while (n5 < n11 && bitMatrix.get(n6, n5) && (n10 = nArray[4]) < n7) {
                    nArray[4] = ++n10;
                    ++n5;
                }
                int n12 = nArray[4];
                if (n12 >= n7) {
                    return Float.NaN;
                }
                if (Math.abs(nArray[0] + nArray[1] + nArray[2] + nArray[3] + n12 - n8) * 5 >= n8 * 2) {
                    return Float.NaN;
                }
                if (FinderPatternFinder.foundPatternCross(nArray)) {
                    return FinderPatternFinder.centerFromEnd(nArray, n5);
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        return Float.NaN;
    }

    private float crossCheckHorizontal(int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        FinderPatternFinder finderPatternFinder = bitMatrix;
        BitMatrix bitMatrix = finderPatternFinder.image;
        int n11 = bitMatrix.getWidth();
        int[] nArray = finderPatternFinder.getCrossCheckStateCount();
        for (n10 = n5; n10 >= 0 && bitMatrix.get(n10, n6); --n10) {
            nArray[2] = n9 = nArray[2] + 1;
        }
        if (n10 < 0) {
            return Float.NaN;
        }
        while (n10 >= 0 && !bitMatrix.get(n10, n6) && (n9 = nArray[1]) <= n7) {
            nArray[1] = ++n9;
            --n10;
        }
        if (n10 >= 0 && nArray[1] <= n7) {
            while (n10 >= 0 && bitMatrix.get(n10, n6) && (n9 = nArray[0]) <= n7) {
                nArray[0] = ++n9;
                --n10;
            }
            if (nArray[0] > n7) {
                return Float.NaN;
            }
            ++n5;
            while (n5 < n11 && bitMatrix.get(n5, n6)) {
                nArray[2] = n10 = nArray[2] + 1;
                ++n5;
            }
            if (n5 == n11) {
                return Float.NaN;
            }
            while (n5 < n11 && !bitMatrix.get(n5, n6) && (n10 = nArray[3]) < n7) {
                nArray[3] = ++n10;
                ++n5;
            }
            if (n5 != n11 && nArray[3] < n7) {
                while (n5 < n11 && bitMatrix.get(n5, n6) && (n10 = nArray[4]) < n7) {
                    nArray[4] = ++n10;
                    ++n5;
                }
                int n12 = nArray[4];
                if (n12 >= n7) {
                    return Float.NaN;
                }
                if (Math.abs(nArray[0] + nArray[1] + nArray[2] + nArray[3] + n12 - n8) * 5 >= n8) {
                    return Float.NaN;
                }
                if (FinderPatternFinder.foundPatternCross(nArray)) {
                    return FinderPatternFinder.centerFromEnd(nArray, n5);
                }
                return Float.NaN;
            }
            return Float.NaN;
        }
        return Float.NaN;
    }

    private int findRowSkip() {
        if (this.possibleCenters.size() <= 1) {
            return 0;
        }
        FinderPattern finderPattern = null;
        for (FinderPattern finderPattern2 : this.possibleCenters) {
            if (finderPattern2.getCount() < 2) continue;
            if (finderPattern == null) {
                finderPattern = finderPattern2;
                continue;
            }
            this.hasSkipped = true;
            return (int)(Math.abs(finderPattern.getX() - finderPattern2.getX()) - Math.abs(finderPattern.getY() - finderPattern2.getY())) / 2;
        }
        return 0;
    }

    private boolean haveMultiplyConfirmedCenters() {
        FinderPatternFinder finderPatternFinder = this;
        int n5 = 0;
        float f5 = 0.0f;
        int n6 = finderPatternFinder.possibleCenters.size();
        for (FinderPattern finderPattern : finderPatternFinder.possibleCenters) {
            if (finderPattern.getCount() < 2) continue;
            ++n5;
            f5 += finderPattern.getEstimatedModuleSize();
        }
        if (n5 < 3) {
            return false;
        }
        float f6 = f5 / (float)n6;
        float f7 = 0.0f;
        Iterator<FinderPattern> iterator = this.possibleCenters.iterator();
        while (iterator.hasNext()) {
            f7 += Math.abs(iterator.next().getEstimatedModuleSize() - f6);
        }
        return f7 <= f5 * 0.05f;
    }

    private FinderPattern[] selectBestPatterns() throws NotFoundException {
        int n5 = ((FinderPatternFinder)((Object)finderPattern)).possibleCenters.size();
        if (n5 >= 3) {
            if (n5 > 3) {
                float f5 = 0.0f;
                float f6 = 0.0f;
                Iterator<FinderPattern> iterator = ((FinderPatternFinder)((Object)finderPattern)).possibleCenters.iterator();
                while (iterator.hasNext()) {
                    float f7 = iterator.next().getEstimatedModuleSize();
                    f5 += f7;
                    f6 += f7 * f7;
                }
                float f8 = n5;
                float f9 = f5 /= f8;
                f8 = (float)Math.sqrt(f6 / f8 - f9 * f9);
                Collections.sort(((FinderPatternFinder)((Object)finderPattern)).possibleCenters, new FurthestFromAverageComparator(f5));
                f8 = Math.max(f5 * 0.2f, f8);
                for (int i5 = 0; i5 < ((FinderPatternFinder)((Object)finderPattern)).possibleCenters.size() && ((FinderPatternFinder)((Object)finderPattern)).possibleCenters.size() > 3; ++i5) {
                    if (!(Math.abs(((FinderPatternFinder)((Object)finderPattern)).possibleCenters.get(i5).getEstimatedModuleSize() - f5) > f8)) continue;
                    ((FinderPatternFinder)((Object)finderPattern)).possibleCenters.remove(i5);
                    --i5;
                }
            }
            if (((FinderPatternFinder)((Object)finderPattern)).possibleCenters.size() > 3) {
                float f10 = 0.0f;
                Iterator<FinderPattern> iterator = ((FinderPatternFinder)((Object)finderPattern)).possibleCenters.iterator();
                while (iterator.hasNext()) {
                    f10 += iterator.next().getEstimatedModuleSize();
                }
                Object object = finderPattern;
                Collections.sort(((FinderPatternFinder)object).possibleCenters, new CenterComparator(f10 /= (float)((FinderPatternFinder)((Object)finderPattern)).possibleCenters.size()));
                List<FinderPattern> list = ((FinderPatternFinder)object).possibleCenters;
                list.subList(3, list.size()).clear();
            }
            FinderPatternFinder finderPatternFinder = finderPattern;
            FinderPattern finderPattern = finderPatternFinder.possibleCenters.get(0);
            FinderPattern finderPattern2 = finderPatternFinder.possibleCenters.get(1);
            FinderPattern finderPattern3 = finderPatternFinder.possibleCenters.get(2);
            return new FinderPattern[]{finderPattern, finderPattern2, finderPattern3};
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final List<FinderPattern> getPossibleCenters() {
        return this.possibleCenters;
    }

    final FinderPatternInfo find(Map<DecodeHintType, ?> map) throws NotFoundException {
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE);
        int n5 = resultPointArray.image.getHeight();
        int n6 = resultPointArray.image.getWidth();
        int n7 = n5 * 3 / 228;
        if (n7 < 3 || bl) {
            n7 = 3;
        }
        bl = false;
        int[] nArray = new int[5];
        for (int i5 = n7 - 1; i5 < n5 && !bl; i5 += n7) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
            nArray[4] = 0;
            int n8 = 0;
            for (int i6 = 0; i6 < n6; ++i6) {
                int n9;
                if (resultPointArray.image.get(i6, i5)) {
                    if (n8 & true) {
                        ++n8;
                    }
                    nArray[n8] = n9 = nArray[n8] + 1;
                    continue;
                }
                if (!(n8 & true)) {
                    if (n8 == 4) {
                        if (FinderPatternFinder.foundPatternCross(nArray)) {
                            if (resultPointArray.handlePossibleCenter(nArray, i5, i6, bl2)) {
                                n7 = 2;
                                if (resultPointArray.hasSkipped) {
                                    bl = super.haveMultiplyConfirmedCenters();
                                } else {
                                    n8 = super.findRowSkip();
                                    if (n8 > (n9 = nArray[2])) {
                                        i5 += n8 - n9 - n7;
                                        i6 = n6 - 1;
                                    }
                                }
                                n8 = 0;
                                nArray[0] = 0;
                                nArray[1] = 0;
                                nArray[2] = 0;
                                nArray[3] = 0;
                                nArray[4] = 0;
                                continue;
                            }
                            nArray[0] = n8 = nArray[2];
                            nArray[1] = n8 = nArray[3];
                            nArray[2] = n8 = nArray[4];
                            nArray[3] = 1;
                            nArray[4] = 0;
                            n8 = 3;
                            continue;
                        }
                        nArray[0] = n8 = nArray[2];
                        nArray[1] = n8 = nArray[3];
                        nArray[2] = n8 = nArray[4];
                        nArray[3] = 1;
                        nArray[4] = 0;
                        n8 = 3;
                        continue;
                    }
                    nArray[++n8] = n9 = nArray[n8] + 1;
                    continue;
                }
                nArray[n8] = n9 = nArray[n8] + 1;
            }
            if (!FinderPatternFinder.foundPatternCross(nArray) || !resultPointArray.handlePossibleCenter(nArray, i5, n6, bl2)) continue;
            n7 = nArray[0];
            if (!resultPointArray.hasSkipped) continue;
            bl = super.haveMultiplyConfirmedCenters();
        }
        ResultPoint[] resultPointArray = resultPointArray.selectBestPatterns();
        ResultPoint.orderBestPatterns(resultPointArray);
        return new FinderPatternInfo((FinderPattern[])resultPointArray);
    }

    protected final boolean handlePossibleCenter(int[] nArray, int n5, int n6, boolean bl) {
        int n7;
        float f5;
        int n8 = n5;
        n5 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4];
        float f6 = ((FinderPatternFinder)((Object)finderPattern3)).crossCheckVertical(n8, n6 = (int)FinderPatternFinder.centerFromEnd(nArray, n6), nArray[2], n5);
        if (!(Float.isNaN(f6) || Float.isNaN(f5 = ((FinderPatternFinder)((Object)finderPattern3)).crossCheckHorizontal(n6, n6 = (int)f6, nArray[2], n5)) || bl && !((FinderPatternFinder)((Object)finderPattern3)).crossCheckDiagonal(n6, n7 = (int)f5, nArray[2], n5))) {
            block3: {
                FinderPattern finderPattern;
                float f7 = (float)n5 / 7.0f;
                for (n5 = 0; n5 < ((FinderPatternFinder)((Object)finderPattern3)).possibleCenters.size(); ++n5) {
                    FinderPattern finderPattern2 = ((FinderPatternFinder)((Object)finderPattern3)).possibleCenters.get(n5);
                    if (!finderPattern2.aboutEquals(f7, f6, f5)) continue;
                    ((FinderPatternFinder)((Object)finderPattern3)).possibleCenters.set(n5, finderPattern2.combineEstimate(f6, f5, f7));
                    break block3;
                }
                FinderPatternFinder finderPatternFinder = finderPattern3;
                FinderPattern finderPattern3 = finderPattern;
                finderPattern = new FinderPattern(f5, f6, f7);
                finderPatternFinder.possibleCenters.add(finderPattern3);
                ResultPointCallback resultPointCallback = finderPatternFinder.resultPointCallback;
                if (resultPointCallback != null) {
                    resultPointCallback.foundPossibleResultPoint(finderPattern3);
                }
            }
            return true;
        }
        return false;
    }

    private static final class FurthestFromAverageComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private final float average;

        private FurthestFromAverageComparator(float f5) {
            this.average = f5;
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            float f5;
            float f6;
            float f7 = Math.abs(finderPattern2.getEstimatedModuleSize() - this.average);
            float f8 = Math.abs(finderPattern.getEstimatedModuleSize() - this.average);
            if (f6 < f5) {
                return -1;
            }
            if (f7 == f8) {
                return 0;
            }
            return 1;
        }
    }

    private static final class CenterComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private final float average;

        private CenterComparator(float f5) {
            this.average = f5;
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            if (finderPattern2.getCount() == finderPattern.getCount()) {
                float f5;
                float f6;
                float f7 = Math.abs(finderPattern2.getEstimatedModuleSize() - this.average);
                float f8 = Math.abs(finderPattern.getEstimatedModuleSize() - this.average);
                if (f6 < f5) {
                    return 1;
                }
                if (f7 == f8) {
                    return 0;
                }
                return -1;
            }
            return finderPattern2.getCount() - finderPattern.getCount();
        }
    }
}

