/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Segment;
import dc.squareup.okio.SegmentPool;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public final class InflaterSource
implements Source {
    private final BufferedSource source;
    private final Inflater inflater;
    private int bufferBytesHeldByInflater;
    private boolean closed;

    public InflaterSource(Source source, Inflater inflater) {
        this(Okio.buffer(source), inflater);
    }

    InflaterSource(BufferedSource bufferedSource, Inflater inflater) {
        if (bufferedSource != null) {
            if (inflater != null) {
                InflaterSource inflaterSource = this;
                inflaterSource.source = bufferedSource;
                inflaterSource.inflater = inflater;
                return;
            }
            throw new IllegalArgumentException("inflater == null");
        }
        throw new IllegalArgumentException("source == null");
    }

    private void releaseInflatedBytes() throws IOException {
        int n5 = this.bufferBytesHeldByInflater;
        if (n5 == 0) {
            return;
        }
        InflaterSource inflaterSource = this;
        int n6 = n5 - this.inflater.getRemaining();
        inflaterSource.bufferBytesHeldByInflater -= n6;
        inflaterSource.source.skip(n6);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long read(Buffer buffer, long l5) throws IOException {
        Segment segment;
        if (l5 < 0L) throw new IllegalArgumentException("byteCount < 0: " + l5);
        if (this.closed) throw new IllegalStateException("closed");
        if (l5 == 0L) {
            return 0L;
        }
        while (true) {
            boolean bl;
            block7: {
                long l6;
                int n5;
                long l7;
                bl = this.refill();
                try {
                    segment = buffer.writableSegment(1);
                    l7 = 8192 - segment.limit;
                }
                catch (DataFormatException dataFormatException) {
                    throw new IOException(dataFormatException);
                }
                {
                    n5 = (int)Math.min(l5, l7);
                    Segment segment2 = segment;
                    byte[] byArray = segment2.data;
                    n5 = this.inflater.inflate(byArray, segment2.limit, n5);
                    if (n5 <= 0) break block7;
                }
                {
                    segment.limit += n5;
                    l5 = buffer.size;
                    l6 = n5;
                }
                buffer.size = l5 + l6;
                return l6;
            }
            if (this.inflater.finished() || this.inflater.needsDictionary()) break;
            if (bl) throw new EOFException("source exhausted prematurely");
        }
        this.releaseInflatedBytes();
        if (segment.pos != segment.limit) return -1L;
        buffer.head = segment.pop();
        SegmentPool.recycle(segment);
        return -1L;
    }

    public final boolean refill() throws IOException {
        if (!((InflaterSource)((Object)segment)).inflater.needsInput()) {
            return false;
        }
        InflaterSource inflaterSource = segment;
        inflaterSource.releaseInflatedBytes();
        if (inflaterSource.inflater.getRemaining() == 0) {
            int n5;
            if (((InflaterSource)((Object)segment)).source.exhausted()) {
                return true;
            }
            InflaterSource inflaterSource2 = segment;
            Segment segment = inflaterSource2.source.buffer().head;
            int n6 = segment.pos;
            inflaterSource2.bufferBytesHeldByInflater = n5 = segment.limit - n6;
            inflaterSource2.inflater.setInput(segment.data, n6, n5);
            return false;
        }
        throw new IllegalStateException("?");
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        InflaterSource inflaterSource = this;
        inflaterSource.inflater.end();
        inflaterSource.closed = true;
        inflaterSource.source.close();
    }
}

