/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.camera;

import android.graphics.Point;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import io.dcloud.feature.barcode2.camera.CameraConfigurationManager;
import io.dcloud.feature.barcode2.decoding.IBarHandler;

final class PreviewCallback
implements Camera.PreviewCallback {
    private static final String TAG = "PreviewCallback";
    private static boolean mIsVerticalScreen = true;
    private final CameraConfigurationManager configManager;
    private final boolean useOneShotPreviewCallback;
    private Handler previewHandler;
    private IBarHandler mBarHandler;
    private int previewMessage;
    private byte[] lastBitmapData = null;

    PreviewCallback(CameraConfigurationManager cameraConfigurationManager, boolean bl) {
        this.configManager = cameraConfigurationManager;
        this.useOneShotPreviewCallback = bl;
    }

    void setHandler(IBarHandler iBarHandler, Handler handler, int n5, boolean bl) {
        PreviewCallback previewCallback = this;
        previewCallback.mBarHandler = iBarHandler;
        previewCallback.previewHandler = handler;
        previewCallback.previewMessage = n5;
        mIsVerticalScreen = bl;
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        IBarHandler iBarHandler = this.mBarHandler;
        if (iBarHandler != null && iBarHandler.isRunning()) {
            PreviewCallback previewCallback = this;
            iBarHandler = previewCallback.configManager.getCameraResolution();
            if (!previewCallback.useOneShotPreviewCallback) {
                camera.setPreviewCallback(null);
            }
            if ((camera = this.previewHandler) != null) {
                Message message;
                int n5 = this.previewMessage;
                if (n5 == 1004) {
                    if (mIsVerticalScreen) {
                        IBarHandler iBarHandler2 = iBarHandler;
                        int n6 = ((Point)iBarHandler2).x;
                        int n7 = ((Point)iBarHandler2).y;
                        message = camera.obtainMessage(1005, n6, n7, (Object)byArray);
                    } else {
                        IBarHandler iBarHandler3 = iBarHandler;
                        int n8 = ((Point)iBarHandler3).x;
                        int n9 = ((Point)iBarHandler3).y;
                        message = camera.obtainMessage(1006, n8, n9, (Object)byArray);
                    }
                } else {
                    IBarHandler iBarHandler4 = iBarHandler;
                    int n10 = ((Point)iBarHandler4).x;
                    int n11 = ((Point)iBarHandler4).y;
                    message = camera.obtainMessage(n5, n10, n11, (Object)byArray);
                }
                message.sendToTarget();
                this.previewHandler = null;
            } else {
                Log.d((String)TAG, (String)"Got preview callback, but no handler for it");
            }
            this.lastBitmapData = byArray;
            return;
        }
    }

    public byte[] getLastBitmapData() {
        return this.lastBitmapData;
    }

    public void setLastBitmapData(byte[] byArray) {
        this.lastBitmapData = byArray;
    }
}

