/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.el.parse;

import com.taobao.weex.WXEnvironment;
import com.taobao.weex.el.parse.ArrayStack;
import com.taobao.weex.el.parse.Block;
import com.taobao.weex.el.parse.Operator;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.el.parse.Symbol;
import com.taobao.weex.el.parse.Token;
import com.taobao.weex.utils.WXLogUtils;
import java.util.ArrayList;
import java.util.List;

public class Parser {
    private String code;
    private int position;
    private ArrayStack<Token> stacks;
    private ArrayStack<Symbol> operators;

    public Parser(String string2) {
        ArrayStack arrayStack;
        ArrayStack arrayStack2;
        ((Parser)object).code = string2;
        ((Parser)object).position = 0;
        Object object = arrayStack2;
        arrayStack2 = new ArrayStack();
        v1.stacks = object;
        object = arrayStack;
        arrayStack = new ArrayStack();
        v1.operators = object;
    }

    public static Token parse(String string2) {
        try {
            return new Parser(string2).parse();
        }
        catch (Exception exception) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e("code " + string2, exception);
            }
            return new Block(null, 6);
        }
    }

    private final void doStackOperators(int n) {
        while (this.operators.size() > n) {
            Parser parser = this;
            parser.doOperator(parser.operators.pop());
        }
    }

    public final Token parse() {
        while (this.hasNextToken()) {
            this.scanNextToken();
        }
        while (!this.operators.isEmpty()) {
            Parser parser = this;
            parser.doOperator(parser.operators.pop());
        }
        if (this.stacks.size() == 1) {
            return this.stacks.pop();
        }
        return new Block(this.stacks.getList(), 6);
    }

    final char scanNextToken() {
        char c = this.nextToken();
        if (c == '$') {
            ++this.position;
            return c;
        }
        if (Character.isJavaIdentifierStart(c)) {
            this.scanIdentifier();
            return c;
        }
        if (c != '(' && c != '{') {
            if (c == '[') {
                this.scanArray();
                return c;
            }
            if (c != '\"' && c != '\'') {
                if (c == '.' && Character.isDigit(this.code.charAt(this.position + 1)) || Character.isDigit(c)) {
                    this.scanNumber();
                    return c;
                }
                if (c == '?') {
                    this.scanIf();
                    return c;
                }
                if (c != ':' && c != ')' && c != '}' && c != ' ' && c != ']') {
                    this.scanOperator();
                    return c;
                }
                ++this.position;
                return c;
            }
            this.scanString();
            return c;
        }
        this.scanBracket();
        return c;
    }

    final void scanArray() {
        Block block;
        ArrayList<Token> arrayList;
        int n = this.stacks.size();
        int n2 = this.operators.size();
        int n3 = 0;
        int n4 = this.position;
        if (n4 - 1 < 0 || !Character.isJavaIdentifierPart(this.code.charAt(n4 - 1))) {
            n3 = 7;
        }
        this.operators.push(new Symbol("[", this.stacks.size()));
        ++this.position;
        while (this.hasNextToken() && this.scanNextToken() != ']') {
        }
        if (this.stacks.size() <= n) {
            while (this.operators.size() > n2) {
                this.operators.pop();
            }
            return;
        }
        while (this.operators.size() > n2) {
            Symbol symbol = this.operators.pop();
            if (this.stacks.size() <= n) continue;
            this.doOperator(symbol);
        }
        Object object = arrayList;
        arrayList = new ArrayList<Token>(4);
        for (n4 = n; n4 < this.stacks.size(); ++n4) {
            object.add(this.stacks.get(n4));
        }
        while (this.stacks.size() > n) {
            this.stacks.pop();
        }
        if (n3 != 7 && this.stacks.size() != 0) {
            Operator operator;
            Token token = this.stacks.pop();
            if (object.size() == 1) {
                object = (Token)object.get(0);
            } else {
                Block block2;
                Block block3 = block2;
                block2 = new Block((List<Token>)object, 6);
                object = block3;
            }
            Operator operator2 = operator;
            operator2(".", n3);
            operator2.first = token;
            operator.second = object;
            this.stacks.push(operator2);
            return;
        }
        Block block4 = block;
        block = new Block((List<Token>)object, 7);
        this.stacks.push(block4);
    }

    void scanBracket() {
        Block block;
        ArrayList<Token> arrayList;
        int n = this.stacks.size();
        int n2 = this.operators.size();
        if (this.code.charAt(this.position) == '{') {
            this.operators.push(new Symbol("{", this.stacks.size()));
            ++this.position;
            while (this.hasNextToken() && this.scanNextToken() != '}') {
            }
        } else {
            this.operators.push(new Symbol("(", this.stacks.size()));
            ++this.position;
            while (this.hasNextToken() && this.scanNextToken() != ')') {
            }
        }
        if (this.stacks.size() <= n) {
            while (this.operators.size() > n2) {
                this.operators.pop();
            }
            return;
        }
        while (this.operators.size() > n2) {
            Symbol symbol = this.operators.pop();
            if (this.stacks.size() <= n) continue;
            this.doOperator(symbol);
        }
        ArrayList<Token> arrayList2 = arrayList;
        arrayList = new ArrayList<Token>(4);
        for (int i = n; i < this.stacks.size(); ++i) {
            arrayList2.add(this.stacks.get(i));
        }
        while (this.stacks.size() > n) {
            this.stacks.pop();
        }
        if (arrayList2.size() == 1) {
            this.stacks.push((Token)arrayList2.get(0));
            return;
        }
        Block block2 = block;
        block = new Block(arrayList2, 6);
        this.stacks.push(block2);
    }

    void scanOperator() {
        Parser parser = this;
        int n = parser.position;
        int n2 = Math.min(n + 3, this.code.length());
        String string2 = parser.code.substring(this.position, n2);
        if (string2.length() >= 3 && !Operators.OPERATORS_PRIORITY.containsKey(string2)) {
            string2 = string2.substring(0, 2);
        }
        if (string2.length() >= 2 && !Operators.OPERATORS_PRIORITY.containsKey(string2)) {
            string2 = string2.substring(0, 1);
        }
        if (!Operators.OPERATORS_PRIORITY.containsKey(string2)) {
            IllegalArgumentException illegalArgumentException;
            n = Math.min(n + 1, this.code.length());
            IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
            illegalArgumentException = new IllegalArgumentException(this.code.substring(0, n) + " illegal code operator" + string2);
            WXLogUtils.e("weex", illegalArgumentException2);
            this.position += string2.length();
            return;
        }
        if (!this.operators.isEmpty() && this.operators.peek() != null && Operators.OPERATORS_PRIORITY.get(this.operators.peek().op) >= Operators.OPERATORS_PRIORITY.get(string2)) {
            Parser parser2 = this;
            parser2.doOperator(parser2.operators.pop());
        }
        if (!Operators.isOpEnd(string2)) {
            this.operators.push(new Symbol(string2, this.stacks.size()));
        }
        this.position += string2.length();
    }

    void doOperator(Symbol symbol) {
        block6: {
            Operator operator;
            int n;
            block9: {
                block8: {
                    int n2;
                    block7: {
                        Operator operator2;
                        String string2 = symbol.op;
                        if ("(".equals(string2) || "{".equals(symbol.op) || "[".equals(symbol.op) || "$".equals(symbol.op) || "{".equals(symbol.op)) break block6;
                        n2 = symbol.pos;
                        n = Math.max(n2 - 1, 0);
                        if (!this.operators.isEmpty()) {
                            n = Math.max(n, this.operators.peek().pos);
                        }
                        operator = operator2;
                        operator2 = new Operator(string2, 5);
                        if (!"!".equals(string2)) break block7;
                        if (this.stacks.size() > n2) {
                            operator.self = this.stacks.remove(n2);
                            this.stacks.add(n2, operator);
                            return;
                        }
                        break block6;
                    }
                    if (this.stacks.size() <= n2) break block6;
                    operator.second = this.stacks.remove(n2);
                    if (this.stacks.size() <= n) break block8;
                    operator.first = this.stacks.remove(n);
                    break block9;
                }
                if (operator.second == null) break block6;
            }
            this.stacks.add(n, operator);
            return;
        }
    }

    void scanIf() {
        Operator operator;
        Operator operator2 = operator;
        operator = new Operator("?", 5);
        int n = 0;
        this.doStackOperators(0);
        if (this.operators.size() > 0) {
            n = Math.max(this.operators.peek().pos, n);
        }
        if (this.stacks.size() > n) {
            operator2.self = this.stacks.pop();
        }
        n = this.stacks.size();
        int n2 = this.operators.size();
        ++this.position;
        while (this.hasNextToken() && this.scanNextToken() != ':') {
        }
        while (this.operators.size() > n2) {
            this.doOperator(this.operators.pop());
        }
        while (this.stacks.size() > n) {
            operator2.first = this.stacks.pop();
        }
        n2 = this.operators.size();
        while (this.hasNextToken()) {
            this.scanNextToken();
            if (this.hasNextToken()) {
                this.scanNextToken();
            }
            if (this.operators.size() > n2) continue;
        }
        this.doStackOperators(n2);
        while (this.stacks.size() > n) {
            operator2.second = this.stacks.pop();
        }
        this.stacks.push(operator2);
    }

    final void scanNumber() {
        Token token;
        char c;
        Parser parser = this;
        boolean bl = true;
        int n = parser.position;
        if (parser.code.charAt(n) == 'e' || this.code.charAt(this.position) == '.') {
            bl = false;
        }
        ++this.position;
        while (this.hasNext() && (Character.isDigit(c = this.code.charAt(this.position)) || c == '.' || c == 'e')) {
            if (c == 'e' || c == '.') {
                bl = false;
            }
            ++this.position;
        }
        String string2 = this.code.substring(n, this.position);
        if (".".equals(string2)) {
            return;
        }
        if (bl) {
            Token token2;
            token = token2;
            token2 = new Token(string2, 1);
        } else {
            Token token3;
            token = token3;
            token3 = new Token(string2, 2);
        }
        this.stacks.push(token);
    }

    final void scanString() {
        Token token;
        StringBuilder stringBuilder;
        ArrayStack<Character> arrayStack;
        int n = ((Parser)((Object)string2)).position;
        int n2 = n;
        ArrayStack<Character> arrayStack2 = arrayStack;
        arrayStack2();
        char c = ((Parser)((Object)string2)).code.charAt(n2);
        n2 = c;
        arrayStack.push(Character.valueOf(c));
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        ((Parser)((Object)string2)).position = n + 1;
        while (((Parser)((Object)string2)).position < ((Parser)((Object)string2)).code.length()) {
            char c2 = ((Parser)((Object)string2)).code.charAt(((Parser)((Object)string2)).position);
            if (c2 == n2) {
                if (((Parser)((Object)string2)).code.charAt(((Parser)((Object)string2)).position - 1) != '\\') {
                    ArrayStack<Character> arrayStack3 = arrayStack2;
                    arrayStack3.pop();
                    if (arrayStack3.size() == 0) {
                        ++((Parser)((Object)string2)).position;
                        break;
                    }
                } else {
                    StringBuilder stringBuilder3 = stringBuilder2;
                    stringBuilder3.deleteCharAt(stringBuilder3.length() - 1);
                    stringBuilder2.append(c2);
                }
            } else {
                stringBuilder2.append(c2);
            }
            ++((Parser)((Object)string2)).position;
        }
        Parser parser = string2;
        String string2 = stringBuilder2.toString();
        Token token2 = token;
        token = new Token(string2, 3);
        parser.stacks.push(token2);
    }

    final void scanIdentifier() {
        Token token;
        int n = ((Parser)((Object)token2)).position;
        ((Parser)((Object)token2)).position = n + 1;
        while (((Parser)((Object)token2)).hasNext() && Character.isJavaIdentifierPart(((Parser)((Object)token2)).code.charAt(((Parser)((Object)token2)).position))) {
            ++((Parser)((Object)token2)).position;
        }
        String string2 = ((Parser)((Object)token2)).code.substring(n, ((Parser)((Object)token2)).position);
        if (string2.startsWith("$")) {
            if (string2.length() == 1) {
                return;
            }
            string2 = string2.substring(1);
        }
        int n2 = 0;
        if (Operators.KEYWORDS.containsKey(string2) && (((Parser)((Object)token2)).operators.isEmpty() || !Operators.isDot(((Parser)((Object)token2)).operators.peek().op))) {
            n2 = 4;
        }
        Parser parser = token2;
        Token token2 = token;
        token = new Token(string2, n2);
        parser.stacks.push(token2);
    }

    final boolean hasNext() {
        return this.position < this.code.length();
    }

    final boolean hasNextToken() {
        while (this.hasNext()) {
            if (this.code.charAt(this.position) == ' ') {
                ++this.position;
                continue;
            }
            return true;
        }
        return false;
    }

    final char nextToken() {
        char c = this.code.charAt(this.position);
        while (c == ' ') {
            Parser parser = this;
            ++parser.position;
            int n = this.position;
            if (parser.code.length() <= n) break;
            c = this.code.charAt(n);
        }
        return c;
    }
}

