/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.taobao.weex.ui.flat.widget.Widget;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.Iterator;
import java.util.List;

public class BaseFrameLayout
extends FrameLayout {
    private List<Widget> mWidgets;

    public BaseFrameLayout(Context context) {
        super(context);
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            this.dispatchDrawInterval(canvas);
            return;
        }
        catch (Throwable throwable) {
            WXLogUtils.e(WXLogUtils.getStackTrace(throwable));
            return;
        }
    }

    protected void dispatchDrawInterval(Canvas canvas) {
        if (((BaseFrameLayout)((Object)iterator)).mWidgets != null) {
            canvas.save();
            canvas.translate((float)iterator.getPaddingLeft(), (float)iterator.getPaddingTop());
            Iterator<Widget> iterator = ((BaseFrameLayout)((Object)iterator)).mWidgets.iterator();
            while (iterator.hasNext()) {
                ((Widget)iterator.next()).draw(canvas);
            }
            canvas.restore();
            return;
        }
        BaseFrameLayout baseFrameLayout = iterator;
        WXViewUtils.clipCanvasWithinBorderBox((View)baseFrameLayout, canvas);
        super.dispatchDraw(canvas);
    }

    public void mountFlatGUI(List<Widget> list) {
        this.mWidgets = list;
        if (list != null) {
            this.setWillNotDraw(true);
        }
        this.invalidate();
    }

    public void unmountFlatGUI() {
        BaseFrameLayout baseFrameLayout = this;
        baseFrameLayout.mWidgets = null;
        baseFrameLayout.setWillNotDraw(false);
        baseFrameLayout.invalidate();
    }

    protected boolean verifyDrawable(@NonNull Drawable drawable2) {
        return this.mWidgets != null || super.verifyDrawable(drawable2);
        {
        }
    }
}

